####################################################################################
##
##  CheckMasters
##  Version 1.0
##  by xiv
##
##  This script will display the handles of the bot owners & channel masters.
##  It will also check who are on at the moment.
##
##  For security reasons, I added a flood protection
##

# do you want the bot to make a differance between owners & masters?
set display_owners 1

# set here the trigger for flood
set masters_flood 1:20

bind pub - !masters pub_masters

# -- don't edit below unless you know what you are doing --

proc pub_masters {nick uhost hand channel args} {

	# detect flood
	if {[masters_detectflood]} {
		putcmdlog "<$nick@$channel> !$hand! masters (flood... not answering!)"
		putserv "NOTICE $nick :don't flood the bots"
		return 0
	}

	# Initializing variables
	global botnick display_owners
	set count_owners 0
	set count_owners_on 0
	set count_masters 0
	set count_masters_on 0
	set owners ""
	set owners_on ""
	set masters ""
	set masters_on ""

	# finding all owners in userlist if 'display_owners' setting is set to 1
	if { $display_owners } {
		foreach user [userlist] {
			if [matchattr $user n $channel] {
				set owners [string trim "$owners, $user" ", "]
				incr count_owners 1
			}
		}
		if {[string length $owners] > 0} {
			putchan $channel "$count_owners owner(s) of the bots: $owners."
		}
	}

	# finding all masters in userlist
	foreach user [userlist] {
		if [matchattr $user m|m $channel] {
			if { (![matchattr $user n]) || ($display_owners == 0) } {
				set masters [string trim "$masters, $user" ", "]
				incr count_masters 1
			}
		}
	}
	if {[string length $masters] > 0} {
		putchan $channel "$count_masters master(s) defined for $channel: $masters."
	} else {
		putchan $channel "There are currently no masters defined for $channel."
	}

	# displaying owners that are on if 'display_owners' setting is set to 1
	if { $display_owners } {
		foreach owner_on [chanlist $channel n] {
			set owners_on [string trim "$owners_on, $owner_on" ", "]
			incr count_owners_on 1
		}
		if {[string length $owners_on] > 0} {
			putchan $channel "Wohoo, $count_owners_on owner(s) of the bots currently on: $owners_on."
		}
	}

	# displaying masters that are on
	foreach master_on [chanlist $channel m] {
		if { (![matchattr $master_on n]) || ($display_owners == 0) } {
			set masters_on [string trim "$masters_on, $master_on" ", "]
			incr count_masters_on 1
		}
	}
	if {[string length $masters_on] > 0} {
		putchan $channel "$count_masters_on master(s) currently on: $masters_on."
	} else {
		putchan $channel "There are currently no masters on $channel."
	}
}

# Avoids flooding
proc masters_detectflood { } {
        global masters_flood
        global masters_floodtrigger
        set thr [lindex [split $masters_flood ":"] 0]
        set lapse [lindex [split $masters_flood ":"] 1]
        if {$thr == "" || $thr == 0} { return 0 }
        if {![info exist masters_floodtrigger]} {
                # First time called
                set masters_floodtrigger [list [unixtime] 1]
                return 0
        }
        if {[expr [lindex $masters_floodtrigger 0] + $lapse] <= [unixtime]} {
                # Trigger time has passed, reset counter
                set masters_floodtrigger [list [unixtime] 1]
                return 0
        }
        set lasttime [lindex $masters_floodtrigger 0]
        set times [lindex $masters_floodtrigger 1]
        if {$times >= $thr} {
                # Flood!
                return 1
        }
        set masters_floodtrigger [list $lasttime [expr $times + 1]]
        return 0
}

putlog "--- CheckMasters 1.0 by xiv loaded ---"