# Author:   Fredrik Lhr (nml375@kuai.se) aka. NML_375
# Version:  2.4
# Date:     990410
# Desc:     Tries to prevent capsing in channels.
#           Will warn people whom is capsing. If they continue to do so, they'll
#           get kicked, and, if they still haven't stopped, get banned.
#
#           This script calculates the percentage of capital letters in all msg:s
#           sent to a channel and decides if it is too much (default 30%) or not.
#
# Comments: Please e-mail me your thoughts of this script, what's good, what's bad, etc...
#           (e-mail: nml375@kuai.se)
# Homepage: http://www.kuai.se/~nml375 or http://come.to/nml375
#
# Legal information:
#           This script and all belonging files are the proberty of Fredrik Lhr.
#           You may use them at own will as long as the author is NOT held
#           responsible for ANY damage caused by the usage of this script, 
#           neither direct or indirect.
#           You may modify the script and all belonging files as long as you
#           keep this copyright-text, include a short description of all
#           changes, and send a copy to the author (e-mail:nml375@kuai.se).

## Version 2.4 by NML_375 (nml375@kuai.se) 990410
# * Added checking of public ctcp's (Yes, it might kick on dcc send, dcc chat, etc..)
#   Added b'cause /me is a ctcp-alias... wasn't checked by caps_pubm
#   Idea form: Adam M. Bodnar (ambodnar@bigfoot.com)
# * Now using regsub to check for caps/no-caps...
#   Should work as before, except a little faster...
# * Someone told me I sould implement an external user database...
#   Well, I prolly won't do that... don't have the time for it, etc...
#   Anyway, if you feel like it, go ahead and write yer own...
# * Adding help-files for 1.3.x bots...
#   (I'd recommend removing the help-files for 1.1.x bots on a 1.3.x bot
#   and the 1.3.x help-files on a 1.1.x bot... U might get some oddy results
#   using help otherwise)
#   Help-files will be automatically loaded on 1.3.x bots... (1.1.x bots don't
#   have to load the help-files..)

# Help-files:
# helpdir/caps/              - 1.1.x
# helpdir/caps/bantime       - 1.1.x
# helpdir/caps/clear         - 1.1.x
# helpdir/caps/clearuser     - 1.1.x
# helpdir/caps/ignore        - 1.1.x
# helpdir/caps/limit         - 1.1.x
# helpdir/caps/list          - 1.1.x
# helpdir/caps/set           - 1.1.x
# helpdir/caps/status        - 1.1.x
# helpdir/dcc/caps/          - 1.1.x
# helpdir/dcc/caps/bantime   - 1.1.x
# helpdir/dcc/caps/clear     - 1.1.x
# helpdir/dcc/caps/clearuser - 1.1.x
# helpdir/dcc/caps/ignore    - 1.1.x
# helpdir/dcc/caps/limit     - 1.1.x
# helpdir/dcc/caps/list      - 1.1.x
# helpdir/dcc/caps/status    - 1.1.x
# helpdir/caps.help          - 1.3.x
# helpdir/msg/caps.help      - 1.3.x


## Version 2.3.3 by NML_375 (nml375@kaui.se) 981010
# * Fixed what I should have fixed in 2.3.2
# (If someone finds a bug in this one I'll probably put a bullet in my head ;)

## Version 2.3.2 by NML_375 (nml375@kuai.se) 980914
# * Fixed what I was supposed to fix in 2.3.1
# (Don't ask me how I could fail to fix that one...)

## Version 2.3.1 by NML_375 (nml375@kuai.se) 980910
# * Fixed some bugs I created while cleaning up the code...
# helpdir/set - 1.1.x
# Known issues:
# * Won't remove bans when using clearuser
# * Might be too many log-entries...
# * Crashes on eggdrop v1.3.8, works fine on eggdrop v1.3.9 though...
# (setuser XTRA broken??) 

## Configurations:
#
# File to store settings in (comment to use default: caps.save)
#set caps_savefile "Filename here"

# Flag to mark capsers with (comment to use default: C)
#set caps_flag "C"


## End of configurations


#################################################################################
# Please don't change anything below if you're not sure 'bout what your doing...#
#################################################################################

# Oddy thing... numversion does'nt seem to exist until config-script has been
# completed, although it's already write-protected. (causing some problems)
# (1.3.x eggdrops)
# Trying to read it seems to solve the problem...
catch {set numversion}

if {![info exists numversion]} {
 set numversion [lindex $version 1]
 while {[string index $numversion 0] == 0} {set numversion [string range $numversion 1 end]}
 if {$numversion < 1010000} {
  unset numversion
  putlog "Caps-Guard: Can't load! Requires eggdrop v1.1 or higher!"
  return
 }
}

putlog "Caps-Guard: Looking for newer versions of Caps-Guard..."

if {[info exists caps_loaded]} {
 if {$caps_loaded > 2400} {
  putlog "Caps-Guard: Newer version found! Aborting..."
  return
 } elseif {$caps_loaded == 2400} {
  putlog "Caps-Guard: Current version is already loaded! Refreshing..."
 }
}
if {![info exists caps_loaded] || $caps_loaded < 2400} {
 putlog "Caps-Guard: No newer versions found! Loading Caps-Guard v2.4 ..."
 catch {unset capslimit}
 catch {unset caps_limit}
 catch {unset caps_set}
 catch {unset caps_bantime}
 catch {unset caps_ignore}
}

if {![info exists caps_savefile]} {set caps_savefile "caps.save"}
if {![info exists caps_flag]} {set caps_flag "C"}


# user-get & user-set for v1.1.x and 1.2.x eggdrops copied from toolkit.tcl (unknown author)
# with minor modifications  (will remove key if no data is supplied - more like 1.3.x's setuser XTRA)
# Also adds flag if running on pre1.3 bot...
if {$numversion < 1030000} {
 proc user-get {hand key} {
  set xtra [getxtra $hand]
  for {set i 0} {$i < [llength $xtra]} {incr i} {
   set this [lindex $xtra $i]
   if {[string compare [lindex $this 0] $key] == 0} {
    return [lindex $this 1]
   }
  }
  return ""
 }
 proc user-set {hand args} {
  set key [lindex $args 0]
  if {[llength $args] > 1} {set data [lrange $args 1 end]}
  set xtra [getxtra $hand]
  for {set i 0} {$i < [llength $xtra]} {incr i} {
   set this [lindex $xtra $i]
   if {[string compare [lindex $this 0] $key] == 0} {
    if {[info exists data]} {
     setxtra $hand [lreplace $xtra $i $i [list $key $data]]
    } {
     setxtra $hand [lreplace $xtra $i $i]
    }
    return
   }
  }
  lappend xtra [list $key $data]
  setxtra $hand $xtra
 }
 foreach i {0 1 2 3 4 5 6 7 8 9} {
  global flag$i
  if {[eval set flag$i] == $i} {
   set flag$i $caps_flag
   break
  }
 }
} {
 loadhelp caps.help
 proc user-get {hand key} {
  return [getuser $hand XTRA $key]
 }
 proc user-set {hand args} {
  if {[llength $args] > 1} {
   return [setuser $hand XTRA [lindex $args 0] [lrange $args 1 end]]
  } {
   return [setuser $hand XTRA $args]
  }
 }
}

set caps_set(def) 0
set caps_limit(def) 30
set caps_bantime(def) 15
set caps_ignore(def) 10

if {![file exists $caps_savefile]} {
 putlog "Caps-Guard: Unable to find \"$caps_savefile\"! Creating new one..."
 set caps_fileid [open $caps_savefile w]
 puts $caps_fileid "def $caps_set(def) $caps_limit(def) $caps_bantime(def) $caps_ignore(def)"
 close $caps_fileid
} {
 set caps_fileid [open $caps_savefile r]
 while {[set len [gets $caps_fileid temp]] >= 0} {
  if {[llength $temp] != 5} {continue}
  set chan [string tolower [lindex $temp 0]]
  set caps_set($chan) [lindex $temp 1]
  set caps_limit($chan) [lindex $temp 2]
  set caps_bantime($chan) [lindex $temp 3]
  set caps_ignore($chan) [lindex $temp 4]
 }
 unset chan
 close $caps_fileid
 putlog "Caps-Guard: Loaded saved settings from \"$caps_savefile\""
}


bind pubm - * caps_pubm
bind ctcp - * caps_ctcp
bind msg - caps caps_msg
bind dcc - caps caps_dcc
bind pub - !caps caps_pub

proc caps_dcc {hand idx arg} {
 set temp [caps_main "\{0\} \{$idx\}" $hand [lindex $arg 0] [lrange $arg 1 end]]
 if {[lindex $temp 0] >= 2} {
  putidx $idx "[lindex $temp 1]"
 } elseif {[lindex $temp 0] == 1} {
  putidx $idx "You are not authorized to use that command!\a"
 }
 return 1
}

proc caps_msg {nick host hand arg} {
 set temp [caps_main "\{1\} \{PRIVMSG $nick :\}" $hand [lindex $arg 1] [lrange $arg 2 end]]
 if {[lindex $temp 0] >= 2} {
  puthelp "PRIVMSG $nick :[lindex $temp 1]"
 } elseif {[lindex $temp 1] == 1} {
  puthelp "PRIVMSG $nick :You are not authorized to use that command!\a"
 }
 return 1
}

proc caps_pub {nick host hand chan arg} {
 set temp [caps_main "\{2\} \{PRIVMSG $chan :${nick}: \} \{PRIVMSG $nick :\}" $hand [lindex $arg 0] [lrange $arg 1 end]]
 if {[lindex $temp 0] >= 2} {
  puthelp "PRIVMSG $chan :${nick}: [lindex $temp 1]"
 } elseif {[lindex $temp 1] == 1} {
  puthelp "PRIVMSG $nick :You are not authorized to use that command!\a"
 }
 return 1
}

proc caps_main {caps_reply hand command arg} {
 switch -glob $command {
  "lim*"  {set r [caps_limit $caps_reply $hand $arg]}
  "se*"   {set r [caps_set $caps_reply $hand $arg]}
  "st*"   {set r [caps_status $caps_reply $hand $arg]}
  "b*"    {set r [caps_bantime $caps_reply $hand $arg]}
  "c*u*"  {set r [caps_clearuser $caps_reply $hand $arg]}
  "i*"    {set r [caps_ignore $caps_reply $hand $arg]}
  "c*"    {set r [caps_clear $caps_reply $hand $arg]}
  "lis*"  {set r [caps_list $caps_reply $hand $arg]}
  default {set r "4 \{Not a command! - \"$command\"\}"}
 }
 return $r
}

proc caps_limit {caps_reply hand text} {
 global caps_limit caps_set numversion caps_bantime caps_ignore
 set temp [string tolower [lindex $text 0]]
 if {[validchan $temp]} {
  set chan $temp
  set text [lrange $text 1 end]
 }
 if {$temp == "def"} {
  set chan "def"
  set text [lrange $text 1 end]
 }
 unset temp
 if {![info exists chan] && [llength $text] <= 1} {
  if {[lindex $caps_reply 0] == 0} {
   set chan [string tolower [lindex [console [lindex $caps_reply 1]] 0]]
  } elseif {[lindex $caps_reply 0] == 2} {
   set chan [string tolower [lindex [lindex $caps_reply 1] 1]]
  }
 }
 if {![info exists chan]} {
  return "2 \{Error: Please supply a valid channel name!\}"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n]} {set ok 1} {
  if {$chan != "def"} {
   if {$numversion < 1030000} {
    if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan]} {set ok 1}
   } {
    if {[matchattr $hand m $chan] || [matchattr $hand n $chan]} {set ok 1}
   }
  }
 }
 if {$ok != 1} {return 1}
 set caps_temp [lindex $text 0]
 if {[string trim [lindex $text 0] 0123456789] == "" && $caps_temp != ""} {
  if {$caps_temp >= 10 && $caps_temp <= 100} {
   if {![info exists caps_limit($chan)]} {caps_setchan $chan}
   putlog "Caps-Guard: $hand changed sensitivity for $chan from $caps_limit($chan) to ${caps_temp}%"
   set caps_limit($chan) $caps_temp
   caps_return $caps_reply 1 "Caps-Guard's sensitivity for $chan has been set to $caps_limit($chan)%"
   caps_save
  } {
   caps_return $caps_reply 1 "You have entered an ivalid option ($caps_temp)."
   caps_return $caps_reply 1 "Valid options are between 10 and 100."
  }
 } elseif {$caps_temp == ""} {
  if {![info exists caps_set($chan)]} {
   caps_return $caps_reply 1 "Current setting for $chan (default) is: active: $caps_set(def), limit: $caps_limit(def)%, ban-time: $caps_bantime(def) min, ignoring: < $caps_ignore(def) chrs"
  } {
   caps_return $caps_reply 1 "Current setting for $chan is: active: $caps_set($chan), limit: $caps_limit($chan)%, ban-time: $caps_bantime($chan) min, ignoring: < $caps_ignore($chan) chrs"
  }
 } {
  caps_return $caps_reply 1 "Please enter a numeric value!"
 }
 return 0
}

proc caps_set {caps_reply hand text} {
 global caps_set caps_limit caps_bantime caps_ignore numversion
 set temp [string tolower [lindex $text 0]]
 if {[validchan $temp]} {
  set chan $temp
  set text [lrange $text 1 end]
 }
 if {$temp == "def"} {
  set chan "def"
  set text [lrange $text 1 end]
 }
 unset temp
 if {![info exists chan] && [llength $text] <= 1} {
  if {[lindex $caps_reply 0] == 0} {
   set chan [string tolower [lindex [console [lindex $caps_reply 1]] 0]]
  } elseif {[lindex $caps_reply 0] == 2} {
   set chan [string tolower [lindex [lindex $caps_reply 1] 1]]
  }
 }
 if {![info exists chan]} {
  return "2 \{Error: Please supply a valid channel name!\}"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n]} {set ok 1} {
  if {$chan != "def"} {
   if {$numversion < 1030000} {
    if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan]} {set ok 1}
   } {
    if {[matchattr $hand m $chan] || [matchattr $hand n $chan]} {set ok 1}
   }
  }
 }
 if {$ok != 1} {return 1}
 set caps_temp [lindex $text 0]
 if {$caps_temp == 0} {
  if {![info exists caps_set($chan)]} {caps_setchan $chan}
  set caps_set($chan) 0
  putlog "Caps-Guard: $hand deactivated Caps-Guard on $chan"
  caps_return $caps_reply 1 "Caps-Guard has been deactivated on ${chan}."
  caps_save
 } elseif {$caps_temp == 1} {
  if {![info exists caps_set($chan)]} {caps_setchan $chan}
  set caps_set($chan) 1
  putlog "Caps-Guard: $hand activated Caps-Guard on $chan"
  caps_return $caps_reply 1 "Caps-Guard has been activated on $chan (limit: $caps_limit($chan)%, ban-time: $caps_bantime($chan) min, ignoring: < $caps_ignore($chan) chrs)"
  caps_save
 } else {
  if {$caps_temp == ""} {
   if {![info exists caps_set($chan)]} {
    caps_return $caps_reply 1 "Current setting for $chan (default) is: active: $caps_set(def), limit: $caps_limit(def)%, ban-time: $caps_bantime(def) min, ignoring: < $caps_ignore(def) chrs"
   } {
    caps_return $caps_reply 1 "Current setting for $chan is: active: $caps_set($chan), limit: $caps_limit($chan)%, ban-time: $caps_bantime($chan) min, ignoring: < $caps_ignore($chan) chrs"
   }
  } {
   caps_return $caps_reply 1 "You have entered an invalid option for $chan ($caps_temp)."
   caps_return $caps_reply 1 "Valid options are: 0 - deactivate, 1 - activate"
  }
 }
 return 0
}

proc caps_status {caps_reply hand text} {
 global caps_set caps_limit caps_bantime caps_ignore numversion
 set temp [string tolower [lindex $text 0]]
 if {[validchan $temp]} {
  set chan $temp
  set text [lrange $text 1 end]
 }
 if {$temp == "def"} {
  set chan "def"
  set text [lrange $text 1 end]
 }
 unset temp
 if {![info exists chan]} {
  if {[lindex $caps_reply 0] == 0} {
   set chan [string tolower [lindex [console [lindex $caps_reply 1]] 0]]
  } elseif {[lindex $caps_reply 0] == 2} {
   set chan [string tolower [lindex [lindex $caps_reply 1] 1]]
  }
 }
 if {![info exists chan]} {
  set chan "def"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n] || [matchattr $hand o]} {set ok 1} {
  if {$chan != "def"} {
   if {$numversion < 1030000} {
    if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan] || [matchchanattr $hand 0 $chan]} {set ok 1}
   } {
    if {[matchattr $hand m $chan] || [matchattr $hand n $chan] || [matchattr $hand o $chan]} {set ok 1}
   }
  }
 }
 if {$ok != 1} {return 1}
 if {![info exists caps_set($chan)]} {set chan "def"}
 caps_return $caps_reply 2 "===== Caps-Guard status ====="
 if {$chan == "def"} {
  caps_return $caps_reply 2 "***   Default settings    ***"
 } {
  caps_return $caps_reply 2 "Channel       : $chan"
 }
 if {$caps_set($chan) == 1} {
  caps_return $caps_reply 2 "Caps-Guard is : activated"
 } else {
  caps_return $caps_reply 2 "Caps-Guard is : de-activated"
 }
 caps_return $caps_reply 2 "Limit         : $caps_limit($chan)%"
 caps_return $caps_reply 2 "Ban-time      : $caps_bantime($chan) min"
 caps_return $caps_reply 2 "Ignoring      : < $caps_ignore($chan) chrs"
 caps_return $caps_reply 2 "=====   End of status   ====="
 return 0
}

proc caps_list {caps_reply hand text} {
 global caps_set botnick
 if {!([matchattr $hand n] || [matchattr $hand m] || [matchattr $hand o])} {return 1}
 if {$text == ""} {set text *} {set text [string tolower [lindex $text 0]]}
 caps_return $caps_reply 2 "===  Caps-Guard channels  ==="
 caps_return $caps_reply 2 "Matching: $text"
 foreach chan [array names caps_set] {
  if {[string match $text $chan] || [string match "#${text}" $chan]} {
   if {[validchan $chan] && [botisop $chan]} {
    set op "@"
   } {
    if {![validchan $chan]} {
     set op " "
    } {
     if {![onchan $botnick $chan]} {set op "-"} {set op "*"}
    }
   }
   if {$caps_set($chan) == 1} {set active "(active)"} {set active ""}
   caps_return $caps_reply 2 "${chan}[string range "                 :" [string length $chan] end] $op $active"
  }
 }
 caps_return $caps_reply 2 "===  End of channel list  ==="
 return 0
}

proc caps_bantime {caps_reply hand text} {
 global caps_set caps_limit caps_bantime numversion
 set temp [string tolower [lindex $text 0]]
 if {[validchan $temp]} {
  set chan $temp
  set text [lrange $text 1 end]
 }
 if {$temp == "def"} {
  set chan "def"
  set text [lrange $text 1 end]
 }
 unset temp
 if {![info exists chan] && [llength $text] <= 1} {
  if {[lindex $caps_reply 0] == 0} {
   set chan [string tolower [lindex [console [lindex $caps_reply 1]] 0]]
  } elseif {[lindex $caps_reply 0] == 2} {
   set chan [string tolower [lindex [lindex $caps_reply 1] 1]]
  }
 }
 if {![info exists chan]} {
  return "2 \{Error: Please supply a valid channel name!\}"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n]} {set ok 1} {
  if {$chan != "def"} {
   if {$numversion < 1030000} {
    if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan]} {set ok 1}
   } {
    if {[matchattr $hand m $chan] || [matchattr $hand n $chan]} {set ok 1}
   }
  }
 }
 if {$ok != 1} {return 1}
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == "" && $caps_temp != ""} {
  if {$caps_temp >= 10 && $caps_temp <= 120} {
   if {![info exists caps_bantime($chan)]} {caps_setchan $chan}
   putlog "Caps-Guard: $hand changed bantime on $chan from $caps_bantime($chan) to $caps_temp min."
   set caps_bantime($chan) $caps_temp
   caps_return $caps_reply 2 "Caps-Guard bantime is set to $caps_bantime($chan) minutes on ${chan}."
  } else {
   caps_return $caps_reply 2 "You have entered an invalid option ($caps_temp)!"
   caps_return $caps_reply 2 "Valid options are between 10 and 120"
  }
 } elseif {$caps_temp == ""} {
  if {![info exists caps_set($chan)]} {
   caps_return $caps_reply 1 "Current setting for $chan (default) is: active: $caps_set(def), limit: $caps_limit(def)%, ban-time: $caps_bantime(def) min, ignoring: < $caps_ignore(def) chrs"
  } {
   caps_return $caps_reply 1 "Current setting for $chan is: active: $caps_set($chan), limit: $caps_limit($chan)%, ban-time: $caps_bantime($chan) min, ignoring: < $caps_ignore($chan) chrs"
  }
 } {
  caps_return $caps_reply 2 "Please enter a numeric value!"
 }
 return 0
}

proc caps_clearuser {caps_reply hand arg} {
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 if {[llength $arg] <= 0} {return "2 \{Usage: caps clearuser <user> \[users\]\}"}
 set norec ""
 foreach temp $arg {
  if {[validuser $temp] == 1} {
   if {[user-get $temp caps] == 0} {
    caps_return $caps_reply 2 "${temp}'s record for caps-regulations has already been cleared..."
   } else {
    user-set $temp caps 0
    caps_return $caps_reply 2 "${temp}'s record for caps-regulations has been cleared..."
    putlog "Caps-Guard: $hand has cleared ${temp}'s record for caps-regulations"
   }
   caps_timer $temp
  } else {
   if {[llength $norec] != 0} {set norec "${norec}, "}
   set norec "${norec}${temp}"
  }
 }
 if {[llength $norec] >= 3} {
  set norec [linsert $norec [expr [llength $norec] - 1] or]
 } elseif {[llength $norec] == 2} {
  regsub -all "," $norec "" norec
  set norec [linsert $norec 1 or]
 } elseif {[llength $norec] == 1} {
  regsub -all "," $norec "" norec
 }
 if {[llength $norec] >= 1} {
  caps_return $caps_reply 2 "Sorry, but I don't know who $norec is..."
 }
 return 0
}

proc caps_ctcp {nick host hand who what text} {
 if {[ischannel $who]} {
  caps_pubm $nick $host $hand $who $text
 }
 return 0
}

proc caps_pubm {nick uhost hand chan text} {
 global caps_limit caps_set caps_bantime botnick caps_ignore default-flags numversion caps_send caps_flag
 set temp [string tolower $chan]
 set chan2 "def"
 if {[lsearch [array names caps_set] $temp] >= 0} {set chan2 $temp}
 if {$caps_set($chan2) != 1} {return 0}
 if {[matchattr $hand m] || [matchattr $hand n] || [matchattr $hand f] || [matchattr $hand b]} {return 0}
 if {$numversion < 1030000} {
  if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan] || [matchchanattr $hand f $chan] || [matchattr $hand B]} {return 0}
 } {
  if {[matchattr $hand m $chan] || [matchattr $hand n $chan] || [matchattr $hand f $chan] || [matchattr $hand t]} {return 0}
 }
 if {[string tolower $nick] == [string tolower $botnick] || ![botisop $chan]} {return 0}
 set caps_upper 0; set caps_space 0; set caps_total 0; set caps_caps 0
 regsub -all " " $text "" text
 set caps_total [string length $text]
 regsub -all {[A-Z]} $text "" text
 set caps_nocaps [string length $text]
 if {$caps_total < $caps_ignore($chan2) || $caps_total < 1} {return 0}
 if {[expr ($caps_total - $caps_nocaps) * 100 / "${caps_total}."] > $caps_limit($chan2)} {
  set uh [maskhost $uhost]
  set temp [user-get $hand caps]
  if {$temp == 0 || $temp == ""} {
   if {![info exists caps_send($chan)] || [expr [unixtime] - $caps_send($chan)] > 10} {
    puthelp "PRIVMSG $chan :$nick: Turn Caps-lock off..."
    puthelp "NOTICE $nick :Turn Caps-lock off before you write anything more in $chan ..."
    set caps_send($chan) [unixtime]
   }
   if {[validuser $hand] == 0} {
    if {[validuser $nick] == 0} {
     set hand $nick
    } else {
     set cntr 0
     while {[validuser "Bad${cntr}"]} {incr cntr 1}
     set hand "Bad${cntr}"
    }
    adduser $hand $uh
    chattr $hand "-${default-flags}+${caps_flag}"
    putlog "Caps-Guard: Added $hand with no attribs"
    if {$numversion < 1030000} {
     setcomment $hand "([date]) Used caps in $chan (${nick}!${uhost})"
    } {
     setuser $hand COMMENT "([date]) Used caps in $chan (${nick}!${uhost})"
    }
   }
   user-set $hand caps 1
   caps_timer $hand
   timer 360 "caps_remove $hand"
   putlog "Caps-Guard: $nick ($hand) has been warned once"
   return 0
  }
  if {$temp == 1} {
   if {![info exists caps_send($chan)] || [expr [unixtime] - $caps_send($chan)] > 5} {
    putserv "KICK $chan $nick :I told you to turn Caps-lock off!"
    putlog "Caps-Guard: $nick ($hand) has been warned a second time (using kick...)"
   }
   user-set $hand caps 2
   caps_timer $hand
   timer 360 "caps_remove $hand"
   return 0
  }
  if {$temp == 2} {
   putserv "MODE $chan -o $nick"
   newchanban $chan $uh CapsGuard "Capsing..." $caps_bantime($chan2)
   putserv "KICK $chan $nick :I've already warned you twice, now I'm banning you for $caps_bantime($chan2) minutes (capsing)"
   user-set $hand caps 3
   caps_timer $hand
   timer 360 "caps_remove $hand"
   putlog "Caps-Guard: $nick ($hand) has been banned from $chan2 in $caps_bantime($chan2) minutes ($uh)"
   return 0
  }
  if {$temp == 3} {
   putserv "MODE $chan -o :$nick"
   newchanban $chan $uh CapsGuard "Capsing... (Perm-banned!)" 0
   putserv "KICK $chan $nick :You are not welcome here anymore! (Capsing)"
   user-set $hand caps 4
   putlog "Caps-Guard: $nick ($hand) has been perm-banned ($uh)"
   caps_timer $hand
   return 0
  }
 }
}

proc caps_timer {hand} {
 set hand [string tolower $hand]
 foreach timer [string tolower [timers]] {
  if {[lindex $timer 1] == "caps_remove $hand"} {
   killtimer [lindex $timer 2]
   putlog "Gaps-Guard: Cleaned up caps_remove timer for $hand"
  }
 }
}

proc caps_remove {hand} {
 global caps_flag
 caps_timer $hand
 set temp [user-get $hand caps]
 if {$temp == "" || $temp == 1} {
  if {[matchattr $hand $caps_flag]} {deluser $hand} {user-set $hand caps}
  return 0
 } elseif {$temp == 4} {
  return 0
 } else {
  user-set $hand caps [expr $temp - 1]
  timer 360 "caps_remove $hand"
  return 1
 }
}

proc caps_ignore {caps_reply hand text} {
 global numversion caps_ignore caps_set caps_limit caps_bantime
 set temp [string tolower [lindex $text 0]]
 if {[validchan $temp]} {
  set chan $temp
  set text [lrange $text 1 end]
 }
 if {$temp == "def"} {
  set chan "def"
  set text [lrange $text 1 end]
 }
 unset temp
 if {![info exists chan] && [llength $text] <= 1} {
  if {[lindex $caps_reply 0] == 0} {
   set chan [string tolower [lindex [console [lindex $caps_reply 1]] 0]]
  } elseif {[lindex $caps_reply 0] == 2} {
   set chan [string tolower [lindex [lindex $caps_reply 1] 1]]
  }
 }
 if {![info exists chan]} {
  return "2 \{Error: Please supply a valid channel name!\}"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n]} {set ok 1}
 if {$chan != "def"} {
  if {$numversion < 1030000} {
   if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan]} {set ok 1}
  } {
   if {[matchattr $hand m $chan] || [matchattr $hand n $chan]} {set ok 1}
  }
 }
 if {$ok != 1} {return 1}
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == "" && $caps_temp != ""} {
  if {$caps_temp > 0} {
   if {![info exists caps_ignore($chan)]} {caps_setchan $chan}
   putlog "Caps-Guard: $hand changed ignore-setting for $chan from $caps_ignore($chan) to $caps_temp chrs."
   set caps_ignore($chan) $caps_temp
   caps_save
  } {
   caps_return $caps_reply 1 "Please enter a value larger than zero"
  }
 } elseif {$caps_temp == ""} {
  if {![info exists caps_set($chan)]} {
   caps_return $caps_reply 1 "Current setting for $chan (default) is: active: $caps_set(def), limit: $caps_limit(def)%, ban-time: $caps_bantime(def) min, ignoring: < $caps_ignore(def) chrs"
  } {
   caps_return $caps_reply 1 "Current setting for $chan is: active: $caps_set($chan), limit: $caps_limit($chan)%, ban-time: $caps_bantime($chan) min, ignoring: < $caps_ignore($chan) chrs"
  }
 } {
  caps_return $caps_reply 1 "Please enter a numeric value"
 }
 return 0
}

proc caps_clear {caps_reply hand text} {
 global caps_set caps_limit caps_bantime numversion
 set temp [string tolower [lindex $text 0]]
 if {[lsearch [array names caps_set] $temp] >= 0} {set chan $temp}
 if {![info exists chan] || [string tolower $chan] == "def"} {
  return "2 \{Error: Please supply a valid channel name!\}"
 }
 set ok 0
 if {[matchattr $hand m] || [matchattr $hand n]} {set ok 1} {
  if {[validchan $chan]} {
   if {$numversion < 1030000} {
    if {[matchchanattr $hand m $chan] || [matchchanattr $hand n $chan]} {set ok 1}
   } {
    if {[matchattr $hand m $chan] || [matchattr $hand n $chan]} {set ok 1}
   }
  }
 }
 if {$ok != 1} {return 1}
 catch {unset caps_set($chan)}
 catch {unset caps_limit($chan)}
 catch {unset caps_bantime($chan)}
 catch {unset caps_ignore($chan)}
 caps_save
 caps_return $caps_reply 1 "Settings for $chan has been cleared"
 putlog "Caps-Guard: $hand cleared settings for $chan"
 return 0
}

proc caps_return {id type text} {
 switch [lindex $id 0] {
  "0" {putidx [lindex $id 1] $text}
  "1" {puthelp "[lindex $id 1]$text"}
  "2" {if {$type == 1 || $type == 2} {puthelp "[lindex $id $type]$text"}}
 }
}

proc caps_setchan {chan} {
 global caps_set caps_limit caps_bantime caps_ignore
 set caps_set($chan) $caps_set(def)
 set caps_limit($chan) $caps_limit(def)
 set caps_bantime($chan) $caps_bantime(def)
 set caps_ignore($chan) $caps_ignore(def)
}

proc caps_save {} {
 global caps_set caps_limit caps_bantime caps_ignore caps_savefile
 set caps_fileid [open $caps_savefile w]
 foreach chan [array names caps_set] {
  if {[validchan $chan] || $chan == "def"} {
   puts $caps_fileid "$chan $caps_set($chan) $caps_limit($chan) $caps_bantime($chan) $caps_ignore($chan)"
  }
 }
 close $caps_fileid
 putlog "Caps-Guard: Saved settings to \"$caps_savefile\""
}

proc caps_rehash {} {
 foreach hand [userlist] {
  set temp [user-get $hand caps]
  if {$temp != "" && $temp != "0"} {
   caps_remove $hand
  }
 }
}

caps_rehash
set caps_loaded 2400
putlog "Caps-Guard v2.4 Loaded!  Written by Fredrik Lhr (NML_375, nml375@kuai.se) Copyright(C) 1998"
