##########################
# Eggdrop Extensions by Vulture <vulture@abac.com>, normally
# Vulture_ on Undernet
###########
# Eggdrop Extensions is, as its name implies, a set of extensions to eggdrop.
# This includes many, many useful channel commands, private message commands,
# and DCC commands alike.
#
# WARNING: This script to be used with Eggdrop 1.3.x ONLY.
#
# The .store command is built in, so REMOVE ANY CONSOLE.TCL SCRIPTS!
#
##########################
### INITIALIZATION ###
source eggdrop-ext.conf

set eggext_version 1.52p1

# set up a handler for the 311 message (from which we get ircnames)
# we can't do this later because the ircname refresh expects this!
bind raw - 311 raw_311_ircname
proc raw_311_ircname {src kword arg} {
  global ircname_list
  set ircname_list([lindex $arg 1]) [string range [lreplace $arg 0 4] 1 end]
  # return 0; be passive and let eggdrop process this message, but we want to
  # also process it...
  return 0
}

# now, set up a handler for the NICK message, which we will need in case
# someone in the database changes nick (if they aren't in the database, put
# a warning in the log and get their ircname; this should never happen)
# I'm using a RAW binding here because I want absolutely no bullshit from the
# bind nick thing.
bind raw - NICK raw_nick_ircname
proc raw_nick_ircname {src kword arg} {
  # first, parse through the src, and ignore everything after a !
  # (some servers give a n!u@h instead of just a nick for this)
  set counter 0
  set srcnick ""
  set foundexc 0
  while { $counter != [string length $src] && $foundexc == 0 } {
    if { [string index $src $counter] != "!" } {
      set srcnick "$srcnick[string index $src $counter]"
    }
    if { [string index $src $counter] == "!" } {
      set foundexc 1
    }
    incr counter
  }
  # clean up used memory; use it for something else :)
  unset foundexc
  unset counter
  # now, form the target nick
  if { [string index [lindex $arg 0] 0] == ":" } {
    set tgtnick [string range [lindex $arg 0] 1 end]
  }
  if { [string index [lindex $arg 0] 0] != ":" } {
    set tgtnick [lindex $arg 0]
  }
  # now, check if this user is in the database
  # global our array
  global ircname_list
  if { [array names ircname_list "$srcnick"] != $srcnick } {
    # ACK! it's NOT in there!!
    global botnick
    putlog "*** WARNING *** : $srcnick changed nick to $tgtnick. $srcnick had no ircname in ircname_list! (this could be caused by a server reporting nick changes even when they're not on a channel with $botnick)"
    putlog "If this problem persists, PLEASE report this to the author of Eggdrop Extensions! (vulture@abac.com at June 8 1998)"
    # let's put it in!
    putserv "WHOIS $tgtnick"
  }
  if { [array names ircname_list "$srcnick"] == $srcnick } {
    # it's in there...
    set ircname_list($tgtnick) $ircname_list($srcnick)
    unset ircname_list($srcnick)
  }
  # as always, let the bot continue processing this message
  return 0
}

# refresh the ircname list, but ONLY IF that user isn't already in it!
foreach target [channels] {
  foreach tgt [chanlist $target] {
    if { [array names ircname_list $tgt] != $tgt } {
      putserv "WHOIS $tgt"
    }
  }
}

# if there isn't already a loaded list, load it up (nwp)
if { [info vars ee-nwpass-chans] != "ee-nwpass-chans" } {
  set ee-nwpass-chans ""
  set nwfd [open "nwpchs.dat" "RDONLY CREAT"]
  gets $nwfd nwch
  while { $nwch != "" } {
    lappend ee-nwpass-chans $nwch
    gets $nwfd nwch
  }
  unset nwch
  close $nwfd
  unset nwfd
}

if { [info vars ctcp-version] == "ctcp-version" && ${ee-disguise-version} != "yes" } {
  set ctcp-version "${ctcp-version}+eggdrop extensions $eggext_version"
}

# Check if there's a botnet-nick set; if not, use bot's primary nick. The
# resulting variable, bnnick, can be used as a name identifier for the bot
# without defining one in this script.
if { [info vars botnet-nick] == "" } {
  set bnnick $nick
}
if { [info vars botnet-nick] != "" } {
  set bnnick ${botnet-nick}
}

# If the toolkit tcl isn't loaded, load 'er up. If it doesn't work, bitch in
# the log.
if {![info exists toolkit_loaded]} {
  catch {source scripts/toolkit.tcl}
  if {![info exists toolkit_loaded]} {
    catch {source toolkit.tcl}
    if {![info exists toolkit_loaded]} {
      putlog "Eggdrop Extensions WARNING: Can't load Tcl toolkit!"
    }
  }
}

# Reassign the +chan/-chan commands to a +m user, instead of +n.
unbind dcc n +chan *dcc:+chan
bind dcc m +chan *dcc:+chan
unbind dcc n -chan *dcc:-chan
bind dcc m -chan *dcc:-chan

# Reassign the whois command if we're supposed to.
if { $all_whois == "yes" } {
  unbind dcc o whois *dcc:whois
  bind dcc - whois *dcc:whois
}

# Reassign msg/say/act dcc commands to masters...that way global ops can't
# send bogus shit to other bots or users.
unbind dcc o say *dcc:say
bind dcc m say *dcc:say
unbind dcc o act *dcc:act
bind dcc m act *dcc:act
unbind dcc o msg *dcc:msg
bind dcc m msg *dcc:msg

# set up the timer for saving the channel list for NWP
bind time - "${hourly-updates} * * * *" autosave_nwpass_chans
proc autosave_nwpass_chans {min hour day month year} {
  putlog "Autosaving no-warn-password channel list..."
  global ee-nwpass-chans
  file delete "nwpchs.dat"
  set nwfd [open "nwpchs.dat" "WRONLY CREAT"]
  foreach tgt ${ee-nwpass-chans} {
    puts $nwfd $tgt
  }
  close $nwfd
  putlog "No-warn-password channel list saved."
}

# note that this DCC stuff really doesn't belong here, but hell.. it's easier
# to code
bind dcc - lnwp dcc_lnowarn
proc dcc_lnowarn {hand idx arg} {
  global ee-nwpass-chans
  putdcc $idx "Not warning about no password on channels: ${ee-nwpass-chans}"
  putlog "#$hand# LWNP"
}

bind dcc m nwp dcc_nwp
proc dcc_nwp {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: nwp <channel1> <channel2> ..."
    putdcc $idx "Purpose: Add one or more channels to the list of channels on which not to warn users about not having passwords set."
    return
  }
  global ee-nwpass-chans
  lappend ee-nwpass-chans $arg
  putdcc $idx "Added channels to no-warn-password list: $arg"
  putlog "#$hand# NWP $arg"
}

bind dcc m rnwp dcc_rnwp
proc dcc_rnwp {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: rnwp <channel1> <channel2> ..."
    putdcc $idx "Purpose: Remove one or more channels from the list of channels on which not to warn users about not having passwords set."
    return
  }
  global ee-nwpass-chans
  foreach tgt $arg {
    while { [lsearch ${ee-nwpass-chans} $tgt] != -1 } {
      set ee-nwpass-chans [lreplace ${ee-nwpass-chans} [lsearch ${ee-nwpass-chans} $tgt] [lsearch ${ee-nwpass-chans} $tgt]]
    }
    putdcc $idx "Removed all no-warn-password entries matching $tgt."
  }
  putlog "#$hand# RNWP $arg"
}

bind dcc m snwp dcc_snwp
proc dcc_snwp {hand idx arg} {
  putdcc $idx "Saving no-warn-password list..."
  putlog "#$hand# SNWP: starting save..."
  global ee-nwpass-chans
  file delete "nwpchs.dat"
  set nwfd [open "nwpchs.dat" "WRONLY CREAT"]
  foreach tgt ${ee-nwpass-chans} {
    puts $nwfd $tgt
  }
  close $nwfd
  putdcc $idx "Finished save."
  putdcc $idx "#$hand# SNWP: finished."
}

### USEFUL PROCEDURES ###
# for that occasional task when you need to send something to the server
# without waiting for it to be de-queued, like if someone's taking over the
# channel (!!!!!)
#
# this proc will return 0 on success, or:
# 1 if it can't find the server idx
proc cputserv {txt} {
  # first, we need to find out what the idx of the server connection is...
  # this method of finding out will probably waste a lot of CPU cycles given
  # how often this is called; hopefully this will be fixed.
  # NOTE: this will find the server connection with the highest idx, for
  # (future) eggdrops that support multiple server connections; just use
  # the putidx command if you will be working with multiple servers...
  set putserv_idx ""
  foreach tgt [dcclist] {
    if { [string tolower [lindex $tgt 3]] == "server" } {
      set putserv_idx [lindex $tgt 0]
    }
  }
  # if the server idx was not in the dcclist, panic
  if { $putserv_idx == "" } {
    return 1
  }
  # got the server idx, send to it then exit successfully
  putidx $putserv_idx $txt
  return 0
}

# makes a hostmask (*!ident@*.lamer.org) from a n!u@h (lamer!ident@p1.lamer.org)
# fairly convenient for bans :)
# also eliminates a duplicate nick
# NOTE that modern eggdrops have a similar command built in, but this one seems
# to be smarter (puts a * before the ident, strips off ~, etc...)
proc uh2mask {userhost} {
  set made-nick 0
  set s1 ""
  set hm ""
  set counter 0
  while { $counter <= [string length $userhost] } {
    if { "[string index $userhost $counter]" == "!" } {
      if { ${made-nick} == 0 } {
        set made-nick 1
        set hm "$hm*!"
        set s1 ""
      }
      incr counter
    }
    if { [string index $userhost $counter] != "!" } {
      if { [string index $userhost $counter] == "@" } {
        if { [string length $s1] > 9 } {
          set s1 "[string range $s1 1 [expr [string length $s1] - 1]]*"
        }
        set hm "$hm*$s1@"
        set s1 ""
        incr counter
      }
      if { [string index $userhost $counter] != "@" } {
        if { [string index $userhost $counter] != "~" } {
          set s1 "$s1[string index $userhost $counter]"
          incr counter
        }
      }
    }
  }
  # s1 is now the host (remember hm is the hostmask and userhost is the
  # n!u@h), so now we will find out if s1 is totally numeric or a DNS addr.
  set counter 0
  set numeric_ip 1
  while { $counter <= [string length $s1] && $numeric_ip != 0 } {
    set ib [string index $s1 $counter]
    if { $ib != 0 && $ib != 1 && $ib != 2 && $ib != 3 && $ib != 4 && $ib != 5 && $ib != 6 && $ib != 7 && $ib != 8 && $ib != 9 && $ib != " " && $ib != "" && $ib != "." } {
      set numeric_ip 0
    }
    incr counter
  }
  # ok, now we know if it's a IP address or not.. now we must make a mask out
  # of it, depending..
  set counter 0
  set s2 ""
                        # hostmask buffer
  set s3 ""
                        # IP addr. section number (not used if $numeric_ip != 1)
  set ip_section 0
                        # which field of the IP address it is, only applies if
                        # $numeric_ip == 1. if $numeric_ip == 0, if it is 1
                        # (i.e. the beginning section of the hostname has
                        # already been parsed) then everything else will be
                        # copied raw, not replaced
  if { $numeric_ip == 1 } {
    while { $counter <= [string length $s1] } {
      if { [string index $s1 $counter] == "." } {
        if { $ip_section != 3 } {
          set s2 "$s2$s3."
        }
        incr ip_section
        set s3 ""
      }
      if { [string index $s1 $counter] != "." } {
        set s3 "$s3[string index $s1 $counter]"
      }
      incr counter
    }
    if { $ip_section == 3 } {
      set s2 "$s2*"
    }
  }
  if { $numeric_ip != 1 } {
    while { $counter <= [string length $s1] } {
      if { [string index $s1 $counter] == "." } {
        if { $ip_section == 0 } {
                                          # if the section is now field
          set s2 "*"
                                          # 0 (_name_.domain.com)
        }
                                          # replace it with an asterisk,
                                          # otherwise leave it
        if { $ip_section != 0 } {
          set s2 "$s2.$s3"
        }
        incr ip_section
        set s3 ""
      }
      if { [string index $s1 $counter] != "." } {
        set s3 "$s3[string index $s1 $counter]"
      }
      incr counter
    }
    if { $ip_section != 0 } {
      set s2 "$s2.$s3"
    }
  }
  set hm "$hm$s2"
  return $hm
}

# a fixed validchan... drop-in replaceable for those versions of eggdrop that
# happen to have a buggy `validchan' command, but useful because you can use
# vldchan on both eggdrops with this problem and those without
proc vldchan {channel} {
  if { [lsearch [string tolower [channels]] [string tolower $channel]] != -1 } {
    return 1
  }
  return 0
}

# sends a message to your subnet
proc putsubnet {msg} {
  global subnet-bots bot_subnet
  if { $bot_subnet == "" } {
    foreach tgt ${subnet-bots} {
      putbot $tgt $msg
    }
  }
  if { $bot_subnet != "" } {
    putallbots $msg
  }
  return 0
}

# validates a subnet message
proc subnetvalid {bot cmd arg} {
  global subnet-bots bot_subnet
  if { [lindex $arg 0] != "NEW" && $bot_subnet != "" } {
    if { [lindex $arg 0] != $bot_subnet } {
      return 0
    }
  }
  if { [lindex $arg 0] != "NEW" && $bot_subnet == "" } {
    return 0
  }
  if { [lsearch ${subnet-bots} $bot] < 1 } {
    return 0
  }
  return 1
}

# These two are for compatibility with older scripts that expect user-get and
# user-set to be there.
proc user-get {handle key} {
  return [getuser $handle XTRA $key]
}

proc user-set {handle key data} {
  setuser $handle XTRA $key $data
}

# Restores your saved console.
proc restore_console {handle idx} {
  global force-channel info-party internal-store
  if {${internal-store} != "yes"} {
    set cons [user-get $handle console]
    set conchan [user-get $handle conchan]
  }
  if {${internal-store} == "yes"} {
    set cons [getuser $handle console]
    set conchan [lindex $cons 0]
  }
  if {![matchattr $handle m]} {
    foreach x {c x r o} {
      regsub -all $x $cons "" cons
    }
  }
  if {$cons != ""} {
    if {$conchan != ""} {
      console $idx [lindex $conchan 0] [lindex $cons 0]
    }
  }
  set echo [user-get $handle echo]
  if {$echo != ""} { echo $idx $echo }
  set chan [user-get $handle chan]
  if {$chan == ""} {
     set chan ${force-channel}
  }
  setchan $idx $chan

  set info [getuser $handle INFO]
  if {${info-party} && $info != ""} {
     #dccputchan $chan "\[$handle\] $info"
  }
}

# Saves your console.
proc save_console {handle idx} {
  global internal-store
  set cons [console $idx]
  if {${internal-store} != "yes"} {
    user-set $handle conchan [lindex $cons 0]
    user-set $handle console [lindex $cons 1]
    user-set $handle echo [echo $idx]
    user-set $handle chan [getchan $idx]
  }
  if {${internal-store} == "yes"} {
    setuser $handle console "$cons [strip $idx] [echo $idx] [page $idx] 0"
  }
}

# Check if a handle is logged in under a nick!host.
proc isloggedin {hand host} {
  # if they're not a valid user, return no
  if { ![validuser $hand] } {
    return 0
  }
  # if their login host mismatches their current nick!user@host (which may be
  # blank, indicating that they're not logged in), no
  if { [getuser $hand xtra login-host] != $host && [getuser $hand xtra login-host] != [string range $host [expr [string first ! $host] + 1] end] } {
    return 0
  }
  # otherwise, yes
  return 1
}

### DCC COMMANDS ###
# masters can refresh the ircname database
bind dcc m rircnames dcc_rircnames
proc dcc_rircnames {hand idx arg} {
  putlog "#$hand# RIRCNAMES (!)"
  global ircname_list
  unset ircname_list
  foreach target [channels] {
    foreach tgt [chanlist $target] {
      putserv "WHOIS $tgt"
    }
  }
}

# for DEBUG purposes, let masters get ircnames of anyone the bot knows:
bind dcc m ircname dcc_ircname
proc dcc_ircname {hand idx arg} {
  global ircname_list
  if { [llength $arg] != 1 } {
    putdcc $idx "Usage: ircname <nick>"
    return
  }
  if { [array names ircname_list $arg] == $arg } {
    putdcc $idx "IRCNAME for $arg: $ircname_list($arg)"
  }
  if { [array names ircname_list $arg] != $arg } {
    putdcc $idx "IRCNAME for $arg not in database."
  }
}

# Performs a mathematical expression. Period. The end.
bind dcc - math dcc_math
proc dcc_math {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: math <expression>"
    return
  }
  putdcc $idx "$arg = [expr $arg]"
}

# Sets whether a user wants global auto op or not.
bind dcc - autoop dcc_autoop
proc dcc_autoop {hand idx arg} {
  if { [string tolower $arg] != "on" && [string tolower $arg] != "off" } {
    putdcc $idx "Usage: autoop on|off"
    putdcc $idx "This command toggles whether or not you want to be automatically opped when you join a channel (in which you are authorized to be opped).  It doesn't compromise security much, since you still must login, but if you insist on not"
    putdcc $idx "being opped for whatever reason, set this to off."
    return
  }
  if { [string tolower $arg] == "on" } {
    putdcc $idx "Auto-op ON."
    chattr $hand -O
    return
  }
  if { [string tolower $arg] == "off" } {
    putdcc $idx "Auto-op OFF."
    chattr $hand +O
    return
  }
  putdcc $idx "There was an error in the bot."
  putdcc $idx "Please send a note to: $admin"
}

bind dcc - autovoice dcc_autovoice
proc dcc_autovoice {hand idx arg} {
  if { [string tolower $arg] != "on" && [string tolower $arg] != "off" } {
    putdcc $idx "Usage: autovoice on|off"
    putdcc $idx "This command toggles whether or not you want to be automatically voiced when you join a channel (in which you are authorized to be voiced).  It doesn't compromise security much, since you still must login, but if you insist on not"
    putdcc $idx "being voiced for whatever reason, set this to off."
    return
  }
  if { [string tolower $arg] == "on" } {
    putdcc $idx "Auto-voice ON."
    chattr $hand -V
    return
  }
  if { [string tolower $arg] == "off" } {
    putdcc $idx "Auto-voice OFF."
    chattr $hand +V
    return
  }
  putdcc $idx "There was an error in the bot."
  putdcc $idx "Please send a note to: $admin"
}

# Kills a partyline user.
bind dcc n kill dcc_kill
proc dcc_kill {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: kill <user> <reason>"
    return
  }
  if { [hand2idx [lindex $arg 0]] != -1 } {
    set tgt_handle [idx2hand [hand2idx [lindex $arg 0]]]
    putdcc [hand2idx [lindex $arg 0]] "Closing connection: Killed ($hand ([lreplace $arg 0 0]))"
    killdcc [hand2idx [lindex $arg 0]]
    dccbroadcast "$tgt_handle killed ($hand ([lreplace $arg 0 0]))"
  }
}

# Warns other +W fellas... same as IRC, except normal users can't see them.
# Period.
bind dcc - wallops dcc_wallops
proc dcc_wallops {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: wallops <message>"
    return
  }
  if { [matchattr $hand W] || [matchattr $hand t] } {
    wallops $hand $arg
    return
  }
  if { ![matchattr $hand W] && ![matchattr $hand t] } {
    putdcc $idx "Access denied."
    putloglev "c" "*" "\#$hand\# failed WALLOPS $arg"
    return
  }
}

# This proc actually performs the wallops... it's a separate proc so other
# procs might be able to use it too.
proc wallops {hand msg} {
  set wl_proc 0
  set wl_ulist [dcclist]
  putallbots "vBOTNET_WALLOPS $hand $msg"
  while { [lindex $wl_ulist $wl_proc] != "" } {
    if { [string tolower [lindex [lindex $wl_ulist $wl_proc] 3]] == "chat" && [validuser [lindex [lindex $wl_ulist $wl_proc] 1]] } {
      if { [matchattr [lindex [lindex $wl_ulist $wl_proc] 1] W] } {
        putdcc [lindex [lindex $wl_ulist $wl_proc] 0] "\[Wallops/$hand\] $msg"
      }
    }
    incr wl_proc
  }
}

# This one's to receive a WALLOPS message over the botnet and broadcast it to
# local +W users.
bind bot - vBOTNET_WALLOPS bot_wallops
proc bot_wallops {bot cmd arg} {
  set hand [lindex $arg 0]
  set msg [lreplace $arg 0 0]
  set wl_proc 0
  set wl_ulist [dcclist]
  while { [lindex $wl_ulist $wl_proc] != "" } {
    if { [string tolower [lindex [lindex $wl_ulist $wl_proc] 3]] == "chat" && [validuser [lindex [lindex $wl_ulist $wl_proc] 1]] } {
      if { [matchattr [lindex [lindex $wl_ulist $wl_proc] 1] W] } {
        putdcc [lindex [lindex $wl_ulist $wl_proc] 0] "\[Wallops/$hand@$bot\] $msg"
      }
    }
    incr wl_proc
  }
}

proc save_console_dcc {handle idx param} {
  set cons [console $idx]
  set chan [getchan $idx]
  user-set $handle conchan [lindex $cons 0]
  user-set $handle console [lindex $cons 1]
  user-set $handle echo [echo $idx]
  user-set $handle chan $chan
  set newcons "[lindex $cons 0]: [lindex $cons 1]"
  if {[echo $idx]} {
    putdcc $idx "Saved your console mode as $newcons (echo on) (chan $chan)"
  } {   
    putdcc $idx "Saved your console mode as $newcons (echo off) (chan $chan)"
  }
  return 1
}

# Does a rehash on your entire subnet. (useful if you have more than one bot
# sharing scripts that you're writing...like me. :)
bind dcc m srehash dcc_srehash
bind dcc m mrehash dcc_srehash
proc dcc_srehash {hand idx arg} {
  global bot_subnet
  putloglev "c" "*" "\#$hand\# SREHASH"
  putdcc $idx "Rehashing all bots on subnet..."
  if { $bot_subnet != "" } {
    putsubnet "vBOTNET_REHASH $bot_subnet $hand"
  }
  if { $bot_subnet == "" } {
    putsubnet "vBOTNET_REHASH NEW $hand"
  }
  rehash
}

bind bot - vBOTNET_SUBNET_DISABLED bot_subnet_disabled
proc bot_subnet_disabled {bot cmd arg} {
  putlog "failed subnet message from $bot: $arg"
}

bind bot - vBOTNET_REHASH bot_rehash
proc bot_rehash {bot cmd arg} {
  global warn-subnet-failures
  if { ![subnetvalid $bot $cmd $arg] } {
    putloglev "c" "*" "\#[lindex $arg 1]@$bot\# failed SREHASH (subnet cmds disabled)"
    if { ${warn-subnet-failures} == "yes" } {
      putbot $bot "vBOTNET_SUBNET_DISABLED $cmd"
    }
    return
  }
  putloglev "c" "*" "\#[lindex $arg 1]@$bot\# SREHASH"
  rehash
}

# Same as srehash, but does a restart instead.
bind dcc m srestart dcc_srestart
proc dcc_srestart {hand idx arg} {
  global bot_subnet
  if { $bot_subnet == "" } {
    putloglev "c" "*" "\#$hand\# failed SRESTART (subnet cmds disabled)"
    putdcc $idx "Can't subnet restart -- subnet commands disabled."
    return
  }
  putloglev "c" "*" "\#$hand\# SRESTART"
  putdcc $idx "Restarting all bots on subnet..."
  if { $bot_subnet != "" } {
    putsubnet "vBOTNET_RESTART $bot_subnet $hand"
  }
  if { $bot_subnet == "" } {
    putsubnet "vBOTNET_RESTART NEW $hand"
  }
  restart
}

bind bot - vBOTNET_RESTART bot_restart
proc bot_restart {bot cmd arg} {
  global bot_subnet warn-subnet-failures
  if { ![subnetvalid $bot $cmd $arg] } {
    putloglev "c" "*" "\#[lindex $arg 1]@$bot\# failed SRESTART (subnet cmds disabled)"
    if { ${warn-subnet-failures} == "yes" } {
      putbot $bot "vBOTNET_SUBNET_DISABLED $cmd"
    }
    return
  }
  putloglev "c" "*" "\#[lindex $arg 1]@$bot\# SRESTART"
  restart
}

# Asks all the bots whether or not they're running eggdrop extensions, and
# which version.
bind dcc m extcheck dcc_extcheck
proc dcc_extcheck {hand idx arg} {
  global bnnick eggext_version
  putdcc $idx "Checking for Eggdrop Extensions on botnet..."
  putdcc $idx "$bnnick is running Eggdrop Extensions version $eggext_version."
  putallbots "vBOTNET_CHECK_EGGDROP_EXT $idx $hand"
}

bind bot - vBOTNET_CHECK_EGGDROP_EXT bot_extcheck
proc bot_extcheck {bot cmd arg} {
  global eggext_version bnnick
  putloglev "c" "*" "\#[lindex $arg 1]@$bot\# EXTCHECK"
  putbot $bot "vBOTNET_CHECK_EGGDROP_EXT_ACK [lindex $arg 0] $bnnick running Eggdrop Extensions version $eggext_version"
}

bind bot - vBOTNET_CHECK_EGGDROP_EXT_ACK bot_extcheckack
proc bot_extcheckack {bot cmd arg} {
  putdcc [lindex $arg 0] "$bot acknowledged: [lreplace $arg 0 0]"
}

# version of wallops is sent to everyone on the botnet, available to +t or
# higher
bind dcc t wall dcc_wall
proc dcc_wall {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: wall <message>"
    return
  }
  dccbroadcast "\[Wall/$hand\] $arg"
}

# Changes or checks the bot's nick.
bind dcc m botnick dcc_botnick
proc dcc_botnick {hand idx arg} {
  global nick altnick botnick
  if { $arg == "" } {
      putdcc $idx "Usage: botnick <nick> \[altnick\]"
      putdcc $idx "Bot's IRC nick is $botnick ::: Primary nick: $nick ::: Secondary nick: $altnick"
    return
  }
  set nick [lindex $arg 0]
  putdcc $idx "Set primary bot nick to [lindex $arg 0]"
  if { [llength $arg] == 2 } {
    set altnick [lindex $arg 1]
    putdcc $idx "Set secondary bot nick to [lindex $arg 1]"
  }
  if { [llength $arg] == 1 } {
    set altnick "[string range [lindex $arg 0] 0 7]_"
    putdcc $idx "Set secondary bot nick to [string range [lindex $arg 0] 0 7]_"
  }
  putloglev "c" "*" "\#$hand\# BOTNICK $arg"
}

bind dcc m mjoin dcc_mjoin
proc dcc_mjoin {hand idx arg} {
    global bot_subnet
    if { $arg == "" } {
	putdcc $idx "Usage: mjoin <channel>"
	return
    }
    if { $bot_subnet == "" } {
      putloglev "c" "*" "\#$hand\# failed MJOIN $arg (subnet cmds disabled)"
      putdcc $idx "Can't mass join -- subnet commands disabled."
      return
    }
    if { [vldchan [lindex $arg 0]] } {
        putserv "JOIN [lindex $arg 0]"
        return
    }
    channel add [lindex $arg 0]
    channel set [lindex $arg 0] -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet +protectops +statuslog -stopnethack -revenge -autovoice -secret -shared
    putdcc $idx "Joining channel [lindex $arg 0] ..."
    if { $bot_subnet == "" } {
        putsubnet "vBOTNET_MJOIN NEW $arg"
    }
    if { $bot_subnet != "" } {
        putsubnet "vBOTNET_MJOIN $bot_subnet $arg"
    }
    putloglev "c" "*" "\#$hand\# MJOIN $arg"
}

bind bot - vBOTNET_MJOIN botnet_mjoin
proc botnet_mjoin {bot cmd arg} {
    global warn-subnet-failures
    if { ![subnetvalid $bot $cmd $arg] } {
      putloglev "c" "*" "\#bot:$bot\# failed MJOIN $arg (subnet cmds disabled)"
      if { ${warn-subnet-failures} == "yes" } {
        putbot $bot "vBOTNET_SUBNET_DISABLED $cmd"
      }
      return
    }
    if { $bot_subnet != [lindex $arg 0] } {
        return
    }
    if { [vldchan [lindex $arg 1]] } {
        putserv "JOIN [lindex $arg 1]"
        return
    }
    channel add [lindex $arg 1]
    channel set [lindex $arg 1] -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet +protectops +statuslog -stopnethack -revenge -autovoice -secret -shared
    putloglev "c" "*" "\#bot:$bot\# MJOIN $arg"
}

# Makes the bot join a channel... a simplified version of +chan, it makes the
# bot join the channel, but do nothing there.
bind dcc m join dcc_cmd_join
proc dcc_cmd_join {hand idx arg} {
    if { $arg == "" } {
	putdcc $idx "Usage: join <channel>"
	return
    }
    if { [vldchan [lindex $arg 0]] } {
        putserv "JOIN [lindex $arg 0]"
        return
    }
    channel add [lindex $arg 0]
    channel set [lindex $arg 0] -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet +protectops +statuslog -stopnethack -revenge -autovoice -secret -shared
    putdcc $idx "Joining channel [lindex $arg 0] ..."
    putloglev "c" "*" "\#$hand\# JOIN $arg"
}

# Same as join, except that it sets your console to the channel and sets +p
# on the console, so it's like your bot is your own client. (kinda..)
bind dcc m cjoin dcc_cmd_cjoin
proc dcc_cmd_cjoin {hand idx arg} {
    if { $arg == "" } {
	putdcc $idx "Usage: cjoin <channel>"
	return
    }
    if { [vldchan [lindex $arg 0]] } {
        putserv "JOIN [lindex $arg 0]"
        return
    }
    channel add [lindex $arg 0]
    channel set [lindex $arg 0] -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet +protectops +statuslog -stopnethack -revenge -autovoice -secret -shared
    console $idx [lindex $arg 0] +p
    putdcc $idx "Joining channel [lindex $arg 0] ..."
    putloglev "c" "*" "\#$hand\# CJOIN $arg"
}

# Leaves the channel.
bind dcc m part dcc_cmd_part
proc dcc_cmd_part {hand idx arg} {
    if { $arg == "" } {
	putdcc $idx "Usage: part <channel>"
	return
    }
    if { ![vldchan [lindex $arg 0]] } {
        putdcc $idx "Invalid channel: [lindex $arg 0]"
        return
    }
    channel remove [lindex $arg 0]
    putdcc $idx "Leaving channel [lindex $arg 0] ..."
    putloglev "c" $arg "\#$hand\# PART $arg"
}

bind dcc m mpart dcc_mpart
proc dcc_mpart {hand idx arg} {
    global bot_subnet
    if { $arg == "" } {
	putdcc $idx "Usage: mpart <channel>"
	return
    }
    if { $bot_subnet == "" } {
      putloglev "c" "*" "\#$hand\# failed MPART $arg (subnet cmds disabled)"
      putdcc $idx "Can't mass part -- subnet commands disabled."
      return
    }
    if { [vldchan [lindex $arg 0]] } {
        putserv "PART [lindex $arg 0]"
        return
    }
    channel remove [lindex $arg 0]
    putdcc $idx "Leaving channel [lindex $arg 0] ..."
    if { $bot_subnet == "" } {
        putsubnet "vBOTNET_MPART NEW $arg"
    }
    if { $bot_subnet != "" } {
        putsubnet "vBOTNET_MPART $bot_subnet $arg"
    }
    putloglev "c" "*" "\#$hand\# MPART $arg"
}

bind bot - vBOTNET_MPART botnet_mpart
proc botnet_mpart {bot cmd arg} {
    global warn-subnet-failures
    if { ![subnetvalid $bot $cmd $arg] } {
      putloglev "c" "*" "\#bot:$bot\# failed MPART $arg (subnet cmds disabled)"
      if { ${warn-subnet-failures} == "yes" } {
        putbot $bot "vBOTNET_SUBNET_DISABLED $cmd"
      }
      return
    }
    if { $bot_subnet != [lindex $arg 0] } {
        return
    }
    if { [vldchan [lindex $arg 1]] } {
        putserv "PART [lindex $arg 1]"
        return
    }
    channel remove [lindex $arg 1]
    putloglev "c" "*" "\#bot:$bot\# MPART $arg"
}

# A DCC interface to restore_console, it restores your saved console.
bind dcc t restore dcc_cmd_restore
proc dcc_cmd_restore {hand idx arg} {
  putdcc $idx "Restoring your saved console state..."
  restore_console $hand $idx
}

# Take over a channel quickly and efficiently.
bind dcc m takeover dcc_cmd_takeover
proc dcc_cmd_takeover {hand idx arg} {
  global autoban_channels botnick
  if { $arg == "" } {
    putdcc $idx "Usage: takeover <channel> \[reason\]"
    putdcc $idx "Use with extreme caution!"
    return
  }
  if { ![vldchan [lindex $arg 0]] } {
    putdcc $idx "Invalid channel: [lindex $arg 0]"
    return
  }
  if { ![botisop [lindex $arg 0]] } {
    putdcc $idx "I don't have ops on [lindex $arg 0], can't take over."
    return
  }
  putdcc $idx "Taking over: [lindex $arg 0]"
  channel set [lindex $arg 0] chanmode +ntims
  channel set [lindex $arg 0] +enforcebans +bitch +stopnethack -autovoice -autoop -greet +revenge +secret
  lappend autoban_channels [lindex $arg 0]
  foreach tgt [chanlist [lindex $arg 0]] {
    if { [isop $tgt [lindex $arg 0]] && ![matchattr [nick2hand $tgt [lindex $arg 0]] f|f [lindex $arg 0]] && $tgt != $botnick } {
      pushmode [lindex $arg 0] -o $tgt
    }
    flushmode [lindex $arg 0]
  }
  pushmode [lindex $arg 0] +n
  pushmode [lindex $arg 0] +t
  pushmode [lindex $arg 0] +i
  pushmode [lindex $arg 0] +m
  pushmode [lindex $arg 0] +s
  pushmode [lindex $arg 0] +k `GoNE`
  flushmode [lindex $arg 0]
  foreach tgt [chanlist [lindex $arg 0]] {
    if { ![matchattr [nick2hand $tgt [lindex $arg 0]] f|f [lindex $tgt 0]] && $tgt != $botnick } {
      putserv "KICK [lindex $arg 0] $tgt"
    }
  }
  set reason [lreplace $arg 0 0]
  if { $reason == "" } {
    set reason "This channel is LAME!!!"
  }
  putserv "TOPIC [lindex $arg 0] :TakeoveR: $reason"
  putloglev "c" $arg "\#$hand\# TAKEOVER $arg"
}

# Stop the effects of a takeover on a channel.
bind dcc m untakeover dcc_cmd_untakeover
proc dcc_cmd_untakeover {hand idx arg} {
  global autoban_channels
  if { $arg == "" } {
    putdcc $idx "Usage: untakeover <channel>"
    return
  }
  if { ![vldchan [lindex $arg 0]] } {
    putdcc $idx "I'm not on that channel!"
    return
  }
  pushmode [lindex $arg 0] -t
  pushmode [lindex $arg 0] -i
  pushmode [lindex $arg 0] -m
  pushmode [lindex $arg 0] -s
  pushmode [lindex $arg 0] -k `GoNE`
  flushmode [lindex $arg 0]
  putserv "TOPIC [lindex $arg 0] :UnTakeoveR Finished."
  channel remove [lindex $arg 0]
  if { [lsearch $autoban_channels [lindex $arg 0]] != -1 } {
    set autoban_channels [lreplace $autoban_channels [lsearch $autoban_channels [lindex $arg 0]] [lsearch $autoban_channels [lindex $arg 0]]]
  }
  putloglev "c" $arg "\#$hand\# UNTAKEOVER $arg"
}

# Sorta like the who /msg command, in DCC.
bind dcc - whochan dcc_cmd_whochan
proc dcc_cmd_whochan {hand idx arg} {
  putloglev c [lindex $arg 0] "#$hand# WHOCHAN $arg"
  global ircname_list ee-nochop-who
  if { $arg == "" } {
    putdcc $idx "Usage: whochan <channel>"
    return
  }
  set chan [lindex $arg 0]
  if { ![vldchan $chan] } {
    putdcc $idx "Invalid channel: $chan"
    return
  }
  if { ![matchattr $hand m|o $chan] } {
    if { [lsearch [channel info $chan] +secret] != -1 || [string match "*s*" [lindex [getchanmode $chan] 0]] || [string match "*p*" [lindex [getchanmode $chan] 0] || ${ee-nochop-who} != "yes" } {
      putdcc $idx "Invalid channel: $chan"
      return
    }
  }
  foreach tgt [chanlist $chan] {
    if { [array names ircname_list $tgt] != $tgt } {
      set user_ircname ""
    }
    if { [array names ircname_list $tgt] == $tgt } {
      set user_ircname "($ircname_list($tgt))"
    }
    set user_prefix " "
    if { [isvoice $tgt $chan] } {
      set user_prefix "+"
    }
    if { [isop $tgt $chan] } {
      set user_prefix "@"
    }
    if { [expr [string length $tgt] < 9] } {
      set counter 0
      set buf ""
      set tgt_counter [expr 9 - [string length $tgt]]
      while { $counter != $tgt_counter } {
        set buf "$buf "
        incr counter
      }
      unset counter
      unset tgt_counter
    }
    if { [expr [string length $tgt] >= 9] } {
      set buf ""
    }
    if { [matchattr $hand h] } {
      putdcc $idx "$chan: \2$user_prefix\2$tgt$buf \2$user_ircname\2"
    }
    if { ![matchattr $hand h] } {
      putdcc $idx "$chan: $user_prefix$tgt$buf $user_ircname"
    }
  }
}

### DCC TRIGGERS ###
# This proc is executed when someone joins the DCC partyline.
# dcc_chat_host = the host of the user that sent a DCC chat as that handle
bind chon - ** dcc_chon
proc dcc_chon {hand idx} {
  global bnnick botnick internal-store
  set proc_autoop_chanlist ""
  set proc_autovoice_chanlist ""
  foreach target [dcclist] {
    foreach tgt [channels] {
      if { [lindex $target 0] == $idx && [onchan [lindex $target 1] $tgt] } {
        if { [getuser $hand xtra dcc_chat_host] == [lindex $target 2] || [getuser $hand xtra dcc_chat_host] == "[lindex $target 1]![lindex $target 2]" || [getuser $hand xtra dcc_chat_host] == "[lindex $target 1]![lindex $target 1]![lindex $target 2]" } {
          if { [lsearch [lindex $target 2] "[lindex $target 1]!*"] == -1 } {
            setuser $hand xtra login-host "[lindex $target 1]![lindex $target 2]"
          }
          if { [lsearch [lindex $target 2] "[lindex $target 1]!*"] != -1 } {
            setuser $hand xtra login-host [lindex $target 2]
          }
          if { [botisop $tgt] && [onchan [lindex $target 1] $tgt] } {
            if { ![matchattr $hand O] } {
              if { [matchattr $hand o|o $tgt] } {
                putserv "MODE $tgt +o [lindex $target 1]"
                lappend proc_autoop_chanlist $tgt
              }
            }
            if { ![matchattr $hand V] } {
              if { [matchattr $hand v|v $tgt] } {
                putserv "MODE $tgt +v [lindex $target 1]"
                lappend proc_autovoice_chanlist $tgt
              }
            }
          }
        }
      }
    }
  }
  if { $proc_autoop_chanlist != "" } {
    set proc_autoop_log "auto op chans: $proc_autoop_chanlist,"
    set proc_autoop_msg "Auto opping on channel(s) $proc_autoop_chanlist,"
  }
  if { $proc_autoop_chanlist == "" }  {
    set proc_autoop_log "no auto op,"
    set proc_autoop_msg "Not auto opping,"
  }
  if { $proc_autovoice_chanlist != "" } {
    set proc_autovoice_log "auto voice chans: $proc_autovoice_chanlist."
    set proc_autovoice_msg "Auto voicing on channel(s) $proc_autovoice_chanlist."
  }
  if { $proc_autovoice_chanlist == "" } {
    set proc_autovoice_log "no auto voice."
    set proc_autovoice_msg "Not auto voicing."
  }
  putloglev "c" "*" "#$hand# auto-LOGIN, $proc_autoop_log $proc_autovoice_log"
  putdcc $idx "*** You are validated to use public commands. $proc_autoop_msg $proc_autovoice_msg"
  # There used to be K-line stuff here... I scrapped it, because it's useless.
  # Do a +ignore if you feel there's a host trying to connect that shouldn't.
  if { [user-get $hand exp] != 1 } {
    # Check if the user that logged in has before... if not, give this cute
    # little message :)
    user-set $hand exp "1"
    putdcc $idx "---> Welcome to the eggdrop partyline!  Please read what follows..."
    putdcc $idx "You will have a few commands you will need to learn."
    putdcc $idx ".help    : Gets you help on your commands.  The most important."
    putdcc $idx ".quit    : Quits the partyline."
    putdcc $idx ".whom    : Shows you who's here."
    putdcc $idx ".me      : Like a IRC /me command."
    putdcc $idx ".info    : Changes your info line, which $botnick says when you join a channel $botnick is on."
    putdcc $idx ".chpass  : Changes your password."
    putdcc $idx "Everything else (not starting with a period) is normal chat and is seen by everyone."
  }
  if {${internal-store} != "yes"} {
    # Restore the console
    restore_console $hand $idx
  }
  # If they're +t or higher, give 'em WALLOPS access.
  if { [matchattr $hand t] == 1 && [matchattr $hand W] != 1 } {
    chattr $hand +W
  }
}

### CHANNEL/MSG TRIGGERS ###
# Procedure executed when someone joins a channel.
bind join - ** ch_join
proc ch_join {nick host hand chan} {
  global botnick auto_id autoban_channels bnnick ee-warn-nopass ee-nwpass-chans ircname_list
  # now, check if they're in the ircname_list array; if not, fire off a whois
  # for them and grab their ircname :)
  if { [array names ircname_list $nick] != $nick } {
    putserv "WHOIS $nick"
  }
  # The open hellos stuff has been removed because it's a serious security
  # compromise. Deal with it.
  # Check if this is an autoban channel, and ban this mofo if they're not +f
  if { [lsearch $autoban_channels $chan] != -1 && $nick != $botnick } {
    if { ![matchattr $hand f|f $chan] } {
      newchanban $chan "$host" $bnnick "AutoBan!"
      putloglev "cj" $chan "($host) !$hand! JOIN $chan (AutoBan!)"
    }
  }
  # Check for auto_id and auto identify people if the channel is set to +greet
  if { [lsearch [channel info $chan] "+greet"] != "-1" } {
    if { $auto_id != "no" } {
      pub_identify $botnick *@* $botnick $chan $nick
    }
  }
  # If a user doesn't have a set password, demand that they set one!
  if { [passwdok $hand ""] && ${ee-warn-nopass} == "yes" && [lsearch ${ee-nwpass-chans} $chan] == -1 } {
    putserv "NOTICE $nick :You don't have a password set on $botnick! Please set it now: /msg $botnick PASS <password>"
    putlog "Warned $nick about no password (joined $chan)"
  }
  # Check if they're logged in... if they are, and not on any of the bot's
  # covered channels, EXCLUDING the one they just joined, log 'em out.
  if { [getuser $hand xtra login-host] != "" } {
    set logemout 1
    # make sure that they're logged in under the exact same nick!user@host
    # as the person who joined...
    if { [getuser $hand xtra login-host] == "$nick!$host" } {
      foreach tgt [channels] {
        # please make sure that we don't think they already were on the channel
        # they just joined...
        if { $tgt != $chan } {
          if { [onchan $nick $tgt] } {
            set logemout 0
          }
        }
      }
    }
    # Well, if we're going to log 'em out after all that testing, lez do it..
    if { $logemout == 1 } {
      setuser $hand xtra login-host ""
    }
  }
  if { [isloggedin $hand "$nick!$host"] && [botisop $chan] } {
    if { [matchattr $hand o|o $chan] } {
      if { ![matchattr $hand O] } {
        putserv "MODE $chan +o $nick"
      }
    }
    if { [matchattr $hand v|v $chan] } {
      if { ![matchattr $hand V] } {
        putserv "MODE $chan +v $nick"
      }
    }
  }
}

# Procedure executed when someone leaves a channel.
bind part - ** ch_part
proc ch_part {nick host hand chan} {
  global ircname_list
  if { [array names ircname_list $nick] == $nick } {
    # if they're in the ircname list, and aren't on any of my other channels,
    # for cleanliness' sake, delete them from it! (and for memory conservation)
    set on_other_chans 0
    foreach tgt [channels] {
      if { [onchan $nick $tgt] } {
        set on_other_chans 1
      }
    }
    if { $on_other_chans == 0 } {
      unset ircname_list($nick)
    }
    unset on_other_chans
  }
}

if {${internal-store} != "yes"} {
  if {${console-autosave}} {
    bind chof - * save_console
  } {
    bind dcc - store save_console_dcc
  }
}

### CHANNEL/MSG COMMANDS ###
# replaced PASS msg command, lets ppl also replace their password
unbind msg - pass *msg:pass
bind msg - pass msg_new_pass
proc msg_new_pass {nick host hand arg} {
  global botnick
  if { ![validuser $hand] } {
    putserv "NOTICE $nick :You aren't a registered user."
    putlog "($nick!$host) !$hand! failed PASS (not a user/bad handle)"
    return
  }
  if { $arg == "" } {
    if { [passwdok $hand ""] } {
      putserv "NOTICE $nick :Usage: PASS <new password>"
      putserv "NOTICE $nick :If you had a password set: PASS <new password> <old password>"
    }
    if { ![passwdok $hand ""] } {
      putserv "NOTICE $nick :Usage: PASS <new password> <old password>"
      putserv "NOTICE $nick :If you didn't have a set password: PASS <new password>"
    }
    putserv "NOTICE $nick :Note that you must use this command before using any others, like IDENT."
    putlog "($nick!$hand) !$hand! PASS (no parameters)"
    return
  }
  if { [passwdok $hand ""] } {
    setuser $hand PASS [lindex $arg 0]
    putserv "NOTICE $nick :Password successfully set to: [lindex $arg 0]"
    putserv "NOTICE $nick :In the future, change the password by: /msg $botnick pass <new password> [lindex $arg 0]"
    putlog "($nick!$host) !$hand! PASS \[something\]"
    return
  }
  if { ![passwdok $hand ""] && ![passwdok $hand [lindex $arg 1]] } {
    putserv "NOTICE $nick :[lindex $arg 1]: bad password (must be your current password)"
    putlog "($nick!$host) !$hand! failed PASS \[something\] \[something\] (bad original password)"
    return
  }
  if { ![passwdok $hand ""] && [passwdok $hand [lindex $arg 1]] } {
    setuser $hand PASS [lindex $arg 0]
    putserv "NOTICE $nick :Successfully changed your password to [lindex $arg 0]."
    putserv "NOTICE $nick :In the future, change the password by: /msg $botnick pass <new password> [lindex $arg 0]"
    putlog "($nick!$host) !$hand! PASS \[something\] \[something\]"
    return
  }
}

# Sorta like the who /msg command, but different...
if { ${ee-enhanced-who} == "yes" } {
  unbind msg - who *msg:who
  bind msg - who msg_enh_who
}
proc msg_enh_who {nick host hand arg} {
  global ircname_list ee-nochop-who
  putloglev c [lindex $arg 0] "\[$nick!$host\] !$hand! WHO $arg"
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: who <channel>"
    return
  }
  set chan [lindex $arg 0]
  if { ![vldchan $chan] } {
    putserv "NOTICE $nick :Invalid channel: $chan"
    return
  }
  # bug: can't match against +o/+m here because they could be spoofing.
  if { [lsearch [chanlist $chan] $nick] == -1 } {
    if { [lsearch [channel info $chan] +secret] != -1 || [string match "*s*" [lindex [getchanmode $chan] 0]] || [string match "*p*" [lindex [getchanmode $chan] 0]] || ${ee-nochop-who} != "yes" } {
      putdcc $idx "Invalid channel: $chan"
      return
    }
  }
  foreach tgt [chanlist $chan] {
    if { [array names ircname_list $tgt] != $tgt } {
      set user_ircname ""
    }
    if { [array names ircname_list $tgt] == $tgt } {
      set user_ircname "($ircname_list($tgt))"
    }
    set user_prefix " "
    if { [isvoice $tgt $chan] } {
      set user_prefix "+"
    }
    if { [isop $tgt $chan] } {
      set user_prefix "@"
    }
    if { [expr [string length $tgt] < 9] } {
      set counter 0
      set buf ""
      set tgt_counter [expr 9 - [string length $tgt]]
      while { $counter != $tgt_counter } {
        set buf "$buf "
        incr counter
      }
      unset counter
      unset tgt_counter
    }
    if { [expr [string length $tgt] >= 9] } {
      set buf ""
    }
    putserv "NOTICE $nick :$chan: \2$user_prefix\2$tgt$buf \2$user_ircname\2"
  }
  putserv "NOTICE $nick :$chan: End of list."
}

bind ctcp p DCC ctcp_dcc_chat
proc ctcp_dcc_chat {nick host hand dest keyword arg} {
  if { [lindex $arg 0] == "CHAT" } {
    setuser $hand XTRA dcc_chat_host "$nick!$host"
  }
  return 0
}

bind msg - explainban msg_explainban
bind msg - .explainban msg_explainban
proc msg_explainban {nick host hand arg} {
  if { $arg == "" } {
    putlog "($nick!$host) !$hand! EXPLAINBAN"
    putserv "NOTICE $nick :Usage: explainban <channel> <channel> ..."
    putserv "NOTICE $nick :Specify 0 for the channel for global bans."
    return
  }
  putlog "($nick!$host) !$hand! EXPLAINBAN $arg"
  set chans $arg
  if { [lsearch $arg "0"] == -1 } {
    lappend chans 0
  }
  foreach target $chans {
    if { $target == 0 } {
      set ban_list [banlist]
    }
    if { $target != 0 } {
      set ban_list [banlist $target]
    }
    foreach ban $ban_list {
      set banmask [lindex $ban 0]
      if { [string match $host "!"] } {
        set ban_pattern $host
      }
      if { ![string match $host "!"] } {
        set ban_pattern "$nick!$host"
      }
      if { [string match $banmask $ban_pattern] } {
        if { $target == 0 } {
          set banstring "Global ban: $banmask"
        }
        if { $target != 0 } {
          putlog c $target "($nick!$host) !$hand! EXPLAINBAN $arg"
          set banstring "$target ban: $banmask:"
        }
        set exp [lindex $ban 2]
        if { $exp == 0 } {
          set banstring "$banstring permanent ban, set [lindex $ban 3] ([ctime [lindex $ban 3]]) by [lindex $ban 5] ([lindex $ban 1])"
        }
        if { $exp != 0 } {
          set banstring "$banstring expiring [lindex $ban 2] ([ctime [lindex $ban 2]]), set [lindex $ban 3] ([ctime [lindex $ban 3]]) by [lindex $ban 5] ([lindex $ban 1])"
        }
        putserv "NOTICE $nick :$banstring"
      }
    }
  }
}

bind msg - math msg_math
bind msg - .math msg_math
proc msg_math {nick host hand arg} {
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: math <expression>"
    return
  }
  putserv "NOTICE $nick :$arg = [expr $arg]"
}

bind pub - .math pub_math
proc pub_math {nick host hand chan arg} {
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: math <expression>"
    return
  }
  putserv "PRIVMSG $chan :::: $arg = [expr $arg]"
}

# Obsolete .topic channel command: insecure
# Obsolete OS command: Linux-only, not cross platform.

# Obsolete voice/kick/ban/op/mode commands: insecure.

# The identify commands match a user on a channel to someone in the userfile.
# The reverse identify does the opposite, searching for a user in the channel
# with a handle in the userfile. It can be used in DCC, on the channel, and
# MSG.
bind pub - .identify pub_identify
bind pub - .id pub_identify
proc pub_identify {nick host hand chan arg} {
  global botnick
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .identify <nickname>"
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan IDENTIFY $arg"
  if { [onchan [lindex $arg 0] $chan] == "0" } {
    putserv "PRIVMSG $chan :IDENTIFY: [lindex $arg 0] is not on the channel."
    return
  }
  if { [string tolower [lindex $arg 0]] == [string tolower $botnick] } {
    putserv "PRIVMSG $chan :IDENTIFY: That's me!"
    return
  }
  set tgt_handle [nick2hand [lindex $arg 0] $chan]
  if { $tgt_handle == "*" } {
    putserv "PRIVMSG $chan :IDENTIFY: Cannot identify [lindex $arg 0]!"
    return
  }
  putserv "PRIVMSG $chan :IDENTIFY: Identified [lindex $arg 0] as $tgt_handle."
  return
}

bind pub - .rid pub_ridentify
bind pub - .ridentify pub_ridentify
proc pub_ridentify {nick host hand chan arg} {
  global botnick
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .ridentify <handle>"
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan RIDENTIFY $arg"
  if { [string tolower [lindex $arg 0]] == [string tolower $botnick] } {
    putserv "PRIVMSG $chan :IDENTIFY: That's me!"
    return
  }
  set tgt_handle [hand2nick $arg $chan]
  if { $tgt_handle == "" } {
    putserv "PRIVMSG $chan :IDENTIFY: Cannot reverse identify [lindex $arg 0]!"
    return
  }
  putserv "PRIVMSG $chan :IDENTIFY: Reverse identified [lindex $arg 0] as $tgt_handle."
  return
}

bind dcc - identify dcc_identify
bind dcc - id dcc_identify
proc dcc_identify {hand idx arg} {
  global botnick
  if { $arg == "" } {
    putdcc $idx "Usage: identify <nickname>"
    return
  }
  if { [lindex $arg 1] == "" } {
    set rchan [lindex [console $idx] 0]
  }
  if { [lindex $arg 1] != "" } {
    set rchan [lindex $arg 1]
  }
  putloglev "c" $rchan "\#$hand\# IDENTIFY $arg"
  if { [onchan [lindex $arg 0] $rchan] == "0" } {
    putdcc $idx "IDENTIFY: [lindex $arg 0] is not on the channel $rchan."
    return
  }
  if { [lindex $arg 0] == $botnick } {
    putdcc $idx "IDENTIFY: That's me!"
    return
  }
  set tgt_handle [nick2hand [lindex $arg 0] $rchan]
  if { $tgt_handle == "*" } {
    putdcc $idx "IDENTIFY: Cannot identify [lindex $arg 0] on $rchan!"
    return
  }
  putdcc $idx "IDENTIFY: Identified [lindex $arg 0] on $rchan as $tgt_handle."
  return
}

bind dcc - rid dcc_ridentify
bind dcc - ridentify dcc_ridentify
proc dcc_ridentify {hand idx arg} {
  global botnick
  if { $arg == "" } {
    putdcc $idx "Usage: .ridentify <handle>"
    return
  }
  if { [lindex $arg 1] == "" } {
    set rchan [lindex [console $idx] 0]
  }
  if { [lindex $arg 1] != "" } {
    set rchan [lindex $arg 1]
  }
  putloglev "c" $rchan "\#$hand\# $rchan RIDENTIFY $arg"
  if { [string tolower [lindex $arg 0]] == [string tolower $botnick] } {
    putdcc $idx "IDENTIFY: That's me!"
    return
  }
  set tgt_handle [hand2nick $arg $rchan]
  if { $tgt_handle == "" } {
    putdcc $idx "IDENTIFY: Cannot reverse identify [lindex $arg 0]!"
    return
  }
  putdcc $idx "IDENTIFY: Reverse identified [lindex $arg 0] as $tgt_handle."
  return
}

bind msg - identify msg_identify
bind msg - id msg_identify
bind msg - .id msg_identify
bind msg - .identify msg_identify
proc msg_identify {nick host hand arg} {
  global botnick
  if { $arg == "" } {
    putserv "PRIVMSG $nick :Usage: identify <nickname>"
    return 255
  }
  if { [lindex $arg 1] == "" } {
    putserv "PRIVMSG $nick :Usage: identify <nickname>"
    return 255
  }
  if { [lindex $arg 1] != "" } {
    set rchan [lindex $arg 1]
  }
  putloglev "c" $rchan "[$nick!host] !$hand! IDENTIFY $arg"
  if { [onchan [lindex $arg 0] $rchan] == "0" } {
    putserv "PRIVMSG $nick :IDENTIFY: [lindex $arg 0] is not on the channel $rchan."
    return 128
  }
  if { [lindex $arg 0] == $botnick } {
    putserv "PRIVMSG $nick :IDENTIFY: That's me!"
    return 0
  }
  set tgt_handle [nick2hand [lindex $arg 0] $rchan]
  if { $tgt_handle == "*" } {
    putserv "PRIVMSG $nick :IDENTIFY: Cannot identify [lindex $arg 0] on $rchan!"
    return 129
  }
  putserv "PRIVMSG $nick :IDENTIFY: Identified [lindex $arg 0] on $rchan as $tgt_handle."
  return 0
}

# Does a cute #WareZZeraW ad. :)
bind pub - .warezad pub_wzad
proc pub_wzad {nick host hand chan arg} {
  putloglev "c" $chan "($host) !$hand! $chan WAREZAD"
  putserv "PRIVMSG $chan :- \[ # 4w 7a 13r 12e z .12 z e r a w \] -"
}

# The bot will tell you your userflags, and flags on the channel.
bind pub - .auth pub_auth
proc pub_auth {nick host hand chan arg} {
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: .auth <user>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Auth Error: Handle does not exist."
    return
  }
  putserv "PRIVMSG $chan :Auth: User $arg [chattr $arg $chan] $chan."
  putloglev "c" $chan "($nick!$host) !$hand! $chan AUTH $arg"
  return
}

# This modified version of .auth works in /MSG.
bind msg - .auth msg_auth
bind msg - auth msg_auth
proc auth {nick host hand arg} {
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: .auth"
    return
  }
  if { ![validuser $hand] } {
    putserv "PRIVMSG $chan :Auth Error: You are not a registered user."
    return
  }
  putserv "PRIVMSG $chan :Auth: You are +[chattr [nick2hand $arg $chan]]."
  putloglev "c" "*" "\[$nick!$host\] !$hand! AUTH $arg"
  return
}

# Last seen stuff.

if { $ee_last_seen == "yes" } {
  bind pub - .seen pub_seen
}
proc pub_seen {nick host hand chan arg} {
  global timezone
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .seen <user1> <user2>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan SEEN $arg"
  foreach tgt $arg {
    if { ![validuser $tgt] } {
      putserv "PRIVMSG $chan :Unregistered user: $tgt"
    }
    if { [validuser $tgt] } {
      set seen-data [getuser $tgt laston]
      putserv "PRIVMSG $chan :Last saw $tgt at [ctime [lindex ${seen-data} 0]] $timezone on [lindex ${seen-data} 1]."
    }
  }
}

bind msg - .seen msg_seen
bind msg - seen msg_seen
proc msg_seen {nick host hand arg} {
  global timezone
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .seen <user1> <user2>..."
    return
  }
  putloglev "c" "*" "\[$nick!$host\] !$hand! SEEN $arg"
  foreach tgt $arg {
    if { ![validuser $tgt] } {
      putserv "PRIVMSG $chan :Unregistered user: $tgt"
    }
    if { [validuser $tgt] } {
      set seen-data [getuser $tgt laston]
      putserv "NOTICE $nick :Last saw $tgt at [ctime [lindex ${seen-data} 0]] $timezone on [lindex ${seen-data} 1]."
    }
  }
}

bind dcc - ctime dcc_ctime
proc dcc_ctime {hand idx arg} {
  if { $arg == "" } {
    putdcc $idx "Usage: ctime <unixtime>"
    return
  }
  putdcc $idx "[ctime [expr $arg + 28800]]"
}

bind pub - .ctime pub_ctime
proc pub_ctime {nick host hand chan arg} {
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: ctime <unixtime>"
    return
  }
  putserv "PRIVMSG $chan :[ctime [expr $arg + 28800]]"
  putloglev "c" $chan "($host) !$hand! $chan CTIME $arg"
}

bind msg - .ctime msg_ctime
bind msg - ctime msg_ctime
proc msg_ctime {nick host hand arg} {
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: ctime <unixtime>"
    return
  }
  putserv "NOTICE $nick :[ctime $arg]"
  putloglev "c" "*" "\[$nick!$host\] !$hand! CTIME $arg"
}

bind msg - .login msg_login
bind msg - login msg_login
proc msg_login {nick host hand arg} {
  global quiet-reject
  if { ![validuser $hand] } {
    putloglev "c" "*" "\[$nick!$host\] !$hand! failed LOGIN (not in userfile)"
    if { quiet-reject != 1 } {
      putserv "NOTICE $nick :You are not a registered user."
    }
    return
  }
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: login <password>"
    return
  }
  if { ![passwdok $hand $arg] } {
    putloglev "c" "*" "\[$nick!$host\] !$hand! failed LOGIN (password incorrect)"
    putserv "NOTICE $nick :Password incorrect, login failed."
    return
  }
  if { [lsearch $host "$nick!*"] == -1 } {
    setuser $hand xtra login-host "$nick!$host"
  }
  if { [lsearch $host "$nick!*"] != -1 } {
    setuser $hand xtra login-host $host
  }
  set proc_autoop_chanlist ""
  set proc_autovoice_chanlist ""
  foreach tgt [channels] {
    if { [botisop $tgt] && [onchan $nick $tgt] } {
      if { ![matchattr $hand O] } {
        if { [matchattr $hand o|o $tgt] } {
          putserv "MODE $tgt +o $nick"
          lappend proc_autoop_chanlist $tgt
        }
      }
      if { ![matchattr $hand V] } {
        if { [matchattr $hand v|v $tgt] } {
          putserv "MODE $tgt +v $nick"
          lappend proc_autovoice_chanlist $tgt
        }
      }
    }
  }
  if { $proc_autoop_chanlist != "" } {
    set proc_autoop_log "auto op chans: $proc_autoop_chanlist,"
    set proc_autoop_msg "Auto opping on channel(s) $proc_autoop_chanlist,"
  }
  if { $proc_autoop_chanlist == "" } {
    set proc_autoop_log "no auto op,"
    set proc_autoop_msg "Not auto opping,"
  }
  if { $proc_autovoice_chanlist != "" } {
    set proc_autovoice_log "auto voice chans: $proc_autovoice_chanlist."
    set proc_autovoice_msg "Auto voicing on channel(s) $proc_autovoice_chanlist."
  }
  if { $proc_autovoice_chanlist == "" } {
    set proc_autovoice_log "no auto voice."
    set proc_autovoice_msg "Not auto voicing."
  }
  putloglev "c" "*" "\[$nick!$host\] !$hand! LOGIN \[something\], $proc_autoop_log $proc_autovoice_log"
  putserv "NOTICE $nick :Password correct, login successful. $proc_autoop_msg $proc_autovoice_msg"
}

bind msg - .logout msg_logout
bind msg - logout msg_logout
bind msg - .logoff msg_logout
bind msg - logoff msg_logout
proc msg_logout {nick host hand arg} {
  global quiet-reject
  if { ![validuser $hand] } {
    putloglev "c" "*" "\[$nick!$host\] !$hand! failed LOGOUT (not in userfile)"
    if { quiet-reject != 1 } {
      putserv "NOTICE $nick :You are not a registered user."
    }
    return
  }
  if { $arg == "" } {
    putserv "NOTICE $nick :Usage: logout <password>"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" "*" "\[$nick!$host\] !$hand! failed LOGOUT (not logged in)"
    putserv "NOTICE $nick :You are not logged in."
    return
  }
  if { ![passwdok $hand $arg] } {
    putloglev "c" "*" "\[$nick!$host\] !$hand! failed LOGOUT (password incorrect)"
    putserv "NOTICE $nick :Password incorrect."
    return
  }
  putloglev "c" "*" "\[$nick!$host\] !$hand! LOGOUT \[something\]"
  setuser $hand xtra login-host ""
  putserv "NOTICE $nick :Logged out."
}

bind pub o|o .op pub_op
proc pub_op {nick host hand chan arg} {
  global botnick
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: I am not opped on $chan."
    putloglev "c" $chan "($host) !$hand! $chan failed OP $arg (bot not opped)"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" $chan "($host) !$hand! $chan failed OP $arg (not logged in)"
    putserv "PRIVMSG $chan :Access denied: $nick is not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .op <nick1> <nickN>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan OP $arg"
  foreach tgt $arg {
    pushmode $chan +o $tgt
  }
}

bind pub o|o .deop pub_deop
bind pub o|o .dop pub_deop
proc pub_deop {nick host hand chan arg} {
  global botnick
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: I am not opped on $chan."
    putloglev "c" $chan "($host) !$hand! $chan failed DEOP $arg (bot not opped)"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" $chan "($host) !$hand! $chan failed DEOP $arg (not logged in)"
    putserv "PRIVMSG $chan :Access denied: $nick is not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .deop <nick1> <nickN>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan DEOP $arg"
  foreach tgt $arg {
    pushmode $chan -o $tgt
  }
}

bind pub o|o .voice pub_voice
proc pub_voice {nick host hand chan arg} {
  global botnick
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: I am not opped on $chan."
    putloglev "c" $chan "($host) !$hand! $chan failed VOICE $arg (bot not opped)"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" $chan "($host) !$hand! $chan failed VOICE $arg (not logged in)"
    putserv "PRIVMSG $chan :Access denied: $nick is not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .voice <nick1> <nickN>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan VOICE $arg"
  foreach tgt $arg {
    pushmode $chan +v $tgt
  }
}

bind pub o|o .devoice pub_devoice
proc pub_devoice {nick host hand chan arg} {
  global botnick
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: I am not opped on $chan."
    putloglev "c" $chan "($host) !$hand! $chan failed DEVOICE $arg (bot not opped)"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" $chan "($host) !$hand! $chan failed DEVOICE $arg (not logged in)"
    putserv "PRIVMSG $chan :Access denied: $nick is not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .devoice <nick1> <nickN>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan DEVOICE $arg"
  foreach tgt $arg {
    pushmode $chan -v $tgt
  }
}

bind pub o|o .kick pub_kick
proc pub_kick {nick host hand chan arg} {
  global botnick
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: I am not opped on $chan."
    putloglev "c" $chan "($host) !$hand! $chan failed KICK $arg (bot not opped)"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putloglev "c" $chan "($host) !$hand! $chan failed KICK $arg (not logged in)"
    putserv "PRIVMSG $chan :Access denied: $nick is not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: .kick <nick1> <nickN>..."
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan KICK $arg"
  foreach tgt $arg {
    putserv "KICK $chan $tgt :Requested by $host ($hand)"
  }
}

bind dcc m msay dcc_msay
proc dcc_msay {hand idx arg} {
  global bot_subnet
  set str $arg
  if { ![vldchan [lindex $str 0]] } {
    set chan [lindex [console $idx] 0]
  }
  if { [vldchan [lindex $str 0]] } {
    set chan [lindex $str 0]
    set str [lreplace $str 0 0]
  }
  if { ![vldchan $chan] } {
    putdcc $idx "ERROR: invalid channel $chan"
    putdcc $idx "Continuing with mass say..."
  }
  if { $bot_subnet == "" } {
    putloglev "c" $chan "\#$hand\# failed MSAY $str (subnet cmds disabled)"
    putdcc $idx "Can't mass say -- subnet commands disabled."
    return
  }
  if { [vldchan $chan] } {
    putserv "PRIVMSG $chan :$str"
  }
  if { $bot_subnet == "" } {
    putsubnet "vBOTNET_MSAY NEW $chan $str"
  }
  if { $bot_subnet != "" } {
    putsubnet "vBOTNET_MSAY $bot_subnet $chan $str"
  }
  putloglev "c" $chan "\#$hand\# MSAY $str"
}

bind bot - vBOTNET_MSAY botnet_msay
proc botnet_msay {bot cmd arg} {
  global warn-subnet-failures
  if { [vldchan [lindex $arg 1]] } {
    if { ![subnetvalid $bot $cmd $arg] } {
      putloglev "c" [lindex $arg 1] "\#bot:$bot\# failed MSAY [lreplace $arg 0 1] (subnet cmds disabled)"
      if { ${warn-subnet-failures} == "yes" } {
        putbot $bot "vBOTNET_SUBNET_DISABLED $cmd"
      }
      return
    }
    putserv "PRIVMSG [lindex $arg 1] :[lreplace $arg 0 1]"
    putloglev "c" [lindex $arg 1] "\#bot:$bot\# MSAY [lreplace $arg 0 1]"
  }
}

bind pub - .say pub_say
proc pub_say {nick host hand chan arg} {
  if { ![matchattr $hand m|m $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    putloglev "c" $chan "($host) !$hand! $chan failed SAY $arg"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied - not logged in."
    putloglev "c" $chan "($host) !$hand! $chan failed SAY $arg"
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan SAY $arg"
  putserv "PRIVMSG $chan :$arg"
}

bind pub - .act pub_act
proc pub_act {nick host hand chan arg} {
  if { ![matchattr $hand m|m $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    putloglev "c" $chan "($host) !$hand! $chan failed ACT $arg"
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied - not logged in."
    putloglev "c" $chan "($host) !$hand! $chan failed ACT $arg"
    return
  }
  putloglev "c" $chan "($host) !$hand! $chan ACT $arg"
  putserv "PRIVMSG $chan :ACTION $arg"
}

bind pub - .time pub_time
proc pub_time {nick host hand chan arg} {
  global timezone
  putserv "PRIVMSG $chan :Local time is: [ctime [unixtime]] $timezone"
}

bind msg - .time msg_time
bind msg - time msg_time
proc msg_time {nick host hand arg} {
  global timezone
  putserv "NOTICE $nick :Local time is: [ctime [unixtime]] $timezone"
}

bind pub - .addvoice pub_addvoice
proc pub_addvoice {nick host hand chan arg} {
  if { ![matchattr $hand o|o $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: addvoice <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |+v $chan
  putserv "PRIVMSG $chan :Added $arg as voice on $chan."
}

bind pub - .addop pub_addop
proc pub_addop {nick host hand chan arg} {
  if { ![matchattr $hand o|o $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: addop <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |+o $chan
  putserv "PRIVMSG $chan :Added $arg as operator on $chan."
}

bind pub - .remvoice pub_remvoice
proc pub_remvoice {nick host hand chan arg} {
  if { ![matchattr $hand o|o $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: remvoice <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |-v $chan
  putserv "PRIVMSG $chan :Removed $arg as voice on $chan."
}

bind pub - .remop pub_remop
proc pub_remop {nick host hand chan arg} {
  if { ![matchattr $hand o|m $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: remop <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |-o $chan
  putserv "PRIVMSG $chan :Removed $arg as operator on $chan."
}

bind pub - .addmaster pub_addmaster
proc pub_addmaster {nick host hand chan arg} {
  if { ![matchattr $hand m|n $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: addmaster <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |+m $chan
  putserv "PRIVMSG $chan :Added $arg as master on $chan."
}

bind pub - .remmaster pub_remmaster
proc pub_remmaster {nick host hand chan arg} {
  if { ![matchattr $hand m|n $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: remmaster <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |-m $chan
  putserv "PRIVMSG $chan :Removed $arg as master on $chan."
}

bind pub - .addowner pub_addowner
proc pub_addowner {nick host hand chan arg} {
  if { ![matchattr $hand m|n $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: addowner <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |+n $chan
  putserv "PRIVMSG $chan :Added $arg as OWNER on $chan!"
}

bind pub - .remowner pub_remowner
proc pub_remowner {nick host hand chan arg} {
  if { ![matchattr $hand m|n $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { $arg == "" } {
    putserv "PRIVMSG $chan :Usage: remowner <handle>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  chattr $arg |-n $chan
  putserv "PRIVMSG $chan :Removed $arg as owner on $chan."
}

bind pub - .adduser pub_adduser
proc pub_adduser {nick host hand chan arg} {
  if { ![matchattr $hand m|m $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { [llength $arg] < 1 } {
    putserv "PRIVMSG $chan :Usage: adduser <user> \[mask\]"
    return
  }
  if { [lindex $arg 1] == "" && [onchan [lindex $arg 0] $chan] } {
    set mask [uh2mask [getchanhost [lindex $arg 0] $chan]]
  }
  if { [lindex $arg 1] == "" && ![onchan [lindex $arg 0] $chan] } {
    putserv "PRIVMSG $chan :[lindex $arg 0] is not on $chan. Try adding a hostmask."
    return
  }
  if { [lindex $arg 1] != "" } {
    set mask [lindex $arg 1]
  }
  adduser [lindex $arg 0] $mask
  putserv "PRIVMSG $chan :Added user [lindex $arg 0] with hostmask $mask."
}

bind pub - .deluser pub_deluser
proc pub_deluser {nick host hand chan arg} {
  if { ![matchattr $hand m|m $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { [llength $arg] != 1 } {
    putserv "PRIVMSG $chan :Usage: deluser <user>"
    return
  }
  if { ![validuser $arg] } {
    putserv "PRIVMSG $chan :Error: Invalid handle."
    return
  }
  if { [matchattr $arg f] || [matchattr $arg o] || [matchattr $arg t] || [matchattr $arg j] || [matchattr $arg a] || [matchattr $arg q] || [matchattr $arg v] || [matchattr $arg k] || [matchattr $arg d] || [matchattr $arg c] } {
    putserv "PRIVMSG $chan :User has special global flags, refused to delete."
    return
  }
  foreach tgt [channels] {
    if { $tgt != $chan } {
      if { [matchattr $arg |f $tgt] || [matchattr $arg |o $tgt] || [matchattr $arg |a $tgt] || [matchattr $arg |q $tgt] || [matchattr $arg |v $tgt] || [matchattr $arg |k $tgt] || [matchattr $arg |d $tgt] } {
        putserv "PRIVMSG $chan :User has special flags on $tgt, refused to delete."
        return
      }
    }
  }
  set tgt_nick ""
  foreach target [userlist] {
    if { [string tolower $target] == [string tolower $arg] } {
      set tgt_nick $target
    }
  }
  if { $tgt_nick == "" } {
    set tgt_nick $tgt
  }
  deluser $tgt_nick
  putserv "PRIVMSG $chan :Deleted user $tgt_nick."
}

bind pub - .bans pub_bans
proc pub_bans {nick host hand chan arg} {
  global timezone
  foreach tgt [banlist] {
    if { [string tolower [lindex $arg 0]] == [string tolower [lindex $tgt 5]] || [string match [string tolower [lindex $arg 0]] [string tolower [lindex $tgt 0]]] == 1 || [string match [string tolower [lindex $arg 0]] [string tolower [lindex $tgt 1]]] \
|| $arg == "" } {
      if { [lindex $tgt 2] != 0 } {
        if { [lindex $tgt 4] != 0 } {
          putserv "NOTICE $nick :Global ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], expiring at [ctime [lindex $tgt 2]] $timezone, created at [ctime [lindex $tgt 3]] $timezone, last used at [ctime [lindex $tgt 4]] $timezone.)"
        }
        if { [lindex $tgt 4] == 0 } {
          putserv "NOTICE $nick :Global ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], expiring at [ctime [lindex $tgt 2]] $timezone, created at [ctime [lindex $tgt 3]] $timezone, never used.)"
        }
      }
      if { [lindex $tgt 2] == 0 } {
        if { [lindex $tgt 4] != 0 } {
          putserv "NOTICE $nick :Global permanent ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], created at [ctime [lindex $tgt 3]] $timezone, last used at [ctime [lindex $tgt 4]] $timezone.)"
        }
        if { [lindex $tgt 4] == 0 } {
          putserv "NOTICE $nick :Global permanent ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], created at [ctime [lindex $tgt 3]] $timezone, never used.)"
        }
      }
    }
  }
  foreach tgt [banlist $chan] {
    if { [string tolower [lindex $arg 0]] == [string tolower [lindex $tgt 5]] || [string match [string tolower [lindex $arg 0]] [string tolower [lindex $tgt 0]]] == 1 || [string match [string tolower [lindex $arg 0]] [string tolower [lindex $tgt 1]]] \
|| $arg == "" } {
      if { [lindex $tgt 2] != 0 } {
        if { [lindex $tgt 4] != 0 } {
           putserv "NOTICE $nick :Channel ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], expiring at [ctime [lindex $tgt 2]] $timezone, created at [ctime [lindex $tgt 3]] $timezone, last used at [ctime [lindex $tgt 4]] $timezone.)"
        }
        if { [lindex $tgt 4] == 0 } {
          putserv "NOTICE $nick :Channel ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], expiring at [ctime [lindex $tgt 2]] $timezone, created at [ctime [lindex $tgt 3]] $timezone, never used.)"
        }
      }
      if { [lindex $tgt 2] == 0 } {
        if { [lindex $tgt 4] != 0 } {
          putserv "NOTICE $nick :Channel permanent ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], created at [ctime [lindex $tgt 3]] $timezone, last used at [ctime [lindex $tgt 4]] $timezone.)"
        }
        if { [lindex $tgt 4] == 0 } {
          putserv "NOTICE $nick :Channel permanent ban: [lindex $tgt 0] (\[[lindex $tgt 1]\] Created by [lindex $tgt 5], created at [ctime [lindex $tgt 3]] $timezone, never used.)"
        }
      }
    }
  }
  putserv "NOTICE $nick :End of ban list."
  putlog "($host) !$hand! $chan BANS $arg"
}

bind pub o|o .+ban pub_addban
proc pub_addban {nick host hand chan arg} {
  global ban-time
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { [llength $arg] < 1 } {
    putserv "PRIVMSG $chan :Usage: +ban <banmask> \[lifetime\] \[reason\]"
    putserv "PRIVMSG $chan :Lifetime is in minutes. Note that if the lifetime is set to 0, the ban is permanent."
    return
  }
  set counter 0
  set arg2_num 1
  set ib 0
  while { $arg2_num == 1 && $ib != "" } {
    set ib [string index [lindex $arg 1] $counter]
    if { $ib != 0 && $ib != 1 && $ib != 2 && $ib != 3 && $ib != 4 && $ib != 5 && $ib != 6 && $ib != 7 && $ib != 8 && $ib != 9 && $ib != " " && $ib != "" } {
      set arg2_num 0
    }
    incr counter
  }
  if { [lindex $arg 1] == " " } {
    set arg2_num 0
  }
  unset counter
  unset ib
  if { [lindex $arg 1] != "" && $arg2_num == 1 } {
    set life [expr [lindex $arg 1]]
  }
  if { [lindex $arg 1] == "" || $arg2_num != 1 } {
    set life ${ban-time}
  }
  if { $arg2_num == 1 } {
    if { [lindex $arg 2] != "" } {
      set cmt [lreplace $arg 0 1]
    }
  }
  if { $arg2_num != 1 } {
    if { [lindex $arg 1] != "" } {
      set cmt [lreplace $arg 0 0]
    }
  }
  if { $arg2_num == 1 } {
#    if { [lindex $arg 2] == "" && $life != 0 } {
#      set cmt "Requested by $nick ($hand), for $life minutes"
#    }
#    if { [lindex $arg 2] == "" && $life == 0 } {
#      set cmt "Requested by $nick ($hand), permanent"
#    }
    if { [lindex $arg 2] == "" } {
      set cmt "Requested by $nick"
    }
  }
  if { $arg2_num == 0 } {
#    if { [lindex $arg 1] == "" && $life != 0 } {
#      set cmt "Requested by $nick ($hand), for $life minutes"
#    }
#    if { [lindex $arg 1] == "" && $life == 0 } {
#      set cmt "Requested by $nick ($hand), permanent"
#    }
    if { [lindex $arg 1] == "" } {
      set cmt "Requested by $nick"
    }
  }
  if { $life == 0 } {
    set cmt "$cmt \[by $hand, permanent\]"
  }
  if { $life != 0 } {
    set cmt "$cmt \[by $hand, $life min\]"
  }
  if { [string length $cmt] > 63 } {
    putserv "PRIVMSG $chan :ERROR: The reason can be no longer than 63 characters."
    putserv "PRIVMSG $chan :ERROR: Ban string was: $cmt"
    return
  }
  if { [onchan [lindex $arg 0] $chan] } {
    set banmask "*![uh2mask [getchanhost [lindex $arg 0] $chan]]"
  }
  if { ![onchan [lindex $arg 0] $chan] } {
    set banmask [lindex $arg 0]
  }
  newchanban $chan $banmask $hand "$cmt \[\]" $life
  if { $life == 0 } {
    putserv "PRIVMSG $chan :Added ban."
  }
  if { $life != 0 } {
    putserv "PRIVMSG $chan :Added ban for $life minutes."
  }
  putlog "($host) !$hand! $chan +BAN $arg"
}

bind pub o|o .-ban pub_delban
proc pub_delban {nick host hand chan arg} {
  if { ![isloggedin $hand "$nick!$host"] } {
    putserv "PRIVMSG $chan :Access denied: not logged in."
    return
  }
  if { [llength $arg] < 1 } {
    putserv "PRIVMSG $chan :Usage: -ban <banmask>"
    return
  }
  foreach tgt [banlist] {
    if { [lindex $tgt 0] == [lindex $arg 0] } {
      putserv "PRIVMSG $chan :Can't remove a global ban!"
      putlog "($host) !$hand! $chan failed -BAN $arg (is a global ban)"
      return
    }
  }
  killchanban $chan [lindex $arg 0]
  putserv "PRIVMSG $chan :Removed ban."
  putlog "($host) !$hand! $chan -BAN $arg"
}

if { [file exists scripts/vinfo.tcl] } {
  source scripts/vinfo.tcl
}
#if { ![file exists scripts/vinfo.tcl] } {
#  putlog "Eggdrop Extensions: Can't find scripts/vinfo.tcl, vInfo not loaded."
#}
if { [file exists scripts/vqotd.tcl] } {
  source scripts/vqotd.tcl
}
if { ![file exists scripts/vqotd.tcl] } {
  putlog "Eggdrop Extensions: Can't find scripts/vqotd.tcl, vQOTD not loaded."
}

### END ###
putlog "Eggdrop Extensions v$eggext_version by Vulture loaded."
