######       vQOTD version 0.2
######          by Vulture
######################################

if { [info vars eggext_version] != "eggext_version" } {
  error "vQOTD: Eggdrop Extensions not found! It must be installed BEFORE vQOTD."
}

bind pub - .qotd pub_qotd
bind pub - .vqotd pub_qotd

proc pub_qotd {nick host hand chan arg} {
  global vq_quotes
  if { $arg == "" } {
    set f_qotd [open vqotd_libs/vqotd.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library empty or not found!"
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  if { $arg != "" } {
    set f_qotd [open vqotd_libs/[string tolower [lindex $arg 0]].user.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      file delete vqotd_libs/[lindex $arg 0].user.vql
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  gets $f_qotd vq_qline
  while { $vq_qline != "" } {
    lappend vq_quotes $vq_qline
    gets $f_qotd vq_qline
  }
  close $f_qotd
  if { $arg == "" } {
    putserv "PRIVMSG $chan :vQOTD: [lindex $vq_quotes [rand [llength $vq_quotes]]]"
  }
  if { $arg != "" } {
    putserv "PRIVMSG $chan :vQOTD: [lindex $vq_quotes [rand [llength $vq_quotes]]]"
  }
  putlog "$nick ($hand) used the QOTD $arg on $chan"
  return
}

bind pub - .qk pub_qk
proc pub_qk {nick host hand chan arg} {
  global botnick
  if { ![matchattr $hand o|o $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand $host] } {
    putserv "PRIVMSG $chan :Access denied: Not logged in."
    return
  }
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: $botnick is not opped."
    return
  }
  global vq_quotes
  if { [llength $arg] != "2" } {
    set f_qotd [open vqotd_libs/vqotd.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library empty or not found!"
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  if { [llength $arg] == "2" } {
    set f_qotd [open vqotd_libs/[string tolower [lindex $arg 1]].user.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library for [lindex $arg 1] empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library for [lindex $arg 1] empty or not found!"
      file delete vqotd_libs/[lindex $arg 1].user.vql
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  set tgt_nick [lindex $arg 0]
  gets $f_qotd vq_qline
  while { $vq_qline != "" } {
    lappend vq_quotes $vq_qline
    gets $f_qotd vq_qline
  }
  close $f_qotd
  if { [llength $arg] != "2" } {
    if { ![matchattr [nick2hand $tgt_nick $chan] f] && ![matchchanattr [nick2hand $tgt_nick $chan] f $chan] } {
      putserv "KICK $chan $tgt_nick :[lindex $vq_quotes [rand [llength $vq_quotes]]]"
      putlog "$nick ($hand) used the QOTD CK $arg on $chan"
    }
    if { ![matchattr [nick2hand $tgt_nick $chan] f] || ![matchchanattr [nick2hand $tgt_nick $chan] f $chan] && [matchattr $hand m] || [matchchanattr $hand m $chan] } {
      putserv "KICK $chan $tgt_nick :[lindex $vq_quotes [rand [llength $vq_quotes]]]"
      putlog "$nick ($hand) used the QOTD CK $arg on $chan"
    }
  }
  if { [llength $arg] == "2" } {
    if { ![matchattr [nick2hand $tgt_nick $chan] f] && ![matchchanattr [nick2hand $tgt_nick $chan] f $chan] } {
      putserv "KICK $chan $tgt_nick :[lindex $vq_quotes [rand [llength $vq_quotes]]] -- Random idiotic or sick things [lindex $arg 0] has said..."
      putlog "$nick ($hand) used the QOTD CK $arg on $chan"
    }
    if { ![matchattr [nick2hand $tgt_nick $chan] f] || ![matchchanattr [nick2hand $tgt_nick $chan] f $chan] && [matchattr $hand m] || [matchchanattr $hand m] } {
      putserv "KICK $chan $tgt_nick :[lindex $vq_quotes [rand [llength $vq_quotes]]] -- Random idiotic or sick things [lindex $arg 0] has said..."
      putlog "$nick ($hand) used the QOTD CK $arg on $chan"
    }
  }
  return
}

bind pub - .rtopic pub_rtopic
proc pub_rtopic {nick host hand chan arg} {
  global botnick
  if { ![matchattr $hand o|o $chan] } {
    putserv "PRIVMSG $chan :Access denied."
    return
  }
  if { ![isloggedin $hand $host] } {
    putserv "PRIVMSG $chan :Access denied: Not logged in."
    return
  }
  if { ![botisop $chan] } {
    putserv "PRIVMSG $chan :Access denied: $botnick is not opped."
    return
  }
  global vq_quotes
  if { $arg == "" } {
    set f_qotd [open vqotd_libs/topics.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library empty or not found!"
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  if { $arg != "" } {
    set f_qotd [open vqotd_libs/[string tolower [lindex $arg 0]].user.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putserv "PRIVMSG $chan :vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      file delete vqotd_libs/[string tolower [lindex $arg 0]].user.vql
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  gets $f_qotd vq_qline
  while { $vq_qline != "" } {
    lappend vq_quotes $vq_qline
    gets $f_qotd vq_qline
  }
  close $f_qotd
  if { $arg == "" } {
    putserv "TOPIC $chan :[lindex $vq_quotes [rand [llength $vq_quotes]]]"
  }
  if { $arg != "" } {
    putserv "TOPIC $chan :[lindex $vq_quotes [rand [llength $vq_quotes]]] -- Random idiotic or sick things [lindex $arg 0] has said..."
  }
  putlog "$nick ($hand) used the RTOPIC QOTD $arg on $chan"
  return
}


#bind pub m .addqotd pub_addqotd
#bind pub Q .addqotd pub_addqotd
#proc pub_addqotd {nick host hand chan arg} {
#  set f_vqlib [open vqotd_libs/vqotd.vql RDWR\ CREAT]
#  seek $f_vqlib [file size vqotd_libs/vqotd.vql]
#  puts $f_vqlib $arg
#  putlog "Master $hand ($nick) added the quote: $arg"
#  putserv "NOTICE $nick :vQOTD: Added quote."
#  close $f_vqlib
#  return
#}

#bind pub m .adduqotd pub_adduqotd
#bind pub Q .adduqotd pub_adduqotd
#proc pub_adduqotd {nick host hand chan arg} {
#  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
#  seek $f_vqlib [file size vqotd_libs/[string tolower [lindex $arg 0]].user.vql]
#  puts $f_vqlib [lreplace $arg 0 0]
#  putlog "Master $hand ($nick) added the quote for [lindex $arg 0]: [lreplace $arg 0 0]"
#  putserv "NOTICE $nick :vQOTD: Added quote for [lindex $arg 0]."
#  close $f_vqlib
#  return
#}

#bind pub m .deluqotd pub_deluqotd
#bind pub Q .deluqotd pub_deluqotd
#proc pub_deluqotd {nick host hand chan arg} {
#  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
#  gets $f_vqlib vq_qline
#  if { $vq_qline == "" } {
#    putlog "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
#    putserv "NOTICE $nick :vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
#    close $f_vqlib
#    file delete vqotd_libs/[lindex $arg 0].uesr.vql
#    return
#  }
#  set f_vqnewlib [open vqotd_libs/[lindex $arg 0].user.new.vql RDWR\ CREAT]
#  while { $vq_qline != "" } {
#    if { [lsearch $vq_qline [lindex $arg 1]] == "-1" } {
#      puts $f_vqnewlib $vq_qline
#    }
#    gets $f_vqlib vq_qline
#  }
#  close $f_vqlib
#  close $f_vqnewlib
#  file delete vqotd_libs/[lindex $arg 0].user.vql
#  file rename vqotd_libs/[lindex $arg 0].user.new.vql vqotd_libs/[lindex $arg 0].user.vql
#  putlog "Removed any quotes from [lindex $arg 0]'s quote file matching [lindex $arg 1]"
#  putserv "NOTICE $nick :vQOTD: Removed any quotes from [lindex $arg 0]'s quote file matching [lindex $arg 1]"
#  return
#}

#bind pub m .delqotd pub_delqotd
#bind pub Q .delqotd pub_delqotd
#proc pub_delqotd {nick host hand chan arg} {
#  if { [llength $arg] != 2 } {
#    set vq_libfile "vqotd"
#    set vq_matchstr [lindex $arg 0]
#  }
#  if { [llength $arg] == 2 } {
#    set vq_libfile [lindex $arg 0]
#    set vq_matchstr [lindex $arg 1]
#  }
#  set f_vqlib [open vqotd_libs/[set vq_libfile].vql RDWR\ CREAT]
#  gets $f_vqlib vq_qline
#  if { $vq_qline == "" } {
#    putlog "vQOTD Error: Quote file for $vq_libfile empty or not found!"
#    putserv "NOTICE $nick :vQOTD Error: Quote file for $vq_libfile empty or not found!"
#    close $f_vqlib
#    file delete vqotd_libs/[set vq_libfile].vql
#    return
#  }
#  set f_vqnewlib [open vqotd_libs/[set vq_libfile].new.vql RDWR\ CREAT]
#  while { $vq_qline != "" } {
#    if { [lsearch $vq_qline $vq_matchstr] == "-1" } {
#      puts $f_vqnewlib $vq_qline
#    }
#    gets $f_vqlib vq_qline
#  }
#  close $f_vqlib
#  close $f_vqnewlib
#  file delete vqotd_libs/$vq_libfile.vql
#  file rename vqotd_libs/$vq_libfile.new.vql vqotd_libs/$vq_libfile.vql
#  putlog "Removed any quotes from $vq_libfile's quote file matching $vq_matchstr"
#  putserv "NOTICE $nick :vQOTD: Removed any quotes from $vq_libfile's quote file matching $vq_matchstr"
#  return
#}

#bind pub m .delunqotd pub_delunqotd
#bind pub Q .delunqotd pub_delunqotd
#proc pub_delunqotd {nick host hand chan arg} {
#  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
#  gets $f_vqlib vq_qline
#  if { $vq_qline == "" } {
#    putlog "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
#    putserv "NOTICE $nick :vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
#    close $f_vqlib
#    file delete [lindex $arg 0].user.vql
#    return
#  }
#  set f_vqnewlib [open vqotd_libs/[lindex $arg 0].user.new.vql RDWR\ CREAT]
#  set vq_proc 0
#  while { $vq_qline != "" } {
#    if { $vq_proc != [lindex $arg 1] } {
#      puts $f_vqnewlib $vq_qline
#    }
#    incr vq_proc
#    gets $f_vqlib vq_qline
#  }
#  close $f_vqlib
#  close $f_vqnewlib
#  file delete vqotd_libs/[lindex $arg 0].user.vql
#  file rename vqotd_libs/[lindex $arg 0].user.new.vql vqotd_libs/[lindex $arg 0].user.vql
#  putlog "Removed quote #[lindex $arg 1] from [lindex $arg 0]'s quote file"
#  putserv "NOTICE $nick :vQOTD: Removed quote #[lindex $arg 1] from [lindex $arg 0]'s quote file"
#  return
#}

#bind pub - .listqotd pub_listqotd
#proc pub_listqotd {nick host hand chan arg} {
#  putlog "$nick ($hand) used .listqotd $arg on $chan"
#  putserv "NOTICE $nick :vQOTD: Listing quotes..."
#  if { $arg == "" } {
#    set vq_qfile "vqotd"
#  }
#  if { $arg != "" } {
#    set vq_qfile $arg
#  }
#  set f_vqlib [open vqotd_libs/$vq_qfile.vql RDWR\ CREAT]
#  gets $f_vqlib vq_line
#  set vq_counter 0
#  while { $vq_line != "" } {
#    putserv "NOTICE $nick :vQOTD: QOTD \[$vq_counter\]: $vq_line"
#    gets $f_vqlib vq_line
#    incr vq_counter
#  }
#  close $f_vqlib
#  putserv "NOTICE $nick :vQOTD: End of list."
#  return
#}

######################################### DCC stuff

bind dcc - listqotd dcc_listqotd
proc dcc_listqotd {hand idx arg} {
  putlog "$hand used .listqotd $arg on DCC"
  putdcc $idx "vQOTD: Listing quotes..."
  if { $arg == "" } {
    set vq_qfile "vqotd"
  }
  if { $arg != "" } {
    set vq_qfile $arg
  }
  set f_vqlib [open vqotd_libs/$vq_qfile.vql RDWR\ CREAT]
  gets $f_vqlib vq_line
  set vq_counter 0
  while { $vq_line != "" } {
    putdcc $idx "vQOTD: QOTD \[$vq_counter\]: $vq_line"
    gets $f_vqlib vq_line
    incr vq_counter
  }
  close $f_vqlib
  putdcc $idx "vQOTD: End of list."
  return
}

bind dcc - qotd dcc_qotd
bind dcc - vqotd dcc_qotd
proc dcc_qotd {hand idx arg} {
  global vq_quotes
  if { $arg == "" } {
    set f_qotd [open vqotd_libs/vqotd.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putdcc $idx "vQOTD Error: QOTD library empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library empty or not found!"
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  if { $arg != "" } {
    set f_qotd [open vqotd_libs/[string tolower [lindex $arg 0]].user.vql RDONLY\ CREAT]
    gets $f_qotd vq_qline
    if { $vq_qline == "" } {
      putdcc $idx "vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      close $f_qotd
      putlog "vQOTD Error: QOTD library for [lindex $arg 0] empty or not found!"
      file delete vqotd_libs/[string tolower [lindex $arg 0]].user.vql
      return
    }
    set vq_quotes ""
    lappend vq_quotes "$vq_qline"
  }
  gets $f_qotd vq_qline
  while { $vq_qline != "" } {
    lappend vq_quotes $vq_qline
    gets $f_qotd vq_qline
  }
  close $f_qotd
  if { $arg == "" } {
    putdcc $idx "vQOTD: [lindex $vq_quotes [rand [llength $vq_quotes]]]"
  }
  if { $arg != "" } {
    putdcc $idx "vQOTD: [lindex $vq_quotes [rand [llength $vq_quotes]]] -- Random idiotic or sick things [lindex $arg 0] has said..."
  }
  putlog "$hand used the QOTD $arg on DCC"
  return
}

bind dcc m addqotd dcc_addqotd
bind dcc Q addqotd dcc_addqotd
proc dcc_addqotd {hand idx arg} {
  set f_vqlib [open vqotd_libs/vqotd.vql RDWR\ CREAT]
  seek $f_vqlib [file size vqotd_libs/vqotd.vql]
  puts $f_vqlib $arg
  putlog "Master $hand added the quote: $arg"
  putdcc $idx "vQOTD: Added quote."
  close $f_vqlib
  return
}

bind dcc m adduqotd dcc_adduqotd
bind dcc Q adduqotd dcc_adduqotd
proc dcc_adduqotd {hand idx arg} {
  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
  seek $f_vqlib [file size vqotd_libs/[string tolower [lindex $arg 0]].user.vql]
  puts $f_vqlib [lreplace $arg 0 0]
  putlog "Master $hand added the quote for [lindex $arg 0]: [lreplace $arg 0 0]"
  putdcc $idx "vQOTD: Added quote for [lindex $arg 0]."
  close $f_vqlib
  return
}

bind dcc m deluqotd dcc_deluqotd
bind dcc Q deluqotd dcc_deluqotd
proc dcc_deluqotd {hand idx arg} {
  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
  gets $f_vqlib vq_qline
  if { $vq_qline == "" } {
    putlog "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
    putdcc $idx "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
    close $f_vqlib
    file delete [lindex $arg 0].user.vql
    return
  }
  set f_vqnewlib [open vqotd_libs/[lindex $arg 0].user.new.vql RDWR\ CREAT]
  while { $vq_qline != "" } {
    if { [lsearch $vq_qline [lindex $arg 1]] == "-1" } {
      puts $f_vqnewlib $vq_qline
    }
    gets $f_vqlib vq_qline
  }
  close $f_vqlib
  close $f_vqnewlib
  file delete vqotd_libs/[lindex $arg 0].user.vql
  file rename vqotd_libs/[lindex $arg 0].user.new.vql vqotd_libs/[lindex $arg 0].user.vql
  putlog "Removed any quotes from [lindex $arg 0]'s quote file matching [lindex $arg 1]"
  putdcc $idx "vQOTD: Removed any quotes from [lindex $arg 0]'s quote file matching [lindex $arg 1]"
  return
}

bind dcc m delqotd dcc_delqotd
bind dcc Q delqotd dcc_delqotd
proc dcc_delqotd {hand idx arg} {
  if { [llength $arg] != 2 } {
    set vq_libfile "vqotd"
    set vq_matchstr [lindex $arg 0]
  }
  if { [llength $arg] == 2 } {
    set vq_libfile [lindex $arg 0]
    set vq_matchstr [lindex $arg 1]
  }
  set f_vqlib [open vqotd_libs/$vq_libfile.vql RDWR\ CREAT]
  gets $f_vqlib vq_qline
  if { $vq_qline == "" } {
    putlog "vQOTD Error: Quote file for $vq_libfile empty or not found!"
    putdcc $idx "vQOTD Error: Quote file for $vq_libfile empty or not found!"
    close $f_vqlib
    file delete vqotd_libs/$vq_libfile.vql
    return
  }
  set f_vqnewlib [open vqotd_libs/$vq_libfile.new.vql RDWR\ CREAT]
  while { $vq_qline != "" } {
    if { [lsearch $vq_qline $vq_matchstr] == "-1" } {
      puts $f_vqnewlib $vq_qline
    }
    gets $f_vqlib vq_qline
  }
  close $f_vqlib
  close $f_vqnewlib
  file delete vqotd_libs/$vq_libfile.vql
  file rename vqotd_libs/$vq_libfile.new.vql vqotd_libs/$vq_libfile.vql
  putlog "Removed any quotes from $vq_libfile's quote file matching $vq_matchstr"
  putdcc $idx "vQOTD: Removed any quotes from $vq_libfile's quote file matching $vq_matchstr"
  return
}

bind dcc m delnqotd dcc_delnqotd
bind dcc Q delnqotd dcc_delnqotd
proc dcc_delnqotd {hand idx arg} {
  if { [llength $arg] == 1 } {
    set vq_libfile "vqotd"
    set vq_killnum $arg
  }
  if { [llength $arg] != 1 } {
    set vq_libfile [lindex $arg 0]
    set vq_killnum [lindex $arg 1]
  }
  set f_vqlib [open vqotd_libs/[set vq_libfile].vql RDWR\ CREAT]
  gets $f_vqlib vq_qline
  if { $vq_qline == "" } {
    putlog "vQOTD Error: Quote file for $vq_libfile empty or not found!"
    putdcc $idx "vQOTD Error: Quote file for $vq_libfile empty or not found!"
    close $f_vqlib
    file delete vqotd_libs/[set vq_libfile].vql
    return
  }
  set f_vqnewlib [open vqotd_libs/$vq_libfile.new.vql RDWR\ CREAT]
  set vq_counter 0
  while { $vq_qline != "" } {
    if { $vq_counter != $vq_killnum } {
      puts $f_vqnewlib $vq_qline
    }
    gets $f_vqlib vq_qline
    incr vq_counter
  }
  close $f_vqlib
  close $f_vqnewlib
  file delete vqotd_libs/[set vq_libfile].vql
  file rename vqotd_libs/[set vq_libfile].new.vql vqotd_libs/[set vq_libfile].vql
  putlog "Removed quote #$vq_killnum from $vq_libfile's quote file"
  putdcc $idx "vQOTD: Removed quote #$vq_killnum from $vq_libfile's quote file"
  return
}

bind dcc m delunqotd dcc_delunqotd
bind dcc Q delunqotd dcc_delunqotd
proc dcc_delunqotd {hand idx arg} {
  set f_vqlib [open vqotd_libs/[lindex $arg 0].user.vql RDWR\ CREAT]
  gets $f_vqlib vq_qline
  if { $vq_qline == "" } {
    putlog "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
    putdcc $idx "vQOTD Error: Quote file for [lindex $arg 0] empty or not found!"
    close $f_vqlib
    file delete vqotd_libs/[lindex $arg 0].user.vql
    return
  }
  set f_vqnewlib [open vqotd_libs/[lindex $arg 0].user.new.vql RDWR\ CREAT]
  set vq_proc 0
  while { $vq_qline != "" } {
    if { $vq_proc == [lindex $arg 1] } {
      puts $f_vqnewlib $vq_qline
    }
    incr vq_proc
    gets $f_vqlib vq_qline
  }
  close $f_vqlib
  close $f_vqnewlib
  file delete vqotd_libs/[lindex $arg 0].user.vql
  file rename vqotd_libs/[lindex $arg 0].user.new.vql vqotd_libs/[lindex $arg 0].user.vql
  putlog "Removed quote #[lindex $arg 1] from [lindex $arg 0]'s quote file"
  putdcc $idx "vQOTD: Removed quote #[lindex $arg 1] from [lindex $arg 0]'s quote file"
  return
}

if { ![file exists vqotd_libs] } {
  file mkdir vqotd_libs
}

putlog "Eggdrop Extensions: vQOTD Loaded."
