## NotePod.tcl (c) 1998 by Amadeus - The Elite Scripting Team efNET #scripting
set NP_version "\002NotePod\002 3.02 by \002Amadeus\002" 
##################################################################################
##
## Credits
## Basic design by Einride, - The Elite Scripting Team
## Based on ideas picked from fluxlearn.tcl by Reflux and WDOG.MRC by Genesis
##
#
# NotePod is a channel definition script, similar in many respects to 
# explain and fluxlearn and others. It has many additional features however,
# including but not limited to:
#  - configurable channel triggers
#  - command specific access flags
#  - fallback to users channel status when user is not on bot
#  - only user who set a definition can replace it (except for master)
#  - only configured script_owners (defined in script config) can forget 
#    or replace defs LOCKED by any script_owner listed
#    lock is set by preceeding def with ":"
#    this supports multiple handles in $owner
#  - will not repeat a def within configurable number of mins.
#  - configurable usage limit (default is 5 defs in 3 mins) prevents
#    over-eager users from lagging the bot.
#  - puts non-users who try to use NotePod commands and those who exceed 
#    usage limit on ignore for configurable number of mins.
#  - special commands for masters
#  - command to replace a definition
#  - backup bot automatically takes over when primary leaves channel
#  - botnet commands to sync definitions for two bots
#  - configure once for both bots
#  - dcc commands to get various internal files
#  - dcc commands to show, learn, forget and replace definitions
#  - dcc and channel commands to do wildcard matches of nick and body of
#    definitions
#  - automatically sorts defs
#
#
## Channel commands:
#  command   trigger
#  
#  help     <configuable>    - user level specific help
#        trigger example "?? ??"
#
#  explain  <configurable>   - show a definition
#        trigger example "?? someword"
#
#  scan     <configurable>   - show definition matchs for a wildcard
#             - will match to word* in def name or body
#        trigger example "??? someword"
#
#  scannick    <configurable>   - show definition matches set by nick
#        trigger example "?!? somenick"        
#
#  scanbody    <configurable>   - show wildcard match in body of definitions
#               will match to *word* in body of def
#        trigger example "??! someword"
#
#  learn    <trigger>learn   - learn a new definition
#             - learn will strip tcl {}[] characters from
#             - definitions. 
#             - mIRC attributes and color codes may be used
#             - in body of def.
#        trigger example "?!learn someword and its definition"
#
#             - if def is set by a user listed in $script_owners and is
#               preceeded with a ":", this definiton may only be changed
#               by one of the $script_owners
#               (applies to forget and replace as well)
#
#  forget   <trigger>forget  - forget a definition
#        trigger example "!forget someword"
#
#  replace  <trigger>replace - replace a definition
#        trigger example "!replace someword with a new def"
#
#  Only the user who set a definition may replace or forget it.
#  The NP_Remove_any and NP_Replace_any variables define the level of
#  a user who can forget or replace ANY definiton. This is usually set
#  to M (master). 
#
#  whoset   <trigger>whoset  - show who set a definition
#        trigger example "!whoset someword"
#
#   As a configured NotePOD OWNER, (configuration option script_owners) 
#   you can LOCK a definition by prepending : (colon) when using the learn
#   or replace commands.
#   The following commands allow you to lock or unlock a pre-existing definition.    puthelp "PRIVMSG $nick :\00313$NP_trigger_Lockdef <def>\003 - lock a current definition."
#   lockdef <word>
#   unlockdef <word>
#
## DCC +m commands:
#
#  
#    .np learn , forget, replace, whoset same as for channel commands
#
#    .np show      - dcc equivalent of explain, 
#            - this is raw mode showing whoset also
#    .np wshow     - dcc equivalent of scan
#    .np bshow     - dcc equivalent of scanbody
#    .np nshow     - dcc equivalent of scannick
#
#    .np getlist      - send definition list
#    .np gethist      - send definition change history
#    .np getsync      - send definition sync file
#
#    .np forcesync    - force def list sync on target bot
#    .np killsync     - delete pending def resync list
#
#    .np update    - update def list on target bot
#            - bot DCC sends list to target bot
#
#    .np move <sync|list> - install new synclist or deflist
#            - that was DCCed to bot by owner
#    .np sort      - sort the def list
#
#
## Definition Sorting:
#
# Definition list is sorted on restart, rehash and via dcc command. 
# A backup file is made.
#
#
## Definition Syncing:
#
# When operated on two bots, NotePOD tries to keep the definition files in
# sync on both. It accompishes this via the botnet link, issuing putbot 
# commands as required. 
#
# Both bots execute learn, replace and forget, but only the primary NotePod bot
# will reply to channel explain and scan commands. 
# When the primary goes offline/channel, the secondary takes over 
# public/msged replies. Both bots store all changes made in a sync file
# while the other is offline.
# If bots are linked but on split channels, def sync is done via botnet.
# When a bot relinks, the other will update it via the botnet.
# If synclist is greater that 1k, sync is not done and a note will be sent
# to the bot OWNER. IN this case, the owner must use the .np update command
# to update the other bot.
# If synclist is 51 bytes, this indicates bot has a default list and it 
# will automatically request, via the botnet, the current def list from the 
# other bot. A note will be sent to OWNER.
#
# Both bots MUST have x flag for each other, and you should have an inbound
# directory defined and created on each. They need to be botlinked also :)
#
# IF both go offline/channel, yer screwed, don't bug me.
#   Amadeus`
#
##################################################################################
## NotePOD Configuration
###################################################################################
set notepod_config "scripts/notepod_config.tcl"
###################################################################################
##
## Initialization
##
## Prefix for all lines put in botlog
set NP_log_prefix "\002NotePod:\002"
##

## Load config
if {[info exists notepod_config]} { 
  if {[file isfile $notepod_config]} { 
    putlog "NotePod: loading $notepod_config"
    source $notepod_config 
  } else {
    putlog "NotePOD: Config $notepod_config defined, but not found, exiting."
    return 0
  }
}

##
## Setting triggers
set NP_trigger_Explain  "$Explain"
set NP_trigger_Scan  "$wc_Explain"
set NP_trigger_ScanBody "$body_Explain"
set NP_trigger_ScanNick "$nick_Explain"

if {![info exists NP_trigger_Define]}  { set NP_trigger_Define  [append NP_trigger_Define $NP_pub_trigger "learn"]}
if {![info exists NP_trigger_Remove]}  { set NP_trigger_Remove  [append NP_trigger_Remove $NP_pub_trigger "forget"]}
if {![info exists NP_trigger_Whoset]}  { set NP_trigger_Whoset  [append NP_trigger_Whoset $NP_pub_trigger "whoset"]}
if {![info exists NP_trigger_Replace]} { set NP_trigger_Replace [append NP_trigger_Replace $NP_pub_trigger "replace"]}
if {![info exists NP_trigger_Lockdef]} { set NP_trigger_Lockdef [append NP_trigger_Lockdef $NP_pub_trigger "lockdef"]}
if {![info exists NP_trigger_Unlockdef]} { set NP_trigger_Unlockdef [append NP_trigger_Unlockdef $NP_pub_trigger "unlockdef"]}


set NP_last ""

## Setting paths on each bot
set NP_definition_file ""
set NP_synclist_file ""
set NP_history_file ""
## primary bot
if {[string tolower $botnick] == [string tolower $NP_primary]} {
  set a "explain.txt"
  set NP_definition_file "$NP_primary_path$a"
  set a "npbotsync.txt"
  set NP_synclist_file "$NP_primary_path$a"
  set a "explain.hst"
  set NP_history_file "$NP_primary_path$a"
} else { 
## secondary bot 
  set a "explain.txt"
  set NP_definition_file "$NP_secondary_path$a"
  set a "npbotsync.txt"
  set NP_synclist_file "$NP_secondary_path$a"
  set a "explain.hst"
  set NP_history_file "$NP_secondary_path$a"
}

## Create definition file if not exists
if {![file exists $NP_definition_file]} {
  set exFile [open $NP_definition_file w]
  puts $exFile "$NP_trigger_Explain default_setting  u seem to know how to do it..."
  close $exFile
  putlog "Created definition file $NP_definition_file" 
  set NP_def_created 1
}


## Create history file if not exists
if {![file exists $NP_history_file]} {
  set exFile [open $NP_history_file w]
  close $exFile
  putlog "Created history file $NP_history_file" 
}

## Create sync file if not exists
if {![file exists $NP_synclist_file]} {
  set exFile [open $NP_synclist_file w]
  close $exFile
  putlog "Created sync file $NP_synclist_file" 
}


## lets determine who the targetbot for this one is
if {[string tolower $botnick] == [string tolower $NP_primary]} {
  set NP_targetbot $NP_secondary
  set NP_isprimary 1
} else {
  set NP_targetbot $NP_primary
  set NP_isprimary 0
}
set NP_trigger_Explain_secondary ""
set NP_trigger_Explain_secondary [string tolower [append NP_trigger_Explain_secondary $NP_pub_trigger $NP_secondary]]
set NP_nick_count ""

###################################################################################
##
## utility procs
##
## isowner
## return true if handle is in $script_owners and is +n or +m
## on the bot
## assumes $script_owners is space separated tcl list
proc isowner { handle } {
  global script_owners botnick
  set so_flags "nm"
  if {![validuser $handle]} { return 0 }
  set hdl [string tolower $handle]
  foreach h $script_owners {
    if {([string tolower $h] == $hdl)} {
      if {[ck_NP_attr $handle $so_flags]} { 
        return 1 
      } else { 
        log "Error: $handle flags: [chattr $handle] in NotePOD OWNER list not $soflags on $botnick" 1
        return 1
      }
    }
  }
  return 0
}

## islocked
## returns true if first character of a def is :
## indicating it can only be chnaged by bot $script_owners
proc islocked { text } {
  if {[string index [lindex $text 1] 0] == ":"} {
    return 1
  } else {
    return 0
  }
}

## botnote_owner
## sends a botnote from the bot, to each handle in $owner
proc botnote_owner { text } {
  global owner botnick
  foreach h $owner {
    sendnote $botnick $h "$text"
  }
}

proc sort_defs {} {
  global NP_definition_file
  set bakNP_definition_file "$NP_definition_file.bak"
  set res [ catch { file copy -force $NP_definition_file $bakNP_definition_file } ]
  if {$res} {
    log "ERROR during backup of $NP_definition_file" 1
    return 0
  }
  log "sorting" 1
  set res [ catch { exec sort $bakNP_definition_file > $NP_definition_file } ]
  if {$res} {
    log "ERROR during sort of $bakNP_definition_file > $NP_definition_file restoring backup " 1
    set res [ catch { file copy -force $bakNP_definition_file $NP_definition_file } ]
    if {$res} {
     log "ERROR restoring $NP_definition_file" 1
     return 0
    }
  }
  return 1
}


## If targetbot is offline, or we are primary
## respond to public Explain,Scan Whoset
## OBVIOUSLY, this is only called if WE are on the channel
proc NP_dopub { chan }  {
  global NP_targetbot NP_isprimary
  if {($NP_isprimary==1) || (![onchan $NP_targetbot $chan])} { return 1 }
  return 0
}

proc ck_NP_status { nick chan flags } {
  if {$flags==""} { return 0}
  for {set i 0} {$i < [string length $flags]} {incr i} {
    set flag [string index $flags $i]
    if {$flag=="o"} {
      if {[isop $nick $chan]} { return 1 }
    }
    if {$flag=="v"} {
      if {[isvoice $nick $chan]} { return 1 }
    }
  }  
  return 0
}

##
## ck_NP_attr handle flags
## Returns 1 if "handle" has one or more of "flags"
##
proc ck_NP_attr {handle flags} {
  set cnt [string length $flags]
  set ndx 0
  while {$ndx < $cnt} {
    set flag [string index $flags $ndx]
    if {[matchattr $handle $flag]} { return 1 }
    incr ndx
  }
  return 0
}

##
## log text logit
## Logs "text" with prefix to botlog, if logit is 1
##
proc log {text logit} {
  global NP_log_prefix
  if {$logit} { putlog "$NP_log_prefix $text" }
}

##
##
proc fixthearg {arg} {
  set response ""
  for {set i 0} {$i < [string length $arg]} {incr i} {
    set char [string index $arg $i]
    if {($char != "\173") && ($char != "\175")} { append response $char }
  }
  return $response
}

proc fixthenick {nick} {
  set fixednick ""
  for {set i 0} {$i < [string length $nick]} {incr i} {
    set char [string index $nick $i]
    if {($char == "\133") || ($char == "\135")} {
      append fixednick \134$char
    } else {
      append fixednick $char
    }
  }
  return $fixednick
}

## maintain_lastexplain_nicklimit
## called by timer removes nick def count
## from $NP_nick_count list
proc maintain_lastexplain_nicklimit { nick count } {
  global NP_nick_count NP_last_nicktime
  if {![info exists NP_nick_count]} { return 0 }
  set fixednick [fixthenick $nick]
  set tmppattern "[string tolower $fixednick] *"
  set tmpidx [lsearch -glob [string tolower $NP_nick_count] $tmppattern]

  if { $tmpidx == -1 } {
putlog "Timer remove:  could not find $tmppattern in $NP_nick_count"
    return 0 
  } else {
    set tmp [lreplace $NP_nick_count $tmpidx $tmpidx]
    set NP_nick_count $tmp
putlog "Timer remove:  removed nickcount: $tmpidx $tmppattern"
    return 1
  }
}

## NP_exceeds_Explain_nicklimit
## check if nick has asked more than $NP_max_Explain_nicklimit 
## chan defs within $NP_last_nicktime mins
proc NP_exceeds_Explain_nicklimit { nick host chan } {
  global owner botnick NP_max_Explain_nicklimit NP_last_nicktime NP_nick_count

  set NP_timers_FIX [expr $NP_last_nicktime + 1]
  if {[matchattr [nick2hand $nick $chan] +n]} { return 0 }
  if {$NP_max_Explain_nicklimit == 0} { return 0 }

  set fixednick [fixthenick $nick]
  set tmppattern "[string tolower $fixednick] *" 

  if {![info exists NP_nick_count]} {
    set repeatcount 1
    set NP_nick_count [lappend NP_nick_count "$nick $repeatcount"]
    timer $NP_timers_FIX "maintain_lastexplain_nicklimit {$nick} {$repeatcount}"
    return 0 
  }

  set tmpidx [lsearch -glob [string tolower $NP_nick_count] $tmppattern]
  if {$tmpidx == -1} {
    set repeatcount 1
    set NP_nick_count [lappend NP_nick_count "$nick $repeatcount"]
    timer $NP_timers_FIX "maintain_lastexplain_nicklimit {$nick} {$repeatcount}"
    return 0 
  } else {
    set repeatcount [lindex [lindex $NP_nick_count $tmpidx] 1]
    incr repeatcount
    set NP_nick_count [lreplace $NP_nick_count $tmpidx $tmpidx "$nick $repeatcount"]

    if {$repeatcount > $NP_max_Explain_nicklimit} {
      set timerslist [timers] 
      set time_tmppattern "maintain_lastexplain_nicklimit *$nick*"
      set time_leftidx [lsearch $timerslist $time_tmppattern]
      if {$time_leftidx != -1} {
        set time_left [lindex [lindex $timerslist $time_leftidx] 0]
      } else {
        set time_left $NP_last_nicktime
      }
      putserv "NOTICE $chan :$nick you have exceeded your maximum NotePOD definitions, please wait $time_left mins."
      newignore [maskhost $nick!$host] $botnick "NotePOD" $time_left
      return 1
    } else {
      return 0
    }
  }
}

## ChannelEnabled
## Format: ChannelEnabled channel
proc ChannelEnabled {chan} {
  global NP_channels
  set retval [lsearch -exact [string tolower $NP_channels] [string tolower $chan]]
  if {$retval == -1 } { 
    set retval 0
  } else {
    set retval 1
  }
  return $retval
}


proc ignore_lamers { nick host } {
  global NP_ignore_lamers NP_last_time botnick
  if {$NP_ignore_lamers} {
    newignore [maskhost $nick!$host] $botnick "NotePOD" $NP_last_time
  }
}

##################################################################################
##
## definitions access
##
## GetLine - Retrieve a line from DB
## Format: GetLine name
## Return: date handle definition 
proc GetLine {name} {
  global NP_definition_file
  set exFile [open $NP_definition_file r]
  while {![eof $exFile]} {
    set curline "[gets $exFile]"
    set curdef [string tolower [lindex $curline 0]]
    if {$curdef==$name} {
      close $exFile
      return "[lrange $curline 1 end]" 
    }
  }
  close $exFile
  return "" 
}


## AddLine - Add a line to DB
## Format: AddLine name handle definition
## Return: 1 
proc AddLine {line} {   
  global NP_definition_file
  set name [string tolower [lindex $line 0]]
  set def [lrange $line 1 end]
  set exFile [open $NP_definition_file r]

  set curline ""  
  while {![eof $exFile]} {
    set curline "[gets $exFile]"
    if {[lindex $curline 0]!=$name} { lappend definitions $curline }
  }
  close $exFile

  set exFile [open $NP_definition_file w]
  puts $exFile "$name $def"
  foreach curline $definitions {
    if {$curline!=""} { puts $exFile $curline }
  }
  close $exFile
  sort_defs
  return 1
}

## DelLine - Del a line from DB
## Format: DelLine name
## Return: 1 
proc DelLine {name} {   
  global NP_definition_file
  set exFile [open $NP_definition_file r]
  set npName "[string tolower $name]"
  while {![eof $exFile]} {
    set curline "[gets $exFile]"
    if {[string tolower [lindex $curline 0]]!=$npName} { lappend definitions $curline }
  }
  close $exFile
  set exFile [open $NP_definition_file w]
  foreach curline $definitions {
    if {$curline!=""} { puts $exFile $curline }
  }
  close $exFile
  return 1
}

## GetLines - Retrieve multiple lines from DB
## Format: GetLines name
## Return: tcl list : date handle definition 
## 
proc GetLines {name} {
  global NP_definition_file deflist NP_max_Scan_match_pub
  set exFile [open $NP_definition_file r]
  set deflist ""
  set defmatches 0
  set pattern [append pattern  $name *]
  while {![eof $exFile]} {
    set curline "[gets $exFile]"
    set curdef [string tolower [lindex $curline 0]]

    if {[string match $pattern $curdef]} {
      if {([lrange $curline 2 end] != "") || ([lrange $curline 2 end] != " ")} {
        lappend deflist "$curdef == [lrange $curline 2 end]"
        incr defmatches
        if {$defmatches==$NP_max_Scan_match_pub} {
          lappend deflist "Maximum matches returned"
          close $exFile
          return $deflist 
        }
      }
    }
  }
  close $exFile
  log "found $defmatches" 1
  return $deflist 
}
## 
proc GetLines_body {name} {
  global NP_definition_file deflist NP_max_Scan_match_pvt
  set exFile [open $NP_definition_file r]
  set deflist ""
  set defmatches 0
  set pattern [string tolower [append pattern * $name *]]
  while {![eof $exFile]} {
    set curdefline "[gets $exFile]"
    set curline [lrange $curdefline 2 end]
    if {[string match $pattern $curline]} {
      set curdef [string tolower [lindex $curdefline 0]]
      lappend deflist "$curdef == [lrange $curdefline 2 end]"
      incr defmatches
      if {$defmatches==$NP_max_Scan_match_pvt} {
        lappend deflist "Maximum matches returned"
        close $exFile
        return $deflist 
      }
    }
  }
  close $exFile
  log "found $defmatches" 1
  return $deflist 
}

proc GetLines_nick {name} {
  global NP_definition_file deflist NP_max_Scan_match_pvt
  set exFile [open $NP_definition_file r]
  set deflist ""
  set defmatches 0
  set pattern [string tolower [append pattern * $name *]]
  while {![eof $exFile]} {
    set curline "[gets $exFile]"
    set nick [string tolower [lindex $curline 1]]
    if {[string match $pattern $nick]} {
      set curdef [string tolower [lindex $curline 0]]
      lappend deflist "$curdef == [lrange $curline 2 end]"
      incr defmatches
      if {$defmatches==$NP_max_Scan_match_pvt} {
        lappend deflist "Maximum matches returned"
        close $exFile
        return $deflist 
      }
    }
  }
  close $exFile
  log "found $defmatches" 1
  return $deflist 
}

##################################################################################
##
## Public commands
##

## pubExplain - bound to public Explain cmd
proc pubExplain {nick host handle chan text} {
  global NP_reply_Explain NP_flags_Explain NP_trigger_Explain NP_status_Explain NP_last NP_last_time
  global NP_trigger_Explain_secondary NP_isprimary botnick

  if {[ChannelEnabled $chan]==0} { return 0 }
  if {[string tolower [lindex $text 0]] == $NP_trigger_Explain_secondary} {
    if {$NP_isprimary == 1} { return 0 }
    set text [lindex $text 1]
  } else {
    if {![NP_dopub $chan]} { return 0 }
  }

  if {([ck_NP_attr $handle $NP_flags_Explain] == 0) && (![ck_NP_status $nick $chan $NP_status_Explain])} {
    putserv "NOTICE $nick :you do not have permission to use the $NP_trigger_Explain command"
    log "$handle/$nick ($host) tried to use the $NP_trigger_Explain command - access denied" 1
    ignore_lamers $nick $host
    return 0
  }

  if {[NP_exceeds_Explain_nicklimit $nick $host $chan]} { return 0 }

  set name [string tolower [lindex $text 0]]
  if {$name == ""} { return 0 }
  if {$name == $NP_trigger_Explain} {
    pubHelp $nick $handle $chan
    return 1
  }

  if {([lindex $NP_last 0] == $name) && ([lindex $NP_last 1] == $chan)} {
    if {$NP_reply_Explain == 0} {
      putserv "NOTICE $nick :I already told you about $name less than $NP_last_time minutes ago"
    } else {
      putserv "NOTICE $chan :$nick I already displayed $name less than $NP_last_time minutes ago"
    }
    return 1
  }

  set line [GetLine $name]
  if {$line==""} {
    set retMsg "$name == <not Defined>"
  } else {
    set retMsg "$name == [lrange $line 1 end]"
    set NP_last "$name $chan"
    timer $NP_last_time "set NP_last none"
  }
  if {$NP_reply_Explain == 0} {
    putserv "NOTICE $nick :[join $retMsg]"
  } else {
    putserv "NOTICE $chan :[join $retMsg]"
  }

  return 1
}

## pubScan - bound to public Scan cmd
proc pubScan {nick host handle chan text} {
  global NP_reply_Scan NP_flags_Scan NP_trigger_Scan NP_status_Scan

  if {[ChannelEnabled $chan]==0} {return 0}
  if {![NP_dopub $chan]} { return 0 }

  if {([ck_NP_attr $handle $NP_flags_Scan] == 0) && (![ck_NP_status $nick $chan $NP_status_Scan]) } {
    putserv "NOTICE $nick :you are not authorized to use the $NP_trigger_Scan command"
    log "$handle/$nick ($host) tried to use the $NP_trigger_Scan command - access denied" 1
    ignore_lamers $nick $host
    return 0
  }
  set name [string tolower [lindex $text 0]] 
  if {$name == ""}  { return 0 }
  set line ""
  set line [GetLines $name]
  log "Got [llength $line] matches" 1
  if {$line==""} {
    set retMsg "$name == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$name == [lindex $line $elmcnt]"
      if {$NP_reply_Scan == 0} {
        putserv "NOTICE $nick :[join $retMsg]"
      } else {
        putserv "NOTICE $chan :[join $retMsg]"
      }
      incr elmcnt
    }
    set retMsg "$name == <$elms matches found>" 
  }
  if {$NP_reply_Scan == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }

  return 1
}

## pubScanNick - bound to public ScanNick cmd
proc pubScanNick {nick host handle chan text} {
  global NP_reply_ScanNick NP_flags_ScanNick NP_trigger_ScanNick

  if {[ChannelEnabled $chan]==0} {return 0}
  if {![NP_dopub $chan]} { return 0 }

  if {[ck_NP_attr $handle $NP_flags_ScanNick] == 0} {
    putserv "NOTICE $nick :you are not authorized to use the $NP_trigger_ScanNick command"
    log "$handle/$nick ($host) tried to use the $NP_trigger_ScanNick command - access denied" 1
    ignore_lamers $nick $host
    return 0
  }
  set name [string tolower [lindex $text 0]] 
  if {$name == ""}  { return 0 }

  set line ""
  set line [GetLines_nick $name]
  log "Got [llength $line] matches" 1
  if {$line==""} {
    set retMsg "$name == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$name == [lindex $line $elmcnt]"
      if {$NP_reply_ScanNick == 0} {
        putserv "NOTICE $nick :[join $retMsg]"
      } else {
        putserv "NOTICE $chan :[join $retMsg]"
      }
      incr elmcnt
    }
    set retMsg "$name == <$elms matches found>" 
  }
  if {$NP_reply_ScanNick == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }

  return 1
}

## pubScanBody - bound to public ScanBody cmd
proc pubScanBody {nick host handle chan text} {
  global NP_reply_ScanBody NP_flags_ScanBody NP_trigger_ScanBody
  if {[ChannelEnabled $chan]==0} {return 0}
  if {![NP_dopub $chan]} { return 0 }

  if {[ck_NP_attr $handle $NP_flags_ScanBody] == 0} {
    putserv "NOTICE $nick :you are not authorized to use the $NP_trigger_ScanBody command"
    log "$handle/$nick ($host) tried to use the $NP_trigger_ScanBody command - access denied" 1
    ignore_lamers $nick $host
    return 0
  }
  set name [string tolower [lindex $text 0]] 
  if {$name == ""}  { return 0 }

  set line ""
  set line [GetLines_body $name]
  log "Got [llength $line] matches" 1
  if {$line==""} {
    set retMsg "$name == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$name == [lindex $line $elmcnt]"
      if {$NP_reply_ScanBody == 0} {
        putserv "NOTICE $nick :[join $retMsg]"
      } else {
        putserv "NOTICE $chan :[join $retMsg]"
      }
      incr elmcnt
    }
    set retMsg "$name == <$elms matches found>" 
  }
  if {$NP_reply_ScanBody == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }

  return 1
}


proc pubDefine {nick host handle chan text} {
  global NP_targetbot NP_reply_Define NP_flags_Define NP_trigger_Remove NP_trigger_Define NP_status_Define NP_status_Remove
  global script_owners

  if { [ChannelEnabled $chan]==0} {return 0}

  if {([ck_NP_attr $handle $NP_flags_Define] == 0) && (![ck_NP_status $nick $chan $NP_status_Define])} {
    putserv "NOTICE $nick :you do not have permission to use the $NP_trigger_Define command"
    log "$handle/$nick ($host) tried to use the $NP_trigger_Define command - access denied" 1
    ignore_lamers $nick $host
    return 0
  }

  set text "[fixthearg $text]"
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set def  [lrange $text 1 end] 
  
  if {[GetLine $name]!=""} {
    set retMsg "$name is already Defined. Use $NP_trigger_Remove to Remove it first"
  } else {

    if {[islocked "$handle $def"] && (![isowner $handle])} {
      putserv "NOTICE $nick :You are not authorized to LOCK a definition. Removing lock"
      set def [string range $def 1 end]
    }
    AddLine "$name $handle $def"
    set retMsg "Now: $name == $def"
    np_syncbot $chan "learn $name $handle $def"
  }

  if {$NP_reply_Define == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}

proc pubRemove {nick host handle chan text} {
  global NP_targetbot NP_flags_Remove_any NP_trigger_Remove NP_reply_Remove NP_status_Remove
  global owner script_owners

  if { [ChannelEnabled $chan]==0} {return 0}
  
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set line [GetLine $name]
  set hnd [lindex $line 0]
  if {$line==""} {
    set retMsg "$name is not Defined."
  } else {
    if {($hnd==$handle) || ([ck_NP_attr $handle $NP_flags_Remove_any] == 1)} {
      if {([isowner $hnd]) && (![isowner $handle]) && ([islocked $line])} {
        set retMsg "Sorry, only $script_owners can forget $name"
      } else {
        DelLine $name
        set retMsg "$name has been Removed"
        np_syncbot $chan "forget $name"
      }
    } else {
      set retMsg "Sorry, u haven't got access to Remove $name, set by $hnd"
    }
  }

  if {$NP_reply_Remove == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}

proc pubLockdef {nick host handle chan text} {
  global script_owners NP_reply_Replace
  if {![isowner $handle]} { return 0 }
  
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set line [GetLine $name]
  set hnd [lindex $line 0]
  set def [lrange $line 1 end]
  if {$line==""} {
    set retMsg "$name is not Defined."
  } else {
    if {[islocked $line]} {
      set retMsg "$name is already locked by $hnd"
    } else {
      DelLine $name
      set def ":$def"
      AddLine "$name $handle $def"
      np_syncbot $chan "replace $name $handle $def"
      set retMsg "$name locked == $def"
    }
  }
  if {$NP_reply_Replace == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}

proc pubUnlockdef {nick host handle chan text} {
  global script_owners NP_reply_Replace
  if {![isowner $handle]} { return 0 }
  
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set line [GetLine $name]
  set hnd [lindex $line 0]
  set def [lrange $line 1 end]
  if {$line==""} {
    set retMsg "$name is not Defined."
  } else {
    if {![islocked $line]} {
      set retMsg "$name is not a locked definition"
    } else {
      DelLine $name
      set def "[lrange $def 1 end]"
      AddLine "$name $handle $def"
      np_syncbot $chan "replace $name $handle $def"
      set retMsg "$name unlocked == $def"
    }
  }
  if {$NP_reply_Replace == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}


proc pubWhoset {nick host handle chan text} {
  global NP_trigger_Whoset NP_flags_Whoset NP_reply_Whoset NP_status_Whoset
  if { [ChannelEnabled $chan]==0} {return 0}
  
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set line [GetLine $name]
  set hnd [lindex $line 0]
  if {$line==""} {
    set retMsg "$name is not Defined."
  } else {
    if {([lindex $line 0]==$handle) || ([ck_NP_attr $handle $NP_flags_Whoset] == 1) || ([ck_NP_status $nick $chan $NP_status_Whoset])} {
      set retMsg "$name was set by $hnd"
    } else {
      set retMsg "Sorry, u haven't got access to Whoset $name"
    }
  }

  if {$NP_reply_Whoset == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}


proc pubReplace {nick host handle chan text} {
  global NP_targetbot NP_flags_Replace_any NP_flags_Replace NP_trigger_Replace NP_reply_Replace NP_status_Replace
  global owner script_owners

  if { [ChannelEnabled $chan]==0} {return 0}
  
  set text "[fixthearg $text]"
  set name [string tolower [lindex $text 0]]
  if {$name == ""}  { return 0 }

  set def [lrange $text 1 end]
  set line [GetLine $name]
  set hnd [lindex $line 0]
  
  if {($hnd==$handle) || ([ck_NP_attr $handle $NP_flags_Replace_any] == 1)} {
    if {([isowner $hnd]) && (![isowner $handle]) && ([islocked $line])} {
      set retMsg "Sorry, only $script_owners can replace $name"
    } else {
      if {$line!=""} { DelLine $name }
      if {[islocked "$handle $def"] && (![isowner $handle])} {
        putserv "NOTICE $nick :You are not authorized to LOCK a definition. Removing lock"
        set def [string range $def 1 end]
      }
      AddLine "$name $handle $def"
      np_syncbot $chan "replace $name $handle $def"
      set retMsg "$name replaced == $def"
    }
  } else {
    set retMsg "Sorry, u haven't got access to Replace $name, set by $hnd"
  }

  if {$NP_reply_Replace == 0} {
    putserv "NOTICE $nick :$retMsg"
  } else {
    putserv "NOTICE $chan :$retMsg"
  }
  return 1
}


proc pubHelp {nick handle chan } {
  global NP_version NP_Status_Help NP_max_Scan_match_pub NP_max_Scan_match_pvt
  global NP_trigger_Explain NP_trigger_Scan NP_trigger_Define NP_trigger_Remove 
  global NP_trigger_Whoset NP_trigger_Replace NP_trigger_ScanBody NP_trigger_ScanNick
  global NP_trigger_Lockdef script_owners

  log "Sending Explain help to $nick" 1
  puthelp "PRIVMSG $nick :\00313$NP_version\002"
  puthelp "PRIVMSG $nick :\00313$NP_trigger_Explain <def>\003 show a definition (v/o)"
  if {([matchattr $handle o]) || ([ck_NP_status $nick $chan $NP_Status_Help])} {
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Define <def> <text>\003 - add a new definition (o)"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Remove <def>\003 - remove definition you set (o)"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Replace <def> <newtext>\003 - replace definition you set (o)"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Whoset <def>\003 - shows who set definition (o)"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Scan <def>\003 wildcard match (matches limited to $NP_max_Scan_match_pub)"
    puthelp "PRIVMSG $nick :the default wildcard is \00313def*\003. You can do \00313de*f\003 for example."
  }
  if {[matchattr $handle m]} {
    puthelp "PRIVMSG $nick :As a Master, you can !forget or !replace any definition."
    puthelp "PRIVMSG $nick :You can also use the special scan commands"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_ScanBody <wildcard>\003 - shows up to $NP_max_Scan_match_pub matches for defs containing wildcard."
    puthelp "PRIVMSG $nick :\00313$NP_trigger_ScanNick <nick>\003 - shows up to $NP_max_Scan_match_pub matchs for defs set by nick."
    puthelp "PRIVMSG $nick :Scan commands wil show up to $NP_max_Scan_match_pvt matches, if sent via msg or in dcc chat."   
  } 
  if {[isowner $handle]} {
    puthelp "PRIVMSG $nick :As a configured NotePOD OWNER, you can LOCK a definition by prepending"
    puthelp "PRIVMSG $nick :a \002:\002 when using $NP_trigger_Define or $NP_trigger_Replace"
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Lockdef <def>\003 - lock a current definition."
    puthelp "PRIVMSG $nick :\00313$NP_trigger_Unlockdef <def>\003 - unlock a current definition."
    puthelp "PRIVMSG $nick :Configured NotePOD OWNERS: \002$script_owners\002"
  }
  return 1
}

##################################################################################
##
## dcc commands
##
bind dcc m np dccnpmenu
proc dccnpmenu { handle idx arg } {
  global NP_synclist_file NP_version
  set newarg [lrange $arg 1 end]
  switch [string tolower [lindex $arg 0]] {
    "status"    { set r [dccGetstatus $handle $idx $arg] }
    "getlist"   { set r [dccGetlist $handle $idx $arg] }
    "gethist"   { set r [dccGethist $handle $idx $arg] }
    "getsync"   { set r [dccGetsync $handle $idx $arg] }
    "killsync"  { set r [file delete $NP_synclist_file] }
    "move"      { set r [dccNpMove $handle $idx $newarg] }
    "forcesync" { set r [dccForcesync $handle $idx $arg] }
    "update"    { set r [dccUpdatelist $handle $idx $arg] }
    "show"      { set r [dccGetLine $handle $idx $newarg] }
    "wshow"     { set r [dccScan $handle $idx $newarg] }
    "bshow"     { set r [dccMbody $handle $idx $newarg] }
    "nshow"     { set r [dccMnick $handle $idx $newarg] }
    "learn"     { set r [dccLearn $handle $idx $newarg] }
    "forget"    { set r [dccForget $handle $idx $newarg ] }
    "replace"   { set r [dccReplace $handle $idx $newarg] }
    "whoset"    { set r [dccWhoset $handle $idx $newarg] }
    "sort"      { set r [dccSortdefs $handle $idx $newarg] }
    default {
      putdcc $idx "$NP_version"
      putdcc $idx "\002Getlist\002 - get current definition list"
      putdcc $idx "\002Gethist\002 - get definition change history"
      putdcc $idx "\002Getsync\002 - get pending def resync list"
      putdcc $idx "\002Forcesync\002 - force def list sync"
      putdcc $idx "\002Killsync\002 - delete pending def resync list"
      putdcc $idx "\002Update\002  - update def list on target bot"
      putdcc $idx "\002Move <sync|list>\002 - install synclist or deflist"
      putdcc $idx "\002Sort\002    - sort the def list"
      putdcc $idx "\002Show <def>\002 - show a definition (raw)"
      putdcc $idx "\002wshow <wc>\002 - show matches for def word"
      putdcc $idx "\002bshow <wc>\002 - show matches for word in body of def"
      putdcc $idx "\002nshow <nick>\002 - show defs set by nick"
      putdcc $idx "\002Learn <word> <def>\002"
      putdcc $idx "\002Forget <word>\002"
      putdcc $idx "\002Replace <word> <def>\002"
      putdcc $idx "\002Whoset <word>\002"
      if {[isowner $handle]} {
        putdcc $idx "As a configured NotePOD OWNER, you can LOCK a definition by prepending"
        putdcc $idx "a \002:\002 (colon) when using $NP_trigger_Define or $NP_trigger_Replace"
        putdcc $idx "\002$NP_trigger_Lockdef <def>\002 - lock a current definition."
        putdcc $idx "\002$NP_trigger_Unlockdef <def>\002 - unlock a current definition."
        putdcc $idx "Configured NotePOD OWNERS: \002$script_owners\002"
      }
      set r 0
    }
  }
  return $r
}

##################################################################################
#
## dcc procs
#
proc dccUpdatelist { handle idx arg } {
  global NP_targetbot NP_definition_file
  putbot $NP_targetbot "npsync sendinglist"
  dccsend $NP_definition_file $NP_targetbot 
}
proc dccForcesync {handle idx arg} {
  global botnick NP_targetbot
  set botnames [string tolower [bots]]
  if {[lsearch $botnames [string tolower $NP_targetbot]] == -1} {
    putdcc $idx "$NP_targetbot is not linked"
  } else {
    np_resync
  }
  return 1
}   
#
proc dccNpMove {handle idx arg} {
  global NP_definition_file NP_synclist_file dcc_incoming

  set filetype [string tolower [string trim [lindex $arg 0]]]
  if { $filetype =="" } {
    putidx $idx "\002FILE\002 not specified"
   return 0
  }
  set targetpath ""
  if {$filetype == "sync"} { set targetpath $NP_synclist_file }
  if {$filetype == "list"} { set targetpath $NP_definition_file }
  if {$targetpath==""} {
    putidx $idx "\002FILE\002 unknown"
    return 0
  }
  set filename [file tail $targetpath]

  if {![file isdirectory $dcc_incoming]} {
    putidx $idx "The directory \002$dcc_incoming\002 does not exist - config error."
    return 0
  }
  if {![file isfile "$dcc_incoming/$filename"]} {
    putidx $idx "\002$filename\002 does not exist in \002$dcc_incoming\002"
    return 0
  }
  set res [ catch { file copy -force $dcc_incoming/$filename $targetpath } ]
  if {$res} {
    putidx $idx "An error occured during move of \002$filename\002 from \002$dcc_incoming\002 to \002$targetpath\002 Inform Admin!"
    return 0
  }
  set res [ catch { file delete $dcc_incoming/$filename} ]
  if {$res} {
    putidx $idx "An error occured during delete of \002$filename\002 from \002$dcc_incoming\002 - File was copied, not moved. Inform Admin!"
    return 0
  }
  putidx $idx "\002$filename\002 was moved from Incoming to \002$targetpath\002"
  return 1
}

proc dccGetstatus {handle idx arg} {
  global NP_definition_file NP_history_file NP_synclist_file
  putdcc $idx "Def :$NP_definition_file [file size $NP_definition_file]"
  putdcc $idx "Sync:$NP_synclist_file [file size $NP_synclist_file]"
  putdcc $idx "Hist:$NP_history_file [file size $NP_history_file]"
  return 1
}

proc dccReplace {handle idx arg} {
  global owner scrip_owners
  set text "[fixthearg $arg]"
  set name [string tolower [lindex $text 0]]
  set def [lrange $text 1 end]
  set line [GetLine $name]
  set hnd [lindex $line 0]
  
  if {([isowner $hnd]) && (![isowner $handle]) && ([islocked $line])} {
    putdcc $idx "Sorry, only $script_owners can replace $name"
    return 0
  }

  if {$line!=""} { DelLine $name }
  AddLine "$name $handle $def"
  np_syncbot "dcc" "replace $name $handle $def"
  putdcc $idx "$name replaced == $def"
  return 1
}

proc dccForget {handle idx arg} {
  global owner script_owners
  set name [string tolower [lindex $arg 0]]
  set line [GetLine $name]
  set hnd [lindex $line 0]

  if {([isowner $hnd]) && (![isowner $handle]) && ([islocked $line])} {
    putdcc $idx "Sorry, only $script_owners can forget $name"
    return 0
  }

  if {$line==""} {
    putdcc $idx "$name is not Defined."
  } else {
    DelLine $name
    putdcc $idx "$name has been Removed"
    np_syncbot "dcc" "forget $name" 
  }
  return 1
}
#
proc dccLearn {handle idx arg} {
  set text "[fixthearg $arg]"
  set name [string tolower [lindex $text 0]]
  set def  [lrange $text 1 end] 
  if {[GetLine $name]!=""} {
    putdcc $idx "$name is already Defined. Use .forget to Remove it first"
  } else {
    AddLine "$name $handle $def"
    putdcc $idx "Now: $name == $def"
    np_syncbot "dcc" "learn $name $handle $def" 
  }
  return 1
}
# dcc equivalent of ?*?
proc dccMnick {handle idx arg } {
  set line [GetLines_nick $arg]
  if {$line==""} {
    set retMsg "$arg == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$arg == [lindex $line $elmcnt]"
      putdcc $idx "[join $retMsg]"
      incr elmcnt
    }
    set retMsg "$arg == <$elms matches found>" 
  }
  putdcc $idx "$retMsg"
  return 1
}

# dcc equivalent of ??*
proc dccMbody {handle idx arg } {
  set line [GetLines_body $arg]
  if {$line==""} {
    set retMsg "$arg == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$arg == [lindex $line $elmcnt]"
      putdcc $idx "[join $retMsg]"
      incr elmcnt
    }
    set retMsg "$arg == <$elms matches found>" 
  }
  putdcc $idx "$retMsg"
  return 1
}
#
proc dccScan {handle idx arg } {
  set line [GetLines $arg]
  if {$line==""} {
    set retMsg "$arg == <not Defined>"
  } else {
    set elms [llength $line]
    set elmcnt 0
    while {$elms > $elmcnt} {
      set retMsg "$arg == [lindex $line $elmcnt]"
      putdcc $idx "[join $retMsg]"
      incr elmcnt
    }
    set retMsg "$arg == <$elms matches found>" 
  }
  putdcc $idx "$retMsg"
  return 1
}
proc dccGetLine { handle idx arg } {
  global NP_definition_file
  set dexFile [open $NP_definition_file r]
 
  while {![eof $dexFile]} {
    set curline "[gets $dexFile]"
    set curdef [string tolower [lindex $curline 0]]
    if {$curdef==$arg} {
      close $dexFile
      putdcc $idx "$arg [lrange $curline 1 end]" 
      return 1
    }
  }
  close $dexFile
  putdcc $idx "$arg Not found"
  return 0
}
proc dccWhoset {handle idx arg} {
  set name [string tolower [lindex $arg 0]]
  set line [GetLine $name]
  set hnd [lindex $line 0]
  if {$line==""} {
    putdcc $idx  "$name is not Defined."
  } else {
    putdcc $idx  "$name was set by $hnd"
  }
  return 1
}
#
proc dccGetlist {handle idx arg} {
  global NP_definition_file
  log "$handle $idx requested $NP_definition_file" 1
  if {[file isfile $NP_definition_file]} {
    dccsend $NP_definition_file $handle
  } else {
    putdcc $idx "$NP_definition_file does not exist"
  }
  return 1
}
#
proc dccGethist {handle idx arg} {
  global NP_history_file
  log "$handle $idx [hand2idx $handle] requested $NP_history_file" 1
  if {[file isfile $NP_history_file]} {
    dccsend $NP_history_file $handle
  } else {
    putdcc $idx "$NP_history_file does not exist"
  }
  return 1
}
#
proc dccGetsync {handle idx arg} {
  global NP_synclist_file
  log "$handle $idx [hand2idx $handle] requested $NP_synclist_file" 1
  if {[file isfile $NP_synclist_file]} {
    dccsend $NP_synclist_file $handle
  } else {
    putdcc $idx "$NP_synclist_file does not exist"
  }
  return 1
}
#
proc dccSortdefs {hand idx arg} {
 sort_defs
 return 0
}



##################################################################################
##
## botnet stuff
##
bind link - * npbotlinked
proc npbotlinked { botname via } {
  global NP_targetbot owner botnick NP_synclist_file NP_synclist_limit 
  global NP_definition_file NP_def_created NP_synclist_mode
  if {[string tolower $botname]!=[string tolower $NP_targetbot]} { return 0 }
  log "Botlinked: $botname" 1

  if {[info exists NP_def_created]} {
    if {[file size $NP_definition_file] == 51} {
      log "Requesting definition file" 1
      putbot $NP_targetbot "npsync sendlist"
      set requested_list 1
      botnote_owner "NotePod asked $NP_targetbot for new def list"
    }  
  }

  if {(![file isfile $NP_synclist_file])} {
    log "synclist $NP_synclist_file does not exist" 1
    return 0
  }
  
  if {[file size $NP_synclist_file]==0} {
    log "synclist $NP_synclist_file is empty" 1
    return 0
  }
  if {[file size $NP_synclist_file] >= $NP_synclist_limit} {
    log "synclist $NP_synclist_file [file size $NP_synclist_file] bytes" 1
    if {$NP_synclist_mode} {
      putbot $NP_targetbot "npsync sendinglist"
      set r [dccsend $NP_definition_file $NP_targetbot ]
      if {$r} { 
        botnote_owner "NotePod Resync syncfile to large, sent full def list"
        file delete $NP_synclist_file
      } else {
        botnote_owner "NotePod Resync syncfile to large, ERROR sending full def list"
      }
    } else {
      botnote_owner "NotePod Resync aborted syncfile too large [file size $NP_synclist_file]" 
    }
    return 0
  }
  np_resync
  return 1
}

proc np_resync { } {
  global NP_targetbot owner botnick NP_synclist_file NP_synclist_limit 
  global NP_definition_file NP_def_created NP_synclist_mode

  log "Starting resync with $NP_targetbot" 1

  set npsyncFile [open $NP_synclist_file r]
  set sfcurline ""  
  set sflinecount 0
  while {![eof $npsyncFile]} {
    set sfcurline "[gets $npsyncFile]"
    if {$sfcurline !=""} {
      putbot $NP_targetbot "npsync $sfcurline" 
      incr sflinecount
    }
  }
  close $npsyncFile  
  log "sync send completed" 1
  botnote_owner "NotePod sent $sflinecount resync commands to $NP_targetbot"
  return 1
}
## 
## np_syncbot is called to add, remove or replace a definition
## if targetbot is on channel, it is assumed that it has processed  the command
##
proc np_syncbot { chan arg } {
  global NP_targetbot
  if {$chan=="dcc"} {
    set botnames [string tolower [bots]]
    if {[lsearch $botnames [string tolower $NP_targetbot]]== -1} {
      set command [lindex $arg 0]
      set line [lrange $arg 1 end]
      bot:addline_sync $command $line 
    } else {
      putbot $NP_targetbot "npsync $arg"
    }
    return 1    
  }

  if {![onchan $NP_targetbot $chan]} { 
    set botnames [string tolower [bots]]
    if {[lsearch $botnames [string tolower $NP_targetbot]]== -1} {
      set command [lindex $arg 0]
      set line [lrange $arg 1 end]
      bot:addline_sync $command $line 
    } else {
      putbot $NP_targetbot "npsync $arg"
    }    
  }
  return 1
}

##
## bot:npresync_cmds
## process NotePod botnet commands and responses
##
bind bot - npsync bot:npresync_cmds
proc bot:npresync_cmds { bot com arg } {
  global botnick NP_definition_file NP_synclist_file NP_targetbot expectlist
  if {[string tolower $bot] != [string tolower $NP_targetbot]} {
    log "ERROR: expected $NP_targetbot, got $bot" 1
    return 0
  }
  set cmd [lindex $arg 0]
  set what [lrange $arg 1 end]
  switch -exact $cmd {
    "sendlist" {
      log "$bot asked for def list" 1
      putbot $bot "npsync sendinglist"
      set r [dccsend $NP_definition_file $NP_targetbot ]
    }
    "learn" {
      log "$bot asked $botnick to learn $what" 1
      AddLine $what
      putbot $bot "npsync learned $what"
      set r 1
    }
    "replace" {
      set word [lindex $what 0]
      log "$bot asked $botnick to replace $word : $what" 1
      DelLine $word
      AddLine $what
      putbot $bot "npsync replaced $what"
      set r 1
    }
    "forget"  {
      set word [lindex $what 0]
      log "$bot asked $botnick to forget $word : $what" 1
      DelLine $word
      putbot $bot "npsync forgotten $what"
      set r 1
    }
    "sendinglist" {
      log "$bot sending list" 1
      set expectlist 1
      set r 1
    }
    "learned" {
      log "$bot has learned $what, removing from synclist" 1
      bot:remline_sync "learn" "$what"
      set r 1
    }
    "replaced" {
      log "$bot has replaced $what, removing from synclist" 1
      bot:remline_sync "replace" "$what"
      set r 1
    }
    "forgotten" {
      log "$bot forgotten $what, removing from synclist" 1
      bot:remline_sync "forget" "$what"
      set r 1
    }
    default   {
      set r 1
    }
  }
  return $r
}

bind rcvd - * file_received
proc file_received {hand nick pathtofile} {
  global NP_targetbot NP_definition_file expectlist botnick owner
  log "Received from $nick : [file tail $pathtofile] [file size $pathtofile]bytes [clock format [file mtime $pathtofile] -format "%d/%m/%y"]" 1
  if {[info exists expectlist]} { 
    if {[string tolower $hand] == [string tolower $NP_targetbot]} {
      set filerecd [string tolower [file tail $pathtofile]]
      set fileexpt [string tolower [file tail $NP_definition_file]]
      if {$filerecd == $fileexpt} {
        set res [ catch { file copy -force $pathtofile $NP_definition_file } ]
        if {$res} {
          log "ERROR during update of $NP_definition_file" 1
          return 0
        } else {
          log "Installed new $NP_definition_file from $hand" 1
          botnote_owner "NotePod received new def file from $nick"
        }
      } else {
        log "Received wrongfile name $pathtofile from $hand" 1
      }
    } else {
      log "Received $pathtofile from $hand expecting $NP_targetbot" 1
    }
  } else {
    log "Received unexpected $pathtofile from $hand" 1
  }
  if {[info exists expectlist]} { unset expectlist }
}

##
## bot:addline_sync
## added to sync buffer on successful learn, forget, replace
## only called from np_syncbot
proc bot:addline_sync { command line } {
  global NP_synclist_file
  set name [string tolower [lindex $line 0]]
  set def [lrange $line 1 end]
  set npsyncFile [open $NP_synclist_file r]

  set curline ""  
  while {![eof $npsyncFile]} {
    set curline "[gets $npsyncFile]"
    if {[lindex $curline 0]!=$name} { lappend npSyncBuf $curline }
  }
  close $npsyncFile

  set npsyncFile [open $NP_synclist_file w]
  foreach curline $npSyncBuf {
    if {$curline!=""} { puts $npsyncFile $curline }
  }
  puts $npsyncFile "$command $name $def"
  close $npsyncFile
  sort_defs
  return 1
}

##
## bot:remline_sync
## remove from sync buffer of bot command
## only called from bot:npresync_cmds
##
proc bot:remline_sync { command name } {
  global NP_synclist_file
  if {![file isfile $NP_synclist_file]} {
    log "synclist $NP_synclist_file does not exist" 1
    return 0
  }
  
  if {[file size $NP_synclist_file]==0} {
    log "synclist $NP_synclist_file is empty" 1
    return 0
  }

  set npName "[string tolower $name]"
  set npsyncFile [open $NP_synclist_file r]

  while {![eof $npsyncFile]} {
    set curline "[gets $npsyncFile]"
    if {("[lindex $curline 0]"!=$command) && ("[lindex $curline 1]"!=$npName)} {
      lappend npSyncBuf $curline
    }
  }
  close $npsyncFile

  set npsyncFile [open $NP_synclist_file w]
  foreach curline $npSyncBuf {
    if {$curline!=""} { puts $npsyncFile $curline }
  }
  close $npsyncFile
  return 1
}

##################################################################################
##
## The Public Binds
##
## binds that are active when bot is active processor
## controlled by NP_dopub proc
##
bind pub - "$NP_trigger_Explain"  pubExplain
bind pub - "$NP_trigger_Scan"     pubScan
bind pub - "$NP_trigger_Whoset"   pubWhoset

bind pub - "$NP_trigger_ScanNick" pubScanNick
bind pub - "$NP_trigger_ScanBody" pubScanBody

#
## binds that are always active
##
bind pub - "$NP_trigger_Define"   pubDefine
bind pub - "$NP_trigger_Remove"   pubRemove
bind pub - "$NP_trigger_Replace"  pubReplace
bind pub - "$NP_trigger_Lockdef"  pubLockdef
bind pub - "$NP_trigger_Unlockdef"  pubUnlockdef

##################################################################################
##
## Sort definitions on load and rehash
sort_defs
putlog "$NP_version loaded. Primary:$NP_isprimary Target: $NP_targetbot"
###EOF
##################################################################################
