###################################################################################
##
## NotePOD Configuration
## notepod_config.tcl
##
## enable NotePod log - logentries will be written to eggdrop log
set logit 1

## script owners
## list of nicks (as used on BOT) which can use the ":" definition
## lock feature. Only these nicks may change a definition (set by any one of them),
## which has ":" as the first character.
## these users must be at least +m on the bot
set script_owners "Amadeus` Ms_Jessca taylor^ HarvestR"

## Bots running this script, use exact nicks in BOTNET userlist
## first listed is considered the primary NotePod bot
## Setup is done this way so no editing is needed when installing script

## setup primary bot
set NP_primary "weborg"
## set definition text path for this bot **USE TRAILING SLASH**
## you can also set to "" if using bot root
set NP_primary_path "/home/mozart/bots/weborg/"

## setup secondary
set NP_secondary "VallaDia"
## set definition text path for this bot **USE TRAILING SLASH**
## you can also set to "" if using bot root
set NP_secondary_path ""

## incoming path
## set 1.1.5 or 1.3.x dcc incoming path variable name here
## makes sure to {} if it contains a dash
set dcc_incoming "${incoming-path}"

## Required flags to perform the various commands
## The user must have ONE not ALL of the flags to use a command
set NP_flags_Explain "ovp12"
set NP_flags_Define "o"
set NP_flags_Scan "o"
set NP_flags_ScanNick "m"
set NP_flags_ScanBody "m"
set NP_flags_Whoset "o"
set NP_flags_Replace "o"
set NP_flags_Remove_any "m"
set NP_flags_Replace_any "m"

## If a user doesn't have the required flags, his/her channel status
## is checked instead. Again, ONE not ALL of the statuses is required
## the only valid flags here are o and v
## m functions (ScanNick, ScanBody, Remove_Any, Replace_any) are not available 
set NP_Status_Help "o"
set NP_status_Explain "ov"
set NP_status_Define "o"
set NP_status_Scan "o"
set NP_status_Whoset "o"

## these are not used, and are NOT TESTED for
## NP_flags_*_any overide these
set NP_status_Replace "o"
set NP_status_Remove "o"
set NP_status_ScanNick "o"
set NP_status_ScanBody "o"

## Determine how to reply to a command
## 0 - Notice to nick
## 1 - Notice to channel
## "" - Don't reply.
set NP_reply_Explain 1
set NP_reply_Define 0
set NP_reply_Remove 0
set NP_reply_Scan 0
set NP_reply_ScanNick 0
set NP_reply_ScanBody 0
set NP_reply_Whoset 0
set NP_reply_Replace 0

## Determine how to pass errors to a user.
## Using the Explain/Whoset cmd and not finding a definition is
## NOT considered an error.
## Trying to Define an existing or Remove a nonexisting definition
## are considered errors.
## 0 - Notice to nick
## 1 - Notice to channel
## "" - Don't reply.
set NP_replyerr_noaccess 0
set NP_replyerr_dontexist 0
set NP_replyerr_exist 0

## Select which channels the various public commands applies to
## Channel names MUST be in all lowercase, space separated
set NP_channels "#cracks #pcvoice"

## Select what to log to the standard botlog
## These are not presently used
set NP_log_Explain 1
set NP_log_Define 1
set NP_log_Remove 1
set NP_log_Scan 1
set NP_log_ScanNick 1
set NP_log_ScanBody 1
set NP_log_Whoset 1
set NP_log_Replace 1

## Define the public triggers
## 
## trigger prefix for commands (learn, replace, whoset, forget )
set NP_pub_trigger !

## trigger to show a definition
## not that a question mark must be escaped so that it it not seen
## as a wildcard character by tcl
set Explain \?\?

## trigger for scan command wildcard def match
set wc_Explain \?\?\?

## trigger for scan command nick match
set nick_Explain \?!\?

## trigger for scan command def body match
set body_Explain \?\?!

## alternate examples
#set NP_pub_trigger "."
#set Explain ".."
#set wc_Explain "..."

## set maximum defs to be returned by Public Scan Commands (???, ?!?, ??! )
set NP_max_Scan_match_pub 10

## set maximum defs to be returned by Msg and DCC Scans (/?? / Body / Nick)
set NP_max_Scan_match_pvt 20

## number of minutes to remember the last def shown
## NotePOD will not re-display the same definition during this period
set NP_last_time 3

## number of minutes to remember the last nick requesting a def
set NP_last_nicktime 3

## number of defs accepted from each nick within NP_last_nicktime
## when he exceeds this limit, a chanel notices will be posted and
## the nick will be ignored for $NP_last_nicktime mins 
## set to zero for unlimited defs per nick
set NP_max_Explain_nicklimit 5

## set to 1 to add non-authorized nicks who attempt to use
## NotePOD to the ignore list
## ignore time will be $NP_last_time mins.
set NP_ignore_lamers 1

## max size allowable in bytes for resync commands
set NP_synclist_limit 10000

## what to do when synclist over the above limit
## 0 = botnote to owner, 1 = send full def file
set NP_synclist_mode 0

##
## END CONFIG
###################################################################################
