# Quote script v1.0

# Setup section

putlog "You didn't check setup section on quote.tcl"
return 0

# Quote filename. Use absolute path
set quotefile "quote.bot"

# Quote administrators need user defined mode +Z (a capital Z)

# Can anyone use quote
set anyquoters 1

# Quote show command
bind pub - "&quote" *pub:showquote
# Quote add command
bind msg Z "quoteadd" *msg:addquote
# Quote del command
bind msg Z "quotedel" *msg:delquote
# Quote reset command - deletes all quotes
bind msg Z "quotereset" *msg:delquotes

if {![file exists $quotefile]} {
    set mfile [open $quotefile w]
    close $mfile
}

proc *pub:showquote { nick idx handle channel args } {    
    global anyquoters quotefile
    if {$anyquoters == 0} {
      if {$handle == "*"} { return 0 }
    }
    set file [open $quotefile r]
    set qc 0
    while {![eof $file]} {
      set quoteline [gets $file]
      incr qc
      if {$qc == $args} {
        puthelp "PRIVMSG $chan :$quoteline"
        close $file
        return 0
      }
    }
    close $file
    incr qc -1
    puthelp "NOTICE $nick :Quote $args not found!"
    puthelp "NOTICE $nick :Only $qc quotes available"
}

proc *msg:addquote { nick idx handle args } {
    global quotefile
    set arg [string trim "$args" "{}"]
    set file [open $quotefile r]
    while {![eof $file]} {
      set line [gets $file]
      lappend datalist $line
    }
    close $file
    lappend datalist $arg
    set file [open $quotefile w]
    foreach line $datalist {
      if {$line != ""} {
        puts $file $line
      }
    }
    close $file
    puthelp "NOTICE $nick :Quote added!"
}

proc *msg:delquote { nick idx handle args } {
    global quotefile
    set file [open $quotefile r]
    set qc 0
    set qd 0
    while {![eof $file]} {
      set line [gets $file]
      incr qc
      if {$qc == $args } { 
        puthelp "NOTICE $nick :Quote deleted"
        set qd 1
      } else {
        lappend datalist $line 
      }
    }
    close $file
    incr qc -1
    set file [open $quotefile w]
    foreach line $datalist {
      if {$line != "" } { puts $file $line }
    }
    close $file
    if { qd == 0 } { puthelp "NOTICE $nick :Only $qc quotes available" }
}

proc *msg:delquotes { nick idx handle args } {
    file delete $quotefile
    set file [open $quotefile w]
    close $file
}

putlog "Quotes v1.0 by Code Mouse loaded"
