# AntiScripts (c) 1999 by Amadeus`
set antiscriptsver "\002AntiScripts\002 v0.3 by Amadeus"
# Inspired on antisd.tcl, author unknown
#
# Fed up with aggravating mIRC scripts that always have a SEEN
# running, refuse  DCCs that they requested, blast colored AWAY 
# messages in channel and annouce themselves as if they were 
# actually good?
# 
# Stop them early! 
#
# This script versions all nick joining any channel the bot is on.
# It matches version replies and channel notices against a list of *tags* 
# for 'proscribed' programs. 
# You can configure what to look for in version response and channel notice, as
# well as what to do when you get a match. Possible actions are WARN, 
# KICK and KICKBAN. You can also configure the name YOU want to call the 
# aggravating script in the channel (eg SLOWdown Pro)
# A list of warning/notice messages, which you can edit or extend, is available.
# One will be randomly selected to publically belittle the script user.
#
#
# This script will not kick global ops in userlist, channel OPS or 
# channel VOICES. It should operate on both 1.1.5 and 1.3.22 versions
# of eggdrop.
#
#
# If mcmon_kicker.tcl is loaded, can be used by a v'ed bot
# 
#
# setup for scripts to kick
# tag         - string to match in version reply or channel notice
#             - make sure you replace spaces with '*'
#             - this check is not case-dependant
# scriptname  - for display purposes
# action      - what to do when detected 
#               (possible actions: WARN, KICK, BANKICK)
#
#   tag               script name       action  #
set script_tags {
  { "ShowDown"       "ShowDowN PrO"    "WARN" }
  { "hze*t" "hze t"  "KICK" }
  { "7Th*Sphere"     "7Th Sphere"      "WARN" }
}

# warning message and channel notice
# warning message is automatically preceeded by the configured scriptname
# and followed by the channel name
# eg "Showdown PrO is too damn aggravating to be allowed to operate in #cracks"
# a random warning is selected from this list
set warnmsgs {
  "is too damn aggravating to be allowed to operate in"
  "is only run by lamers, m00ks and d3wbs, please leave"
  "is so dumb, I can't believe someone as apparently intelligent as you would use it in"
  "is the spawn of Bill Gates, the offal of Intel and the virus of mIRC, and doesn't belong in"
  "is just plain silly. Depart, ye lamer, forever from the high channel of"
  " - what can we say - it's the shits - let's wipe yer ass from" 
}

# time to ban 
set as_bantime 30

bind ctcr - "SCRIPT" checkscriptversion
bind ctcr - "VERSION" checkscriptversion
bind join - %* checkversion

# build binds to notices from various scripts
foreach tag $script_tags { 
  bind notc - "*[lindex $tag 0]*" check_script_notice 
}

#
proc as:random_warning { } {
  global warnmsgs
  return [lindex $warnmsgs [rand [llength $warnmsgs]]]
}
#
proc checkversion {nick uhost hand chan} {
  putserv "PRIVMSG $nick :\x01VERSION\x01"
}
#
# This kludge is made for scripts that do not respond correctly to a CTCP-query.
# will also catch nicks that joined while bot was not on channel
proc check_script_notice {nick uhost hand text} {
  global botnick
  checkscriptversion $nick $uhost $hand $botnick VERSION $text
}
#
proc checkscriptversion {nick uhost hand dest keyword args} {
  global script_tags
  set args [string tolower $args]
  if {[matchattr $hand o]} { return 0 }

  foreach tag $script_tags {
    set stag   [string tolower [lindex $tag 0]]
    set script [lindex $tag 1]
    set action [lindex $tag 2]
    if {[string match "*$stag*" $args]} { kick_dumb_script $nick $hand $uhost $action $script}
  }
}

proc kick_dumb_script { nick hand uhost action script } {
  putlog "\002AntiScripts:\002 $nick $script"
  foreach chan [channels] {
    if {[onchan $nick $chan]} {
      if {(![matchattr $hand o]) && (![isop $nick $chan]) && (![isvoice $nick $chan])} {
        set warn [as:random_warning] 
        putserv "NOTICE $chan :\002$nick\002 $script $warn $chan"
        switch $action {
          "WARN"    { putserv "PRIVMSG :\002$nick\002 $script $warn $chan" }
          "KICK"    { as:kick $nick $hand $chan $script $warn}
          "BANKICK" { as:bankick $nick $hand $uhost $chan $script $warn}
          default   { putserv "PRIVMSG :\002$nick\002 $script $warn $chan" }
        }
      }
    }
  }
}

proc as:kick { nick hand chan script warn } {
  global botnick owner mcmon_kicker_loaded
  if {[isop $botnick $chan]} {
    putserv "KICK $chan $nick :\002AntiScripts\002 $script $warn $chan"
  } else {
    if {[info exists mcmon_kicker_loaded]} {
      abusekick $nick $uhost "\002AntiScripts\002 $script $warn $chan" 
    }
  }
}

proc as:bankick { nick hand uhost chan script warn } {
  global botnick owner mcmon_kicker_loaded as_bantime
  if {[isop $botnick $chan]} {
    set uhost [lindex [split [maskhost "*$uhost"] "!"] 1]
    newban "*!*$uhost" $botnick "$script" $as_bantime
    putserv "KICK $chan $nick :\002AntiScripts\002 $script $warn $chan"
  } else {
    if {[info exists mcmon_kicker_loaded]} {
      abuseban $nick $uhost "\002AntiScripts\002 $script $warn $chan"
    }
  }
}
#
putlog "$antiscriptsver loaded"
foreach tag $script_tags { putlog "\002AntiScripts\002 configured [lindex $tag 2] for [lindex $tag 1]" }
