## BounceBot Copyright (c) 1998 by Amadeus` - The Elite Scripting Team
set bouncever "\002BounceBot\002 v0.1 by Amadeus"
##
## This script was inspired by bnc.tcl by ^Kenwood^ and 
## based upon my mIRC script PCbounce.mrc
## It allows you to configure your bot to use BNC on a shell other
## then that on which th ebot runs. Avoid k-lines for multiple clones.
## you can get the bnc2.4.6 at http://bnc.refract.com
## This script should be the last loaded
## your BNC server should not appear in your eggdrops server section
##

# BNC Server ( the host running BNC)
set bncserver bounce.com
# BNC server port 
set bncport 1234
## BNC PASSWORD (case sensitive)
set bncpass "xXxXxXxX"
## BNC Vhost (virtual host on BNC server)
set bncvip "damn.iam.good.to"

# set to 1 to select random IRC server, 0 to select servers sequentially
set dorand 1

## List of known good servers
## format server:port 
## if port not specified uses default
## if set to "", script will use servers in egg config instead 
set ircservers {
 irc.total.net
 irc1.c-com.net:6667
 irc.homelien.no
}
## if port not specified use this as default port
set default-port 6667

##
## End of Configuration
##

## Change some egdrop config items
set strict-servernames 0
set servlimit 1

## sequential server selection count
set seq 0

bind notc - * bounce
proc bounce {nick host hand text} {
  global bncserver bncport bncpass bncvip
  if {($nick != "Bnc") && ([string match "*Closing Link*" $text])} { 
    jump $bncserver $bncport $bncpass
    return 0 
  }
  if {[string match "You need to say*" $text]} { 
    putserv "PASS $bncpass" 
#    putlog "BounceBot: sent pass"
    return 0
  }
  if {[string match "Level two*" $text]} {
    putserv "vip $bncvip" 
#    putlog "BounceBot: sent vhost"
    return 0
  }
  if {[string match "type /quote conn*" $text]} {
    putserv "conn [getaserver]" 
#    putlog "BounceBot: sent conn"
    return 0
  }
  if {[string match "Failed Connection" $text]} { 
    putserv "conn [getaserver]" 
#    putlog "BounceBot: sent conn"
    return 0
  }
  return 1
}

proc getaserver { } {
  global servers ircservers dorand default-port seq
  if {[llength ircservers] > 0 } {
    set servlist $ircservers  
  } else {
    set servlist $servers
  }
  set maxserv [llength $servlist]
  putlog "BounceBot: [llength $servlist] servers available"

  if {$dorand} {
    set serv [lindex $servlist [rand [llength $servlist]]]
  } else { 
    set serv [lindex $servlist $seq]
    incr seq 1
    if {$seq == $maxserv} { set seq 0 }
  }
  if {[string match "*:*" $serv]} { 
    set serv [split $serv :]
    set serv [lindex $serv 0]
    set port [lindex $serv 1]
  } else {
    set port ${default-port}
  }
  putlog "BounceBot: Trying $serv $port"
  return "$serv $port"
}

## make sure we dont jump on rehash
if {![info exists bouncingbot]} { jump $bncserver $bncport $bncpass }
set bouncingbot 1
putlog "$bouncever loaded"
