# Joker (c) 1999 by Amadeus` The Elite Scripting Team efNET #scripting
set jkrver "Joker v1.0 (c) 1999 by Amadeus`"
# inspired by joke.tcl - Copyright (c) 1997 by t00NIE
# 
# v1.0 Additions and Fixes:
# - Made text/ default joke_path, not longer have to specify path in .addjoke
# - joke_path is configurable
# - Added attack mode joke loading, see Attack Mode Joke Files and 
#   addjoke dcc command descriptions.
# - Added proc cleanandfancyjokes{} which prevents the error exit during
#   load of certain joke files.
#   This proc translates quotes to -, escapes tcl braces and brakets, 
#   and auto-adds bold on/off to lines that contain one of: 
#     A: (as it Q: A: type jokes) 
#     ?  (another Q/A type jokes)
#    ... (as in you might be a something... type jokes)
#   Does Not add bold if line already has bold sequence in it.
# - Number of lines for quote translation, unTCLifing and bold addition 
#   are displayed on load.
# - !jokecount now displays total in channel. Indvidual joke type 
#   counts are still noticied to nick.
# - !jokehelp now shows which types have attack mode
# - .remjoke now unbinds pub and dcc binds
#
#
# Features:
#   `Built-in yomomma and redneck with attack mode
#   `Can load and remove any one joke-per-line file, script automatically
#    builds pub and dcc binds, as well as pub and dcc procs for each joke type.
#   `Can load and remove any attack type joke file
#   `protects owner from attack, insult or joke is turned against the attacker
#   `reacts to another channel op using 'redneck' or 'yomomma' in a channel
#    message
#
#   I have included a number of jokefiles, already loaded in $joker_loader. 
#   You may remove any yu find distasteful or unfunny, using the 
#   dcc .remjoke <trigger> command. You must restart the bot to remove binds.
#
# Joke Files format:
#   Each file should contain one line per joke. Joker will convert all
#   double-quotes to dashs and will escape tcl braces and brakets.
#   You may use highlighting such as bold, underline etc. , but be aware
#   that Joker will automatically add bold if it encounters "A:", "?" or "...". 
#
#
# Attack Mode Joke Files:
#   These are similar to Yomomma and Redneck. Usually of the type
#   "You might be ? if ..." or "You know you are... "
#   The text file itself should not contain this prefix, you give it as the
#   attack string in the .addjoke command.
#   eg. .addjoke irc irc.txt You might be addicted to IRC if
#
#
#   Default Pub commands:
#   All pub commands are accessible by bot masters and channel OPS.
#
#   !joke - trigger selects and displays a random joke from all loaded jokelists.
#   !jokehelp - lists all joke triggers
#   !jokecount - msgs nick with count for each joke type and total
#
#   !yomomma [[<nick>] [<channel>]]
#   !redneck [[<nick>] [<channel>]]
#     no args         - joke shown in channel
#     nick            - joke addressed to nick in channel
#                     - if nick not on common channel, insult is msged
#     nick channel    - if nick and bot on same channel, 
#                       joke is addressed to nick in channel
#                       otherwise bot goes into attack mode:
#                       will change its own nick, join channel,
#                       insult the nick, part channel and revert to 
#                       it's original nick
#   
#   !<addedtrigger>   - joke is shown in current channel
#   !AttackModeTrigger [[<nick>] [<channel>]] (same outputs as redneck)
#
#
#   Owner (+n) DCC commands:
#   .addjoke <trigger> <path> [attack mode string]
#                     - install a jokelist file
#                       creates binds and procs in $joker_loader
#                       eg : .addjoke blond text/blond.txt
#                       creates a pub bind for !blond, a dcc bind
#                       for .blond, and the related procs
#                       attack mode example:
#                       .addjoke irc text/irc.txt You might be addicted to IRC if
#   
#   .remjoke <trigger>  - remove a jokelist
#                       deletes binds and procs in $joker_loader
#                       eg : .remjoke blond
#
#
#   Master (+m) DCC commands:
#
#   .jokehelp   - shows channel triggers and dcc commands help
#   .jokecount  - shows count for each joke type and total
#   .joke <channel|nick>            - joke is msged to channel or nick
#   .<addedtrigger> <channel|nick>  - joke is msged to channel or nick
#   .yomomma [[<nick|channel>] [<channel>]]
#   .redneck [[<nick|channel>] [<channel>]]
#   .addedAttackTrigger [[<nick|channel>] [<channel>]]
#
# Known bugs:
# In attack mode:
# - sometimes does not say anything in attack channel
# - sometimes changes back to original nick before leaving attack channel
# - if cloak nick is already in use, will use bot config alt nick (noted in v1.3.22)
#   in that case, it will not say anything in attack channel, because
#   the temp on JOIN of cloak nick bind is not triggered


## location of joke loader file
set joker_loader "scripts/joker_loader.tcl"
## location of joke text files
set joke_path "text/"

## Channel OP or bot Master only
bind pub - !joke pub:randjoke
bind dcc m joke dcc:randjoke

bind pub - !jokecount jokecount
bind dcc m jokecount dcc:jokecount

bind pub - !jokehelp jokehelp
bind dcc m jokehelp dcc:jokehelp

bind pub - !redneck pub_redneck
bind pubm - *redneck* msg_redneck
bind dcc m redneck dcc_redneck

bind pub - !yomomma pub_yomomma
bind pubm - *yomomma* msg_yomomma
bind dcc m yomomma dcc_yomomma

bind dcc n addjoke dcc:install_joke
bind dcc n remjoke dcc:remove_joke

## install a joke file
## usage : .addjoke <trigger> <path> [attack mode string]
##    eg : .addjoke blond text/blond.txt
## creates binds and procs
proc dcc:install_joke { hand idx arg } {
  global joker_loader joke_path
  if {$arg == ""} {
    putdcc $idx "Joker: .addjoke <joketrigger> <filename> [attack string]"
    return 0
  }
  set joketype [string tolower [lindex $arg 0]]
  if {($joketype == "yomomma") || ($joketype == "redneck")} {
    putdcc $idx "Joker: $joketype already handled internally"
    return 0
  }
  set jokefile $joke_path[lindex $arg 1]
  if {![file isfile $jokefile]} {
    putdcc $idc "Joker: cannot find $jokefile"
    return 0
  }

  set doattack 0
  if {[llength $arg] >2} { 
    set doattack 1
    set attack_string [lrange $arg 3 end]
  }

  set isdone [info procs pub:$joketype]
  if {$isdone != "" } {
    putdcc $idx "Joker: $joketype already configured"
    return 0
  } else {
    putdcc $idx "Joker: configuring $joketype $jokefile"
  }
# write init for joketype
  set newloader [open $joker_loader a] 
  puts $newloader ""
  puts $newloader "## Start Joker Type:$joketype"
  puts $newloader "## using $jokefile"
  puts $newloader "set jokefile$joketype \"$jokefile\""
  puts $newloader "set list$joketype \[loadjokefile $joketype $jokefile\]"
  puts $newloader "##"
  puts $newloader "bind dcc m $joketype dcc:$joketype"
  puts $newloader "proc dcc:$joketype \{hand idx arg\} \{"
  puts $newloader "  global list$joketype"
  puts $newloader "  return \[dcc:showjoke \$idx $joketype \$list$joketype \$arg\]"
  puts $newloader "\}"
  puts $newloader "##"
  if {$doattack == 0} {
    puts $newloader "bind pub - !$joketype pub:$joketype"
    puts $newloader "proc pub:$joketype \{nick uhost hand chan text\} \{"
    puts $newloader "  global list$joketype"
    puts $newloader "  return \[pub:showjoke \$nick \$chan \$list$joketype\]"
    puts $newloader "\}"
  } else {
    puts $newloader "## Attack Mode $joketype"
    puts $newloader "bind pub - !$joketype pub:$joketype"
    puts $newloader "proc pub:$joketype \{nick uhost handle chan testes\} \{"
    puts $newloader "  global list$joketype botnick myintro owner attack_nick attack_chan"
    puts $newloader "  if \{(!\[isop \$nick \$chan\]) && (!\[matchattr \$nick m\])\} \{ return 1 \}"
    puts $newloader "  set attack_nick \[lindex \$testes 0\]"
    puts $newloader "  set attack_chan \[lindex \$testes 1\]"
    puts $newloader "  if \{\[string index \$attack_nick 0\] == \"#\"\} \{"
    puts $newloader "    putserv \"PRIVMSG \$nick :Joker Usage: !$joketype <nick> <channel>\""
    puts $newloader "    return 0"
    puts $newloader "  \}"
    puts $newloader "  set outputw \[lindex \$list$joketype \[rand \[llength \$list$joketype\]\]\]"
    puts $newloader "  set intro \[lindex \$myintro \[rand \[llength \$myintro\]\]\]"
    puts $newloader "  if \{\$attack_nick == \"\"\} \{"
    puts $newloader "    putserv \"PRIVMSG \$chan :\$nick, $attack_string \$outputw.\""
    puts $newloader "    return 1"
    puts $newloader "  \}"
    puts $newloader "  if \{\[string compare \[string tolower \$botnick\] \[string tolower \$attack_nick\]\] == 0\} \{"
    puts $newloader "    putserv \"PRIVMSG \$chan :Hey \$nick, instead of us joking about myself why don't I tell everyone about how $attack_string \$outputw.\""
    puts $newloader "    return 1"
    puts $newloader "  \}"
    puts $newloader "  if \{\[string compare \[string tolower \$nick\] \[string tolower \$attack_nick\]\] == 0\} \{"
    puts $newloader "    putserv \"PRIVMSG \$chan :Hey \$nick, let's not joke about yourself, let's do it to someone else. Will you?\""
    puts $newloader "    return 1"
    puts $newloader "  \}"
    puts $newloader "  if \{\[nick2hand \$attack_nick \$chan\] == \$owner\} \{"
    puts $newloader "    putserv \"PRIVMSG \$chan :Haha fool...\$owner told me to tell ya >>> \$nick <<< that $attack_string \$outputw.\""
    puts $newloader "    return 1"
    puts $newloader "  \}"
    puts $newloader "  if \{\$attack_chan == \"\"\} \{"
    puts $newloader "    if \{\[oncommonchan \$attack_nick\]\} \{"
    puts $newloader "      putserv \"PRIVMSG \$chan :\$attack_nick, \$nick said $attack_string \$outputw.\""
    puts $newloader "    \} else \{"
    puts $newloader "      putserv \"PRIVMSG \$attack_nick :\$nick said $attack_string \$outputw.\""
    puts $newloader "    \}"
    puts $newloader "    return 1"
    puts $newloader "  \}"
    puts $newloader "  set curchan \[channels\]"
    puts $newloader "  foreach chann \$curchan \{"
    puts $newloader "    if \{\[string tolower \$chann\] == \[string tolower \$attack_chan\]\} \{"
    puts $newloader "      putserv \"PRIVMSG \$attack_chan :\$attack_nick, one of my Friends tells me $attack_string \$outputw.\""
    puts $newloader "      return 0"
    puts $newloader "    \}"
    puts $newloader "  \}"
    puts $newloader "  attack_timer \$chan \$attack_chan \$attack_nick $joketype \"pub:$joketype\" \"attack_nick$joketype\""
    puts $newloader "\}"
    puts $newloader "##"
    puts $newloader "proc attack_nick$joketype \{ nick uhost hand chan \} \{"
    puts $newloader "  global list$joketype myintro attack_nick"
    puts $newloader "  set outputw \[lindex \$list$joketype \[rand \[llength \$list$joketype\]\]\]"
    puts $newloader "  set intro \[lindex \$myintro \[rand \[llength \$myintro\]\]\]"
    puts $newloader "  putserv \"PRIVMSG \$chan :\$intro >>> \$attack_nick <<<, a special Friend wanted me to let you know $attack_string \$outputw.\""
    puts $newloader "\}"
  }
  puts $newloader "##"
  puts $newloader "## End Joker Type:$joketype"
  puts $newloader "##"
  puts $newloader ""
  close $newloader
  putdcc $idx "Joker: $joker_loader updated.  Rehash to enable."
}
#
## remove a jokelist
## usage : .remjoke trigger
##    eg : .rejoke blond
## removes binds and procs from $joker_loader file
## does not delete joke text file
proc dcc:remove_joke { hand idx arg } {
  global joker_loader
  if {$arg == ""} {
    putdcc $idx "Joker: .remjoke <trigger>>"
    return 0
  }
  set joketype [string tolower $arg]
  if {($joketype == "yomomma") || ($joketype == "redneck")} {
    putdcc $idx "Joker: $joketype is internal and cannot be removed"
    return 0
  }

  set bakup_file "$joker_loader.bak"
  set res [ catch { file copy -force $joker_loader $bakup_file } ]
  if {$res} {
    putdcc $idx "Joker: ERROR during backup of $joker_loader Cannot remove $joketype"
    return 0
  }

  set group_pattern_start "## Start Joker Type:$joketype"
  set group_pattern_end "## End Joker Type:$joketype"
  set oldloader [open $bakup_file r]
  set newloader [open $joker_loader w]
  set found_group 1
  set skip_group 0
  while {![eof $oldloader]} {
    set line [gets $oldloader]
    if {[string match $group_pattern_start $line]} { 
      set found_group 1
      set skip_group 1 
    }  
    if {[string match $group_pattern_end $line]} { 
      set skip_group 0 
      continue
    }  
    if {$skip_group == 0 } {
      puts $newloader $line
    }
  }
  close $newloader
  close $oldloader
  if {$found_group} {
    unbind dcc m $joketype dcc:$joketype
    unbind pub - !$joketype pub:$joketype
    putdcc $idx "Joker: $joketype removed, binds removed, restart to implement."
  } else {
    putdcc $idx "Joker: unable to find $joketype"
  }
}

## CleanJokes
## translate and escape characters that would confuse tcl
## escape [ ] { } braces and brackets
## trigger bold on A: or "..." sequence
## Does not change text files
## 
proc cleanandfancyjokes { arg } {
  global boldcount quotecount untcledcount
  if { $arg == ""} { return "" }
  ## change " to - 
  if {[regsub -all {"} $arg {-} newarg] > 0} { incr quotecount }

  set boldon ""
  set boldoff ""
  set periodcount 0
  set addedbold 0
  set isbolded 0
  set response ""
  ## check if already bold on/off sequences
  set isbolded [regexp -nocase {} $arg]

  ## check for bold triggers
  if {$isbolded == 1} {
    set newarg1 $newarg
  } else {
    if {[regsub -nocase {A:} $newarg {A:} newarg1]>0} { 
      set addedbold 1
    } else {
      if {[regsub -nocase {\?} $newarg {?} newarg1]>0} { 
        set addedbold 1 
      }
    }
    if {$addedbold == 0} { 
      set newarg1 $newarg 
      #putlog "no {$boldtrig1} {$boldtrig2}"
    }
  }

  ## scan for tcl brakets and braces
  for {set i 0} {$i < [string length $newarg1]} {incr i} {
    set char [string index $newarg1 $i]
    if {($char == "\173") || ($char == "\175") || ($char == "\133") || ($char == "\135")} {
      append response \134$char
      incr untcledcount
    }
    if {($isbolded == 0) && ($addedbold == 0) && ($char == ".")} { 
      append response $char
      incr periodcount 
      if {$periodcount == 3} { 
        append response $boldon
        set addedbold 1 
        set periodcount 0
      }
    } else {
      append response $char
    }
  }
  if {$addedbold} {
    incr boldcount 
    return $response$boldoff 
  } else { 
    return $response 
  }
}

## LoadJokeFile
## Loads a text file and returns a tcl list
## usage : loadjokefile trigger filename
proc loadjokefile { joketype jokefile } {
  global boldcount quotecount untcledcount
  # open the file and get the jokes
  if {![file isfile $jokefile]} {
    putlog "Joker: $jokefile does not exist"
    return 0
  }
  set boldcount 0
  set quotecount 0
  set untcledcount 0
  set afile [open $jokefile r]
  set jokelist ""
  while { ![eof $afile] } {
    set elist [cleanandfancyjokes [gets $afile]]
    if {[llength $elist] > 0} { lappend jokelist $elist }
  }
  close $afile

  if {[llength $jokelist] > 0} {
    putlog "Joker: Loaded [llength $jokelist] $joketype jokes from $jokefile Added bold $boldcount lines, Stripped quotes $quotecount lines, UnTCLified $untcledcount lines."
    return $jokelist
  } else {
    putlog "Joker: WARNING found NO $joketype jokes in $jokefile"
    return "No $joketype jokes"
  }
}

#
proc dcc:showjoke { idx joketype tcllist arg } {
  if {$arg == ""} {
    putdcc $idx "Usage: .$joketype <channel|nick>"
    return 0
  }
  putserv "PRIVMSG $arg :[lindex $tcllist [rand [llength $tcllist]]]"
  return 0
}
#
proc pub:showjoke { nick chan tcllist } {
  if {[isop $nick $chan]} {
    putserv "PRIVMSG $chan :[lindex $tcllist [rand [llength $tcllist]]]"
  }
  return 0
}
#
proc dcc:randjoke { hand idx arg } {
  global jokelists
  if {$arg == ""} {
    putdcc $idx "Joker Usage: .joke <channel|nick>"
    return 0
  }
  uplevel 1 { set tcllist [set [lindex $jokelists [rand [llength $jokelists]]]] }
  global tcllist
  putserv "PRIVMSG $arg :[lindex $tcllist [rand [llength $tcllist]]]"
  return 0
}
proc pub:randjoke { nick uhost handle chan arg } {
  global jokelists
  uplevel 1 { set tcllist [set [lindex $jokelists [rand [llength $jokelists]]]] }
  global tcllist
  if {[matchattr $nick m] || [isop $nick $chan]} {
    putserv "PRIVMSG $chan :[lindex $tcllist [rand [llength $tcllist]]]"
  }
  return 0
}
#

proc dcc:jokecount {hand idx arg} {
  global jokelists tcllistname tcllength totjokes jkrver
  set tcllistname ""
  set tcllength ""
  set totjokes ""
  putdcc $idx "$jkrver"
  foreach tcllistname $jokelists {
    uplevel 1 { set tcllength [llength [set $tcllistname]] }
    set totjokes [expr $totjokes + $tcllength]
    putdcc $idx "$tcllength [string toupper [string range $tcllistname 4 end]] jokes"
  }
  putdcc $idx "Total: $totjokes"
}


proc jokecount {nick uhost hand chan text} {
  global jokelists  tcllistname tcllength totjokes jkrver
  if {[matchattr $nick m] || [isop $nick $chan]} {
    putserv "PRIVMSG $nick :$jkrver"
    set tcllistname ""
    set tcllength ""
    set totjokes ""
    set jokecats 0
    foreach tcllistname $jokelists {
      incr jokecats
      uplevel 1 { set tcllength [llength [set $tcllistname]] }
      set totjokes [expr $totjokes + $tcllength]
      putserv "PRIVMSG $nick :$tcllength ![string range $tcllistname 4 end] jokes"
    }
    putserv "NOTICE $chan :Total !Jokes Online: $totjokes in $jokecats catagories."
  }
}
#

proc jokehelp {nick uhost hand chan text} {
  global jokelists jkrver
  if {[matchattr $nick m] || [isop $nick $chan]} {
    set triggers "!jokehelp !jokecount !joke (random)"
    foreach jf $jokelists {
      set trig [string range $jf 4 end]
      set procname attack_nick$trig
      if {[info procs $procname] !=""} {
        append triggers " !$trig\002(attack)\002"
      } else {
        append triggers " !$trig"
      }
    }
    putserv "NOTICE $chan :$jkrver :OP $triggers"
  }
}

proc dcc:jokehelp {hand idx arg} {
  global jokelists jkrver
  set triggers "!jokehelp !jokecount !joke (random)"
  foreach jf $jokelists {
    set trig [string range $jf 4 end]
    set procname attack_nick$trig
    if {[info procs $procname] !=""} {
      append triggers " !$trig\002(attack)\002"
    } else {
      append triggers " !$trig"
    }
  }
  putdcc $idx "$jkrver"
  putdcc $idx "Channel triggers (OP only)"
  putdcc $idx "$triggers"
  putdcc $idx "\002.jokecount\002 - shows count for each joke type and total"
  putdcc $idx "\002.joke <channel|nick>\002            - joke is msged to channel or nick"
  putdcc $idx "\002.<addedtrigger> <channel|nick>\002  - joke of type trigger is msged to channel or nick"
  putdcc $idx "\002.yomomma \[\[<nick|channel>\] \[<channel>\]\]\002 - same as channel"
  putdcc $idx "\002.redneck \[\[<nick|channel>\] \[<channel>\]\]\002 - same as channel"

  if {[matchattr $hand n]} {
    putdcc $idx "\002.addjoke <trigger> <textfile> [attack string]\002       - install a jokelist file"
    putdcc $idx " creates binds and procs in joker loader for textfile in text/ folder. rehash reqd"
    putdcc $idx " eg : .addjoke blond blond.txt"
    putdcc $idx " creates a pub bind for !blond, a dcc bind for .blond, and the related procs"
    putdcc $idx "\002.remjoke <trigger>\002              - remove a jokelist"
    putdcc $idx " deletes binds and procs in joker loader. restart reqd"
    putdcc $idx "eg : .remjoke blond"
  }
}
##
## t00nies original code 
## with some serious mods
##


##
## YOMOMMA
##

proc pub_yomomma {nick uhost handle chan testes} {
  global listyomomma botnick myintro owner attack_nick attack_chan
  if {(![isop $nick $chan]) && (![matchattr $nick m])} { return 1 }
  set attack_nick [lindex $testes 0]
  set attack_chan [lindex $testes 1]
  if {[string index $attack_nick 0] == "#"} {
    putserv "PRIVMSG $nick :Joker Usage: !yomomma <nick> <channel>"
    return 0
  }
  set outputw [lindex $listyomomma [rand [llength $listyomomma]]]
  set intro [lindex $myintro [rand [llength $myintro]]]
  if {$attack_nick == ""} {
    putserv "PRIVMSG $chan :$intro >>> $nick <<<, $outputw."
    return 1
  }
  if {[string compare [string tolower $botnick] [string tolower $attack_nick]] == 0} {
    putserv "PRIVMSG $chan :Hey >>> $nick <<<, instead of us talking about my mommy why dont I tell everyone about how $outputw."
    return 1
  }
  if {[string compare [string tolower $nick] [string tolower $attack_nick]] == 0} {
    putserv "PRIVMSG $chan :Hey >>> $nick <<<, let'd not talk about your mommy. Let's talk about someone else's mommy."
    return 1
  }
  if {[nick2hand $attack_nick $chan] == $owner} {
    putserv "PRIVMSG $chan :Haha fool... $owner told me to tell ya >>> $nick <<< that $outputw."
    return 1
  }
  if {$attack_chan == ""} {
    if {[oncommonchan $attack_nick]} {
      putserv "PRIVMSG $chan :$intro >>>> $attack_nick <<<< , $nick said $outputw."
    } else {
      putserv "PRIVMSG $attack_nick :$intro >>>> $attack_nick <<<< , $nick said $outputw."
    }
    return 1
  }
  set curchan [channels]
  foreach chann $curchan {
    if {[string tolower $chann] == [string tolower $attack_chan]} {
      putserv "PRIVMSG $attack_chan :$intro >>> $attack_nick <<<, one of my Friends tells me $outputw."
      return 0
    }
  }
  attack_timer $chan $attack_chan $attack_nick "yomomma" "pub_yomomma" "attack_nickyomomma" 
}

proc attack_nickyomomma { nick uhost hand chan } {
  global listyomomma myintro attack_nick
  set outputw [lindex $listyomomma [rand [llength $listyomomma]]]
  set intro [lindex $myintro [rand [llength $myintro]]]
  putserv "PRIVMSG $chan :$intro >>> $attack_nick <<<, a special Friend wanted me to let you know $outputw."
}

set yomommamsgs {
 {I would not talk about yomomma if I were you, cause she is here right now.}
 {yomomma cant hear yu, her head is between my legs}
 {Yeah right, at least my momma didnt screw a dog to have me.}
}
proc msg_yomomma {nick uhost hand chan text} {
  global yomommamsgs
  if {[matchattr $nick m] || [isop $nick $chan]} {
    putserv "PRIVMSG $chan :$nick [lindex $yomommamsgs [rand [llength $yomommamsgs]]]"
  }
  return 0
}

proc dcc_yomomma {hand idx arg} {
  global listyomomma
  if {$arg == ""} {
    putdcc $idx "Usage: .yomomma <channel|nick > <nick>"
    return 0
  }
  set targ [lindex $arg 0]
  set nick [lindex $arg 1]
  putserv "PRIVMSG $targ :$nick [lindex $listyomomma [rand [llength $listyomomma]]]"
  return 0
}

##
## REDNECK
##

proc pub_redneck {nick uhost handle chan testes} {
  global listredneck botnick myintro owner attack_nick attack_chan
  if {(![isop $nick $chan]) && (![matchattr $nick m])} { return 1 }
  set attack_nick [lindex $testes 0]
  set attack_chan [lindex $testes 1]
  if {[string index $attack_nick 0] == "#"} {
    putserv "PRIVMSG $nick :Joker Usage: !redneck <nick> <channel>"
    return 0
  }
  set outputw [lindex $listredneck [rand [llength $listredneck]]]
  set intro [lindex $myintro [rand [llength $myintro]]]
  if {$attack_nick == ""} {
    putserv "PRIVMSG $chan :$nick, You Might Be A Redneck If $outputw."
    return 1
  }

  if {[string compare [string tolower $botnick] [string tolower $attack_nick]] == 0} {
    putserv "PRIVMSG $chan :Hey $nick, instead of us joking about myself why don't I tell everyone about how You Might Be A Redneck If $outputw."
    return 1
  }
  if {[string compare [string tolower $nick] [string tolower $attack_nick]] == 0} {
    putserv "PRIVMSG $chan :Hey $nick, let's not joke about yourself, let's do it to someone else. Will you?"
    return 1
  }
  if {[nick2hand $attack_nick $chan] == $owner} {
    putserv "PRIVMSG $chan :Haha fool... $owner told me to tell ya >>> $nick <<< that $outputw."
    return 1
  }
  if {$attack_chan == ""} {
    if {[oncommonchan $attack_nick]} {
      putserv "PRIVMSG $chan :$attack_nick, $nick said You Might Be A Redneck If $outputw."
    } else {
      putserv "PRIVMSG $attack_nick :$nick said You Might Be A Redneck If $outputw."
    }
    return 1
  }

  set curchan [channels]
  foreach chann $curchan {
    if {[string tolower $chann] == [string tolower $attack_chan]} {
      putserv "PRIVMSG $attack_chan :$attack_nick, one of my Friends tells me You Might Be A Redneck If $outputw."
      return 0
    }
  }
  attack_timer $chan $attack_chan $attack_nick "redneck" "pub_redneck" "attack_nickredneck" 
}
#
proc attack_nickredneck { nick uhost hand chan } {
  global listredneck myintro attack_nick
  set outputw [lindex $listredneck [rand [llength $listredneck]]]
  set intro [lindex $myintro [rand [llength $myintro]]]
  putserv "PRIVMSG $chan :$intro >>> $attack_nick <<<, a special Friend wanted me to let you know You Might Be A Redneck If $outputw."
}

set redmsgs {
  {There is nothing wrong with being a redneck, just because I worship beer you should not hold that against me.}
  {Hey now, if you are gonna talk about rednecks, you could at least get me a beer!}
  {Hey, can someone please help me take these wheels off my trailer.}
  {Yes, I am a redneck and yes I can beat your mother in arm wrestling.}
}
proc msg_redneck {nick uhost hand chan text} {
  global redmsgs
  if {[matchattr $nick m] || [isop $nick $chan]} {
    putserv "PRIVMSG $chan :$nick [lindex $redmsgs [rand [llength $redmsgs]]]"
  }
  return 0
}

proc dcc_redneck {hand idx arg} {
  global listredneck
  if {$arg == ""} {
    putdcc $idx "Usage: .redneck <channel|nick> <nick>"
    return 0
  }
  putserv "PRIVMSG $arg :$nick You Might Be A Redneck If [lindex $listredneck [rand [llength $listredneck]]]"
  return 0
}

set myintro {
  {Hahaha}
  {Hey}
  {You know}
  {Did you know}
  {What's this I hear}
  {Is that really true}
  {Damn are you gonna take that}
  {LOL}
  {ROTFL}
}

set lotsanicks {
  {d1ckhead}
  {BoDracid}
  {HowdyDooD}
  {FatAlex}
  {StuDMuFF}
  {ReDRuM}
  {DrSenile}
  {tiFFed}
  {Da_BroaD}
  {StarWolfie}
  {eatThis}
  {UPussy}
  {ThaTDewd}
  {LayMur}
}

proc attack_timer { chan attack_chan attack_nick trigger triggerbind tempjoinbind } {
  global botnick currname lotsanicks
  set res [unbind pub - !$trigger $triggerbind]
  putlog "Unbinding $trigger $res"
  set currname $botnick
  set keep-nick 0
  set newnick [lindex $lotsanicks [rand [llength $lotsanicks]]]
#  if {$botnick != $newnick} { set newnick $botnick }

  set jbindmask "$attack_chan $newnick*"
  set res [bind JOIN - "$jbindmask" $tempjoinbind]
  putlog "Added JOIN bind $res"
  putserv "NICK $newnick"

  putserv "PRIVMSG $chan :Now Joining $attack_chan to $trigger the user $attack_nick..."
  channel add $attack_chan {
    chanmode "+nt"
    +bitch
  }
  utimer 16 "joinunbind $attack_chan $newnick $tempjoinbind"
  utimer 24 "trigrebind $chan $trigger $triggerbind
  utimer 40 "rerenick $currname"
}
## timer procs
proc joinunbind { attack_chan newnick tempjoinbind } {
  channel remove $attack_chan
  set res [unbind JOIN - "$attack_chan $newnick*" $tempjoinbind]
  putlog "Unbinding JOIN $res"
}
proc trigrebind { chan trigger triggerbind } {
  putlog "Rebinding $trigger [bind pub - !$trigger $triggerbind]"
  putserv "PRIVMSG $chan :!$trigger Re-Activated."
}
proc rerenick { currname } {
  putserv "NICK $currname"
  set keep-nick 1
}
#
proc oncommonchan { nick } {
  set curchan [channels]
  foreach c $curchan {
    if {[onchan $nick $c]} { return 1 }
  }
  return 0
}
##
##
## get binds and procs and load the jokes
source $joker_loader
set jokelists [info vars "list*"]
putlog "$jkrver loaded successfully!"