# mass.tcl by tw|ster [holmsen@mindless.com]
# -{[ Released 24.may 1999 ]}-
#
# COMMANDS
# .massop [channel]       ops all +o users
# .massdeop [channel]     deops all non-botusers

bind dcc n massop twist_massop_dcc
bind dcc n massdeop twist_massdeop_dcc

proc twist_twist_massop_dcc {hand idx chan} {
  if {$chan == ""} {
    set chan [lindex [channels] 0]
  } else {
    if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] < 0} {
      putdcc $idx "Sorry, I'm not on a channel called $chan"
      return 0
    }
  }
  putdcc $idx [mass_op $chan]
  return 1
}

proc twist_massdeop_dcc {hand idx chan} {
  if {$chan == ""} {
    set chan [lindex [channels] 0]
  } else {
    if {[lsearch -exact [string tolower [channels]] [string tolower $chan]] < 0} {
      putdcc $idx "Sorry, I'm not on a channel called $chan"
      return 0
    }
  }
  putdcc $idx [mass_deop $chan]
  return 1
}

proc mass_op {channel} {
  if ![botisop $channel] {
    global server
    return "I don't have ops on $channel according to $server"
  }
  foreach p [chanlist $channel o] {
    if ![isop $p $channel] {
        lappend oplist $p
    }
  }
  if ![info exists oplist] {
    return "Couldn't find anyone needing ops on $channel"
  }
  set cnt 0
  while {$cnt < [llength $oplist]} {
    putserv "MODE $channel +oooo [lrange $oplist $cnt [expr $cnt + 3]]"
    incr cnt 4
  }
  return "Oping [llength $oplist] on $channel\: $oplist"
}

proc mass_deop {channel} {
  if ![botisop $channel] {
   global server
   return "I don't have ops on $channel according to $server"
  }
  foreach p [chanlist $channel] {
    set who [finduser ${p}![getchanhost $p $channel]]
    if {[isop $p $channel] && ![matchattr $who m] && ![matchattr $who f] && ![matchattr $who o]} {
      lappend deoplist $p
    }
  }
  if ![info exists deoplist] {
    return "Couldn't find anyone needing deoped on $channel"
  }
  set cnt 0
  while {$cnt < [llength $deoplist]} {
    putserv "MODE $channel -oooo [lrange $deoplist $cnt [expr $cnt + 3]]"
    incr cnt 4
  }
  return "Deoping [llength $deoplist] on $channel\: $deoplist"
}
