# twist_seen2.tcl by tw|ster [holmsen@mindless.com]
# -{[ Released 24.may 1999 ]}-

bind pub - !seen pub_seen
bind msg - seen msg_seen
bind dcc - seen cmd_seen
bind chat - "seen *" chat_seen

proc seen_seen {user nick} {
	global botnick
	if {[string compare [string tolower $botnick] [string tolower $nick]] == 0} {
		return "Yeah, whenever I look in a mirror..."
	}
	if {[string compare [string tolower $nick] [string tolower $user]] == 0} {
		return "Trying to find yourself, eh?"
	}
    foreach chan [channels] {
	if {[onchansplit $nick $chan]} {
		return "$nick was just on $chan, but got netsplited..."
	}
	if {[onchan $nick $chan]} {
		return "$nick is on $chan right now!"
	}
	foreach i [chanlist $chan] {
		set hand [finduser $i![getchanhost $i $chan]]
		if {($hand != "*") && ([string compare [string tolower $hand] [string tolower $nick]] == 0)} {
        		if {[onchansplit $i $chan]} {
				return "$i is $nick, and $i was just on $chan but got netsplited..."
       		 	} {
	  			if {[onchan $i $chan]} {
            				return "$i is $nick, and $i is on $chan right now!"
          			}
			}
		}
	}
    }
  	if {[validuser $nick]} {
    		set lasttime [getlaston $nick]
		if {$lasttime == 0} {
      			return "$nick has never been around..."
		}
	} else {
		return "I don't know who $nick is."
	}
	set totalyear [expr [unixtime] - $lasttime]
	if {$totalyear < 60} {
        	return "$nick left $chan less then a minute ago..."
	}
	if {$totalyear > 31536000} {
      		set yearsfull [expr $totalyear/31536000]
      		set years [expr int($yearsfull)]
      		set yearssub [expr 31536000*$years]
      		set totalday [expr $totalyear - $yearssub]
    	}
    	if {$totalyear < 31536000} {
    	 	set totalday $totalyear
     		set years 0
   	}
	if {$totalday > 86400} {
   		set daysfull [expr $totalday/86400]
      		set days [expr int($daysfull)]
      		set dayssub [expr 86400*$days]
      		set totalhour [expr $totalday - $dayssub]
        }
    	if {$totalday < 86400} {
      		set totalhour $totalday
      		set days 0
  	}
    	if {$totalhour > 3600} {
    		set hoursfull [expr $totalhour/3600]
		set hours [expr int($hoursfull)]
      		set hourssub [expr 3600*$hours]
      		set totalmin [expr $totalhour - $hourssub]
    	}
    	if {$totalhour < 3600} {
     		set totalmin $totalhour
      		set hours 0
    	}
    	if {$totalmin > 60} {
      		set minsfull [expr $totalmin/60]
      		set mins [expr int($minsfull)]
    	}
    	if {$totalmin < 60} {
	      	set mins 0
    	}
    if {$years < 1} then {set yearstext ""} else {set yearstext "$years years, "}
    if {$days < 1} then {set daystext ""} else {set daystext "$days days, "}
    if {$hours < 1} then {set hourstext ""} else {set hourstext "$hours hours, "}
    if {$mins < 1} then {set minstext ""} else {set minstext "$mins minutes"}
    return "$nick was last here $yearstext$daystext$hourstext$minstext ago"
}
  
proc pub_seen {nick uhost hand chan args} {
## To reply via notice instead, comment up the line below, and uncomment
## the line following it.
	puthelp "PRIVMSG $chan :$nick: [seen_seen $nick $args]"
##	puthelp "NOTICE $chan :[seen_seen $nick $args]"
}

proc msg_seen {nick uhost hand args} {
	puthelp "PRIVMSG $nick :[seen_seen $nick $args]"
}

proc cmd_seen {hand idx nick} {
	if {$nick == ""} {
		putdcc $idx "Usage: .seen <handle>"
		return 0
	}
	putdcc $idx "$hand: [seen_seen $hand $nick]"
}

