########################
 ### jIRCoff Fserve ###
 ### Started 7-4-99 ###
########################

# DVS01@EFnet&Undernet, dvs02@earthlink.net
# DVS01 on Verbatim util&script group. #NoLimits@EFnet
# Report all bugs, requests, comments, etc. to me.

# Note: all relative paths are equal to the path to whatever loaded this tcl.  Usually, that's in the directory where the config file resides.
# Most DCC Commands and extensive documentation didn't make it into this release.  The help command within the Fserve describes basic usage of all available Fserve commands.

# DCC Commands:
# .transfers

### Configuration ###
# Note: You can change the configuration via DCC.
# For this first release, you will have to use .set
# I have made the script detect changes to the vars,
# so all changes should take effect properly.

# [0/1] Should the Fileserver start enabled? 0 for no, 1 for yes.
set dvs_fserve(enable) 1

# What is/are the fserve trigger(s)?
set dvs_fserve(triggers) {
	!fs
}

# What does the fserve contain?
set dvs_fserve(content) "jIRCserv"

# [0/1] Should the Fserve be advertised if disabled?
set dvs_fserve(ad_while_off) 0

# [0/1] Must the user be on the userlist for them to use the fserve?
set dvs_fserve(validuser) 0

# What flags should the fserve require? This makes the bot automatically
# require valid users, no matter what the previous setting is. To allow anyone
# and to let the previous setting take effect, use -|-
set dvs_fserve(bind) -|-

# Which channels should the bot have an onjoin message/advertise on?
set dvs_fserve(channels) {
}

# [0/1] Should the bot have a timed advertisement to its channels?
set dvs_fserve(ad) 0

# [0/1] Some ircd's do not like multiple destinations in a PRIVMSG (ie. #chan1,#chan2,#chan3).
# If you want the bot to message all of its advertisement channels using this method,
# then set this to 0 (saves bandwidth if there are alot of channels to msg to).
# If you want the bot to seperately message each channel, then set this to 1
# (uses up more bandwidth but is more compatible).
set dvs_fserve(admode) 0

# How many minutes should delay between advertisements be?
# Yes, fractions (such as 0.2, 1.5, etc.) are allowed.
set dvs_fserve(ad_delay) 5

# How many lines of chatter should be in between every advertisement?
# If the delay passes and the amount of lines have not been reached, then
# the bot won't advertise until it's reached.
# This is useful to prevent the bot from being an annoyance.
# Joins, parts, quits, kicks, ACTION CTCP's, nick changes, mode changes,
# topic changes, and messages all count as one line.
# Try counting the amount of lines in a screenful of
# text on your IRC client. That should be a good number to use.
set dvs_fserve(ad_linemin) 30

# [0/1] Should the bot try to advertise to a channel its not on? If it doesn't, it saves
# some bandwidth. You can make it send a message to the channel anyways, though, if
# you're counting on the bot advertising to channels that are -n.
set dvs_fserve(msg_to_notonchan) 0

# What is the maximum amount of filesearch matches to output to a user? This prevents abuse, for if
# a user does a search for * on a large file server, then the bot would flood and lag itself
set dvs_fserve(maxmatches) 30

# What motd file should the bot display for Fserve users? Set to "" to disable.
set dvs_fserve(motd) /home/user/eggdrop/motd.txt

# What is the path to the Fserve filesystem? 
set dvs_fserve(filepath) /home/user/eggdrop/fserve

# What flags must a user have in order to be able to log in as janitor?
set dvs_fserve(janflags) jJ

# What directories are to be unaccessible by normal users? (Must be janitor to access the dirs)
set dvs_fserve(jdirs) {
	/home/user/eggdrop/fserve/incoming
	/home/user/eggdrop/fserve/priv
}

# [0/1/2/3] What ratio should there be?
#  0 - None
#  1 - Byte
#  2 - File
#  3 - Byte & File
set dvs_fserve(ratiotype) 0

# What should the byte ratio be? (amount sent:credits recieved)
set dvs_fserve(bratio) 1:4

# What should the file ratio be?
set dvs_fserve(fratio) 1:4

# How many byte credits should a user start with?
set dvs_fserve(startbcredits) 15000

# How many file credits should a user start with?
set dvs_fserve(startfcredits) 3

# How many joins in how many seconds is considered a flood? This is to
# prevent the bot from sending too many onjoins and lagging itself.
set dvs_fserve_floodratio(onjoin) 4:7

# How many triggers in how many seconds is considered a flood? This is to
# prevent trigger floods from lagging the bot.
set dvs_fserve_floodratio(pub) 5:5

# How many commands/messages in how many seconds is considered a flood to
# the Fserve via DCC? Flooders will be killed.
set dvs_fserve_floodratio(fserve) 6:9

# What is the maximum amount of downloads that a user may request?
# Note: the variable max-dloads is set in the eggdrop config file.
# I have my own variable for this, since a public fserve would probably
# want to have less files available for download at the same time.
# If max-dloads is lower than dvs_fserve(maxdloads), then dvs_fserve(maxdloads)
# will be ineffective.
set dvs_fserve(maxdloads) 2

# What is the max amount of transfers the bot will allow per user?
# The total amount of sends and gets will not be permitted to exceed this.
set dvs_fserve(maxtrans) 4

# What is the maximum amount of fserve slots?
set dvs_fserve(maxslots) 5

# How long should a user's info (credits) on the temporary userlist last before expiring?
# (in minutes)
set dvs_fserve(expireuser) 30

# What is the maximum amount of people allowed on the bot that have the same hostmask?
set dvs_fserve(maxclone) 1

# What is the maximum allowed idle time (in seconds) on the fserve? If this is set
# to less than 31, then the "Closing idle connection in 30 seconds" message will not
# appear.
set dvs_fserve(maxidle) 120

# What is the maximum length of a line in the commands listing in Help?
# Don't change this if you don't know what it does.
set dvs_fserve(maxchars) 62

# The following 2 variables are needed to properly mask hosts

# What is the maximum number of characters allowed in nickname? EFnet is 9.
set dvs_max_nickchars 9

# What is the maximum number of characters allowed in an ident? EFnet is 10.
set dvs_max_identchars 10

### End of configuration.

set dvs_fserve_version 0x01
set dvs_fserve_vts 946951178

### FSERVE STARTUP ###
proc dvs_fserve:func:startup {} {
	global dvs_fserve_slots
	
	if {![info exists dvs_fserve_slots(pending)]} then {
		set dvs_fserve_slots(pending) ""
	}
	
	dvs_fserve:func:stats-init
	dvs_fserve:func:binds
	dvs_fserve:func:pub-ad
	dvs_fserve:func:du
	dvs_fserve:func:traceinit
	dvs_func:tracecall dvs_fserve filepath -
	if {![string match *dvs?fserve?func?floodctrl* [string tolower [utimers]]]} then {
		utimer 5 "dvs_fserve:func:floodctrl clean"
	}
	if {![string match *dvs?fserve?func?usercleanup* [string tolower [utimers]]]} then {
		utimer 10 dvs_fserve:func:usercleanup
	}
	if {![string match *dvs?fserve?func?pendclean* [string tolower [utimers]]]} then {
		utimer 15 dvs_fserve:func:pendclean
	}
	if {![string match *dvs?fserve?func?pendcheck* [string tolower [utimers]]]} then {
		utimer 20 dvs_fserve:func:pendcheck
	}
}

### VALID NUM CHECK ###
proc dvs_func:validnum {num} {
	catch {
		expr $num * 0
	} result
	if {$result != 0} then {
		return 0
	} else {
		return 1
	}
}

### mIRC CONTROL CHARS ###
proc b {} {
	return 
}
proc k {} {
	return 
}
proc o {} {
	return 
}
proc r {} {
	return 
}
proc u {} {
	return 
}

### SETTINGS VALIDATION ###
set ferr "j[u][b]IRC[b]off[u] Fserve error:"
set rerr "Error loading"

# Eggdrop version test
if {$numversion < 1032900} then {
	putlog "j[u][b]IRC[b]off[u] Fserve warning: Eggdrop version must be at least 1.3.29 for the Fserve to work properly"
}

# Variable existance test
foreach setting {
	dvs_fserve(enable)
	dvs_fserve(ad_while_off)
	dvs_fserve(validuser)
	dvs_fserve(bind)
	dvs_fserve(ad)
	dvs_fserve(ad_delay)
	dvs_fserve(ad_linemin)
	dvs_fserve(msg_to_notonchan)
	dvs_fserve(maxmatches)
	dvs_fserve(motd)
	dvs_fserve(filepath)
	dvs_fserve(jdirs)
	dvs_fserve(ratiotype)
	dvs_fserve(bratio)
	dvs_fserve(fratio)
	dvs_fserve(startbcredits)
	dvs_fserve(startfcredits)
	dvs_fserve_floodratio
	dvs_fserve(maxdloads)
	dvs_fserve(maxtrans)
	dvs_fserve(maxslots)
	dvs_fserve(expireuser)
	dvs_fserve(maxclone)
	dvs_fserve(maxidle)
	dvs_fserve(maxchars)
	dvs_fserve(admode)
	dvs_fserve(janflags)
} {
	if {![info exists $setting] } then {
		putlog "$ferr \$$setting variable was not set in configuration"
		return $rerr
	}
}

# Valid number test
foreach setting {
	dvs_fserve(ad_delay)
} {
	if {![dvs_func:validnum [subst $$setting]]} then {
		putlog "$ferr \$$setting must be a valid number."
		return $rerr
	}
}

# Valid integer test
foreach setting {
	dvs_fserve(ad_linemin)
	dvs_fserve(startbcredits)
	dvs_fserve(startfcredits)
	dvs_fserve(maxdloads)
	dvs_fserve(maxtrans)
	dvs_fserve(maxslots)
	dvs_fserve(expireuser)
	dvs_fserve(maxclone)
	dvs_fserve(maxidle)
	dvs_fserve(maxchars)
	dvs_fserve(enable)
	dvs_fserve(ad_while_off)
	dvs_fserve(validuser)
	dvs_fserve(ad)
	dvs_fserve(msg_to_notonchan)
	dvs_fserve(admode)
} {
	if {![dvs_func:validnum [subst $$setting]] || int([subst $$setting]) != [subst $$setting]} then {
		putlog "$ferr \$$setting must be a valid integer."
		return $rerr
	}
}

# Valid ratio test
foreach setting {
	dvs_fserve(bratio)
	dvs_fserve(fratio)
} {
	set set1 [lindex [split [subst $$setting] :] 0]
	set set2 [lindex [split [subst $$setting] :] 1]
	if {![dvs_func:validnum $set1] || int($set1) != $set1 || ![dvs_func:validnum $set2] || int($set2) != $set2} then {
		putlog "$ferr \$$setting must be a valid ratio in form of integer:integer"
		return $rerr
	}
}

# Valid fserve path test
catch {
	set dvs_fserve_pwd [pwd]
	set dvs_fserve_temp1 [catch {cd $dvs_fserve(filepath)}]
	set dvs_fserve_path [pwd]
	set dvs_fserve_temp2 [catch {cd $dvs_fserve_pwd}]
}
if {$dvs_fserve_temp1 || $dvs_fserve_temp2} then {
	putlog "$ferr Invalid Fserve path."
	return $rerr
}

# Valid ratio type test
if {$dvs_fserve(ratiotype) != 0 && $dvs_fserve(ratiotype) != 1 && $dvs_fserve(ratiotype) != 2 && $dvs_fserve(ratiotype) != 3} then {
	putlog "$ferr \$dvs_fserve(ratiotype) must be a valid integer ranging from 0 to 3."
	return $rerr
}

# Valid maxidle time test
if {$dvs_fserve(maxidle) < 1} then {
	putlog "$ferr \$dvs_fserve(maxidle) must be a valid integer greater than 0"
	return $rerr
}

# File existance test
foreach setting {
	dvs_fserve(motd)
} {
	if {[subst $$setting] != "" && ![file exists [subst $$setting]]} then {
		putlog "$ferr filename for \$$setting ([subst $$setting]) doesn't exist."
		return $rerr
	}
}

unset setting
unset ferr
unset rerr
unset dvs_fserve_temp1
unset dvs_fserve_temp2

### VARIABLE TRACE INITIALIZATION ###
proc dvs_fserve:func:traceinit {} {
	global dvs_fserve
	foreach var {
		dvs_fserve(triggers)
		dvs_fserve(bind)
		dvs_fserve(filepath)
		dvs_fserve(enable)
	} {
		dvs_func:tracedel $var
		trace variable $var w dvs_func:tracecall
	}
	return
}
proc dvs_func:tracecall {var index mode} {
	switch -- $var\
	dvs_fserve {
		switch -- $index\
		triggers {
			dvs_fserve:func:binds
		} bind {
			dvs_fserve:func:binds
		} enable {
			global dvs_fserve dvs_fserve_stats
			set dvs_fserve_stats(reenable) [expr ($dvs_fserve_stats(reenable) == 2) ? 1 : 0]
			if {!$dvs_fserve(enable) && $dvs_fserve_stats(wasenabled)} then {
				putlog "j[u][b]IRC[b]off[u] Fserve: Disabled."
			} elseif {$dvs_fserve(enable) && !$dvs_fserve_stats(wasenabled)} then {
				putlog "j[u][b]IRC[b]off[u] Fserve: Enabled."
			}
			set dvs_fserve_stats(wasenabled) $dvs_fserve(enable)
		} filepath {
			global dvs_fserve dvs_fserve_stats
			if {![dvs_fserve:func:dir isvalid -]} then {
				putlog "j[u][b]IRC[b]off[u] Fserve error: Invalid Fserve path."
				set dvs_fserve_stats(reenable) 2
				set dvs_fserve(enable) 0
				set dvs_fserve_stats(lock) 1
			} elseif {$dvs_fserve_stats(reenable)} then {
				set dvs_fserve(enable) 1
				set dvs_fserve_stats(lock) 0
			} else {
				set dvs_fserve_stats(lock) 0
			}
		} default {
			return
		}
	} default {
		return
	}
}
proc dvs_func:tracedel {var} {
	global dvs_fserve
	foreach element [trace vinfo $var] {
		uplevel 0 trace vdelete $var [lindex $element 0] [lindex $element 1]
	}
	return
}

### VERSION MANIPULATION ###
proc dvs_fserve:func:version {element {format ""}} {
	global dvs_fserve_version dvs_fserve_vts
	switch -- $element\
	version {
		switch -- $format\
		long {
			return [format %u $dvs_fserve_version]
		} hex {
			return $dvs_fserve_version
		} 0long {
			return [format %05u $dvs_fserve_version]
		} formatted {
			return [format %.2f [expr $dvs_fserve_version * .01]]
		} default {
			return -1
		}
	} ts {
		switch -- $element\
		datetime {
			return [strftime "%m-%d-%y %H:%M:%S" $dvs_fserve_vts]
		} date {
			return [strftime "%m-%d-%y" $dvs_fserve_vts]
		} strdate {
			return [strftime "%b %d, %Y" $dvs_fserve_vts]
		} strdatetime {
			return [strftime "%b %d, %Y %H:%M:%S" $dvs_fserve_vts]
		} default {
			return [strftime "%m-%d-%y" $dvs_fserve_vts]
		}
	} default {
		return -1
	}
}

### FREE SLOT COUNTER ###
proc dvs_fserve:func:slotcount {} {
	global dvs_fserve dvs_fserve_availslots dvs_fserve_slots
	
	set count [expr [array size dvs_fserve_slots] - 1 + [llength $dvs_fserve_slots(pending)]]
	set dvs_fserve_availslots [expr ($count > $dvs_fserve(maxslots)) ? 0 : $dvs_fserve(maxslots) - $count]
	return $dvs_fserve_availslots
}

### AD GENERATOR ###
proc dvs_fserve:func:adgen {} {
	global dvs_fserve
	if {$dvs_fserve(enable)} then {
		set enable on
	} else {
		set enable off
	}
	if {[llength $dvs_fserve(triggers)] > 1} then {
		set triggers "Triggers: "
	} else {
		set triggers "Trigger: "
	}
	set tcount 1
	foreach trigger $dvs_fserve(triggers) {
		if {$tcount > 1} then {
			append triggers ", $trigger"
		} else {
			append triggers "$trigger"
		}
		incr tcount
	}
	switch -- $dvs_fserve(ratiotype)\
	0 {
		set ratio "No ratio"
	} 1 {
		set ratio "Byte ratio $dvs_fserve(bratio), $dvs_fserve(startbcredits) initial credits"
	} 2 {
		set ratio "File ratio $dvs_fserve(fratio), $dvs_fserve(startfcredits) initial credits"
	} 3 {
		set ratio "Byte ratio $dvs_fserve(bratio) with $dvs_fserve(startbcredits) byte credits, file ratio $dvs_fserve(fratio) with $dvs_fserve(startfcredits) file credits"
	}
	set slots "[dvs_fserve:func:slotcount]/$dvs_fserve(maxslots) open slots"
	return "Fserve is $enable. $triggers. $ratio. $slots. Content: $dvs_fserve(content)"
}

### MOTD DISPLAYER ###
proc dvs_fserve:func:motd {{idx ""}} {
	global dvs_fserve dvs_fserve_slots
	
	if {![info exists dvs_fserve_slots($idx)]} then {
		return "Invalid idx"
	}
	
	set infile [open $dvs_fserve(motd)]
	set temp [unixtime]![clock clicks]
	while {![eof $infile]} {
		gets $infile line
		set line [split $line]
		while {[set match [lsearch -glob $line %*]] != -1} {
			set lmatch $match
			switch -- [string range [lindex $line $match] 1 end]\
			botnick {
				global botnick
				set replacement $botnick
			} nick {
				set replacement [dvs_fserve:func:slots get $idx nick]
			} uhost {
				set replacement [dvs_fserve:func:slots get $idx uhost]
			} version {
				set replacement [dvs_fserve:func:version version formatted]
			} vdate {
				global dvs_fserve_vdate
				set replacement $dvs_fserve_vdate
			} % {
				set replacement ${temp}!percent
			} freeslots {
				set replacement [dvs_fserve:func:slotcount]
			} totalslots {
				set replacement $dvs_fserve(maxslots)
			} usedslots {
				set replacement [expr [llength [array names dvs_fserve_slots]] -1]
			} ratiocred {
				set bcredits [dvs_fserve:func:slots get $idx bcredits]
				set fcredits [dvs_fserve:func:slots get $idx fcredits]
				switch -- $dvs_fserve(ratiotype)\
				0 {
					set replacement "No ratio"
				} 1 {
					set replacement "Byte ratio $dvs_fserve(bratio), $bcredits credits"
				} 2 {
					set replacement "File ratio $dvs_fserve(fratio), $fcredits credits"
				} 3 {
					set replacement "Byte ratio $dvs_fserve(bratio) with $bcredits byte credits, file ratio $dvs_fserve(fratio) with $fcredits file credits"
				}
			} ratio {
				switch -- $dvs_fserve(ratiotype)\
				0 {
					set replacement "No ratio"
				} 1 {
					set replacement "Byte ratio $dvs_fserve(bratio)"
				} 2 {
					set replacement "File ratio $dvs_fserve(fratio)"
				} 3 {
					set replacement "Byte ratio $dvs_fserve(bratio), file ratio $dvs_fserve(fratio)"
				}
			} cred {
				set bcredits [dvs_fserve:func:slots get $idx bcredits]
				set fcredits [dvs_fserve:func:slots get $idx fcredits]
				switch -- $dvs_fserve(ratiotype)\
				0 {
					set replacement "Unlimited credits"
				} 1 {
					set replacement "$bcredits byte credits"
				} 2 {
					set replacement "$fcredits file credits"
				} 3 {
					set replacement "$bcredits byte credits, $fcredits file credits"
				}
			} bcred {
				set bcredits [dvs_fserve:func:slots get $idx bcredits]
				switch -- $dvs_fserve(ratiotype)\
				0 {
					set replacement "Unlimited byte credits"
				} 1 {
					set replacement "$bcredits byte credits"
				} 2 {
					set replacement "Unlimited byte credits"
				} 3 {
					set replacement "$bcredits byte credits"
				}
			} fcred {
				set fcredits [dvs_fserve:func:slots get $idx fcredits]
				switch -- $dvs_fserve(ratiotype)\
				0 {
					set replacement "Unlimited file credits"
				} 1 {
					set replacement "Unlimited file credits"
				} 2 {
					set replacement "$fcredits file credits"
				} 3 {
					set replacement "$fcredits file credits"
				}
			} time12 {
				set replacement [strftime "%I:%M %p"]
			} time24 {
				set replacement [strftime "%H:%M"]
			} date2 {
				set replacement [strftime %m-%d-%y]
			} date4 {
				set replacement [strftime %m-%d-%Y]
			} strdate {
				set replacement [strftime "%B %d, %Y"]
			} maxdl {
				set replacement $dvs_fserve(maxdloads)
			} maxul {
				set replacement $dvs_fserve(maxuploads)
			} maxtrans {
				set replacement $dvs_fserve(maxtrans)
			} trigcount {
				global dvs_fserve_stats
				set replacement $dvs_fserve_stats(uses)
			} filecount {
				global dvs_fserve_stats
				set replacement $dvs_fserve_stats(foffered)
			} filecntf {
				global dvs_fserve_stats
				set replacement [dvs_func:nformat $dvs_fserve_stats(foffered)]
			} kilocount {
				global dvs_fserve_stats
				set replacement $dvs_fserve_stats(koffered)
			} kilocntf {
				global dvs_fserve_stats
				set replacement $dvs_fserve_stats(koffered)
			} megcount {
				global dvs_fserve_stats
				set replacement [format %.3f [expr $dvs_fserve_stats(koffered) / 1024]]
			} megcntf {
				global dvs_fserve_stats
				set replacement [dvs_func:nformat [format %.3f [expr $dvs_fserve_stats(koffered) / 1024]]]
			} backsp {
				set replacement ${temp}!backsp
			} default {
				set replacement ""
			}
			set line [lreplace $line $match $match $replacement]
		}
		while {[set match [lsearch $line ${temp}!percent]] != -1} {
			set line [lreplace $line $match $match %]
		}
		set line [split [join $line]]
		while {[set match [lsearch $line ${temp}!backsp]] != -1} {
			set tlength [string length ${temp}!backsp]
			set line1 [lrange $line 0 $match]
			set slength [string length $line1]
			set line1 [string range $line1 0 [expr $slength - $tlength - 2]]
			set line2 [string range [lrange $line $match end] [expr $tlength + 1] end]
			set line $line1$line2
		}
		set line [join $line]
		putdcc $idx $line
	}
	close $infile
	return
}

### PUB BINDS DATABASE ###
proc dvs_fserve:func:binds {{vcheck ""}} {
	global dvs_fserve dvs_fserve_binds
	set vtrigs ""
	foreach trigger $dvs_fserve(triggers) {
		if {[info exists dvs_fserve_binds($trigger)]} then {
			if {$dvs_fserve_binds($trigger) != $dvs_fserve(bind)} then {
				unbind pub $dvs_fserve_binds($trigger) $trigger dvs_fserve:pub:fserve
				unset dvs_fserve_binds($trigger)
			} else {
				lappend vtrigs $trigger
			}
		}
		set dvs_fserve_binds($trigger) $dvs_fserve(bind)
		bind pub $dvs_fserve(bind) $trigger dvs_fserve:pub:fserve
		lappend vtrigs $trigger
	}
	foreach trigger [array names dvs_fserve_binds] {
		if {[lsearch -exact $dvs_fserve(triggers) $trigger] == -1} then {
			unbind pub $dvs_fserve_binds($trigger) $trigger dvs_fserve:pub:fserve
			unset dvs_fserve_binds($trigger)
		}
	}
	if {$vtrigs != "" && [lsearch -exact $vtrigs $vcheck] == -1} then {
		return 0
	} else {
		return 1
	}
}

### FLOOD CONTROL ###
proc dvs_fserve:func:floodctrl {type {arg ""}} {
	global dvs_fserve dvs_fserve_floodratio dvs_fserve_flood
	set type [string tolower $type]
	if {![string match *dvs?fserve?func?floodctrl* [string tolower [utimers]]]} then {
		utimer 30 "dvs_fserve:func:floodctrl clean"
	}
	if {![dvs_func:imatch or $type "pub" "onjoin" "fserve" "clean"]} then {
		return "Invalid type"
	} elseif {$type == "fserve"} then {
		if {$arg == ""} then {
			return -1
		}
		if {![info exists dvs_fserve_flood($arg)]} then {
			set dvs_fserve_flood($arg) [unixtime]
			return 0
		}
		set x [lindex [split $dvs_fserve_floodratio(fserve) :] 0]
		set y [lindex [split $dvs_fserve_floodratio(fserve) :] 1]
		set element 0
		set templist ""
		foreach ts $dvs_fserve_flood($arg) {
			if {[unixtime] - $ts <= $y} then {
				lappend templist [lindex $dvs_fserve_flood($arg) $element]
			}
			incr element
		}
		set dvs_fserve_flood($arg) $templist
		lappend dvs_fserve_flood($arg) [unixtime]
		if {[llength $dvs_fserve_flood($arg)] >= $x} then {
			return 1
		} else {
			return 0
		}
	}
	if {$type == "clean"} then {
		set x [lindex [split $dvs_fserve_floodratio(fserve) :] 0]
		set y [lindex [split $dvs_fserve_floodratio(fserve) :] 1]
		foreach entry [array names dvs_fserve_flood] {
			if {![dvs_func:imatch or $entry "fserve" "onjoin" "pub" "clean"]} then {
				continue
			}
			set length [llength $dvs_fserve_flood($entry)]
			set element 1
			foreach ts $dvs_fserve_flood($entry) {
				if {[unixtime] - $ts <= $y} then {
					break
				} elseif {$element == $length} then {
					unset dvs_fserve_flood($entry)
					break
				} else {
					incr element
				}
			}
		}
		return 0
	} elseif {![info exists dvs_fserve_flood($type)]} then {
		set dvs_fserve_flood($type) [unixtime]
		return 0
	}
	set x [lindex [split $dvs_fserve_floodratio($type) :] 0]
	set y [lindex [split $dvs_fserve_floodratio($type) :] 1]
	set element 0
	set templist ""
	foreach ts $dvs_fserve_flood($type) {
		if {[unixtime] - $ts <= $y} then {
			lappend templist [lindex $dvs_fserve_flood($type) $element]
		}
		incr element
	}
	set dvs_fserve_flood($type) $templist
	lappend dvs_fserve_flood($type) [unixtime]
	if {[llength $dvs_fserve_flood($type)] >= $x} then {
		return 1
	} else {
		return 0
	}
}

### ONJOIN ###
bind join $dvs_fserve(bind) * dvs_fserve:join:onjoin
proc dvs_fserve:join:onjoin {nick uhost hand chan} {
	global dvs_fserve
	if {[matchattr $hand b] || ($dvs_fserve(validuser) && $hand == "*") || (!$dvs_fserve(enable) && !$dvs_fserve(ad_while_off)) || [lsearch -exact [string tolower $dvs_fserve(channels)] [string tolower $chan]] == -1 || [dvs_fserve:func:floodctrl onjoin]} then {
		return 0
	}
	puthelp "NOTICE $nick :[dvs_fserve:func:adgen]"
	return 0
}

### CHANNEL LINE COUNTER ###
bind pubm -|- * dvs_fserve:bind:chan-counter
bind join -|- * dvs_fserve:bind:chan-counter
bind part -|- * dvs_fserve:bind:chan-counter
bind sign -|- * dvs_fserve:bind:chan-counter
bind kick -|- * dvs_fserve:bind:chan-counter
bind nick -|- * dvs_fserve:bind:chan-counter
bind topc -|- * dvs_fserve:bind:chan-counter
bind ctcp -|- ACTION dvs_fserve:bind:chan-counter
bind raw -|- MODE dvs_fserve:raw:chan-counter

proc dvs_fserve:bind:chan-counter {1 2 3 chan {args ""}} {
	global dvs_fserve dvs_fserve_linecount
	set chan [string tolower $chan]
	if {[lsearch -exact [string tolower $dvs_fserve(channels)] [string tolower $chan]] == -1} then {
		return -1
	}
	set channels [string tolower $dvs_fserve(channels)]
	foreach channel [array names dvs_fserve_linecount] {
		if {![validchan $channel] || ![botonchan $channel] || [lsearch -exact $channels $channel] == -1} then {
			unset dvs_fserve_linecount($channel)
		}
	}
	if {![info exists dvs_fserve_linecount($chan)]} then {
		set dvs_fserve_linecount($chan) 1
	} else {
		incr dvs_fserve_linecount($chan)
	}
	return 0
}

proc dvs_fserve:raw:chan-counter {from keyword text} {
	dvs_fserve:bind:chan-counter 1 2 3 [lindex $text 0]
	return 0
}

### TIMED ADVERTISEMENTS ###
proc dvs_fserve:func:pub-ad {} {
	global dvs_fserve_linecount dvs_fserve
	foreach timer [utimers] {
		if {[lindex $timer 1] == "dvs_fserve:func:pub-ad"} then {
			killutimer [lindex $timer 2]
		}
	}
	foreach timer [timers] {
		if {[lindex $timer 1] == "dvs_fserve:func:pub-ad"} then {
			killtimer [lindex $timer 2]
		}
	}
	if {[expr int($dvs_fserve(ad_delay))] == $dvs_fserve(ad_delay)} then {
		timer $dvs_fserve(ad_delay) dvs_fserve:func:pub-ad
	} else {
		utimer [expr int($dvs_fserve(ad_delay) * 60 + .5)] dvs_fserve:func:pub-ad
	}
	if {!$dvs_fserve(enable) || !$dvs_fserve(ad)} then {
		return
	}
	set channels [string tolower $dvs_fserve(channels)]
	
	# For those ircd's that dont like multiple destinations
	if {$dvs_fserve(admode)} then {
		foreach channel $channels {
			if {!$dvs_fserve(msg_to_notonchan) && (![validchan $channel] || ![botonchan $channel]) || ![info exists dvs_fserve_linecount($channel)] || $dvs_fserve_linecount($channel) < $dvs_fserve(ad_linemin)} then {
				continue
			}
			puthelp "PRIVMSG #channel :[dvs_fserve:func:adgen]"
		}
		return
	}
	
	set dest ""
	foreach channel $channels {
		if {!$dvs_fserve(msg_to_notonchan) && (![validchan $channel] || ![botonchan $channel]) || ![info exists dvs_fserve_linecount($channel)] || $dvs_fserve_linecount($channel) < $dvs_fserve(ad_linemin)} then {
			continue
		} elseif {[string length dest] > 0} then {
			append dest ,$channel
		} else {
			set dest $channel
		}
		set dvs_fserve_linecount($channel) 0
	}
	if {$dest != ""} then {
		puthelp "PRIVMSG $dest :[dvs_fserve:func:adgen]"
	}
	return
}

### HOST MASKER ###
proc dvs_func:maskhost {host options} {
	global dvs_max_nickchars dvs_max_identchars
	set options [split $options .]
	set arg1 [lindex $options 0]
	set arg2 [lindex $options 1]
	set arg3 [lindex $options 2]
	set nick [dvs_func:sindex $host 0 !]
	set ident [dvs_func:sindex $host 1 !@]
	set host [dvs_func:sindex $host 1 @]
	
	switch -- $arg1\
	n {
		set nickmask $nick
	} *n {
		set nickmask *[string range $nick [expr [string length $nick] - $dvs_max_nickchars + 1] end]
	} n* {
		set nickmask [string range $nick 0 [expr $dvs_max_nickchars - 2]]*
	} *n* {
		set nickmask [string range $nick 0 [expr $dvs_max_nickchars - 2]]*
		set nickmask *[string range $nickmask [expr [string length $nickmask] - $dvs_max_nickchars + 1] end]
	} * {
		set nickmask *
	} default {
		return "Invalid syntax"
	}
	
	switch -- $arg2\
	u {
		set identmask $ident
	} *u {
		if {[string length [string trimleft $ident ~]] > 0} then {
			set ident [string trimleft $ident ~]
		} elseif {[string length $ident] > 1} then {
			set ident [string range $ident 1 end]
		}
		set identmask *[string range $ident [expr [string length $ident] - $dvs_max_identchars + 1] end]
	} u* {
		set identmask [string range $ident 0 [expr $dvs_max_identchars - 2]]*
	} *u* {
		if {[string length [string trimleft $ident ~]] > 0} then {
			set ident [string trimleft $ident ~]
		} elseif {[string length $ident] > 1} then {
			set ident [string range $ident 1 end]
		}
		set identmask [string range $ident 0 [expr $dvs_max_identchars - 2]]*
		set identmask *[string range $identmask [expr [string length $identmask] - $dvs_max_identchars + 1] end]
	} * {
		set identmask *
	} default {
		return "Invalid syntax"
	}
	
	switch -- $arg3\
	h {
		set hostmask $host
	} *h {
		set hostmask [dvs_func:sindex [maskhost $host] 1 @]
	} * {
		set hostmask *
	} default {
		return "Invalid syntax"
	}
	
	return ${nickmask}!${identmask}@${hostmask}
}

### SINDEX & SRANGE (Returns index'th element of a string) ###
proc dvs_func:sindex {string index {split " "}} {
	catch {
		join [lrange [split $string $split] $index $index]
	} result
	return $result
}
proc dvs_func:srange {string first last {split " "}} {
	catch {
		join [lrange [split $string $split] $first $last]
	} result
	return $result
}

### IMATCH ###
proc dvs_func:imatch {op var args} {
	switch -- $op\
	or {
		foreach arg $args {
			if {![string compare $var $arg]} then {
				return 1
			}
		}
		return 0
	} and {
		foreach arg $args {
			if {[string compare $var $arg]} then {
				return 0
			}
		}
		return 1
	} default {
		return -1
	}
}

### NUMBER FORMATTING ###
proc dvs_func:nformat {num} {
	if {![dvs_func:validnum $num]} then {
		return "Invalid number"
	}
	set int [lindex [split $num .] 0]
	set dec [lindex [split $num .] 1]
	if {$dec != ""} then {
		set es .
	} else {
		set es ""
	}
	set place [expr [string length $int] % 3]
	if {!$place} then {
		set place 3
	}
	set charnum 1
	foreach char [split $int {}] {
		if {$charnum == $place} then {
			append int2 ${char},
			set charnum 1
			set place 3
		} else {
			append int2 $char
			incr charnum
		}
	}
	return [string trimright $int2 ,]${es}$dec
}

### UNIXTIME WITH MS ###
proc dvs_func:unixtime {{unixtime [unixtime]} {clicks "[clock clicks]"}} {
	set n 0
	if {$clicks < 0} then {
		set clicks [expr abs($clicks)]
		set n 1
	}
	set ms [expr [format "%.3f" [expr double($clicks) / 1000000]] * 1000]
	if {$n} then {
		set ms [expr 1000 - int([string trimleft $ms 0])]
	}
	return $unixtime.$ms
}

### BOT IP ###
proc dvs_func:myip {{format "base256"}} {
	global nat-ip
	
	if {$format == "base256" || $format == "quad"} then {
		if {![info exists nat-ip] || ${nat-ip} == ""} then {
			return [dvs_func:longip-2-quad [myip]]
		} else {
			return ${nat-ip}
		}
	} elseif {$format == "long" || $format == "longip"} then {
		if {![info exists nat-ip] || ${nat-ip} == ""} then {
			return [myip]
		} else {
			set splitip [split ${nat-ip} .]
			set ip1 [lindex $splitip 0]
			set ip2 [lindex $splitip 1]
			set ip3 [lindex $splitip 2]
			set ip4 [lindex $splitip 3]
			return [format %u [expr $ip1*256*256*256 + $ip2*256*256 + $ip3*256 + $ip4]]
		}
	} else {
		return "Invalid type. Available types: base256 and quad, long and longip."
	}
}

### DIRECTORY WORK ###
proc dvs_fserve:func:dir {command dir {dir2 ""}} {
	global dvs_fserve_pwd dvs_fserve dvs_fserve_path
	
	switch -- $command\
	isin {
		if {$dir2 == ""} then {
			set dir2 $dvs_fserve_path
		}
		if {![file isdirectory $dir2]} then {
			return 0
		}
		catch {
			cd $dvs_fserve_path/$dir
		} pass1
		catch {
			cd $dir
		} pass2
		set pwd [pwd]
		if {![string length $pass1] && [string match $dir2* $pwd] || ![string length $pass2] && [string match $dir2* $pwd]} then {
			cd $dvs_fserve_pwd
			return $pwd
		} else {
			cd $dvs_fserve_pwd
			return 0
		}
	} isvalid {
		catch {
			set dvs_fserve_pwd [pwd]
			set dvs_fserve_temp1 [catch {cd $dvs_fserve(filepath)}]
			set dvs_fserve_path [pwd]
			set dvs_fserve_temp2 [catch {cd $dvs_fserve_pwd}]
		}
		return [expr !($dvs_fserve_temp1 || $dvs_fserve_temp2)]
	} relative {
		return /[string trim [string range $dir [string length $dvs_fserve_path] end] /]
	} default {
		return -1
	}
}
		
### FSERVE HELP ORGANIZATION ###
proc dvs_fserve:func:help {{element "all"}} {
	global dvs_fserve
	set help_items {
		help
		ls
		dir
		get
		find
		credits
		stats
		exit
		cd
		pwd
		who
		say
		login
		cp
		mv
		rm
		rmdir
		mkdir
	}
	switch -- $element\
	all {
		set length 0
		foreach entry $help_items {
			#set entry [string trim $entry [b][u][k][r][o]]
			set elength [string length $entry]
			if {$elength > $length} then {
				set length $elength
			}
		}
		incr length 2
		set items_per_line [expr int($dvs_fserve(maxchars) / $length)]
		if {!$items_per_line} then {
			incr items_per_line
		}
		set amount 0
		set string "Help for Fserve [dvs_fserve:func:version version formatted]:\n\nCommands:\n    "
		foreach entry $help_items {
			set item [format %-${length}s $entry]
			if {$amount >= $items_per_line} then {
				append string "\n    $item"
				set amount 0
			} else {
				append string $item
			}
			incr amount
		}
		return $string
	} help {
		return "###    help \[command\]\n  Displays a list of available commands.  If a command is specified, a detailed description on the command is given, if available."
	} ls {
		return "###    ls \[args\]\n  Displays a UNIX-style dir listing.  Supply -l to use a long listing format."
	} dir {
		return "###    dir\n  Displays an MS-DOS-style dir listing."
	} get {
		return "###    get <filename/mask>\n  Sends specified file(s) to a user if they have sufficient credits. Wildcards accepted."
	} find {
		return "###    find <mask>\n  Searches for files matching a mask.  Uses globbing rules."
	} credits {
		return "###    credits\n  Displays credits."
	} stats {
		return "###    stats\n  Displays Fileserver statistics and information."
	} exit {
		return "###    exit\n  Exits the Fserve."
	} cd {
		return "###    cd <directory>\n  Changes current directory."
	} pwd {
		return "###    pwd\n  Displays current directory."
	} say {
		return "###    say <message>\n  Sends a message to other users on the Fserve."
	} who {
		return "###    who\n  Displays a list of users currently on the Fserve."
	} login {
		return "###    login <password>\n  Fserve janitor login."
	} cp {
		return "###    [u]cp[u] <[u]source[u]> <[u]destination[u]>\n  Copies file(s) or dir(s).  Wildcards accepted.  Janitor only."
	} mv {
		return "###    [u]mv[u] <[u]source[u]> <[u]destination[u]>\n  Moves file(s) or dir(s).  Wildcards accepted.  Janitor only."
	} rm {
		return "###    [u]rm[u] <[u]target[u]>\n  Deletes file(s).  Wildcards accepted.  Janitor only."
	} rmdir {
		return "###    [u]rmdir[u] <[u]target[u]>\n  Deletes dir(s).  Wildcards accepted.  Janitor only."
	} mkdir {
		return "###    [u]mkdir[u] <[u]directory[u]>\n  Attempts to create a directory.  Janitor only."
	} default {
		if {[lsearch -exact $help_items $element] == -1} then {
			return "Invalid help item."
		} else {
			return "No help available on that."
		}
	}
}

### FSERVE SIZE CALCULATION ###
proc dvs_fserve:func:du {} {
	global dvs_fserve_stats dvs_fserve_path
	set dvs_fserve_stats(koffered) [lindex [exec du -s $dvs_fserve_path] 0]
	set files 0
	foreach entry [split [exec du -a $dvs_fserve_path] \n] {
		set name [lindex $entry 1]
		if {![file isdirectory $name]} then {
			incr files
		}
	}
	set dvs_fserve_stats(foffered) $files
	if {![string match *dvs?fserve?func?du* [string tolower [timers]]]} then {
		timer 2 dvs_fserve:func:du
	}
	return
}

### FSERVE FUNCTIONS ###
proc dvs_fserve:func:fserve {command {arg1 ""} {arg2 ""} {arg3 ""}} {
	switch -- $command\
	ls {
		global dvs_fserve
		if {$arg1 == "" || ($arg2 != "-l" && $arg2 != "")} then {
			return "### Usage: ls \[-l\]"
		} elseif {$arg2 == "-l"} then {
			set length 0
			set ls [glob -nocomplain -- [split $arg1]/*]
			foreach entry $ls {
				set elength [string length [file size $entry]]
				if {$elength > $length} then {
					set length $elength
				}
			}
			set pwd [dvs_fserve:func:dir relative $arg1]
			set string "### \[$pwd\]"
			foreach entry $ls {
				set size [format %${length}s [file size $entry]]
				set name [file tail $entry]
				if {[file isdirectory $entry]} then {
					append name /
				}
				append string "\n  $size  [strftime "%b %d %H:%M" [file mtime $entry]] $name"
			}
			return $string
		}
		set length 0
		set ls [glob -nocomplain -- [split $arg1]/*]
		set dir ""
		foreach entry $ls {
			set name [file tail $entry]
			if {[file isdirectory $entry]} then {
				append name /
			}
			set elength [string length $name]
			if {$elength > $length} then {
				set length $elength
			}
			lappend dir $name
		}
		incr length 2
		set items_per_line [expr int($dvs_fserve(maxchars) / $length)]
		if {!$items_per_line} then {
			incr items_per_line
		}
		set amount 0
		set pwd [dvs_fserve:func:dir relative $arg1]
		set string "### \[$pwd\]\n  "
		foreach entry $dir {
			set item [format %-${length}s $entry]
			if {$amount >= $items_per_line} then {
				append string "\n  $item"
				set amount 0
			} else {
				append string $item
				incr amount
			}
		}
		return $string
	} dir {
		global dvs_fserve
		if {$arg2 != ""} then {
			return "### Usage: dir"
		}
		set ls [glob -nocomplain -- [split $arg1]/*]
		set length 0
		foreach entry $ls {
			set elength [string length [dvs_func:nformat [file size $entry]]]
			if {$elength > $length} then {
				set length $elength
			}
		}
		if {$length < 8} then {
			set length 8
		}
		set pwd [dvs_fserve:func:dir relative $arg1]
		set string "### Directory of $pwd"
		foreach entry $ls {
			if {[file isdirectory $entry]} then {
				set info [format %-${length}s <DIR>]
			} else {
				set info [format %${length}s [dvs_func:nformat [file size $entry]]]
			}
			set date [strftime %m-%d-%y [file mtime $entry]]
			set time [format %6s [string trim [string tolower [strftime %I:%M%p [file mtime $entry]]] 0m]]
			append string "\n  $info  $date $time [file tail $entry]"
		}
		return $string
	} stats {
		global dvs_fserve_stats dvs_fserve
		# koffered foffered
		set nick [dvs_fserve:func:slots get $arg1 nick]
		set ko [dvs_func:nformat $dvs_fserve_stats(koffered)]
		set fo [dvs_func:nformat $dvs_fserve_stats(foffered)]
		switch -- $dvs_fserve(ratiotype)\
		0 {
			set ratio "No ratio."
		} 1 {
			set ratio "$dvs_fserve(bratio) byte ratio.\n  $dvs_fserve(startbcredits) start byte credits."
		} 2 {
			set ratio "$dvs_fserve(fratio) file ratio.\n  $dvs_fserve(startfcredits) start file credits."
		} 3 {
			set ratio "$dvs_fserve(bratio) byte ratio.\n  $dvs_fserve(fratio) file ratio.\n  $dvs_fserve(startbcredits) start byte credits.\n  $dvs_fserve(startfcredits) start file credits."
		}
		set dccs [dvs_fserve:func:transfers formatted $nick]
		return "### Fserve v[dvs_fserve:func:version version formatted] \[[dvs_fserve:func:version ts date]\] by DVS01. Stats:\n  Fserve was triggered $dvs_fserve_stats(uses) time(s).\n  KB offered: $ko\n  Files offered: $fo\n  $ratio\n$dccs"
	} credits {
		global dvs_fserve
		set bcredits [dvs_fserve:func:slots get $arg1 bcredits]
		set fcredits [dvs_fserve:func:slots get $arg1 fcredits]
		switch -- $dvs_fserve(ratiotype)\
		0 {
			set credits "Unlimited credits."
		} 1 {
			set credits "$bcredits byte credits, $dvs_fserve(bratio) byte ratio."
		} 2 {
			set credits "$fcredits file credits, $dvs_fserve(fratio) file ratio."
		} 3 {
			set credits "$bcredits byte credits, $dvs_fserve(bratio) byte ratio.\n  $fcredits file credits, $dvs_fserve(fratio) file ratio."
		}
		return "### Credits:\n  $credits"
	} get {
		global dvs_fserve max-dcc dvs_fserve_path
		
		if {$arg2 == ""} then {
			return "Usage: get <file/mask>"
		}
		if {[string index $arg2 0] == "/"} then {
			set pwd $dvs_fserve_path
		} else {
			set pwd [dvs_fserve:func:slots get $arg1 pwd]
		}
		set count 0
		# arg1 is idx, arg2 is text
		set filelist ""
		foreach entry [glob -nocomplain -- [split $pwd]/[split $arg2]] {
			# set tail [file tail $entry]
			set dir [file dirname $entry]
			# The above line should obsolete this: set dir [string range $entry 0 [expr [string length $entry] - [string length $tail] - 1]]
			if {[dvs_fserve:func:dir isin $dir] == 0 || ![file isfile $entry]} then {
				continue
			}
			foreach jdir $dvs_fserve(jdirs) {
				set result [dvs_fserve:func:dir isin $dir $jdir]
				if {$result != 0 && ![dvs_fserve:func:slots get $idx janitor]} then {
					continue
				}
			}
			lappend filelist $entry
			incr count
		}
		if {!$count} then {
			return "No matches."
		}
		
		set nick [dvs_fserve:func:slots get $arg1 nick]
		set bcredits [dvs_fserve:func:slots get $arg1 bcredits]
		set fcredits [dvs_fserve:func:slots get $arg1 fcredits]
		
		set validcount 0
		set insuff 0
		set maxdl 0
		set maxtrans 0
		set maxdcc 0
		set dccerror 0
		foreach entry $filelist {
			set size [file size $entry]
			set uploads [expr [lindex [dvs_fserve:func:transfers incoming $nick] 0] + [lindex [dvs_fserve:func:transfers pendin $nick] 0]]
			set downloads [expr [lindex [dvs_fserve:func:transfers outgoing $nick] 0] + [lindex [dvs_fserve:func:transfers pendout $nick] 0]]

			if {$dvs_fserve(ratiotype) == 1 && $size > $bcredits || \
				$dvs_fserve(ratiotype) == 2 && $fcredits < 1     || \
				$dvs_fserve(ratiotype) == 3 && $size > $bcredits && $fcredits < 1
			} then {
				incr insuff
				continue
			} elseif {${max-dcc} <= [dccused]} then {
				incr maxdcc
				continue
			} elseif {$downloads + $uploads >= $dvs_fserve(maxtrans) && ![dvs_fserve:func:slots get $arg1 janitor]} then {
				incr maxtrans
				continue
			} elseif {$downloads >= $dvs_fserve(maxdloads) && ![dvs_fserve:func:slots get $arg1 janitor]} then {
				incr maxdl
				continue
			}
			switch -- [dccsend $entry $nick]\
			0 {
				incr validcount
				putdcc $arg1 "Sending file: [file tail $entry]"
				switch -- $dvs_fserve(ratiotype)\
				1 {
					incr bcredits -$size
					dvs_fserve:func:slots set $arg1 bcredits $bcredits
				} 2 {
					incr fcredits -1
					dvs_fserve:func:slots set $arg1 fcredits $fcredits
				} 3 {
					incr bcredits -$size
					incr fcredits -1
					dvs_fserve:func:slots set $arg1 bcredits $bcredits
					dvs_fserve:func:slots set $arg1 fcredits $fcredits
				}
			} 1 {
				continue
			} 2 {
				incr dccerror
				continue
			} 3 {
				continue
			} 4 {
				# Queued. That's not wanted, so the new idx has to be killed.
				foreach idx [dcclist] {
					set fnd 0
					foreach i $oidx {
						if {$i == [lindex $idx 0]} then {
							set fnd 1
							break
						}
					}
					if {!$fnd} then {
						killdcc [lindex $idx 0]
						break
					}
				}
			}
		}
		putdcc $arg1 "$validcount out of $count matches sent."
		if {$insuff} then {
			putdcc $arg1 "$insuff matches were denied due to insufficient credits."
		}
		if {$maxdcc} then {
			putdcc $arg1 "$maxdcc matches were denied because there were no dcc slots available."
		}
		if {$maxtrans} then {
			putdcc $arg1 "$maxtrans matches were denied because you had too many dcc transfers."
		}
		if {$maxdl} then {
			putdcc $arg1 "$maxdl matches were denied because you had too many downloads."
		}
		if {$dccerror} then {
			putdcc $arg1 "$dccerror matches were denied because there were problem(s) establishing dcc connection(s)."
		}
		return
	} say {
		if {[string trim $arg1] == ""} then {
			return "Usage: say <message>"
		}
		set nick [dvs_fserve:func:slots get $arg2 nick]
		dvs_fserve:func:uinfo say $arg2 "<$nick> $arg1"
		return "Said: $arg1"
	} who {
		global dvs_fserve_slots
		foreach idx [dvs_fserve:func:uinfo who] {
			append nicklist "[dvs_fserve:func:slots get $idx nick], "
		}
		set nicklist [string trimright [join [lsort $nicklist]] ", "]
		return "Users online: $nicklist"
	} cp {
		global dvs_fserve_path
		set pwd1 [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg2 0] == "/"} then {
			set pwd1 $dvs_fserve_path
		}
		set pwd2 [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg3 0] == "/"} then {
			set pwd2 $dvs_fserve_path
		}
		set scount 0
		set dcount 0
		set copycount 0
		set srclist ""
		set destlist ""
		foreach entry [glob -nocomplain -- [split $pwd1]/[split $arg2]] {
			set dir [file dirname $entry]
			if {[file isfile $entry] && [dvs_fserve:func:dir isin $dir] == 0 || [file isdirectory $entry] && [dvs_fserve:func:dir isin $entry] == 0} then {
				continue
			}
			lappend srclist $entry
			incr scount
		}
		foreach entry [glob -nocomplain -- [split $pwd2]/[split $arg3]] {
			set dir [file dirname $entry]
			if {[file isfile $entry] && [dvs_fserve:func:dir isin $dir] == 0 || [file isdirectory $entry] && [dvs_fserve:func:dir isin $entry] == 0} then {
				continue
			}
			lappend destlist $entry
			incr dcount
		}
		if {$destlist == ""} then {
			lappend destlist $pwd2/$arg3
		}

		foreach dest $destlist {
			foreach src $srclist {
				if {$src != $dest} then {
					catch {
						file copy -force -- $src $dest
					} result
					if {$result == ""} then {
						incr copycount
					}
				}
			}
		}
		return "### Copied $copycount object(s) out of $scount total matching object(s) to $dcount matching destination(s)."
	} mv {
		global dvs_fserve_path
		set pwd1 [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg2 0] == "/"} then {
			set pwd1 $dvs_fserve_path
		}
		set pwd2 [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg3 0] == "/"} then {
			set pwd2 $dvs_fserve_path
		}
		set scount 0
		set dcount 0
		set movecount 0
		set srclist ""
		set destlist ""
		foreach entry [glob -nocomplain -- [split $pwd1]/[split $arg2]] {
			set dir [file dirname $entry]
			if {[file isfile $entry] && [dvs_fserve:func:dir isin $dir] == 0 || [file isdirectory $entry] && [dvs_fserve:func:dir isin $entry] == 0} then {
				continue
			}
			lappend srclist $entry
			incr scount
		}
		foreach entry [glob -nocomplain -- [split $pwd2]/[split $arg3]] {
			set dir [file dirname $entry]
			if {[file isfile $entry] && [dvs_fserve:func:dir isin $dir] == 0 || [file isdirectory $entry] && [dvs_fserve:func:dir isin $entry] == 0} then {
				continue
			}
			lappend destlist $entry
			incr dcount
		}
		if {$destlist == ""} then {
			lappend destlist $pwd2/$arg3
		}

		foreach dest $destlist {
			foreach src $srclist {
				if {$src != $dest} then {
					catch {
						file rename -force -- $src $dest
					} result
					if {$result == ""} then {
						incr movecount
					}
				}
			}
		}
		return "### Moved $movecount object(s) out of $scount total matching object(s) to $dcount matching destination(s)."
	} rm {
		global dvs_fserve_path
		set pwd [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg2 0] == "/"} then {
			set pwd $dvs_fserve_path
		}
		set count 0
		foreach entry [glob -nocomplain -- [split $pwd]/[split $arg2]] {
			set dir [file dirname $entry]
			#set tail [file tail $entry]
			#set dir [string range $entry 0 [expr [string length $entry] - [string length $tail] - 1]]
			if {[dvs_fserve:func:dir isin $dir] == 0 || ![file isfile $entry]} then {
				continue
			}
			file delete -- $entry
			incr count
		}
		return "### Deleted $count file(s)"
	} rmdir {
		global dvs_fserve_path
		set pwd [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg2 0] == "/"} then {
			set pwd $dvs_fserve_path
		}
		set count 0
		foreach entry [glob -nocomplain -- [split $pwd]/[split $arg2]] {
			#set dir [file dirname $entry]
			#set tail [file tail $entry]
			#set dir [string range $entry 0 [expr [string length $entry] - [string length $tail] - 1]]
			if {[dvs_fserve:func:dir isin $entry] == 0 || [dvs_fserve:func:dir isin $entry] == $dvs_fserve_path || ![file isdirectory $entry]} then {
				continue
			}
			file delete -force -- $entry
			putdcc $arg1 "Deleted dir: [dvs_fserve:func:dir relative $entry]"
			incr count
		}
		return "### Deleted $count dir(s)"
	} mkdir {
		global dvs_fserve_path
		set pwd [dvs_fserve:func:slots get $arg1 pwd]
		if {[string index $arg2 0] == "/"} then {
			set pwd $dvs_fserve_path
		}
		set count 0
		set dirs [file dirname $arg2]
		set dest [file tail $arg2]
		set result [glob -nocomplain -- [split $pwd]/[split $dirs]]
		if {[llength $result] <= 1} then {
			putdcc $arg1 "### Single dir mode."
			if {$result == ""} then {
				catch {
					set exists [file exists $dvs_fserve_path/$arg2]
					file mkdir $dvs_fserve_path/$arg2
					set dest $dvs_fserve_path
				} result
			} else {
				catch {
					set exists [file exists $result/$dest]
					file mkdir $result/$dest
					set dest $result
				} result
			}
			if {[string match error* $result] || $exists} then {
				return "Destination already exists."
			} elseif {[dvs_fserve:func:dir isin $dest] == 0} then {
				file delete -force -- $dest/$arg2
				return "Invalid path."
			}
			return "### Created dir: [dvs_fserve:func:dir relative [file dirname $dest]/$arg2]"
		} else {
			putdcc $arg1 "### Multidir mode."
			foreach entry $result {
				set dir [file dirname $entry]
				if {[dvs_fserve:func:dir isin $dir] == 0 || [file exists $entry/$dest]} then {
					continue
				}
				file mkdir $entry/$dest
				putdcc $arg1 "Created [dvs_fserve:func:dir relative $entry/$dest]"
				incr count
			}
			return "### Created $count dir(s)"
		}
	} default {
		return "Invalid command."
	}
}

### FSERVE USERLIST MANAGEMENT ###
proc dvs_fserve:func:userlist {command user {element ""} {data ""}} {
	global dvs_fserve_users
	set command [string tolower $command]
	set user [string tolower $user]
	set element [string tolower $element]
	set data [string tolower $data]
	switch -- $command\
	set {
		if {$data == "" || $element == "" || [llength $data] > 3 || (![info exists dvs_fserve_users($user)] && $element != "all" && $command != "exists") || $command != "exists" && (![dvs_func:imatch or $element "all" "ts" "bcredits" "fcredits"])} then {
			return -1
		} elseif {$element == "all"} then {
			if {[llength $data] != 3 || ![dvs_func:validnum [lindex $data 0]] || ![dvs_func:validnum [lindex $data 1]] || ![dvs_func:validnum [lindex $data 2]]} then {
				return -1
			}
			set dvs_fserve_users($user) $data
			return 1
		} elseif {[llength $data] > 1} then {
			return -1
		}
		switch -- $element\
		ts {
			set index 0
		} bcredits {
			if {![dvs_func:validnum $data]} then {
				return -1
			}
			set index 1
		} fcredits {
			if {![dvs_func:validnum $data]} then {
				return -1
			}
			set index 2
		}
		set dvs_fserve_users($user) [lreplace $dvs_fserve_users($user) $index $index $data]
		return 1
	} get {
		if {![info exists dvs_fserve_users($user)]} then {
			return 0
		} elseif {![dvs_func:imatch or $element "all" "ts" "bcredits" "fcredits"]} then {
			return -1
		} elseif {$element == "all"} then {
			return $dvs_fserve_users($user)
		}
		switch -- $element\
		ts {
			set index 0
		} bcredits {
			set index 1
		} fcredits {
			set index 2
		}
		return [lindex $dvs_fserve_users($user) $index]
	} exists {
		if {![info exists dvs_fserve_users($user)]} then {
			return 0
		} else {
			return 1
		}
	} default {
		return -1
	}
}

proc dvs_fserve:func:usercleanup {} {
	global dvs_fserve dvs_fserve_users
	foreach user [array names dvs_fserve_users] {
		if {[unixtime] - [lindex $dvs_fserve_users($user) 0] >= ($dvs_fserve(expireuser) * 60) && [dvs_fserve:func:slots isonfserve $user masked] >= 1} then {
			unset dvs_fserve_users($user)
		}
	}
	if {![string match *dvs?fserve?func?usercleanup* [string tolower [utimers]]]} then {
		utimer 30 dvs_fserve:func:usercleanup
	}
}

### FSERVE SLOTS MANAGEMENT ###
proc dvs_fserve:func:slots {command idx {element ""} {data ""}} {
	global dvs_fserve_slots
	set command [string tolower $command]
	if {![dvs_func:validnum $idx] && ![dvs_func:imatch or $command "isonfserve" "addpend" "delpend" "ispend"]} then {
		return -1
	}
	switch -- $command\
	set {
		if {$data == "" || $element == "" || [llength $data] > 7 || (![info exists dvs_fserve_slots($idx)] && $element != "all" && $command != "isonfserve") || ($command != "isonfserve" && ![dvs_func:imatch or $element "all" "nick" "mask" "bcredits" "fcredits" "pwd" "idle" "janitor"])} then {
			return -1
		} elseif {$element == "all"} then {
			if {[llength $data] != 7 || ![dvs_func:validnum [lindex $data 2]] || ![dvs_func:validnum [lindex $data 3]] || ![dvs_func:validnum [lindex $data 5]] || ![dvs_func:validnum [lindex $data 6]]} then {
				return -1
			}
			set dvs_fserve_slots($idx) $data
			return 1
		}
		# Check for ([llength $data] > 1) was removed
		switch -- $element\
		nick {
			set index 0
		} host {
			set index 1
		} bcredits {
			if {![dvs_func:validnum $data]} then {
				return -1
			}
			set index 2
		} fcredits {
			set index 3
			if {![dvs_func:validnum $data]} then {
				return -1
			}
		} pwd {
			set index 4
		} idle {
			set index 5
			if {![dvs_func:validnum $data]} then {
				return -1
			}
		} janitor {
			set index 6
			if {$data != 0 && $data != 1} then {
				return -1
			}
		}
		set dvs_fserve_slots($idx) [lreplace $dvs_fserve_slots($idx) $index $index $data]
		return 1
	} get {
		if {![info exists dvs_fserve_slots($idx)]} then {
			return 0
		} elseif {![dvs_func:imatch or $element "all" "nick" "host" "bcredits" "fcredits" "pwd" "idle" "janitor"]} then {
			return -1
		} elseif {$element == "all"} then {
			return $dvs_fserve_slots($idx)
		}
		switch -- $element\
		nick {
			set index 0
		} host {
			set index 1
		} bcredits {
			set index 2
		} fcredits {
			set index 3
		} pwd {
			set index 4
		} idle {
			set index 5
		} janitor {
			set index 6
		}
		return [lindex $dvs_fserve_slots($idx) $index]
	} isonfserve {
		if {![info exists dvs_fserve_slots]} then {
			return 0
		} elseif {$element == "masked"} then {
			set idx [dvs_func:maskhost n!$idx *.*u.*h]
		}
		set idx [string tolower $idx]
		set count 0
		foreach entry [array names dvs_fserve_slots] {
			if {[string match [string tolower $idx] [string tolower [lindex $dvs_fserve_slots($entry) 1]]]} then {
				incr count
			}
		}
		return $count
	} addpend {
		if {$idx == ""} then {
			return -1
		} elseif {![info exists dvs_fserve_slots(pending)]} then {
			set dvs_fserve_slots(pending) ""
		}
		lappend dvs_fserve_slots(pending) "[unixtime] $idx"
	} delpend {
		if {$idx == ""} then {
			return -1
		} elseif {![info exists dvs_fserve_slots(pending)]} then {
			return
		}
		set success 0
		set templist ""
		foreach entry [string tolower $dvs_fserve_slots(pending)] {
			if {[string tolower [lindex $entry 1]] == [string tolower $idx] && !$success} then {
				set success 1
			} else {
				lappend templist $entry
			}
		}
		set dvs_fserve_slots(pending) $templist
		return
	} ispend {
		if {![info exists dvs_fserve_slots(pending)]} then {
			return 0
		}
		set count 0
		foreach entry [string tolower $dvs_fserve_slots(pending)] {
			if {[string tolower [lindex $entry 1]] == [string tolower $idx]} then {
				incr count
			}
		}
		return $count
	} default {
		return -1
	}
}

proc dvs_fserve:func:pendclean {} {
	global dvs_fserve_slots
	if {![info exists dvs_fserve_slots(pending)]} then {
		return
	}
	foreach entry $dvs_fserve_slots(pending) {
		if {[unixtime] - [lindex $entry 0] >= 30} then {
			dvs_fserve:func:slots delpend [lindex $entry 1]
		}
	}
	if {![string match *dvs?fserve?func?pendclean* [string tolower [utimers]]]} then {
		utimer 30 dvs_fserve:func:pendclean
	}
}

### STATS INIT ###
proc dvs_fserve:func:stats-init {} {
	global dvs_fserve dvs_fserve_stats
	if {![info exists dvs_fserve_stats]} then {
		set dvs_fserve_stats(uses) 0
		set dvs_fserve_stats(koffered) 0
		set dvs_fserve_stats(foffered) 0
		set dvs_fserve_stats(ksnagged) 0
		set dvs_fserve_stats(krecieved) 0
		set dvs_fserve_stats(reenable) 0
		set dvs_fserve_stats(wasenabled) $dvs_fserve(enable)
		set dvs_fserve_stats(lock) 0
	}
	return
}

### DCC TRANSFERS ###
bind dcc j|- transfers dvs_dcc:transfers
proc dvs_dcc:transfers {hand idx text} {
	putdcc $idx [dvs_fserve:func:transfers formatted $text]
	return 1
}

proc dvs_fserve:func:transfers {type {nick ""}} {
	switch -- $type\
	incoming {
		set sends 0
		set output ""
		foreach entry [dcclist SEND] {
			if {$nick != "" && [string tolower [lindex $entry 1]] != [string tolower $nick]} then {
				continue
			}
			set olist ""
			set file [lrange [lindex $entry 4] 2 end]
			set whom [lindex $entry 1]
			set sent [string trim [lindex [split [lindex [lindex $entry 4] 1] /] 0] ()]
			set total [lindex [split [lindex [lindex $entry 4] 1] /] 1]
			lappend olist $whom $file $sent $total
			lappend output $olist
			incr sends
		}
		set output [linsert $output 0 $sends]
		return $output
	} outgoing {
		set gets 0
		set output ""
		foreach entry [dcclist GET] {
			if {$nick != "" && [string tolower [lindex $entry 1]] != [string tolower $nick]} then {
				continue
			}
			set olist ""
			set file [lrange [lindex $entry 4] 2 end]
			set whom [lindex $entry 1]
			set sent [string trim [lindex [split [lindex [lindex $entry 4] 1] /] 0] ()]
			set total [lindex [split [lindex [lindex $entry 4] 1] /] 1]
			lappend olist $whom $file $sent $total
			lappend output $olist
			incr gets
		}
		set output [linsert $output 0 $gets]
		return $output
	} pendin {
		set sends 0
		set output ""
		foreach entry [dcclist SEND_PENDING] {
			if {$nick != "" && [string tolower [lindex $entry 1]] != [string tolower $nick]} then {
				continue
			}
			set olist ""
			set file [lrange [lindex $entry 4] 2 end]
			set whom [lindex $entry 1]
			set sent [string trim [lindex [split [lindex [lindex $entry 4] 1] /] 0] ()]
			set total [lindex [split [lindex [lindex $entry 4] 1] /] 1]
			lappend olist $whom $file $sent $total
			lappend output $olist
			incr sends
		}
		set output [linsert $output 0 $sends]
		return $output
	} pendout {
		set gets 0
		set output ""
		foreach entry [dcclist GET_PENDING] {
			if {$nick != "" && [string tolower [lindex $entry 1]] != [string tolower $nick]} then {
				continue
			}
			set olist ""
			set file [lrange [lindex $entry 4] 2 end]
			set whom [lindex $entry 1]
			set sent [string trim [lindex [split [lindex [lindex $entry 4] 1] /] 0] ()]
			set total [lindex [split [lindex [lindex $entry 4] 1] /] 1]
			lappend olist $whom $file $sent $total
			lappend output $olist
			incr gets
		}
		set output [linsert $output 0 $gets]
		return $output
	} formatted {
		set incoming [dvs_fserve:func:transfers incoming $nick]
		set outgoing [dvs_fserve:func:transfers outgoing $nick]
		set incount [lindex $incoming 0]
		set outcount [lindex $outgoing 0]
		set incoming [lreplace $incoming 0 0]
		set outgoing [lreplace $outgoing 0 0]
		set output ""
		if {!$incount && $nick == ""} then {
			append output "### No incoming transfers."
		} elseif {!$incount && $nick != ""} then {
			append output "### No incoming transfers for $nick."
		} else {
			if {$nick == ""} then {
				append output "### Incoming transfers:"
			} else {
				append output "### Incoming transfers for $nick:"
			}
			foreach entry $incoming {
				set whom [lindex $entry 0]
				set filename [file tail [lindex $entry 1]]
				set sent [format %.3f [expr double([lindex $entry 2]) / 1024]]
				set total [format %.3f [expr double([lindex $entry 3]) / 1024]]
				set percentage [expr int($sent * 100 / $total)]
				append output "\n<- $filename from $whom.\n  [dvs_func:nformat $sent]k out of [dvs_func:nformat $total]k ($percentage%)."
			}
		}
		if {!$outcount && $nick == ""} then {
			append output "\n### No outgoing transfers."
		} elseif {!$outcount && $nick != ""} then {
			append output "\n### No outgoing transfers for $nick."
		} else {
			if {$nick == ""} then {
				append output "\n### Outgoing transfers:"
			} else {
				append output "\n### Outgoing transfers for $nick:"
			}
			foreach entry $outgoing {
				set whom [lindex $entry 0]
				set filename [file tail [lindex $entry 1]]
				set sent [format %.3f [expr double([lindex $entry 2]) / 1024]]
				set total [format %.3f [expr double([lindex $entry 3]) / 1024]]
				set percentage [expr int($sent * 100 / $total)]
				append output "\n-> $filename to $whom.\n  [dvs_func:nformat $sent]k out of [dvs_func:nformat $total]k ($percentage%)."
			}
		}
		if {$incount || $outcount} then {
			append output "\n### $incount DCC get(s), $outcount DCC send(s)."
		}
		return $output
	} default {
		return -1
	}
}

### PUB FSERVE ###
proc dvs_fserve:pub:fserve {nick uhost hand chan text} {
	global dvs_fserve max-dcc
	# Took out: ![dvs_fserve:func:binds $lastbind]
	# Tracing the settings should make this redundant
	if {[matchattr $hand b] || ($dvs_fserve(validuser) && $hand == "*") || !$dvs_fserve(enable) || [dvs_fserve:func:floodctrl pub]} then {
		return 0
	}
	if {[dccused] >= ${max-dcc}} then {
		puthelp "NOTICE $nick :Sorry, maximum amount of dcc slots are in use."
		return 0
	} elseif {[dvs_fserve:func:slotcount] < 1} then {
		puthelp "NOTICE $nick :Sorry, all slots are full ($dvs_fserve(maxslots))"
		return 0
	} elseif {([dvs_fserve:func:slots isonfserve $uhost] + [dvs_fserve:func:slots ispend $uhost]) >= $dvs_fserve(maxclone)} then {
		puthelp "NOTICE $nick :Maximum amount of connections from the same user has been reached."
		return 0
	}
	dvs_fserve:fserv:init $nick $uhost
	return 1
}

### FSERVE INIT ###
proc dvs_fserve:fserv:init {nick uhost} {
	putserv "NOTICE $nick :Initiating DCC chat..."
	dvs_fserve:func:slots addpend $uhost
	set port [listen 0 script null]
	listen $port off
	listen $port script "dvs_fserve:listen:init [split $nick] [split $uhost] $port"
	utimer 30 "catch {listen $port off}"
	putserv "PRIVMSG $nick :\001DCC CHAT chat [dvs_func:myip long] $port\001"
	return 0
}

proc dvs_fserve:listen:init {nick uhost port idx} {
	global dvs_fserve dvs_fserve_path dvs_fserve_stats
	listen $port off
	dvs_fserve:func:slots delpend $uhost
	set hostmask [dvs_func:maskhost $nick!$uhost *.*u.*h]
	if {![dvs_fserve:func:userlist exists $hostmask]} then {
		dvs_fserve:func:userlist set $hostmask all "[unixtime] $dvs_fserve(startbcredits) $dvs_fserve(startfcredits)"
	}
	dvs_fserve:func:slots set $idx all "$nick $uhost [dvs_fserve:func:userlist get $hostmask bcredits] [dvs_fserve:func:userlist get $hostmask fcredits] $dvs_fserve_path [unixtime] 0"
	incr dvs_fserve_stats(uses)

	dvs_fserve:func:idleman $idx clean
	if {$dvs_fserve(maxidle) < 31} then {
		utimer $dvs_fserve(maxidle) "dvs_fserve:func:idleman $idx kill"
	} else {
		utimer [expr $dvs_fserve(maxidle) - 30] "dvs_fserve:func:idleman $idx warn"
	}

	putdcc $idx "Welcome, $nick."
	putdcc $idx "Fserve script by DVS01 v[dvs_fserve:func:version version formatted] \[[dvs_fserve:func:version ts date]\]"
	putdcc $idx "Type \"help\" for a listing of all the commands."
	dvs_fserve:func:motd $idx
	dvs_fserve:func:uinfo say $idx "*** $nick has connected to the Fserve."
	control $idx "dvs_fserve:control:fserve [split $nick] [split $uhost]"
	return 0
}

proc dvs_fserve:control:fserve {nick uhost idx text} {
	global dvs_fserve_slots dvs_fserve dvs_fserve_path dvs_fserve_stats

	dvs_fserve:func:idleman $idx clean
	if {[dvs_fserve:func:floodctrl fserve $idx] && ![dvs_fserve:func:slots get $idx janitor]} then {
		dvs_fserve:func:ukill $idx 0 0 "Flood."
		return 1
	}
	dvs_fserve:func:userlist set [dvs_func:maskhost $nick!$uhost *.*u.*h] ts [unixtime]
	dvs_fserve:func:slots set $idx idle [unixtime]
	if {$dvs_fserve(maxidle) < 31} then {
		utimer $dvs_fserve(maxidle) "dvs_fserve:func:idleman $idx kill"
	} else {
		utimer [expr $dvs_fserve(maxidle) - ([dvs_fserve:func:slots get $idx janitor] ? 0 : 30)] "dvs_fserve:func:idleman $idx warn"
	}
	
	if {$dvs_fserve_stats(lock) && $text != ""} then {
		putdcc $idx "j[u][b]IRC[b]off[u] Fserve is currently locked."
		return 0
	} elseif {$text == ""} then {
		dvs_fserve:func:ukill $idx 0 1
		return 1
	}
	set string $text
	set text [string trimleft $text]
	set command [string tolower [dvs_func:sindex $text 0]]
	set text [dvs_func:srange $text 1 end]
	if {$command == "" && $string != ""} then {
		set command .
	}
	switch -- $command\
	"" {
		# Bah. This seems like an eggdrop bug or something. At this point, all our idx's are considered invalid for some reason.
		dvs_fserve:func:ukill $idx 0 1
		return 1
	} help {
		if {[llength $text] > 1 || $text == ""} then {
			putdcc $idx [dvs_fserve:func:help all]
		} else {
			putdcc $idx [dvs_fserve:func:help $text]
		}
		return 0
	} ls {
		set pwd [dvs_fserve:func:slots get $idx pwd]
		putdcc $idx [dvs_fserve:func:fserve ls $pwd $text]
		return 0
	} dir {
		set pwd [dvs_fserve:func:slots get $idx pwd]
		putdcc $idx [dvs_fserve:func:fserve dir $pwd]
		return 0
	} find {
		if {$text == ""} then {
			putdcc $idx "Usage: find <mask>"
			return 0
		}
		set pwd [dvs_fserve:func:slots get $idx pwd]
		set result [dvs_func:ffind $pwd $text [dvs_fserve:func:slots get $idx janitor]]
		putdcc $idx "Matches for $text:"
		set count 0
		foreach element $result {
			putdcc $idx [dvs_fserve:func:dir relative $element]
			incr count
		}
		putdcc $idx "Total matches: $count (max $dvs_fserve(maxmatches))"
		return 0
	} cd {
		set pwd [dvs_fserve:func:slots get $idx pwd]
		if {[string index $text 0] == "/"} then {
			set pwd $dvs_fserve_path
		}
		set dir [dvs_fserve:func:dir isin $pwd/$text]
		foreach jdir $dvs_fserve(jdirs) {
			set result [dvs_fserve:func:dir isin $pwd/$text $jdir]
			if {$result != 0 && ![dvs_fserve:func:slots get $idx janitor]} then {
				putdcc $idx "You need to be logged on as janitor in order to access [dvs_fserve:func:dir relative $result]"
				return 0
			}
		}
		if {$dir == 0} then {
			putdcc $idx "Invalid directory."
			return 0
		}
		dvs_fserve:func:slots set $idx pwd $dir
		putdcc $idx "### Directory changed to: [dvs_fserve:func:dir relative $dir]"
		return 0
	} pwd {
		set pwd [dvs_fserve:func:dir relative [dvs_fserve:func:slots get $idx pwd]]
		putdcc $idx "### \[$pwd\]"
		return 0
	} stats {
		putdcc $idx [dvs_fserve:func:fserve stats $idx]
		return 0
	} credits {
		putdcc $idx [dvs_fserve:func:fserve credits $idx]
		return 0
	} get {
		putdcc $idx [dvs_fserve:func:fserve get $idx $text]
		return 0
	} say {
		putdcc $idx [dvs_fserve:func:fserve say $text $idx]
	} who {
		putdcc $idx [dvs_fserve:func:fserve who - $idx]
	} login {
		set user [finduser $nick![dvs_fserve:func:slots get $idx host]]
		if {$user == "*" || ![matchattr $user $dvs_fserve(janflags)]} then {
			putdcc $idx "You're not a valid user."
			return 0
		} elseif {[dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You already have Janitor priveleges."
			return 0
		} elseif {$text == ""} then {
			putdcc $idx "Usage: login <password>"
			return 0
		} elseif {![passwdok $user $text]} then {
			putdcc $idx "Incorrect password."
			return 0
		}
		dvs_fserve:func:slots set $idx janitor 1
		putdcc $idx "### You now have Janitor priveleges."
		return 0
	} cp {
		if {![dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You must be logged in as a janitor in order to use this function."
			return 0
		}
		set src [dvs_func:sindex $text 0]
		set dest [dvs_func:srange $text 1 end]
		if {$dest == ""} then {
			putdcc $idx "Usage: cp <source> <destination>"
			return 0
		}
		putdcc $idx [dvs_fserve:func:fserve cp $idx $src $dest]
		return 0
	} mv {
		if {![dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You must be logged in as a janitor in order to use this function."
			return 0
		}
		set src [dvs_func:sindex $text 0]
		set dest [dvs_func:srange $text 1 end]
		if {$dest == ""} then {
			putdcc $idx "Usage: mv <source> <destination>"
			return 0
		}
		putdcc $idx [dvs_fserve:func:fserve mv $idx $src $dest]
		return 0
	} rm {
		global dvs_fserve_path
		if {![dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You must be logged in as a janitor in order to use this function."
			return 0
		}
		if {$text == ""} then {
			putdcc $idx "Usage: rm <target>"
			return 0
		}
		putdcc $idx [dvs_fserve:func:fserve rm $idx $text]
		return 0
	} rmdir {
		global dvs_fserve_path
		if {![dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You must be logged in as a janitor in order to use this function."
			return 0
		}
		if {$text == ""} then {
			putdcc $idx "Usage: rmdir <target>"
			return 0
		}
		putdcc $idx [dvs_fserve:func:fserve rmdir $idx $text]
		return 0
	} mkdir {
		global dvs_fserve_path
		if {![dvs_fserve:func:slots get $idx janitor]} then {
			putdcc $idx "You must be logged in as a janitor in order to use this function."
			return 0
		}
		if {$text == ""} then {
			putdcc $idx "Usage: mkdir <target>"
			return 0
		}
		putdcc $idx [dvs_fserve:func:fserve mkdir $idx $text]
		return 0
	} exit {
		dvs_fserve:func:ukill $idx 0 0 "Goodbye."
		return 1
	} default {
		putdcc $idx "Invalid command."
		return 0
	}
}

### USER KILLER ###
proc dvs_fserve:func:ukill {idx kill wait {message ""}} {
	global dvs_fserve_slots
	
	set hostmask [dvs_func:maskhost n![dvs_fserve:func:slots get $idx host] *.*u.*h]
	set nick [dvs_fserve:func:slots get $idx nick]
	dvs_fserve:func:userlist set $hostmask bcredits [dvs_fserve:func:slots get $idx bcredits]
	dvs_fserve:func:userlist set $hostmask fcredits [dvs_fserve:func:slots get $idx fcredits]
	unset dvs_fserve_slots($idx)
	if {$message != ""} then {
		putdcc $idx $message
	}
	if {$kill && [valididx $idx]} then {
		killdcc $idx
	}
	dvs_fserve:func:idleman $idx clean
	if {$wait} then {
		utimer $wait "dvs_fserve:func:uinfo say 0 \"*** $nick has disconnected from the Fserve.\""
	} else {
		dvs_fserve:func:uinfo say $idx "*** $nick has disconnected from the Fserve."
	}
}

### USER HANDLING ###
proc dvs_fserve:func:uinfo {command args} {
	switch -- $command\
	who {
		global dvs_fserve_slots
		set idxlist [array names dvs_fserve_slots]
		set pend [lsearch $idxlist pending]
		return [lreplace $idxlist $pend $pend]
	} say {
		set idxlist [dvs_fserve:func:uinfo who]
		set exclude [lsearch $idxlist [lindex $args 0]]
		foreach idx [lreplace $idxlist $exclude $exclude] {
			if {[valididx $idx]} then {
				putdcc $idx [lindex $args 1]
			}
		}
	} default {
		return -1
	}
}

### PENDING TRANSFER TIMEOUT PATROL ###
proc dvs_fserve:func:pendcheck {} {
	if {![string match *dvs?fserve?func?pendcheck* [string tolower [utimers]]]} then {
		utimer 15 "dvs_fserve:func:pendcheck"
	}
	foreach idx [dcclist] {
		if {([lindex $idx 3] == "GET_PENDING" || [lindex $idx 3] == "SEND_PENDING") && [unixtime] - [lrange $idx end end] >= 30} then {
			killdcc [lindex $idx 0]
		}
	}
	return
}

### RECURSIVE FILE FINDER ###
proc dvs_func:ffind {path filename {jan 1}} {
	set var dvs_fserve_[unixtime]_[rand 1024]
	global $var ${var}_cnt
	set ${var}_cnt 0
	set $var ""
	dvs_func:ff $path $filename $var 1 $jan
	set result [subst $$var]
	unset $var
	unset ${var}_cnt
	return $result
}
	
proc dvs_func:ff {path filename var level {jan 0}} {
	global $var ${var}_cnt dvs_fserve
	
	foreach entry [glob -nocomplain -- [split $path]/*] {
		if {[file isfile $entry] && [string match [string tolower $filename] [string tolower [file tail $entry]]]} then {
			incr ${var}_cnt
			if {[subst $${var}_cnt] > $dvs_fserve(maxmatches)} then {
				return
			}
			set append 1
			foreach jdir $dvs_fserve(jdirs) {
				set dir [file dirname $entry]
				#set dir [string range $entry 0 [expr [string length $entry] - [string length [file tail $entry]] - 1]]
				if {!$jan && [dvs_fserve:func:dir isin $dir $jdir] != 0} then {
					set append 0
				}
			}
			if {$append} then {
				lappend $var $entry
			}
		} elseif {[file isdirectory $entry]} then {
			dvs_func:ff $entry $filename $var [expr $level + 1] $jan
		}
	}
}

### IDLE TIMEOUT CONTROL ###
proc dvs_fserve:func:idleman {idx {action "warn"}} {
	global dvs_fserve_slots
	
	switch $action\
	warn {
		dvs_fserve:func:idleman $idx clean
		if {[valididx $idx]} then {
			putdcc $idx "Closing idle connection in 30 seconds..."
		}
		utimer 30 "dvs_fserve:func:idleman $idx kill"
	} kill {
		dvs_fserve:func:idleman $idx clean
		if {[valididx $idx]} then {
			dvs_fserve:func:ukill $idx 1 0 "Idle timeout."
		}
	} clean {
		foreach utimer [utimers] {
			set entry [lindex $utimer 1]
			if {[lindex $entry 0] == "dvs_fserve:func:idleman" && [lindex $entry 1] == $idx} then {
				killutimer [lrange $utimer end end]
			}
		}
	} default {
		return "Invalid option. Valid options: warn, kill, clean."
	}
}

### LONGIP -> DOTTED QUAD ADDRESS CONVERTER ### - Thanks MrGrim
proc dvs_func:longip-2-quad {longip} {
	set ip1 [expr ($longip >> 24) & 255]
	set ip2 [expr ($longip >> 16) & 255]
	set ip3 [expr ($longip >> 8) & 255]
	set ip4 [expr $longip & 255]
	return ${ip1}.${ip2}.${ip3}.${ip4}
}

dvs_fserve:func:startup
set dvs_fserve_loaded 1

putlog "j[u][b]IRC[b]off[u] Fserve script by DVS01 v[dvs_fserve:func:version version formatted] \[[dvs_fserve:func:version ts date]\]"