#################################
### DALnetNews.tcl            ###
### Version 1.1               ###
### By Wcc                    ###
### wcc@techmonkeys.org       ###
### http://dawg.oc255.net:81/ ###
### EFnet #|DAWG|Tcl          ###
#################################

############################################################################
### Copyright  2000 - 2002 |DAWG| Scripting Group. All rights reserved. ###
############################################################################

##########################################################################
## This script shows the last X news entries from the DALnet news page. ##
## It is compatable with the DALnet news website as of 05/09/02. Thanks ##
## to worst (DALnet) for the idea.                                      ##
##########################################################################

##############
## COMMANDS ##
##################################################################
## DCC ## .DALnews [limit] (Can be changed.)                    ##
######### Shows the last X  news entries from the DALnet news   ##
######### page. X is defined by the default setting, below, or  ##
######### by the optional "limit" (max news entries to show)    ##
######### argument.                                             ##
##################################################################
## PUB ## !DALnews [limit] (Can be changed.)                    ##
######### Shows the last X  news entries from the DALnet news   ##
######### page. X is defined by the default setting, below, or  ##
######### by the optional "limit" (max news entries to show)    ##
######### argument.                                             ##
##################################################################

##########################################################
## Just load the script, edit the settings, and rehash. ##
##########################################################

#############################
# Set the dcc command here. #
#############################

set dalnetnews_setting(dcmd) "DALnews"

#############################
# Set the pub command here. #
#############################

set dalnetnews_setting(pcmd) "!DALnews"

##########################################################################
# Set the flag required to use the pub and dcc commands here ("-" allows #
# all users).                                                            #
##########################################################################

set dalnetnews_setting(flag) "-"

#########################################################
# Set the number of recent news entries to return here. #
#########################################################

set dalnetnews_setting(rmax) "2"

#######################################################
# Set the url to obtain data from here (NO HTTP://!). #
#######################################################

set dalnetnews_setting(url) "www.dal.net/news/index.php3"

###################################
# Enable use of bold in DCC chat? #
###################################

set dalnetnews_setting(bold) 1

##############################################
# Prefix "DALNETNEWS:" in DCC chat messages? #
##############################################

set dalnetnews_setting(DALNETNEWS:) 1

####################
# Code begins here #
####################

if {![string match 1.6.* $version]} { putlog "\002DALNETNEWS:\002 \002WARNING:\002 This script is intended to run on eggdrop 1.6.x or later." }
if {[info tclversion] < 8.2} { putlog "\002DALNETNEWS:\002 \002WARNING:\002 This script is intended to run on Tcl Version 8.2 or later." }

package require http

bind dcc $dalnetnews_setting(flag) $dalnetnews_setting(dcmd) dalnetnews_dcc
bind pub $dalnetnews_setting(flag) $dalnetnews_setting(pcmd) dalnetnews_pub

proc dalnetnews_dopre {} {
	if {!$::dalnetnews_setting(DALNETNEWS:)} { return "" }
	if {!$::dalnetnews_setting(bold)} { return "DALNETNEWS: " }
	return "\002DALNETNEWS:\002 "
}
proc dalnetnews_notnumber {string} { return [regexp {[^0-9]} $string] }
proc dalnetnews_dcc {hand idx text} {
	if {[string compare $text ""] == 0 || [dalnetnews_notnumber [set limit [join [lindex [split $text] 0]]]]} { set limit $::dalnetnews_setting(rmax) }
	dalnetnews_go 0 $idx $limit
}
proc dalnetnews_pub {nick uhost hand chan text} {
	if {[string compare $text ""] == 0 || [dalnetnews_notnumber [set limit [join [lindex [split $text] 0]]]]} { set limit $::dalnetnews_setting(rmax) }
	dalnetnews_go 1 $chan $limit
}
proc dalnetnews_go {type dest limit} {
	::http::config -useragent DALnetNews.tcl"
	if {[catch {set tok [::http::geturl $::dalnetnews_setting(url)]} error]} {
		set text "An error occured while connecting to $::dalnetnews_setting(url)."
		if {$type} { putserv "PRIVMSG $dest :$text" } { putdcc $dest "[dalnetnews_dopre]$text" }
		return
	}
	if {[::http::ncode $tok] != 200} {
		set text "An error occured while connecting to $::dalnetnews_setting(url)."
		if {$type} { putserv "PRIVMSG $dest :$text" } { putdcc $dest "[dalnetnews_dopre]$text" }
		::http::cleanup $tok ; return
	}
	set data [dalnetnews_html2text [::http::data $tok]]
	regsub -all {\n[\n ]*} [string trim [string range $data [expr [string first "News Archive" $data] + 12] [expr [string last "denotes services announcement" $data] - 1]]] "\n" data
	set count 0
	foreach {a b} [split $data \n] {
		if {$count >= $limit} { break }
		incr count
		if {$type} { putserv "PRIVMSG $dest :$a: $b" } { putdcc $dest "[dalnetnews_dopre]$a: $b" }
	}
	if {$count != 0 && [string compare $data ""] != 0} { return }
	set text "No entries returned."
	if {$type} { putserv "PRIVMSG $dest :$text" } { putdcc $dest "[dalnetnews_dopre]$text" }
 ::http::cleanup $tok
}
proc dalnetnews_html2text {text} {
	regsub -all {<.*?>}  $text {}    text
	regsub -all {&nbsp;} $text { }   text
	regsub -all {&lt;}   $text {<}   text
	regsub -all {&gt;}   $text {>}   text
	regsub -all {&quot;} $text {\\"} text
	regsub -all {&#39;}  $text {'}   text
	regsub -all {&#91;}  $text {\\[} text
	regsub -all {&#93;}  $text {\\]} text
	regsub -all {&copy;} $text {}   text
	regsub -all {&amp;}  $text {&}   text
	regsub -all {^{\n}}  $text {}    text
	return $text
}

putlog "\002DALNETNEWS:\002 DALnetNews.tcl Version 1.1 by Wcc is loaded."
