############ Vdeop script ############ 
# This script is a part of the Veed scripts
# Naveed my_naveed@hotmail.com
# ^Naveed^ @ #Des-Pardes @ Undernet
# Remember to set the bot running this script as a +f (friend) 
# and add the other bots as +f too, to avoid mass flood,and fight between them.
#
#### Description ####
#  This script works as a strictop script. 
#  Only global ops, bots and users with defined channelflags may op other users. If you arent allowed
#   the bot will deop the user being opped, and give the operator opping a message to not op others. 
#  The second time the operator ops someone both will be deoped, and if suspend time is set
#   the operators access will be suspended and he wont gain ops for a while, before bot unsuspends.
#  You may choose your custom: suspend time, warn message, suspend message, 
#   user flags allowed to op others, and enable/disable script for your channel.
#  Take some time to set the settings as you want them for your channel, by using the .Vdeop 
#   command in dcc partyline.
#
#######################################################
# Dont edit, configurations in Dcc Partyline          #
#######################################################
#Checking if the config file exists, else create one. #
#######################################################
set Vdeop_conf "$Veed_dir/Vdeop.conf" 
if {![file exists $Vdeop_conf]} {
  set Vf [open $Vdeop_conf w]
  puts $Vf ""
  close $Vf
}
#######################################################
#### Lets add or load settings for a chan we join. ####
#######################################################
#Setting the items we need in this script
	set Vdeop_items "status warn flags time susp"
bind join - * Veed:join:deop
	proc Veed:join:deop {nick uhost hand chan} {
	global Vdeop_conf Vdeop_items Veed_chans
#set the line we need to check the status
	set Vline "[ini_read $Vdeop_conf $chan Vdeop($chan,status)]"
#perform check
	if {"$Vline" == "\;"} {
# This is an new channel, add default settings
	ini_write $Vdeop_conf $chan Vdeop($chan,status) "0" 
	ini_write $Vdeop_conf $chan Vdeop($chan,warn) "You are not allowed to op other users, you are risking your access!" 
	ini_write $Vdeop_conf $chan Vdeop($chan,susp) "Your access have been suspended, remember to not op others."
	ini_write $Vdeop_conf $chan Vdeop($chan,time) "5" 
	ini_write $Vdeop_conf $chan Vdeop($chan,flags) "m" 
}
#update variables with the new settings
 Vdeop:load:rehash rehash
    	unset Vline
	return 0}

#########################################
#####        The dcc commands       #####
#########################################
#.Vdeop set #chan <Command> <Value>"
bind dcc m|n Vdeop dcc:Veed:deop
proc dcc:Veed:deop { hand idx arg } {
global Vdeop_conf Vdeop Vdeop_list Veed_chans
#setting variables
	set Veed_chans "[channels]"
	set Vdeop_list "warn flags susp"
	set Vdeopchan "[lindex $arg 1]"
	set Vitem "[string tolower [lindex $arg 2]]"    
	set Vval "[lrange $arg 3 end]"
if { [llength $arg] == 0 } {
        Veed:Vdeop:help "$idx"
        return 0
    }
# Checking if command is correct
	set cmd "[string tolower [lindex $arg 0]]"
#output settings list if command is list.
if { $cmd == "list" } {
putdcc $idx "*** \037Veed Deop settings\037 ***"
foreach chan "$Veed_chans" {
# Verify access flag ..
if {(([matchattr $hand m]) || ([matchattr $hand -|n $chan]))} { 
putdcc $idx "*** Channel: $chan ***"
putdcc $idx "Script status: $Vdeop($chan,status)"
putdcc $idx "Suspend message: $Vdeop($chan,susp)"  
putdcc $idx "Warn message: $Vdeop($chan,warn)"
putdcc $idx "User flags: $Vdeop($chan,flags)"
putdcc $idx "Suspend time: $Vdeop($chan,time)"}
putdcc $idx ""} 
return 0
 }
# the set commands
if { $cmd == "set" } {
#Check if channel is valid.
if {![validchan $Vdeopchan]} {
	putdcc $idx "'$Vdeopchan' is not a valid channel!"
	return 0
   }
# Verify access flag ..
if {!(([matchattr $hand m]) || ([matchattr $hand -|n $Vdeopchan]))} {    
	putdcc $idx "Sorry, you have insufficient access to perform that command."
        return 0
   }
### start of commands ###
# check for status key word.
if { $Vitem == "status" } {
 set Vdeop_ok "1"
#Making sure all fields are changed.
foreach item "$Vdeop_list" {
if {$Vdeop($Vdeopchan,$item) == "0"} { set Vdeop_ok 0 }
   }
if { (($Vval == "0") || ($Vval == "1")) && ($Vdeop_ok == "1")} {
	ini_write $Vdeop_conf $Vdeopchan Vdeop($Vdeopchan,$Vitem) "$Vval"
	set Vdeop($Vdeopchan,$Vitem) "$Vval"
	putdcc $idx "Info changed to: $Vval \037for\037 $Vitem"
   } else {
        putdcc $idx "Use 1 = ON or 0 = OFF Check '.Vdeop' for help"
	putdcc $idx "Also make sure all fields are filled out."}
	return 0
   }
# check for susp/warn key word. 
if { $Vitem == "susp" || $Vitem == "warn"} {
if { ($Vval != "") } {
	ini_write $Vdeop_conf $Vdeophan Vdeop($Vdeopchan,$Vitem) "$Vval"
	set Vdeop($Vdeopchan,$Vitem) "$Vval"  
	putdcc $idx "Info changed to: $Vval \037for\037 $Vitem"
   } else {
        putdcc $idx "Remember to insert your message! Check '.Vdeop' for help"}
	return 0 
   }
# check for flags key word.
if { $Vitem == "flags"} {
if { ($Vval != "0") } {
	ini_write $Vdeop_conf $Vdeopchan Vdeop($Vdeopchan,$Vitem) "$Vval"        
	set Vdeop($Vdeopchan,$Vitem) "$Vval"          
	putdcc $idx "Info changed to: $Vval \037for\037 $Vitem"
   } else {
        putdcc $idx "Set the channel flags here!  Check '.Vdeop' for help"}
	return 0 
   }
# check for time key word.   
if { $Vitem == "time"} {                    
if { ($Vval <= 60 ) } {
	ini_write $Vdeop_conf $Vdeopchan Vdeop($Vdeopchan,$Vitem) "$Vval"     
	set Vdeop($Vdeopchan,$Vitem) "$Vval"   
	putdcc $idx "Info changed to: $Vval \037for\037 $Vitem"
   } else {
        putdcc $idx "Set time in minutes between 1 and 60 min! 0 to Disable. Check '.Vdeop' for help"}     
	return 0 
   } else { 
	Veed:deop:help "$idx" 
	return 0
   } 
#set
}
#last 
}

########################
####### The code #######
########################
set Vdeop_op_list ""
#the binding #
bind mode - * Veed:Vdeop:ops
#the proc #
proc Veed:Vdeop:ops {nick uhost hand chan mode victim} {
     global Vdeop_op_list Vdeop
# Checking if script is disabled for this chan.
if {$Vdeop($chan,status) == "0"} { return 0 }
#It isnt diabled, continue... checking if bot has op and the mode is correct.
if {([botisop $chan]) && ($mode == "+o")} {
#checking if nick allready exists in the list,or if he has any flags.
if {[lsearch $Vdeop_op_list "$hand"]!=-1 && (![matchattr $hand bf|$Vdeop($chan,flags) $chan])} { 
#deop and give warning
	pushmode $chan -o $victim
	pushmode $chan -o $nick
#user has been warned, and access will be suspended.
if {($Vdeop($chan,time) > 0 && $Vdeop($chan,time) <= 60) && ([validuser $hand])} { 
 chattr $hand |-o+d $chan
puthelp "Notice $nick :$Vdeop($chan,susp)"
timer "$Vdeop($chan,time)" [split "Vdeop:remove:list $chan $hand"]
}
return 0 } elseif {(![matchattr $hand bo|$Vdeop($chan,flags) $chan])} { 
# add op to list and warn.
	lappend Vdeop_op_list "$hand" 
	pushmode $chan -o $victim
puthelp "Notice $nick :$Vdeop($chan,warn)" 
return 0 
}  
#isop bot
}
#last
}

##########################
# unsuspend users access #
##########################
proc Vdeop:remove:list {chan hand} {
global Vdeop_op_list
chattr $hand |-d+o $chan
# find user in the list and remove him.
set vnr [lsearch $Vdeop_op_list "$hand"] 
set Vdeop_list [lreplace $Vdeop_op_list $vnr $vnr] 
return 0 }

#######################################################
###########     The Veed deop help proc     #######
#######################################################
proc Veed:Vdeop:help {idx} {
putdcc $idx "*** Veed Deop commands ***" 
putdcc $idx "Usage:.Vdeop set #chan <Command> <Value> or .Vdeop list"
putdcc $idx "Command:'status':Value:<0/1>:Enable/Disable script for your channel.('0'=OFF)"
putdcc $idx "Command:'warn':Value:<msg> :Sets the warn message for ops in your channel."
putdcc $idx "Command:'susp':Value:<msg> :Sets the suspend message for your channel"
putdcc $idx "Command:'flags':Value:<see .help whois>:Sets userflags who are allowed to op other users."
putdcc $idx "Command:'time':Value:<min>:Sets the suspend time. setting to 0 will disable"
}

########################################
####### Loading all variables ##########
########################################
bind evnt - rehash Vdeop:load:rehash
bind evnt - loaded Vdeop:load:loaded

proc Vdeop:load:loaded {loaded} {
global Veed_chans Vdeop_items Vdeop_conf Vdeop
foreach Vchan "$Veed_chans" {
foreach item "$Vdeop_items" {
 set Vdeop($Vchan,$item) "[ini_read $Vdeop_conf $Vchan Vdeop($Vchan,$item)]"
} }
}
proc Vdeop:load:rehash {rehash} {
global Veed_chans Vdeop_items Vdeop_conf Vdeop
set Veed_chans "[channels]"
foreach Vchan "$Veed_chans" {
foreach item "$Vdeop_items" { 
 set Vdeop($Vchan,$item) "[ini_read $Vdeop_conf $Vchan Vdeop($Vchan,$item)]"
} }
}
lappend Veed_components "Vdeop"