#Complete Channel Administration Script (CCA Script)

#---------------------------------------------------------------------------------------
#             This script includes support for:
#---------------------------------------------------------------------------------------
#  Auto-Banning XDCC/TDCC Bots
#  Monitoring and Auto-Banning Onjoins/Onparts (including virus DCC's)
#  Monitoring for SPAM and Mass MSG'ing and Auto-Banning
#  Auto-Banning of SPAM-type recruiters
#  Auto-Kicking of people using annoying script ads in the channel
#  Auto-Kicking of people listing websites in the channel
#  Auto-Kicking of people using ! or @ triggers
#  Auto-Kicking of people using excessive !!!!!!!!!!!'s and/or ??????????'s
#  Auto-Kicking of people begging within 60 seconds of joining
#  Auto-Sending of channel rules upon CTCP request
#  Auto-Sending of customizable text upon CTCP request
#---------------------------------------------------------------------------------------
#             Basic channel OP triggers support:
#---------------------------------------------------------------------------------------
#  Perm Banning:
#	!ban <nick>
#	!perm <nick>
#	!ban <hostmask>
#	!perm <hostmask>
#---------------------------------------------------------------------------------------
#  Kick/Banning (60min ban):
#	!kb <nick> [reason]
#---------------------------------------------------------------------------------------
#  Kicking:
#	!k <nick> [reason]
#	!kick <nick> [reason]
#---------------------------------------------------------------------------------------
#  Unbanning of both channel and/or bot bans:
#	!unban <hostmask>
#---------------------------------------------------------------------------------------
#  Adding FTP's to the bot and/or giving them +v in the channel:
#	!addserv <nick>
#---------------------------------------------------------------------------------------
#  Removing FTP's from the bot (essentially the same as !deluser):
#	!delserv <nick>
#---------------------------------------------------------------------------------------
#  Adding new OPs to the bot and/or giving them +o in the channel:
#	!addop <nick>
#---------------------------------------------------------------------------------------
#  Removing users from the bot (essentially the same as !delserv):
#	!deluser <nick>
#---------------------------------------------------------------------------------------

# Created by Loki` (#FTP4Warez on EFNet)

#Version History:
#
#10/02/2001 - 1.0	Initial Release
#10/05/2001 - 1.1b	Added the following:
#				!addbot <nick>		- Adds a user with +vf flags (meant for sitebots)
#				!chattr <nick> <flags>	- Changes users flags
#				!chpass <nick>		- Resets password to nothing, and msg's the user to set a new one
#				!addhost <nick>	[host]	- Adds user's current host to the bot (must have same nick)
#10/21/2001 - 1.1	Redesigned to work completely within netset.tcl (NetBots.TCL is a must.. get it!)
#11/16/2001 - 1.12	Added the following:
#				Added a 3 strike ban warning system (allows up to 2 warnings b4 perm banning)
#				Auto-banning of IRC Flooders (allows 2 warnings b4 perm ban)
#				Refined the autoban criteria (you can edit this urself, but now the defaults are better)
#				Color (green) script logging (so you can pick it out faster)
#				2 timed channel messages (fully customizable)
#				Added support for ACTION script ad checking (/me checking)
#				


#------------------------------------------------------------------------------------------------------------
# The following conversion makes sure that all the characters in the approved channel list
# are lower case.
#------------------------------------------------------------------------------------------------------------
set approved_chans [string tolower $approved_chans]

#------------------------------------------------------------------------------------------------------------
# The following two if{} statements make sure that there is a space at the beginning and 
# end of the approved channel list.
#------------------------------------------------------------------------------------------------------------
if {[string index $approved_chans 0] != " "} {
   set approved_chans " $approved_chans"
}
if {[string index $approved_chans [expr [string length $approved_chans]-1]] != " "} {
   set approved_chans "$approved_chans "
}

#------------------------------------------------------------------------------------------------------------
# The following conversion makes sure that all the characters in the spamcheck channel list
# are lower case.
#------------------------------------------------------------------------------------------------------------
set spamcheck_chans [string tolower $spamcheck_chans]

#------------------------------------------------------------------------------------------------------------
# The following two if{} statements make sure that there is a space at the beginning and 
# end of the spamcheck channel list.
#------------------------------------------------------------------------------------------------------------
if {[string index $spamcheck_chans 0] != " "} {
   set spamcheck_chans " $spamcheck_chans"
}
if {[string index $spamcheck_chans [expr [string length $spamcheck_chans]-1]] != " "} {
   set spamcheck_chans "$spamcheck_chans "
}

#------------------------------------------------------------------------------------------------------------
# The following proc makes a proper hostmask for use with banning, etc..
#------------------------------------------------------------------------------------------------------------
proc getmask {nick chan} {
  set mask [string trimleft [maskhost [getchanhost $nick $chan]] *!]
  set mask *!*$mask
  return $mask
}

#------------------------------------------------------------------------------------------------------------
# The following proc makes a proper hostmask for use with banning, etc..
#------------------------------------------------------------------------------------------------------------
proc warnban {nick mask chan bantime warn rest} {
  global color1loki rulebreaker
	if {$warn == 0} { set rulebreaker($mask) 0 }
	if {![info exists rulebreaker($mask)]} {
		set rulebreaker($mask) $warn
	}
	if {$rulebreaker($mask) < 1} {
		puthelp "PRIVMSG $nick :$color1loki You have triggered an AutoBan: $rest \(Perm Ban\)"
		putlog "\0033 4 $nick \($mask\) has been Auto Perm Banned"
		puthelp "PRIVMSG #ftp4warezopchat :4 $nick \($mask\) has been Auto Perm Banned from $chan \(5 Reason: $rest\)"
		newchanban $chan $mask "Autoban" $rest 0
		unset rulebreaker($mask)
		putkick $chan $nick "AutoBan: $rest \(Perm Banned\)"
	} elseif {$rulebreaker($mask) == 1} {
		if {$bantime != 0} {
			puthelp "PRIVMSG $nick :$color1loki You have triggered an AutoBan: $rest \[Last Warning\] \($bantime min ban\)"
			newchanban $chan $mask "Autoban" $rest $bantime
		}
		set rulebreaker($mask) [expr $rulebreaker($mask) - 1]
		putkick $chan $nick "AutoBan: $rest !-Last Warning-! \($bantime min ban\)"
	} elseif {$rulebreaker($mask) == 2} {
		if {$bantime != 0} {
			puthelp "PRIVMSG $nick :$color1loki You have triggered an AutoBan: $rest \[Warning\] \($bantime min ban\)"
			newchanban $chan $mask "Autoban" $rest $bantime
		}
		set rulebreaker($mask) [expr $rulebreaker($mask) - 1]
		putkick $chan $nick "AutoBan: $rest !-Warning-! \($bantime min ban\)"
	} elseif {$rulebreaker($mask) == 3} {
		if {$bantime != 0} {
			puthelp "PRIVMSG $nick :$color1loki You have triggered an AutoBan: $rest \[Warning\] \($bantime min ban\)"
			newchanban $chan $mask "Autoban" $rest $bantime
		}
		set rulebreaker($mask) [expr $rulebreaker($mask) - 1]
		putkick $chan $nick "AutoBan: $rest !-Warning-! \($bantime min ban\)"
	} else {
		if {$bantime != 0} {
			puthelp "PRIVMSG $nick :$color1loki You have triggered an AutoBan: $rest \[1st Warning\] \($bantime min ban\)"
			newchanban $chan $mask "Autoban" $rest $bantime
		}
		set rulebreaker($mask) [expr $rulebreaker($mask) - 1]
		putkick $chan $nick "AutoBan: $rest !-1st Warning-! \($bantime min ban\)"
	}
return 1
}

putlog "\0033 CCA Script v1.12 (Written by Loki` #FTP4Warez) Loaded Succesfully"
