# FlagOnJoin.tcl version 3.1 by thepin in the 1998
#############################################################################
#
# DCC COMMANDS:
#
# .onjoin add <#channel> <flag> <msg>
# - to make a onjoin message for <flag> informations about flags given with
#   .onjoin flags
# - if <#channel> is * or -, then this will work on all channels which the bot
#   is on.
# - You can add in the <msg>:
#   %b - which will be replaced with: My nick, the botnick.
#   %n - Will be replaced with: The nick of the person which we msg.
#   %c - Will be replaced with: The channel which the person joined.
#   %t - Will be replaced with: Current time and date.
#
# .onjoin rem <number of msg> 
# - Remove a message. U can find the <number of msg> with
#   .onjoin messages which lists the messages.
#
# .onjoin messages 
# - gives you list of the added onjoin messages..   
#  
# .onjoin flags
# - shows list of flags which flagonjoin allows with description of every
#   flag.
#
#  New:  Added a flood protection, if you install the script as you
#  get it, then it'll only send messages with 20 seconds delay.
#  Some messages will get lost... if you dont want that, then go down
#  and set itime to 0.
#
#  If you want your bot to notice instead of msg, then go down, to the
#  msg setting, and change it to 2.
#############################################################################
# if you got some questions or ideas mail me at:
# own3r8@hotmail.com
#############################################################################

# User settings.
set itime 1                       ;# Seconds between each message.
set msg 2                         ;# 1 for msg, 2 for notice.

# Do not edit below this line plz.

# Global Settings.
set flagfile "./flagmsg.lst"      ;# The data record file.
set flagver "3.1"                 ;# Version of this script.
set flags "mntofpjVxa\-\*"        ;# Allowed flags..
set timed [expr [unixtime] + 10]  ;# Time when it'll be ok to msg the next one.

if {$msg == 1} {
  set smsg "PRIVMSG"
} else {
  set smsg "NOTICE"
}

# Checks if a buffer has only numbers in it.
proc isnumber {buf} {
  if {$buf == ""} {
    return 0
  }

  for {set i 0} {$i < [string length $buf]} {incr i} {
    set c [string index $buf $i]
    if {$c != 0 && $c != 1 && $c != 2 && $c != 3 && $c != 4 && $c != 5 && \
        $c != 6 && $c != 7 && $c != 8 && $c != 9} {
      return 0
    }
  }
  return 1
}


# Change %b in to the bot's nick, %n into nickname, %c into channel..etc..
proc fixstring {nick channel lin} {
 global botnick
  set b 0 
  set d 0
  set ret ""
  for {set i 0} {$i < [string length $lin]} {incr i} {
    set d $b
    set b 0
    if {[string index $lin $i] == "%"} {
      switch [string index $lin [expr $i + 1]] {
        "b" { append ret $botnick ; incr b ; continue }
        "n" { append ret $nick ; incr b ; continue }
        "c" { append ret $channel ; incr b ; continue }
        "t" { append ret [string trimright [string trimleft [ctime [unixtime]]]] ; incr b ; continue }
      }

      if {$b == 1 || $d == 1} {
        set i [expr $i + 3]
        continue;
      }
    }
    if {$b == 0 && $d == 0} {
      append ret [string index $lin $i]
    }
  }
  return "$ret"
}


# Main command (a dcc command).
# Allows you to add onjoin messages, remove them, see all messages
# added, list flags which a message can be added for.
bind dcc m onjoin dcc:onjoin_addmsg
proc dcc:onjoin_addmsg {handle idx arg} {
 global flagver flagfile flags

  set command [string tolower [lindex $arg 0]]
  if {$command == "" || $command == "help"} {
    putidx $idx "FlagOnJoin.tcl $flagver by thepin in the 1998"
    putidx $idx "-------------------------------------------"
    putidx $idx "USAGE: .onjoin add <#channel> <flag> <msg>"
    putidx $idx "USAGE: .onjoin rem <number of msg>"
    putidx $idx "USAGE: .onjoin messages"
    putidx $idx "USAGE: .onjoin flags"
    putidx $idx "USAGE: .onjoin help"
    putidx $idx "-------------------------------------------"
    return 0
  }

  if {$command == "add"} {
    set channel [lindex $arg 1]
    set flag [string tolower [string trimleft [lindex $arg 2] +]]
    set msg [lrange $arg 3 end]
    if {$msg == "" || [string tolower $channel] == "help" || $flag == ""} {
      putidx $idx "USAGE: .onjoin add <#channel> <flag> <msg>"
      return 0
    }
    if {![validchan $channel]} {
      putidx $idx "I'm not enforcing $channel"
      return 0
    }
    if {![string match "*$flag*" $flags] && $flag != "nonusers"} {
      putidx $idx "$flag: Unknown flag!"
      return 0
    }

    set file [open $flagfile a+]
    puts $file "$flag $channel $msg"
    close $file
    putidx $idx "Stored the msg."

    putcmdlog "#$handle# onjoin add $flag ..."
    return 0
  }

  if {$command == "rem"} {
    set numofnote [lindex $arg 1]
    if {[isnumber $numofnote] == 1} {
      set lol [expr $numofnote + 1]
    } else {
      set lol -1
    }

    if {($numofnote == "" || $numofnote == "help") || $lol <= -1} {
      putidx $idx "USAGE: .onjoin rem <num of msg>."
      return 0
    }

    putidx $idx "Removing note $numofnote from $flagfile"
    if {![file exist $flagfile]} {
      putidx $idx "$flagfile doesnt exist!"
      return 0
    }

    set damn [open $flagfile r]
    set txt [split [read $damn] \n]
    close $damn

    set open [open $flagfile w]
    set cnt 1
    foreach string [string trimleft [string trimright $txt]] {
      if {$cnt != $numofnote && [lindex $string 2] != ""} {
        puts $open "[string trimleft $string]"
      }
      incr cnt
    }
      
    close $open
    putcmdlog "#$handle# onjoin rem $numofnote"
    return 0
  }


  if {$command == "flags"} {
    putidx $idx "\n FlagOnJoin $flagver FLAGS:"
    putidx $idx ""
    putidx $idx " FLAG		DESCRIPTION"
    putidx $idx "-----------------------------------------------------------"
    putidx $idx " +n            Owner."
    putidx $idx " +m            Master."
    putidx $idx " +o            Op."
    putidx $idx " +t            Botnet master."
    putidx $idx " +f            Friend."
    putidx $idx " +j            Janitor."
    putidx $idx " +v            Voice."
    putidx $idx " +x            File system access."
    putidx $idx " +a            Auto-op."
    putidx $idx " -             For everyone."
    putidx $idx " *             For everyone."
    putidx $idx " nonusers      For people which ain't added in the bot."
    putidx $idx "-----------------------------------------------------------"
    putidx $idx " end of flags."
    return
  }

  if {$command == "messages"} {
    if {![file exist $flagfile]} {
      putidx $idx "There are no on-join messages stored, yet"
      return 0
    }
    set input [open $flagfile r]
    set damn [split [read $input] \n]
    close $input 

    set cnt 1
    foreach text [string trimleft $damn] {
      if {[lindex $text 2] != ""} {
        putidx $idx "$cnt. c: [lindex $text 1] m: [lrange $text 2 end]"
        incr cnt
      }
    }

    if {$cnt == 1} {
      putidx $idx "No are no on-join messages stored, yet"
    } else {
      putidx $idx "eof .onjoin messages"
    }

    putcmdlog "#$handle# onjoin messages"
    return 0
  }
}


# If a user joins.. check if there are any onjoin messages for him..
# if there are any, then send em to the user.
bind join - * join:check_forhim
proc join:check_forhim {nick uhost handle channel} {
 global flagfile botnick timed itime smsg


  if {[string tolower $nick] == [string tolower $botnick]} \
  { ;# Me self joining.
    return;
  }

  if {[expr [unixtime] < [expr $timed]] && $itime != 0} \
  { ;# Too short time since we messaged the last guy.
    return
  }

  set timed [expr [unixtime] + $itime]

  if {![file exist $flagfile]} {
    return 0
  }

  set open [open $flagfile r]
  set damn [split [read $open] \n]
  close $open

  # Got rid of string tolower.  Not sure why it was there. -DVS01
  # foreach tex [string tolower [string trimright $damn]] \{
  foreach tex [string trimright $damn] {
    #change %b to botnick, %n to nick, with fixstring.. 
    set msg [fixstring $nick $channel [lrange [string trimleft $tex] 2 end]]

    if {[lindex $tex 0] == "-" || [lindex $tex 0] == "*" && \
        ([string tolower $channel] == [string tolower [lindex $tex 1]] || \
         [lindex $tex 1] == "*" || [lindex $tex 1] == "-")} \
    { ;# Found a message which is for everone.
      putserv "$smsg $nick :$msg" 

    } elseif {($tex != "" && [lindex $tex 0] != "nonusers") && \
              [matchattr $handle [lindex $tex 0]] && \
              [string tolower [lindex $tex 1]] == [string tolower $channel]} \
    { ;# Found a message which is for some specified user flag.
      putserv "$smsg $nick :$msg"

    } elseif {[lindex $tex 0] == "nonusers" && ![validuser $handle]} \
    { ;# Found a message which is only for people which aint added in the bot.
      putserv "$smsg $nick :$msg"

    }
  }

  return 0
}

putlog "flag-on-join tcl by thepin version $flagver loaded."
