  bind pub o|o "!k" inchankick
  bind pub o|o "!kick" inchankick
  bind pub o|o "!kb" inchankb
  bind pub o|o "!ban" inchanban
  bind pub o|o "!perm" inchanban
  bind pub o|o "!unban" inchanunban
  bind pub o|o "!addserv" inchanaddserv
  bind pub o|o "!addbot" inchanaddbot
  bind pub o|o "!delserv" inchandelserv
  bind pub m "!deluser" inchandeluser
  bind pub m "!delbot" inchandeluser
  bind pub m "!addop" inchanaddop
  bind pub m "!chpass" inchanchpass
  bind pub m "!chattr" inchanchattr
  bind pub m "!addhost" inchanaddhost
  bind pub o "!ccashelp" inchantriggerlist
  bind pub - "!ccasfeatures" inchanfeaturelist

#------------------------------------------------------------------------------------------------------------
# The following processes the !kb trigger command
#------------------------------------------------------------------------------------------------------------
proc inchankb {nick uhost hand chan rest} {
    global noadvtriggers
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          puthelp "NOTICE $nick :I don't see $knick in this channel"
          return 0
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :$nick, It's not polite to kick ops, and *I'm* polite!"
             return 0
          }
          set mask [getmask $knick $chan]
          warnban $knick $mask $chan 60 2 $reason
          return 0
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !k and !kick trigger commands
#------------------------------------------------------------------------------------------------------------
proc inchankick {nick uhost hand chan rest} {
    global noadvtriggers
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          puthelp "NOTICE $nick :I don't see $knick in this channel"
          return 0
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :$nick, It's not polite to kick ops, and *I'm* polite!"
             return 0
          }
          set mask [getmask $knick $chan]
          warnban $knick $mask $chan 0 2 $reason
          return 0
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !ban and !perm trigger commands
#------------------------------------------------------------------------------------------------------------
proc inchanban {nick uhost hand chan rest} {
    global noadvtriggers
    set chan [string tolower $chan]
       set knick [lindex $rest 0]
       set reason [lrange $rest 1 end]
       if {[onchan $knick $chan] == 0} {
          if [string match "*!*@*" $knick] {
            if [string match "\\*!\\*@\\*" $knick] {
              puthelp "PRIVMSG $chan :You just tried to perm ban the whole channel!!"
              return 0
            }
            newchanban $chan $knick $nick "$reason \(by $nick\)..." "0"
            puthelp "NOTICE $nick :Host $knick is now perm banned"
          putlog "\0035 $nick is adding $knick to the permban list"
            return 0
          } else {
            puthelp "NOTICE $nick :I don't see $knick in this channel"
            return 0
          }
       }
       if [onchan $knick $chan] {
          if [isop $knick $chan] {
             puthelp "PRIVMSG $chan :C'mon $nick, I'm not gunna ban an op, that's just mean!"
             return 0
          }
          set mask [getmask $knick $chan]
          putlog "\0035 $nick is adding $knick to the permban list \($reason\)"
          warnban $knick $mask $chan 0 0 $reason
          return 0
       }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !unban trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanunban {nick uhost hand chan rest} {
	global noadvtriggers
	set chan [string tolower $chan]
	set knick [lindex $rest 0]
	if {![string match "*!*@*" $knick]} {
		puthelp "NOTICE $nick :Syntax: !unban <hostmask> [global]"
		return 0
	}
	if {[lindex $rest 1] == "global"} {
		foreach channel [channels] {
			if [matchban $knick $channel] {
				killchanban $channel $knick
				pushmode $channel -b $knick
				puthelp "NOTICE $nick :Host $knick is now un-banned from $channel"
				putlog "\0035 $nick is removing ban $knick from $channel"
			}
		}
		if [matchban $knick] {
			killban $knick
			foreach channel [channels] {
				pushmode $channel -b $knick
			}
		}
		puthelp "NOTICE $nick :Host $knick is now un-banned globally"
		return 0
	} else {
		if [matchban $knick $chan] {
			killchanban $chan $knick
			pushmode $chan -b $knick
			puthelp "NOTICE $nick :Host $knick is now un-banned from $chan"
			putlog "\0035 $nick is removing ban $knick from $chan"
			return 0
		}
		if [ischanban $knick $chan] {
			pushmode $chan -b $knick
			puthelp "NOTICE $nick :Host $knick is now un-banned from $chan"
		} else {
			puthelp "NOTICE $nick :I don't see $knick in the ban list"
			return 0
		}
	}
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addserv trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddserv {nick uhost hand chan rest} {
  global noadvtriggers
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if {[validuser [nick2hand $knick]] == 1 && [string match "*v*" [chattr [nick2hand $knick]]] == 1} {
          puthelp "NOTICE $nick :$knick is already +v!  Adding new host instead"
          set mask [getmask $knick $chan]
          setuser [nick2hand $knick] HOSTS $mask
          putlog "\0035 $nick is adding host $mask to $knick"
          return 0
        } elseif [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :$knick is already on the bots, setting +vP-A"
          set mask [getmask $knick $chan]
          setuser [nick2hand $knick] HOSTS $mask
          chattr [nick2hand $knick] +vP-A
          setuser [nick2hand $knick] XTRA PROBATE [unixtime]
          putlog "\0035 $nick is setting +vP-A flags to $knick"
          return 0
        } else {
          set mask [getmask $knick $chan]
          adduser $knick $mask
          chattr $knick -hopfmnx
          chattr $knick +vP
          setuser [nick2hand $knick] XTRA PROBATE [unixtime]
          puthelp "NOTICE $nick :Adding $knick to the auto +v list."
          putlog "\0035 $nick is adding $knick with +vP flags"
          return 0
        }
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addbot trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddbot {nick uhost hand chan rest} {
  global noadvtriggers
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :$knick is already on the bots, adding +vf"
          set mask [getmask $knick $chan]
          setuser [nick2hand $knick] HOSTS $mask
          chattr [nick2hand $knick] +vf $chan
          setuser [nick2hand $knick] PASS "SDgtgfdfsdde23d34d3"
          putlog "\0035 $nick is adding +vf flags to $knick"
          return 0
        } else {
          set mask [getmask $knick $chan]
          adduser $knick $mask
          chattr $knick -hopmnx
          chattr $knick +vf $chan
          setuser [nick2hand $knick] PASS "SDgtgfdfsdde23d34d3"
          puthelp "NOTICE $nick :Adding $knick to the bots with +vf."
          putlog "\0035 $nick is adding $knick with +vf flags"
          return 0
        }
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !delserv trigger command
#------------------------------------------------------------------------------------------------------------
proc inchandelserv {nick uhost hand chan rest} {
  global noadvtriggers
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
        if [validuser $knick] {
          if [matchattr $knick o] {
            puthelp "NOTICE $nick :$knick is an OP not an FTP site!  Nice try, tho."
            return 0
          } else {
            deluser $knick
            putserv "MODE $chan -ov $knick $knick"
            puthelp "NOTICE $nick :$knick has been successfully removed from the bots."
            putlog "\0035 $nick is deleting $knick from the bots"
            return 0
          }
        } else {
          puthelp "NOTICE $nick :$knick is not a valid user.."
        }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addop trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddop {nick uhost hand chan rest} {
  global noadvtriggers botnick
        if {[lsearch -exact $noadvtriggers [string tolower $chan]] >= 0} {
                puthelp "NOTICE $nick :No Advanced Triggers allow in this channel \(!addop !deluser, etc..\)"
                return 0
        }
    set chan [string tolower $chan]
    set opchan [string tolower [lindex $rest 1]]
      if {[string match "global" $opchan] || [string match "" $opchan]} {
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if [validuser [nick2hand $knick]] {
          set mask [getmask $knick $chan]
          setuser [nick2hand $knick] HOSTS $mask
          chattr [nick2hand $knick] +hopf
          puthelp "NOTICE $nick :$knick is already on the bots, added +o"
          putlog "\0035 $nick is adding global +hopf flags to $knick"
          return 0
        } else {
          set mask [getmask $knick $chan]
          adduser $knick $mask
          chattr $knick +hopf
          puthelp "NOTICE $nick :Added $knick as our newest op! Welcome $knick!"
          puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
          putlog "\0035 $nick is adding $knick as a global OP"
          return 0
        }
      }
      } elseif {[string match "channel" $opchan]} {
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if [validuser [nick2hand $knick]] {
          set mask [getmask $knick $chan]
          setuser [nick2hand $knick] HOSTS $mask
          chattr [nick2hand $knick] +hopf $chan
          puthelp "NOTICE $nick :$knick is already on the bots, added +o"
          putlog "\0035 $nick is adding channel +hopf flags to $knick"
          return 0
        } else {
          set mask [getmask $knick $chan]
          adduser $knick $mask
          chattr $knick -hpomnx
          chattr $knick +hopf $chan
          puthelp "NOTICE $nick :Added $knick as our newest channel op! Welcome $knick!"
          puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
          putlog "\0035 $nick is adding $knick as a channel OP"
          return 0
        }
      }
      } else {
        puthelp "NOTICE $nick :Syntax: !addop <nick> \[global/channel\]"
        return 0
      } 
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !deluser trigger command
#------------------------------------------------------------------------------------------------------------
proc inchandeluser {nick uhost hand chan rest} {
  global noadvtriggers
        if {[lsearch -exact $noadvtriggers [string tolower $chan]] >= 0} {
                puthelp "NOTICE $nick :No Advanced Triggers allow in this channel \(!addop !deluser, etc..\)"
                return 0
        }
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
        if [validuser $knick] {
            deluser $knick
            putserv "MODE $chan -ov $knick $knick"
            puthelp "NOTICE $nick :$knick has been successfully removed from the bots."
            putlog "\0035 $nick is deleting $knick from the bots"
            return 0
        } else {
          puthelp "NOTICE $nick :$knick is not a valid user.."
        }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !chpass trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanchpass {nick uhost hand chan rest} {
  global noadvtriggers botnick
        if {[lsearch -exact $noadvtriggers [string tolower $chan]] >= 0} {
                puthelp "NOTICE $nick :No Advanced Triggers allow in this channel \(!addop !deluser, etc..\)"
                return 0
        }
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :Resetting $knick's password"
          setuser [nick2hand $knick] PASS ""
          puthelp "NOTICE $knick :Please set a password using: /msg $botnick pass <password>"
          putlog "\0035 $nick is resetting $knick's password"
          return 0
        } else {
          puthelp "NOTICE $nick :$knick is not a valid user."
          return 0
        }
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !addhost trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanaddhost {nick uhost hand chan rest} {
  global noadvtriggers
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      set mask [lrange $rest 1 end]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if [validuser $knick] {
          if [string match "*!*@*" $mask] {
            if [string match "\\*!\\*@\\*" $mask] {
              puthelp "PRIVMSG $nick :Don't think so buddy!!"
              return 0
            }
            if {[string match "*!*@\\*" $mask] == 1 || [string match "*!\\*@*" $mask] == 1} {
              puthelp "PRIVMSG $nick :Host is too broad, please be more specific"
              return 0
            }
            setuser $knick HOSTS $mask
            puthelp "NOTICE $nick :$knick's new hostmask has been added"
            puthelp "NOTICE $knick :Your new hostmask has been added"
            putlog "\0035 $nick is adding $knick's new host"
            return 0
          }
          puthelp "NOTICE $nick :Attempting to add $knick's new hostmask"
          set mask [getmask $knick $chan]
          setuser $knick HOSTS $mask
          puthelp "NOTICE $knick :Your new hostmask has been added"
            putlog "\0035 $nick is adding $knick's new host"
          return 0
        } else {
          puthelp "NOTICE $nick :$knick is either not a valid user, or is known as something else."
          return 0
        }
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !chattr trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanchattr {nick uhost hand chan rest} {
  global noadvtriggers
        if {[lsearch -exact $noadvtriggers [string tolower $chan]] >= 0} {
                puthelp "NOTICE $nick :No Advanced Triggers allow in this channel \(!addop !deluser, etc..\)"
                return 0
        }
    set chan [string tolower $chan]
      set knick [lindex $rest 0]
      set attr [lrange $rest 1 end]
      if {![onchan $knick $chan]} {
        puthelp "NOTICE $nick :I don't see $knick in this channel"
        return 0
      } else {
        if {[string match "*n*" $attr] || [string match "*x*" $attr] || [string match "*m*" $attr]} {
                if {[matchattr $hand n] == 0} {
                        puthelp "NOTICE $nick :Only owners can set +n, +m or +x!"
                        return 0
                }
        }
        if [validuser [nick2hand $knick]] {
          puthelp "NOTICE $nick :Changing $knick's attributes to $attr"
          chattr [nick2hand $knick] $attr
          putlog "\0035 $nick is adding $attr to $knick's attributes"
          return 0
        } else {
          puthelp "NOTICE $nick :$knick is not a valid user."
          return 0
        }
      }
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !ccastriggers trigger command
#------------------------------------------------------------------------------------------------------------
proc inchantriggerlist {nick uhost hand chan rest} {
  global noadvtriggers botnick triggerhelp
        if {[lsearch -exact $noadvtriggers [string tolower $chan]] >= 0} {
                puthelp "NOTICE $nick :No Advanced Triggers allowed in this channel \(!addop !deluser, etc..\)"
                return 0
        }
        putlog "\0033 Sending $nick the trigger list"
        puthelp "PRIVMSG $nick :\002 CCAS Trigger List:"
        foreach trigger $triggerhelp {
                puthelp "PRIVMSG $nick :$trigger"
        }
        puthelp "PRIVMSG $nick :\002 Type !ccasfeatures for a complete feature list"
}

#------------------------------------------------------------------------------------------------------------
# The following processes the !ccasfeatures trigger command
#------------------------------------------------------------------------------------------------------------
proc inchanfeaturelist {nick uhost hand chan rest} {
  global botnick ccasfeatures
        putlog "\0033 Sending $nick the feature list"
        puthelp "PRIVMSG $nick :\002 CCAS Feature List:"
        foreach feature $ccasfeatures {
                puthelp "PRIVMSG $nick :$feature"
        }
}

