//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _REMIND_ALARM_H_
#define _REMIND_ALARM_H_

#include <qdatetm.h>

#include "event.h"
#include "sortlist.h"

//*****************************************************************************

class AlarmEntry {
   private:
      Event _event;
      QDateTime _alarm_time;
   public:
      AlarmEntry(QDateTime alarm_time, Event *ep);
      ~AlarmEntry();
      Event *event(void);
      QDateTime dateTime(void);
      int operator < (AlarmEntry& ae);
      int operator == (AlarmEntry& ae);
};

//*****************************************************************************

class AlarmList {
   private:
      QtedSortList<AlarmEntry> _alarm_list;
   public:
      AlarmList();
      ~AlarmList(); 
      void removeEvent(unsigned int key);
      void inSort(const AlarmEntry* ae_p);
      AlarmEntry *expired(QDateTime time_now);
};

#endif

//*****************************************************************************
