//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _Q_TED_CALENDAR_H_
#define _Q_TED_CALENDAR_H_

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>

#include "weekday_labels.h"
#include "monthday_button.h"

//*****************************************************************************

#define MAX_LINES_PER_MONTH	6
#define MIN_YEAR		1
#define MAX_YEAR		9999
#define MIN_MONTH		1
#define MAX_MONTH		12

//*****************************************************************************

class QtedCalendar : public QWidget {
   Q_OBJECT
   private:
      int _month, _year, _lines, _first_day, _max_day;
      QPushButton *_left_arrow_p, *_right_arrow_p, *_dbl_left_p, *_dbl_right_p;
      QPushButton *_close_p;
      QButtonGroup *_monthdayButtons;
      QtedMonthdayButton *_month_days[MAX_LINES_PER_MONTH * DAYS_PER_WEEK];
      QtedWeekdayLabels *_wdl_p;
      QLabel *_header_p;
      int  linesNeeded(void);
      void update(void);
   protected:
      void resizeEvent(QResizeEvent *);
   public:
      QtedCalendar(int month, int year, QWidget *parent=0, const char *name=0);
      void nextMonth(void);
      void previousMonth(void);
      void nextYear(void);
      void previousYear(void);
      int  month(void) { return (_month); }
      void month(int mo) { _month = mo; }
      int  year(void) { return (_year); }
      void year(int yr) { _year = yr; }
      QtedMonthdayButton *getMonthdayButton(int offset);
      QtedMonthdayButton *getMonthdayButtonByDay(int day);
      int dayNameOffset(int day);
      int maxDay(void);
   private slots:
      void leftClicked() { previousMonth(); } 
      void rightClicked() { nextMonth(); }
      void dblLeftClicked() { previousYear(); }
      void dblRightClicked() { nextYear(); }
      void closeButton() { emit closeClicked(); }
      void monthdayClicked(int offset) { emit dayClicked(offset); }
   signals:
      void monthChanged();
      void dayClicked(int offset);
      void closeClicked();
};

#endif

//*****************************************************************************
