//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _EVENT_H_
#define _EVENT_H_

//*****************************************************************************

#include <gdbm.h>
#include <qstring.h>
#include <qlist.h>
#include <qdatetm.h>

#include "persist.h"
#include "calendar.h"
#include "sortlist.h"

class Remind;
class MonthCache;

//*****************************************************************************

class Event : public QtedPersist {
   public:
      enum EventType{ None, Individual, Weekday, MonthDay, MonthWkday, Yearly };
   private:
      EventType _type;
//
//	The UINT* types are for compact storage to the db,
//	not that the list of events will be huge or anything.
// 	I see myself having about 100 entries in the database.
//
      UINT16 _year;		// year, example: 1997
      UINT8 _month;		// month number 1-12
      UINT8 _day;		// can be 1-31
      UINT8 _day_name_offset;	// See weekday_labels.h: weekdayNames[] 
      UINT8 _week_num;		// 1-5 as in the 4th Thursday of the month
      UINT8 _hour;		// 0-23
      UINT8 _minute;		// 0-59
      QString _comment;
      QList<int> _notify_list;	// notification times in minutes before event

      void init(void);
      int minutes(void);		// minutes since mid-night
   public:
      Event(int year, int month, int day, QString comment,
            int hour = 12, int minute = 0);
      Event(UINT8 day_name_offset, QString comment, int hour = 12, 
            int minute = 0);
      Event(int day, QString comment, int hour = 12, int minute = 0);
      Event(UINT8 day_name_offset, int week_num, QString comment, 
            int hour = 12, int minute = 0);
      Event(int month, int day, QString comment, int hour = 12, int minute = 0);
      Event(const Event& event);
      ~Event();

      void show(void);
      void clearNotifyList(void);
      void addNotifyTime(int minutes_before_event); 
      QString string(int long_version = 0);
      int hour(void);
      int hour12(void);
      int minute(void);
      int isPm(void);
      QList<int> notifyList(void);
      EventType type(void); 
      QString eventText(void);
      int matches(int year, int month, int day, UINT8 day_name_offset);
      int operator < (Event &);
      int operator == (Event &);
      QDateTime dateTime(void);
      QList<QDateTime> notifyTimes(QDate a_date); 

// These functions are required by QtedPersist
      Event(int key, QByteArray data);
      virtual const char *dbClassName(void);
      virtual int dbSave(void);
      virtual int dbRestore(QByteArray data);
// The querey functions are optional, but you need at least one!
      static Event *getByKey(int key);
      static MonthCache *getByMonth(QtedCalendar *cal_p);
      static void loadAlarms(Remind *remind_p);
};

#endif

//*****************************************************************************
