//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _EVENT_EDIT_H_
#define _EVENT_EDIT_H_

//*****************************************************************************

#include <qlined.h> 
#include <qchkbox.h>
#include <qpushbt.h>
#include <qlistbox.h>
#include <qradiobt.h> 
#include <qlabel.h>

#include "event.h"
#include "settime.h"
#include "calendar.h"
#include "remind.h"

class MonthCache;

//*****************************************************************************

class EventEdit : public QWidget {
   Q_OBJECT
   private:
      int _min_x, _min_y;
      QLabel *_text_label_p;
      QLabel *_event_time_label_p, *_event_type_label_p, *_notify_time_label_p;
      QtedSetTime *_event_time_p, *_notify_time_p;
      QButtonGroup *_event_type_bg_p, *_notify_bg_p;
      QFrame *_event_time_frame_p;
      QRadioButton *_ind_p, *_weekly_p, *_ordinal_weekday_p, *_day_of_month_p;
      QRadioButton *_yearly_p;
      QCheckBox *_notify_time_button_p, *_notify_day_button_p, 
                *_notify_week_button_p;
      QLineEdit *_line_edit_p;
      QListBox *_list_box_p;
      MonthCache *_month_cache_p;
      Remind *_remind_p;

      QPushButton *_save_button_p, *_dismiss_button_p;
      QPushButton *_deselect_button_p, *_delete_button_p;
      int _year, _month, _day, _week_num;
      int _selected_event;

// THIS MUST BE UNIT8 to match the overloaded constructor for class Event
      UINT8 _day_name_offset;

      void setupEventTimeFrame(void);
      void setupTypeButtonGroup(QtedMonthdayButton *mdb_p, int month, 
                                int offset);
      void setupNotifyButtonGroup(void);
      void resetForm(void);
      void loadForm(Event *ep);
      void reset(void);
   private slots:
      void savePressed();
      void dismissPressed();
      void deletePressed();
      void newPressed();
      void itemSelected(int);
   protected:
      void resizeEvent(QResizeEvent *);
   public:
      EventEdit(Remind *remind_p, MonthCache *month_cahce_p, 
                QtedMonthdayButton *mdb_p, int offset, 
                QWidget *parent=0, const char *name=0);
      ~EventEdit();
      void updateListBox(void);
};

#endif

//*****************************************************************************
