//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _MONTH_CACHE_H_
#define _MONTH_CACHE_H_

//*****************************************************************************

#include <qintdict.h> 

#include "event.h"

//*****************************************************************************

class MonthCache {
   private:
      int _year;
      int _month;
      int _max_day;
      int _first_day_offset;
      int _ref_count;
      QtedCalendar *_cal_p;
      QIntDict<QtedSortList<Event> > _day_list_dict;
      static QList<MonthCache>_full_list;
   public:
      MonthCache(QtedCalendar *cal_p);
      ~MonthCache();
      int year(void);
      int month(void);
      int dayNameOffset(int day);
      QtedSortList<Event> *dayList(int day);
      int addEvent(Event *ep);
      int removeEvent(Event *ep);
      int updateEvent(Event *ep);
      void updateCalendar(void);

      void incRefCount(void);
      void decRefCount(void);
      void cal(QtedCalendar *cal_p);

      static MonthCache *get(QtedCalendar *cal_p);
};

#endif

//*****************************************************************************
