//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _REMIND_H_
#define _REMIND_H_

//*****************************************************************************

#include <qpushbt.h>
#include <qtimer.h>
#include <qdatetm.h>

#include "event.h"
#include "alarm.h"
#include "calendar.h"

class MonthCache;

//*****************************************************************************

class Remind : public QWidget {
   Q_OBJECT
   private:
      QPushButton *_exit_button_p, *_main_button_p;
      QtedCalendar *_cal_p;
      QTimer *_timer_p;
      QDateTime _update, _start, _end;
      MonthCache *_month_cache_p;
      void monthUpdate(void);
      AlarmList _alarm_list;
      QApplication *_app;
   protected:
      void resizeEvent(QResizeEvent *);
   public:
      Remind(QApplication *app, QWidget *parent=0, const char *name=0);
      ~Remind();
      int addToAlarmList(Event *ep, int use_current_time = 0);
      void removeEvent(unsigned int key);
   private slots:
      void mainClicked();
      void heartBeat();
      void dayClicked(int offset);
      void monthChanged();
      void calClose();
      void notify(Event *ep);
};

#endif

//*****************************************************************************
