//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#include <settime.h>

//*****************************************************************************

QtedSetTime::
QtedSetTime(int hour, int minute, int pm, int flags, 
            QWidget *parent, const char *name) : QWidget(parent, name),
            _flags(flags) {
   QRadioButton *rb;

   if (flags == TimeOfDay)
      _hour_p = new QtedSetInt(1, 12, hour, QtedSetInt::RightJustified, this);
   else
      _hour_p = new QtedSetInt(0, 23, hour, QtedSetInt::RightJustified, this);

   _minute_p = new QtedSetInt(0, 59, minute, QtedSetInt::ZeroFilled, this);

   _colon_p = new QLabel(":", this);
   _colon_p->setAlignment(AlignCenter);


   if (flags == TimeOfDay) {
      _am_pm_bg_p = new QButtonGroup(this);

      _am_p = new QRadioButton("AM", _am_pm_bg_p);   
      _am_p->setChecked(!pm); 

      _pm_p = new QRadioButton("PM", _am_pm_bg_p);   
      _pm_p->setChecked(pm); 
   }

   setSize();
}

//*****************************************************************************

void QtedSetTime::
setSize(void) {
   int x = 0;
   int colon_w, colon_h;
   int space = 5;

   colon_h = fontMetrics().lineSpacing () + 2 * _colon_p->frameWidth();
   colon_w = fontMetrics().width(':');

   _hour_p->setGeometry(x, 0, _hour_p->width(), _hour_p->height());
   x += _hour_p->width();
   _colon_p->setGeometry(x, 0, colon_w, colon_h);
   x += _colon_p->width();
   _minute_p->setGeometry(x, 0, _minute_p->width(), _minute_p->height());
   x += _minute_p->width();

   if (_flags == TimeOfDay) {
      x += space;
      QSize size = _am_p->sizeHint();
      _am_pm_bg_p->setGeometry(x, 0, size.width(), _minute_p->height());
      int half = _minute_p->height() / 2;
      _am_p->setGeometry(0, 0, size.width(), half);
      _pm_p->setGeometry(0, half, size.width(), half);
      x += size.width() + space;
   }

   setFixedSize(x, _minute_p->height());
}

//*****************************************************************************

void QtedSetTime::
setTime(int hour, int minute, int pm) {
   _hour_p->value(hour);
   _minute_p->value(minute);
   
   if (_flags == TimeOfDay) {
      _am_p->setChecked(!pm);
      _pm_p->setChecked(pm);
   }
}

//*****************************************************************************

int QtedSetTime::
getHour24(void) { 
   int hour = getHour();

   if (hour == 12)
      hour = 0;

   if (getPm())
      hour += 12;

   return (hour); 
}

//*****************************************************************************

int QtedSetTime::
getPm(void) { 
   int result = 0;

   if (_flags == TimeOfDay && _pm_p->isChecked())
      result = 1;

   return (result); 
}

//*****************************************************************************
