//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************

#ifndef _Q_TED_SET_TIME_H_
#define _Q_TED_SET_TIME_H_

//*****************************************************************************

#include <stream.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qradiobt.h> 

#include "setint.h"

//*****************************************************************************

class QtedSetTime : public QWidget {
   private:
      QtedSetInt *_hour_p;
      QtedSetInt *_minute_p;
      QLabel *_colon_p;
      QRadioButton *_am_p, *_pm_p;
      QButtonGroup *_am_pm_bg_p;
      int _pm, _flags;
      void setSize(void);
   public:
      enum { TimeOfDay, Interval };
      QtedSetTime(int hour, int minute, int pm, int flags, QWidget *parent=0, 
                  const char *name=0);
      void setTime(int hour, int minute, int pm = 0);
      int getHour(void) { return (_hour_p->value()); }
      int getHour24(void);
      int getMinute(void) { return (_minute_p->value()); }
      int getPm(void);
};

#endif

//*****************************************************************************
