//*****************************************************************************
//
// qtremind - an X windows appoint reminder program.
// Copyright (C) 1997  Tom Daley
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// The license is in the file COPYING.
//
// Tom Daley
// 1309 W. Lorraine Ave.
// Woodland Park, CO  80863-2329
//
// tdaley@vsys.com
//
//*****************************************************************************
//
//	If you define "operator <" and "operator ==" for a class, you can
//	use this list with inSort() to have an acending sorted list.
//
//*****************************************************************************

#ifndef _QTED_SORT_LIST_H_
#define _QTED_SORT_LIST_H_

//*****************************************************************************

#include <qlist.h>

//*****************************************************************************

template <class T>
class QtedSortList : public QList<T> {
   public:
      int compareItems(GCI item1, GCI item2);
};

//*****************************************************************************

template <class T>
int QtedSortList<T>::
compareItems(GCI item1, GCI item2) {
   int result = 1;
   if (*(T*)item1 < *(T*)item2)
      result = -1;
   else if (*(T*)item1 == *(T*)item2)
      result = 0;
   return (result);
}

#endif

//*****************************************************************************
