/*
 * $Header: /cvsroot/overdose/overdose/cmd.c,v 1.16 2006/04/19 03:25:41 segin Exp $
 */

#include <string.h>
#include "ycht.h"
#include "main.h"
#include "cmd.h"
#include "gui.h"
#include <curses.h>

/* Although maties forgot to include string.h, and on most platforms it isn't
 * needed, there are a few awkward compilers that will choke without it.
 *
 * Remember, not eveyone is smart enough to realize that gcc and compatables 
 * are better than any commercial compiler bundled with a commercial UNIX
 * which was made by the same company as said UNIX. 
 *
 * The HP-UX compiler or the ACK suite with Minix are excellent examples.
 * Don't know about Compaq's (HP's) C compiler for Alpha, think that's for
 * making Linux binaries.
 * 
 * Minix isn't commercial, I know, but the ACK <==> Minix example still holds.
 * 
 * Some testing needs to be done with exotic platforms to work out all the 
 * kinks.
 * 			-- Segin
 */

int s;

void command(char *cmd, char *arg)
{
  if(strcasecmp(cmd, "connect") == 0) {
    if (arg) { 
      if (arg[0] == '\0') { 
        conn(""); 
      } else { 
        conn(arg); 
      } 
    } else { 
      conn(""); 
    }
  }
  if(strcasecmp(cmd, "login") == 0) {
    if (arg) { 
      if (arg[0] == '\0') { 
        login(""); 
      } else { 
        login(arg); 
      } 
    } else { 
      login(""); 
    }
  }
  if(strcasecmp(cmd, "logout") == 0)
    ycmd(s, 0x71, "logout", 6);
  if(strcasecmp(cmd, "disconnect") == 0)
    disconnect();
  if(strcasecmp(cmd, "join") == 0) {
    if (arg) { 
      if (arg[0] == '\0') { 
        join(""); 
      } else { 
        join(arg); 
      } 
    } else { 
      join(""); 
    }
  }
  if(strcasecmp(cmd, "me") == 0)
    yemote(s, arg);
  if(strcasecmp(cmd, "follow") == 0)
    yfollow(s, arg);
  if(strcasecmp(cmd, "ping") == 0)
    yping(s);
  if(strcasecmp(cmd, "exec") == 0)
    pexec(arg); 
  if(strcasecmp(cmd, "i") == 0 || strcasecmp(cmd, "ignore") == 0) {
    if (arg) { 
      if (arg[0] == '\0') { 
        ignoreuser(""); 
      } else { 
        ignoreuser(arg); 
      } 
    } else { 
      ignoreuser(""); 
    }
  }
  if(strcasecmp(cmd, "timestamp") == 0 || strcasecmp(cmd, "ts") == 0)
    togglets();
  if(strcasecmp(cmd, "quit") == 0 || strcasecmp(cmd,"q") == 0)
    quit();
  if(strcasecmp(cmd, "target") == 0)
	  if (joindroom == 1) {
#ifdef __WIN32__
	ysay(s, "Overdose was built for target \"Windows-32\"");
#else
	ysay(s, "Overdose was built for target \"Unix\"");
#endif		  
	  } else { 
#ifdef __WIN32__
	guiprintf("This version of Overdose was built for Windows.\n");
#else
	guiprintf("This version of Overdose was built for Unix.\n");
#endif
	  }
	if(strcasecmp(cmd, "ver") == 0 || strcasecmp(cmd,"version") == 0) { 
		if (joindroom == 1) {
			ysay(s, "I am using Overdose version "VERSION", built"
			"on a "
			ARCH" box running "OS" "OS_VERSION".");
		} else {
			guiprintf("Overdose version ");
			wattron(outputwin, COLOR_PAIR(COLOR_BLUE));
			guiprintf(VERSION);
			wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
			guiprintf(".\nBuild system is ");
			wattron(outputwin, COLOR_PAIR(COLOR_GREEN));
			guiprintf(ARCH);
			wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
			guiprintf(" running ");
			wattron(outputwin, COLOR_PAIR(COLOR_RED));
			guiprintf(OS);
			wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
			guiprintf(" ");
			wattron(outputwin, COLOR_PAIR(COLOR_CYAN));
			guiprintf(OS_VERSION);
			wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
			guiprintf(".\n");
		}
	}
}

