/* 
 * $Header: /cvsroot/overdose/overdose/gui.c,v 1.12 2006/09/23 19:18:13 segin Exp $
 */

#include "main.h"
#include "gui.h"
#include <curses.h>
#include <stdarg.h>
#ifndef __WIN32__
#include <sys/ioctl.h>
#include <sys/signal.h>
#endif
#include <unistd.h>
#include <stdlib.h>
#include "snprintf.h"


/* My system is missing glib headers, and besides, this is slightly faster on
 * the compile. 
 */

/* gint g_vasprintf (gchar **string, gchar const *format, va_list args); */

WINDOW *inputwin, *outputwin, *statuswin;

/* There are a few platforms (NetBSD 2.0.2 is known for sure) that use the 
 * classic BSD curses library. This library, however, is unable to handle
 * the resizing of an xterm (e.g. no resize_term function). These systems
 * can still be used, but you can't resize your term without causing a 
 * segmentation fault, or installing ncurses (which most platforms have)
 *
 * I will add some preprocessor directives to cure this for now, but it 
 * *WILL* break on NetBSD if you use a xterm and then resize it while 
 * using Overdose. Hope you like your nice little core dump. Update!
 * NetBSD may/may not crash. A proper handler for SIGWINCH was put in.
 * 
 * Our current reference platform is Gentoo Linux. It works on Mac OS X.
 * It works on all of the BSDs with or without modification.
 * 			-- Segin
 *
 * Corrections to above: BSD curses has resizeterm(), but not resize_term()...
 * What the fuck?
 * 			-- Segin
 * 
 */
 
/* It should be noted that the following code is just bloat on Win32*/

#if !defined(__WIN32__) && !defined(NORESIZE)
void *resize(int a);
#ifndef BROKEN_SIGNAL_H
sighandler = &resize;
#endif

#if defined (SIGWINCH)
void *resize(int a)
{
  struct winsize size;
  ioctl(STDOUT_FILENO, TIOCGWINSZ, &size);
  resizeterm(size.ws_row, size.ws_col);
  int maxy, maxx;
  getmaxyx(stdscr, maxy, maxx);
  wresize(inputwin, 1, maxx);
  wresize(outputwin, maxy - 1, maxx);
  wresize(statuswin, 1, maxx);
  mvwin(inputwin, maxy - 1, 0);
  mvwin(inputwin, maxy - 2, 0);
  wclear(outputwin);
  wrefresh(outputwin);
  wrefresh(inputwin);
  wrefresh(statuswin);
  /* This is not valid ANSI C. Here's the error:
   * gui.c:46: cannot cast 'void()' to 'void *(int)' 
   */
  signal(SIGWINCH, sighandler);
  return(0);
}
#else
/* This definition was taken from 'kill -l SIGWINCH' under Linux.
 * Not too sure how accurate that is, concidering that Linux hasn't
 * been tested for POSIX conformance
 */
#define SIGWINCH 28 
void *resize(int a)
{
	signal(SIGWINCH, resize);
	return(0);
}
#endif
#endif

void startgui()
{
  initscr();
  if(has_colors())
    {
      start_color();
#ifdef assume_default_colors
      assume_default_colors(COLOR_WHITE, COLOR_BLACK);
#endif
      init_pair(COLOR_BLACK, COLOR_BLACK, COLOR_BLACK);
      init_pair(COLOR_GREEN, COLOR_GREEN, COLOR_BLACK);
      init_pair(COLOR_RED, COLOR_RED, COLOR_BLACK);
      init_pair(COLOR_CYAN, COLOR_CYAN, COLOR_BLACK);
      init_pair(COLOR_WHITE, COLOR_WHITE, COLOR_BLACK);
      init_pair(COLOR_MAGENTA, COLOR_MAGENTA, COLOR_BLACK);
      init_pair(COLOR_BLUE, COLOR_BLUE, COLOR_BLACK);
      init_pair(COLOR_YELLOW, COLOR_YELLOW, COLOR_BLACK);
    }
  cbreak();
  noecho();
  keypad(stdscr, TRUE);
  int maxy, maxx;
  getmaxyx(stdscr, maxy, maxx);
  outputwin = newwin(maxy - 1, 0, 0, 0);
  inputwin = newwin(1, 0, maxy - 1, 0);
  statuswin = newwin(1, 0, maxy - 2, 0);
  scrollok(outputwin, 1);
  scrollok(inputwin, 1);
  scrollok(statuswin, 0);
  wattron(statuswin,A_REVERSE);
#if defined(SIGWINCH) && !defined(NORESIZE)
  signal(SIGWINCH, sighandler);
#endif
}

void
wordwrap(char *s)
{
	int mcol, row, col;
	getyx(outputwin, row, col);
	char *ptr = strchr(s,'\0');
	while(ptr>s)
	{
		--ptr;
		if((*ptr == '\n')|| (*ptr == ' '))
			*ptr = '\0';
		else break;
	}
	char *buf;
	if(!(buf = (char *)calloc(2048, sizeof(char))))
		/* err(1,NULL); */
		guiprintf("");
	mcol = COLS-1;
	int cols = mcol - col;
	ptr = s;
	while(strlen(ptr) > cols)
	{
		if(strchr(ptr,'\n')) break;
		char *spc = ptr+cols;
		while(spc > ptr)
		{
			if(*spc == ' ')
				break;
			else
				--spc; /* back up a byte till we find space */
		}
		if(spc > ptr) 
		{
			int n = spc - ptr;
			strncat(buf,ptr,n);
			strcatl(buf,"\n",2048);
			ptr = spc+1; /* skip it */
			while(*ptr && (*ptr == ' ')) ++ptr;
			cols = mcol;
		}
		else
		{
			strncat(buf,ptr,cols);
			strcatl(buf,"\n",2048);
			ptr = ptr+(cols);
			while(*ptr && (*ptr == ' ')) ++ptr;
			cols = mcol;
		}
	}
	if(ptr == s) /* maybe we didnt need to wordwrap */
	{
		wprintw(outputwin,"%s",s);
	}
	else if(*ptr != '\0') /* the left overs from the previous while loop */
	{
		strcatl(buf,ptr,2048);
		wprintw(outputwin,"%s",buf);
	}
	free(buf);
}

void endgui()
{
  delwin(outputwin);
  delwin(inputwin);
  endwin();
}

/* The most one will ever need to printf at once will be 4096 bytes + \0 
 * This is because Yahoo! doesn't allow for datagrams larger than 4K.
 */

void guiprintf(char *fmt, ...)
{
  int maxx, maxy;
  char *text = malloc(4097);
  va_list ap;
  getmaxyx(stdscr, maxy, maxx);
  va_start(ap, fmt);
  vasprintf(&text, fmt, ap);
  va_end(ap);
  wprintw(outputwin, text);
  free(text);
  wrefresh(outputwin);
  wrefresh(inputwin);
}

/* Function for reading in the keyboard. I have a feeling that it is completely
 * broken. damn Maties.
 */
int guigetln(char **text, int echo)
{
  int c, len = 0;
  *text = (char *) malloc(1 * sizeof(char));
  while(c = wgetch(inputwin))
    {
      if(c == '\n')
        {
          (*text)[len] = 0;
          if(echo != 0)
            wclear(inputwin);
          return len;
        }
      else if(c == KEY_LEFT)
        {
          int y, x;
          getyx(inputwin, y, x);
          mvwdelch(inputwin, y, x - 1);
        }
      else if(c == KEY_BACKSPACE || c == erasechar() || c == 8)
        {
          if(len == 0)
            continue;
          len--;
	  (*text)[len] = 0;
          *text = (char *) realloc((char *) *text, (len + 1) * sizeof(char));
          if(echo != 0)
            {
              int y, x;
              getyx(inputwin, y, x);
              mvwdelch(inputwin, y, x - 1);
            }
        }
      else if(c == 9)
        {
          int i, ii;
          for(i = 0; i < strarrlen(users); i++)
            if(strncmp(*text, users[i], len) == 0)
              {
                wclear(inputwin);
                waddstr(inputwin, users[i]);
                waddstr(inputwin, "> ");
                wrefresh(inputwin);
                len = strlen(users[i]) + 2;
                *text = (char *) realloc((char *) *text, (len + 3) * sizeof(char));
                strncpy(*text, users[i], strlen(users[i]) + 1);
                strncat(*text, "> ", 2);
                break;
              }
        }
      else if(c == 15)
      {
	      wrefresh(outputwin);
	      wrefresh(inputwin);
	      wrefresh(statuswin);
      }
      else if(c >= 32)
        {
          if(echo != 0)
            waddch(inputwin, c);
          (*text)[len] = c;
          len++;
	  *text = (char *) realloc((char *) *text, (len + 1) * sizeof(char));
        }
    }
}

