/* 
 * $Header: /cvsroot/overdose/overdose/main.c,v 1.41 2006/09/30 00:19:38 segin Exp $
 */
#include "main.h"
#include "gui.h"
#include "tcp.h"
#include "ycht.h"
#include "strutil.h"
#include "cmd.h"
// #if !defined(__WIN32__)
#include <sys/utsname.h>
// #endif
#include <stdio.h>
#include <pthread.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

char *defserver = 0, *defroom = 0, *defuser = 0, *username, **users, *groom;
char **ignore;
pthread_t thrdid;
int s, connected = 0, logdin = 0, joindrom = 0, session = 0, status = 0;

void wrongopt(char *opt);
void showversion(void);
void showhelp(int exitstatus);
void noarg(char *opt);

/* Alex Mercader helped me here; i was doing a very stupid (opt=="string")
 * string comparasion. Damn I was stupid!
 *
 * It was Vincent Damewood who suggested that I use strcmp.
 */
void debug_message(char *msg)
{
   wattron(outputwin, COLOR_PAIR(COLOR_GREEN));
   guiprintf("DEBUG: %s\n",msg);
   wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
}

void parselongopt(char *opt)
{
	char *tmp;
	if (opt[0]=='-'&&opt[1]=='-') {
		opt++;
		opt++;
			if (strcmp(opt,"help") == 0) {
				showhelp(0);
			}
			if (strcmp(opt,"version") == 0) {
				showversion();
				exit(0);
			} else {
				opt--;
				opt--;
				wrongopt(opt);
			}
	} else {
		opt--;
		opt--;
		wrongopt(opt);
	}
}

void wrongopt(char *arg)
{
	printf("Unknown option: %s\n",arg);
	showhelp(1);
}

void noarg(char *arg)
{
	printf("Option requires an argument: %s\n",arg);
	showhelp(1);
}

void showversion(void)
{
#if !defined(__WIN32__)
	struct utsname uts;
#endif
	printf("Overdose version "VERSION"\n");
	printf("Copyright (C) 2006 Segin\n");
	printf("Built on a "ARCH" box running "OS" "OS_VERSION".\n");
#ifdef __WIN32__
	printf("Current running system is %s %s %s.\n",NULL,NULL,NULL);
#else
	uname(&uts);
	printf("Current running system is %s %s %s.\n",uts.sysname,
		uts.release,uts.machine);
#endif
}

void showhelp(int exitstatus)
{
	showversion();
	puts("POSIX (short) options:\n"
	     "\n"
	     "	-r <room>	Automatically join specified room after login.\n"
	     "	-s <server>	Automatically connect to the specified server.\n"
	     "	-u <user>	Login as the specified user.\n"
	     "\n"
	     "GNU long options:\n"
	     "\n"
	     "	--help		Shows this help screen.\n"
	     "	--version	Shows the version and quits.\n");
	exit(exitstatus);
}

void parseargs(int argc, char **argv)
{
	int x,y=0;
	if (argc==0) return;
	for(x=0;x<argc;x++) {
		if (argv[x+y][0]=='-') {
			if (strcmp(argv[x+y],"-u")==0) {
				if (argv[x+y+1]!=NULL) {
					defuser = strdup(argv[x+y+1]);
					y++;
				} else {
					noarg(argv[x+y]);
				}
			}
			if (strcmp(argv[x+y],"-s")==0) {
				if (argv[x+y+1]!=NULL) {
					defserver = strdup(argv[x+y+1]);
					y++;
				} else {
					noarg(argv[x+y]);
				}
			}
			if (strcmp(argv[x+y],"-r")==0) {
				if (argv[x+y+1]!=NULL) {
					defroom = strdup(argv[x+y+1]);
					y++;
				} else {
					noarg(argv[x+y]);
				}
			}
			if (argv[x+y][1]=='-') {
				if (argv[x+y][2]!='\0') {
					parselongopt(argv[x+y]);
				}
			} else {
				wrongopt(argv[x+y]);
				showhelp(1);
			}
		} else {
			wrongopt(argv[x+y]);
			showhelp(1);
		}
	};
}

void printusers()
{
  int l = strarrlen(users);
  char *str, *txt = malloc(2048 * sizeof(char));
  memset(txt, 0, 2047);
  if(l == 0)
    {
      guiprintf("no users in room\n");
      return;
    }
  wattron(outputwin, COLOR_PAIR(COLOR_CYAN));
  strcat(txt, ">> ");
  int i;
  for(i = 0; i < l - 1; i++) {
	oasprintf(&str, "%s, ", users[i]);
	strcat(txt, str);
	free(str);
  }
  oasprintf(&str,"%s\n", users[l - 1]);
  strcat(txt, str);
  free(str);
  wordwrap(txt);
  guiprintf("\n");
  wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
  updateroom();
}

void atlogout()
{
  logdin = 0;
  free(users);
  users = (char **) malloc(1 * sizeof(char *));
  users[0] = 0;
  guiprintf("logged out\n");
  joindroom = 0;
}

void atdisconnect()
{
	if(logdin == 1) {
		atlogout();
	} else { 
		joindroom = 0;
	}
	connected = 0;
	guiprintf("disconnected\n");
}

char *removepart(char *start, char *end, char *str)
{
  char *str2 = (char *) malloc(1 * sizeof(char));
  int i, ii, o, startlen = strlen(start), endlen = strlen(end);
  for(i = 0, ii = 0; str[i] != 0; i++, ii++)
    {
      if(strncmp(str + i, start, strlen(start)) == 0)
        {
          int a;
          for(a = i; str[a] != 0; a++)
            if(strncmp(str + startlen + a, end, endlen) == 0)
              {
                i = startlen + a + endlen - 1;
                ii--;
                goto endloop;
              }
        }
      str2[ii] = str[i];
      str2 = (char *) realloc((char *) str2, (ii + 2) * sizeof(char));
      endloop:;
    }
  str2[ii] = 0;
  return str2;
}

char *removestr(char *rem, char *str)
{
  char *str2 = (char *) malloc(1 * sizeof(char));
  int i, ii, len = strlen(rem);
  for(i = 0, ii = 0; str[i] != 0; i++, ii++)
    {
      if(strncmp(str + i, rem, len) == 0)
        {
          i = i + len - 1;
          ii--;
          goto endloop;
        }
      str2[ii] = str[i];
      str2 = (char *) realloc((char *) str2, (ii + 2) * sizeof(char));
      endloop:;
    }
  str2[ii] = 0;
  return str2;
}

char *removeformatting(char *str)
{
  char *str2 = removepart("<font", ">", str);
  char *str3 = removepart("<FONT", ">", str2);
  free(str2);
  str2 = removepart("<fade", ">", str3);
  free(str3);
  str3 = removepart("<FADE", ">", str2);
  free(str2);
  str2 = removestr("</font>", str3);
  free(str3);
  str3 = removestr("</FONT>", str2);
  free(str2);
  str2 = removestr("</fade>", str3);
  free(str3);
  str3 = removestr("</FADE>", str2);
  free(str2);
  str2 = removepart("", "m", str3);
  free(str3);
  str3 = removestr("<red>", str2);
  free(str2);
  str2 = removestr("<green>", str3);
  free(str3);
  str3 = removestr("<b>", str2);
  free(str2);
  str2 = removestr("</b>", str3);
  free(str3);
  str3 = removestr("<i>", str2);
  free(str2);
  str2 = removestr("</i>", str3);
  free(str3);
  str3 = removestr("<u>", str2);
  free(str2);
  str2 = removestr("</u>", str3);
  free(str3);	  
  return str2;
}

void updateroom()
{
	char *str = malloc(4096);
	char *str2 = malloc(4096);; 
	int maxy, maxx, a, b, c;
	getmaxyx(stdscr, maxy, maxx);
	wclear(statuswin);
	snprintf(str,4096," %s -- %s",groom, username);
	a = strlen(str);
	b = maxx - a;
	bzero(str2,4096);
	memset(str2,32,b);
	strcat(str,str2);
	waddstr(statuswin, str);
	free(str);
	free(str2);
	wrefresh(statuswin);
	wrefresh(inputwin);
}

void yrecvd(int service, char *content, int len)
{
  char **data;
  split("\300\200", content, &data);
  switch(service)
    {
      case 0x30:
        guiprintf("logged in\n");
        logdin = 1;
        break;
      case 0x02:
        if(logdin == 1)
          disconnect();
	return;
	break;
      case 0x11:
        if(strcmp(data[0], "*** Danger Will Robinson!!!") == 0)
          guiprintf("no such room\n");
        else if(strcmp(data[0], "That room is full.  Try a similar room?") == 0)
          guiprintf("room is full\n");
        else
          {
            char **data2;
            int c = split("\001\002", data[8], &data2) / 6;
            int userc = strarrlen(users);
            int i, i2;
            for(i = 0, i2 = 0; i < c; i++, i2++)
              {
                int ii;
                for(ii = 0; ii < userc; ii++)
                  if(strcmp(users[ii], data2[i * 6]) == 0)
                    {
                      i2--;
                      goto endadd;
                    }
                users = (char **) realloc((char **) users, (userc + i2 + 2) * sizeof(char *));
                users[userc + i2] = (char *) malloc((strlen(data2[i * 6]) + 1) * sizeof(char));
                strncpy(users[userc + i2], data2[i * 6], strlen(data2[i * 6]) + 1);
                users[userc + i2 + 1] = 0;
                endadd:;
              }
            if(c > 1)
              printusers();
            else
              {
		timestamp();
                wattron(outputwin, COLOR_PAIR(COLOR_CYAN));
                guiprintf(">> %s\n", data2[0]);
                wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
		updateroom();
              }
            free(data2);
          }
        break;
      case 0x12:
	timestamp();
        if(logdin == 1 && strcmp(data[2], username) == 0)
          {
            disconnect();
            return;
	    break;
          }
        wattron(outputwin, COLOR_PAIR(COLOR_GREEN));
        guiprintf("<< %s\n", data[2]);
        wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
        strarrdel(&users, data[2]);
        updateroom();
	break;
      case 0x41:
	/* if (strcmp("gamesmaster0009", data[2]) == 0) break; */
	if (isUser(ignore,data[2]) == 1) break;
	timestamp();
        if(strcmp(username, data[2]) == 0)
          {wattron(outputwin, COLOR_PAIR(COLOR_BLUE));}
        else
          wattron(outputwin, COLOR_PAIR(COLOR_YELLOW));
        guiprintf("%s: ", data[2]);
        wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
        char *text = removeformatting(data[4]);
	wordwrap(text);
        guiprintf("\n"/*, text*/);
        free(text);
        updateroom();
	break;
      case 0x43:
	if (isUser(ignore,data[2]) == 1) break;
	timestamp();
        wattron(outputwin, COLOR_PAIR(COLOR_RED));
        guiprintf("* ");
        wattron(outputwin, COLOR_PAIR(COLOR_WHITE));
        char *etext = removeformatting(data[4]);
        guiprintf("%s "/* %s\n" */, data[2]/*, etext */);
	wordwrap(etext);
	guiprintf("\n");
        free(etext);
	updateroom();
        break;
    }
  free(data);
}

void timestamp()
{
	struct tm *times;
	time_t lt;
	if (tson == 1) {
		lt = time(NULL);
		times = localtime(&lt);
		/*
		if (times->tm_hour > 9) {
			guiprintf("[%d:",times->tm_hour);
		} else {
			guiprintf("[0%d:",times->tm_hour);	
		} 				
		if (times->tm_min > 9) {		
			guiprintf("%d:", times->tm_min);
		} else {
			guiprintf("0%d:", times->tm_min);
		}		
		if (times->tm_sec > 9) {
			guiprintf("%d] ",times->tm_sec);
		} else { 
			guiprintf("0%d] ",times->tm_sec);
		}
		*/
		guiprintf("[%02d:%02d:%02d] ", times->tm_hour, times->tm_min, times->tm_sec);
	}
}

void *recvthread()
{
  yrecv(s);
  atdisconnect();
  pthread_exit(0);
}

void disconnect()
{
  close(s);
  atdisconnect();
}

void pexec(char *cmd)
{
	char buf[2048]="\0\0";
	char temp[80]="\0\0";
	char txt[4096];
	int a;
	FILE *popen_in;
	if ((popen_in = popen(cmd,"r")) == NULL) 
		return;
	while(fgets(temp,2,popen_in) && (strlen(buf) < 800)) {
		strncat(buf,temp,2);
		if((strlen(buf)+strlen(cmd)) > 510) 
			break;	
	};
	pclose(popen_in);
	sprintf(txt,"%s: %s",cmd, buf);
	a = strlen(txt);
	txt[a-1]='\0';
#ifdef DEBUG	
	sprintf(temp ,"strlen(txt) = %d\n", strlen(txt));
	debug_message(temp);
#endif
	ysay(s, txt);
}

void quit()
{
  free(groom);
  if(logdin == 1)
    ycmd(s, 0x71, "logout", 6);
  if(connected == 1)
    disconnect();
  endgui();
  free(defroom);
  free(defuser);
  free(defserver);
#ifdef __WIN32__
  WSACleanup();
#endif
  _exit(0);
}

char *readline(FILE *f)
{
  char *line = (char *) malloc(2 * sizeof(char));
  int i;
  for(i = 0;; i++)
    {
      char c = fgetc(f);
      if(c == '\n' || c == EOF)
        break;
      line[i] = c;
      line = (char *) realloc((char *) line, (i + 3) * sizeof(char));
    }
  line[i] = 0;
  if(i == 0)
    return 0;
  return line;
}

void togglets(void)
{
	if (tson == 1) {
		tson = 0;
	} else { 
		tson = 1;
	}
}

void readconfig()
{
  char *path;
  oasprintf(&path, "%s/.overdoserc", getenv("HOME"));
  FILE *cfg;
  if((cfg = fopen(path, "r")) == 0)
    return;
  free(path);
  defserver = readline(cfg);
  defroom = readline(cfg);
  defuser = readline(cfg);
  fclose(cfg);
}

void ignoreuser(char *uS)
{
	char *str = (char *) malloc(512 * sizeof(char));
	if (strcmp(uS,"") == 0) return;
	if (toggleIgnore(&ignore,uS) == 1) {
		snprintf(str, 512, "*** Added %s to ignore list.", uS);
		wordwrap(str); /* autmatically does free(str); */
	} else {
		snprintf(str, 512, "*** Removed %s from ignore list.", uS);
		wordwrap(str); /* autmatically does free(str); */
	}
}

void loadignore(void)
{
	char *path;
	FILE *cfg;
	oasprintf(&path, "%s/.zinc/ignore", getenv("HOME"));
	if((cfg = fopen(path, "r")) == 0) {
		free(path);
		oasprintf(&path, "%s/.overdoseig", getenv("HOME"));
		if((cfg = fopen(path, "r")) == 0) { 
			free(path);
			return;
		} else {
			fclose(cfg);
			ignore = unserializeArray(path);
			free(path);
			return;
		}
		fclose(cfg);
		ignore = unserializeArray(path);
		free(path);
		return;
	}
}

void connerr()
{
	char *str;
	oasprintf(&str,"error: %s\n",strerror(errno));
	wordwrap(str); /* this also free()s str */
	guiprintf("\n");
}

int conn(char *host)
{
  if(host == NULL || host[0] == '\0')
    {
      guiprintf("enter server address [or press enter for jcs.chat.dcn.yahoo.com]: ");
      guigetln(&host, 1);
      if (host == NULL || host[0]=='\0') host = "dcs2.chat.dcn.yahoo.com";
      guiprintf("%s\n", host);
    }
  if(logdin == 1)
    ycmd(s, 0x71, "logout", 6);
  if(connected == 1)
    disconnect();
  if((s = tcp_connect(host, 8002)) < 0)
    {connerr(); return 1;}
  connected = 1;
  if(pthread_create(&thrdid, 0, recvthread, 0) != 0)
    {guiprintf("error: cant create thread\n"); return 1;}
  guiprintf("connected\n");
  return 0;
}

int login(char *id)
{
/* old code here is ifdef'd out. */
  if(connected != 1)
    if(conn(defserver) != 0) {
#ifdef DEBUG
       guiprintf("conn() FAILED.\n");
#endif
	return 1;
	}
  if(id == NULL || id[0] == '\0')
    {
      guiprintf("enter your username: ");
      guigetln(&username, 1);
      guiprintf("%s\n", username);
      guiprintf("enter your password (will not echo)\n");
    }
  else
    {
      oasprintf(&username, "%s", id);
      guiprintf("enter password for %s\n", username);
    }
  char *password;
  guigetln(&password, 0);
  guiprintf("logging in...\n");
  session = 0;
  char *auth;
  if(yauth(username, password,&auth) != 0)  
    {guiprintf("error: cannot login\n"); return 1;}  
  free(password);
  guiprintf(auth);
  char *msg;
  oasprintf(&msg, "0\xc0\x80%s\xc0\x80""1\xc0\x80%s\xc0\x80""6\xc0\x80%s\xc0\x80"
  	          "2\xc0\x80%s\xc0\x80", username, username, auth, username);

  guiprintf("%s\n", msg);

  status = 0x5a55aa55;
  ycmd(s, 0x1e, msg, strlen(msg)); 
  free(auth);
  guiprintf("login sent\n");
  return 0;
}

void join(char *room)
{
  if(room == NULL || room[0] == '\0')
    {
      guiprintf("enter room to join [or press enter for Linux, FreeBSD, Solaris:1]: ");
      guigetln(&room, 1);
      if(strcmp(room,"")==0) room = "Linux, FreeBSD, Solaris:1";
      guiprintf("%s\n", room);
    }
  if(logdin == 0)
    if(login(defuser) != 0)
      return;
  ycmd(s, 0x11, room, strlen(room));
  strncpy(groom,room,32);
  updateroom();
  joindroom = 1;
}

void segv(int sig) 
{
  free(groom);
  if(logdin == 1)
    ycmd(s, 0x71, "logout", 6);
  if(connected == 1)
    disconnect();
  endgui();
  free(defroom);
  free(defuser);
  free(defserver);
#ifdef __WIN32__
  WSACleanup();
#endif
  kill(getpid(),SIGSEGV);
}

int main(int argc, char *argv[])
{
#ifdef __WIN32__
 struct WSAData wsaData;
 int wsaret=WSAStartup(0x101,&wsaData);
 if(wsaret)
    return;
#endif
  int didlogin;
  tson = 1;
  argc--;
  argv++;
  groom = malloc(128);
  parseargs(argc, argv);
  users = (char **) malloc(1 * sizeof(char *));
     users[0] = 0;
  startgui();
  signal(SIGINT, quit);
  guiprintf("Overdose "VERSION". Running as PID %d\n",getpid());
  signal(SIGTRAP, segv);
  signal(SIGABRT, segv);
  /* Uncomment as needed
  signal(SIGTRAP, segv);
  signal(SIGTRAP, segv);
  */
  readconfig();
  didlogin = login(defuser);
  if (didlogin != 0) {
     guiprintf("Login failed.\n");
  }
  if(defserver != 0)
    conn(defserver);
  if(defroom != 0)
    join(defroom);
  for(;;)
    {
      char *txt;
      if(guigetln(&txt, 1) == 0)
        {
          free(txt);
          continue;
        }
      if(txt[0] == '/')
        {
          char *txt2 = txt + 1;
          if(txt2[0] == 0)
            printusers();
          else
            {
              char *cmd = strsep(&txt2, " ");
              command(cmd, txt2);
            }
        }
      else
        ysay(s, txt);
      free(txt);
    }
}

