#
# Shell script for finding functions within a given set of source code files.
# Copyright (C) 2006 Segin
# 
# This program is released under the GNU GPLv2 or, at your option, any later version.
# Please see the accompanying LICENSE file, or in it's abscense, http://www.gnu.org/licenses/gpl.txt
#
# $Header: /cvsroot/overdose/overdose/memcheck.sh,v 1.8 2006/04/06 01:00:51 segin Exp $
#

FUNCTIONS="malloc realloc free" ;
byline()
{
	for FUNCTION in ${FUNCTIONS} ; do
	printf "\033[32;01m * \033[0m\033[1m${FUNCTION}\033[33;01m()\033[0m's by file: \n" ;
		for SOURCEFILE in *.c ; do
			# debug
			# echo $FUNCTION $SOURCEFILE
			printf "\033[32;1m * \033[0m${SOURCEFILE}: \n";
			grep --color=always -n "${FUNCTION}(" ${SOURCEFILE} > /tmp/grep;
			ENTRIES=`echo \`cat /tmp/grep | wc -l\` | bc`
			if [ ${ENTRIES} \!= 0 ]; then
				COUNT=1
				while [ ${COUNT} != ${ENTRIES} ]; do
					printf "  \033[32;1m * \033[0m"
					cat /tmp/grep | head -n ${COUNT} | tail -n 1
					COUNT=`echo ${COUNT}+1 | bc`
				done
			fi
		done
	done
}

context()
{
	for FUNCTION in ${FUNCTIONS}; do 
		printf "\033[32;01m * \033[0m\033[1m${FUNCTION}\033[33;01m()\033[0m's by file: \n" ;
		for SOURCEFILE in *.c ; do 
			# debug
			# echo $FUNCTION $SOURCEFILE
			printf "\033[32;1m * \033[0m${SOURCEFILE}: ";
			grep --color=always -n -C 1 "${FUNCTION}(" ${SOURCEFILE} > /tmp/grep;
			ENTRIES=`echo \`cat /tmp/grep | wc -l\` | bc`;
			if [ ${ENTRIES} \!= 0 ]; then
				COUNT=1;
				printf "\n";
				while [ ${COUNT} != ${ENTRIES} ]; do
					printf "  \033[32;1m * \033[0m"
					cat /tmp/grep | head -n ${COUNT} | tail -n 1
					COUNT=`echo ${COUNT}+1 | bc`
				done
			else 
				printf " No occurences of ${FUNCTION}\n";
			fi
		done
	done
}

default()
{
	for FUNCTION in ${FUNCTIONS}; do 
		printf "\033[32;01m * \033[0m\033[1m${FUNCTION}\033[33;01m()\033[0m's by file: \n" ;
		for SOURCEFILE in *.c ; do
		printf "\033[32;1m * \033[0m${SOURCEFILE}	: ";
		grep "${FUNCTION}(" ${SOURCEFILE} -c;
		done
	done
}

printhelp()
{
	echo "memcount.sh: A script for counting functions."
	echo "SYNTAX: ${0} [-C | -l]"
	echo "	-l	Print out line numbers and line text for each occurence."
	echo "	-C	Like above, but prints more context per occurence."
	echo "	--help	Self explanatory."
	echo ""
	echo "Please send bug reports to segin2005@gmail.com."
	echo "This script requires GNU grep."
}

if [ $# == 0 ]; then 
	default; 
	exit;
fi

if [ $# == 1 ]; then
	if [ $1 == '-l' ]; then
		byline;
		rm /tmp/grep;
		exit;
	fi
	if [ $1 == '-C' ]; then
		context;
		rm /tmp/grep;
		exit;
	fi
	if [ $1 == '--help' ]; then
		context;
		exit;
	fi
fi

printhelp;
exit 1;
