/*
 * $Header: /cvsroot/overdose/overdose/strutil.c,v 1.21 2006/10/16 02:39:35 segin Exp $
 */

#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>

/* The following function was found in a archined email to the glib-devel 
 * mailing list in a patch. I changed all glib-only types to standard ones.
 * I hope the author doesn't mind me using it. I should email him about it,
 * of course the function was submitted in 1999, so...
 */

#ifndef strsep 
char* strsep (char **string, const char *delim)
{
  char *p, *q;
  
  if (!(p =* string))
    return NULL;
  
  if (delim[0] == '\0' || delim[1] == '\0')
    {
      char ch = delim[0];
      
      if (ch != '\0')
        q = (*p == ch) ? p : strchr (p + 1, ch);
      else
       q = NULL;
    }
  else
    q = strpbrk (p, delim);
  
  if (q)
    {
      *q++ = '\0';
      *string = q;
    }
  else
    *string = NULL;
  
  return p;
}
#endif

void
strcatl(char *dst, const char *src, size_t size)
{
	int n, cnt;

	n = strlen(dst);
	cnt = size-1-n;
	if(cnt > 0)
		strncat(dst,src,cnt);
}

int
strequal(const char *s1, const char *s2)
{
	if(s1 && s2)
		return(strcmp(s1, s2) ? 0 : 1);
	return 0;
}

#ifdef __WIN32__
void bzero(void *buf, size_t len)
{
	memset(buf, 0, len);
}
#endif

int oasprintf(char **strp, char *fmt, ...)
{
	va_list ap;
	int ret;
	va_start(ap,fmt);
	ret = vasprintf(strp, fmt, ap);
	va_end(ap);
	return(ret);
}

char *substr(char *str, int start, size_t length)
{
  char *str2 = (char *) malloc(length * sizeof(char *));
  int i;
  for(i = 0; i < length; i++)
    str2[i] = str[start + i];
  str2[i] = 0;
  return str2;
}

int split(char *separator, char *str, char ***array)
{
  char *str2 = (char *) malloc((strlen(str) + 1) * sizeof(char));
  strncpy(str2, str, strlen(str));
  str2[strlen(str)] = 0;
  *array = (char **) malloc(1 * sizeof(char *));
  int i;
  for(i = 0; ((*array)[i] = strsep(&str2, separator)); i++)
    *array = (char **) realloc((char **) *array, (i + 2) * sizeof(char *));
  free(str2);
  return i;
}

void strput(char *dest, int pos, char *text, int len)
{
  int i;
  for(i = 0; i < len; i++)
    dest[pos + i] = text[i];
}

int digit(int num, int pos, int base)
{
  int num2 = num;
  int i;
  for(i = 0; i < pos; i++)
    num2 = (num2 / base) - ((num2 / base) % 1);
  return num2 % base;
}

int strint(char *str, int len)
{
  int total = 0;
  int m = 1;
  int i;
  for(i = 0; i < len; i++)
    {
      int ch = (unsigned char) str[(len - 1) - i];
      total = total + (ch * m);
      m = m * 256;
    }
  return total;
}

int StrLen(char *str)
{
          int x;
          for(x=0;(str[x]!='\0');x++);
          return(x);
}

/** Returns the number of elements in a array of strings,
    that is, a char ** array (so that you aren't confused.
 **/

int strarrlen(char **strarr)
{
  int c;
  for(c = 0; strarr[c] != 0; c++);
  return c;
}

int strarrdel(char ***strarr, char *str)
{
  int i, l = strarrlen(*strarr);
  if (l == 0) return 1;
  for(i = 0; i < l; i++)
    if(strcmp((*strarr)[i], str) == 0)
      {
        free((*strarr)[i]);
        (*strarr)[i] = (*strarr)[l - 1];
        (*strarr)[l - 1] = 0;
        *strarr = (char **) realloc((char **) *strarr, l * sizeof(char *));
        return 0;
      }
  return 1;
}

// What up wit it Doc[umentation]?!?!?!
// @ Returnage: returns 1 if *uS is found in **uA
// @ char **uA: the array to search
// @ char *uS : The string (username) to search for in **uA
// ? Whats the difference between a dead baby and thetans girlfriend?
// + Thetan doesnt kiss his girlfriend after sex
// ! lollercaust

int isUser(char **uA, char *uS)
{
        int i, sI = strarrlen(uA);
        
        for(i = 0; i < sI; i++)
        {
                if (strcasecmp(uA[i], uS) == 0) return 1;
        }
        return 0;       
}

//<Thetan> so like: blah(char **uA, char *uS){ if(*uS is in **uA){delete *uS in **uA}else{add *uS to **uA} } ?
//<segin> Thetan: EXACTLY!!!
// What up wit it Doc[umentation]?!?!?!
// @ Returnage: returns 1 if *uS was added to **uA 0 if it was removed
// @ char **uA: the array to search/modify
// @ char *uS : The string (username) to search for in **uA
int toggleIgnore(char ***uA, char *uS)
{
	int l;
	
	if(strarrdel(uA, uS))
	{
		l = strarrlen(*uA);
		*uA = (char **) realloc((char **) *uA, ++l * sizeof(char *));
		(*uA)[--l] = strdup(uS);
		return 1;
	}
	return 0;
}

// What up wit it Doc[umentation]?!?!?!
// @ Returnage: see fclose()
// @ char **uA: the array to serialize for later
// @ char *fS : string of the file to write **uA to
int serializeArray(char **uA, char *fS)
{
	FILE *fP = fopen(fS, "w+");
	
	do
	{
		fprintf(fP, "%s\n", *uA);
	} while (*++uA);
	return fclose(fP);
}

// What up wit it Doc[umentation]?!?!?!
// @ Returnage: a **uA representation of *fS
// @ char *fS : the name of the file to read the strings from
char** unserializeArray(char *fS)
{
	char **rA;
	char *tA;
	char tC;
	int i, i2;
	FILE *fP = fopen(fS, "r");
	
	rA = (char**) NULL;
	tA = (char*) NULL;
	for (i = 0; !feof(fP); i++)
	{
		rA = (char**) realloc(rA, (i+1)*sizeof(char*));
		for (i2 = 0; (tC = getc(fP)) != '\n' && tC != EOF; i2++)
		{
			tA = (char*) realloc(tA, (i2+1)*sizeof(char));
			tA[i2] = tC; 
		}
		tA = (char*) realloc(tA, (i2+1)*sizeof(char));
		tA[i2] = (char) 0;
		if (tC != EOF)
		{
			rA[i] = tA;
		}
		else
		{
			free(tA);
			rA[i] = (char*) 0;
		}
		tA = NULL;
	}
	return rA;
}

/* From mingw */
void mbcopy(char *src, char *dest, size_t len)
{
  if (dest < src)
    while (len--)
      *dest++ = *src++;
  else
    {
      char *lasts = src + (len-1);
      char *lastd = dest + (len-1);
      while (len--)
        *(char *)lastd-- = *(char *)lasts--;
    }
}
/* from cddbd, whatever the hell that is. */

/* This function returns 1 if the given charater c is in the 
 * given string str.
 *
 * Otherwise it returns 0.
 */

int
is_instr(char c, char *str)
{

	if(*str == '\0')
		return 1;

	while(*str != '\0') {
		if(c == *str)
			return 1;
		++str;
	}

	return 0;
}


/* This function removes CR and LF chars at the end
 * of a string by replacing them with NULL chars.
 *
 * This has the added side-effect of being useful for 
 * compilers, arrays, etc.
 */

void
strip_crlf(char *buf)
{
	char *p;

	/* Strip out newlines. */
	p = &buf[strlen(buf) - 1];

	while(*p == '\n' || *p == '\r') {
		*p = '\0';

		if(p == buf)
			break;
		p--;
	}
}


/* This function determines if the line in
 * a string contain the ## comment line.
 */
int
is_DblHash(char *buf)
{
	char *p;

	p = &buf[0];
	if (*p == '#' && *(++p) == '#') {
		return 1;
	}
	
	return 0;
}

/* This is the Overdose version of the memdup function. 
 * It returns a pointer to a memory location containing 
 * the duplicated data referenced by ptr up to the first
 * size bytes.
 */

void *omemdup(const void *ptr, size_t size) 
{
  void *newptr = malloc(size);

  if (!newptr)
    return NULL;
  memcpy(newptr, ptr, size);
  return newptr;
}

void strrep(char *str, char fm, char to)
{
	while( *str ) {
		if ( *str == fm ) {
			*str = to;
		}
  		str++;
	}
}

/* Portable version of bzero for systems without it.
   This function is in the public domain.  */

/*
NAME
	bzero -- zero the contents of a specified memory region

SYNOPSIS
	void pdbzero(char *to, int count)

DESCRIPTION
	Zero COUNT bytes of memory pointed to by TO.

BUGS
	Significant speed enhancements may be made in some environments
	by zeroing more than a single byte at a time, or by unrolling the
	loop.

*/

void
pdbzero (char *to, int count)
{
  while (count-- > 0)
    {
      *to++ = 0;
    }
}

/* bcmp
   This function is in the public domain.  */

/*

NAME

	pdbcmp -- compare two memory regions

SYNOPSIS

	int pdbcmp (char *from, char *to, int count)

DESCRIPTION

	Compare two memory regions and return zero if they are identical,
	non-zero otherwise.  If count is zero, return zero.

NOTES

	No guarantee is made about the non-zero returned value.  In
	particular, the results may be signficantly different than
	strcmp(), where the return value is guaranteed to be less than,
	equal to, or greater than zero, according to lexicographical
	sorting of the compared regions.

BUGS

*/


int pdbcmp(char *from, char *to, size_t count)
{
  int rtnval = 0;

  while (count-- > 0)
    {
      if (*from++ != *to++)
	{
	  rtnval = 1;
	  break;
	}
    }
  return (rtnval);
}

/* Portable version of strchr()
   This function is in the public domain.  */

/*
NAME
	pdstrchr -- return pointer to first occurance of a character

SYNOPSIS
	char *pdstrchr(const char *s, int c)

DESCRIPTION
	Returns a pointer to the first occurance of character C in
	string S, or a NULL pointer if no occurance is found.
	
BUGS
	Behavior when character is the null character is implementation
	dependent.
*/

char *pdstrchr(const char *s, int c)
{
  do {
    if (*s == c)
      {
	return (char*)s;
      }
  } while (*s++);
  return (0);
}

/* Overdose version of strdup. Duplicates a string like 
 * omemdup. Remember to free() the returned pointer when
 * done with it.
 */

char *ostrdup(char *s)
{
    char *result = (char*)malloc(strlen(s) + 1);
    if (result == (char*)0)
	return (char*)0;
    strcpy(result, s);
    return result;
}
