/*
 * $Header: /cvsroot/overdose/overdose/tcp.c,v 1.5 2006/04/09 01:27:29 segin Exp $
 */

#include <strings.h>
#include <sys/types.h>
/* The networking header is winsock.h on Windows. */
#ifdef __WIN32__
#include <winsock2.h>
#else /* For Unix */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

/* Big #ifdef because of broken Winsock */

int tcp_connect(char *host, int port)
#ifdef __WIN32__
{
 SOCKET sock;
 sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
 if(sock==INVALID_SOCKET) {
 #ifdef DEBUG
  debug_message("Invalid socket.");
 #endif
    return -1;
}
  struct hostent *remotehost;
  if((remotehost = gethostbyname(host)) == 0) return -2;
  struct sockaddr_in addr;
  bzero(addr.sin_zero, 8);
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr = *((struct in_addr *) remotehost->h_addr);
  if(connect(sock, (struct sockaddr *) &addr, sizeof(struct sockaddr)) == -1) return -3;
  return sock;
}
#else
{
  struct protoent *proto = getprotobyname("tcp");
  int sock;
  if((sock = socket(AF_INET, SOCK_STREAM, proto->p_proto)) == -1)
    return -1;
  struct hostent *remotehost;
  if((remotehost = gethostbyname(host)) == 0)
    return -2;
  struct sockaddr_in addr;
  bzero(addr.sin_zero, 8);
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr = *((struct in_addr *) remotehost->h_addr);
  if(connect(sock, (struct sockaddr *) &addr, sizeof(struct sockaddr)) == -1)
    return -3;
  return sock;
}
#endif
int tcp_listen(int port)
{
#ifdef __WIN32__
 SOCKET sock;
 sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
 if(sock==INVALID_SOCKET)
#else
  struct protoent *proto = getprotobyname("tcp");
  int sock;
  if((sock = socket(AF_INET, SOCK_STREAM, proto->p_proto)) == -1)
#endif
    return -1;
  int reuseaddr = 1;
  if(setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &reuseaddr, sizeof(int)) == -1)
    return -2; 
  struct sockaddr_in localsockaddr;
  bzero(localsockaddr.sin_zero, sizeof(localsockaddr.sin_zero));
  localsockaddr.sin_family = AF_INET;
  localsockaddr.sin_addr.s_addr = htonl(INADDR_ANY);
  localsockaddr.sin_port = htons(port);
  if(bind(sock, (struct sockaddr *) &localsockaddr, sizeof(localsockaddr)) == -1)
    return -3;
  if(listen(sock, SOMAXCONN) == -1)
    return -4;
  return sock;
}
