/*
 $Header: /cvsroot/overdose/overdose/userlst.c,v 1.3 2006/04/06 01:00:51 segin Exp $
   
userlst.c
Copyright (c) 2006, Alex Mercader
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,this
    list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <stdlib.h>
#include "ymskdef.h"
#ifdef __USE_YMSK__
struct luser *find_luser(struct luser *, const char *);
void delete_luser(struct luser **, struct luser **, const char *);

int
add_luser(struct luser **first, struct luser **last, const char *name)
{
	struct luser *old, *p, *loser;

	if(find_luser(*first, name))
	{
		delete_luser(first, last, name);
		return 1;
	}
	if(!(loser=(struct luser *)malloc(sizeof(struct luser))))
		err(1,NULL);
	if(asprintf(&loser->name, "%s", name) == -1)
		err(1,NULL);

	if(*last == NULL) /* first element in list */
	{
		loser->next = NULL;
		loser->prev = NULL;
		*last = loser;
		*first = loser;
		return 0;
	}

	old = NULL;
	p = *first; /* start at top of list */
	while(p)
	{
		if(strcasecmp(p->name, loser->name) < 0)
		{
			old = p;
			p = p->next;
		}
		else
		{
			if(p->prev)
			{
				p->prev->next = loser;
				loser->next = p;
				loser->prev = p->prev;
				p->prev = loser;
				return 0;
			}
			loser->next = p; /* the first element */
			loser->prev = NULL;
			p->prev = loser;
			*first = loser;
			return 0;
		}
	}
	old->next = loser; /* put on end */
	loser->next = NULL;
	loser->prev = old;
	*last = loser;
	return 0;
}


void
delete_luser(struct luser **first, struct luser **last, const char *name)
{
	struct luser *loser;
	
	loser = find_luser(*first, name);
	if(loser)
	{
		if(*first == loser)
		{
			*first = loser->next;
			if(*first)
				(*first)->prev = NULL;
			else
				*last = NULL;
		}
		else
		{
			loser->prev->next = loser->next;
			if(loser != *last)
				loser->next->prev = loser->prev;
			else
				*last = loser->prev;
		}
		free(loser->name);
		free(loser);  /* return memory to system */
	}
}


struct luser *
find_luser(struct luser *first, const char *name)
{
	struct luser *loser;

	loser = first;
	while(loser)
	{
		if(!strcasecmp(name, loser->name))
			return loser;
		loser = loser->next;  /* get next luser */
	}
	return NULL;
}

void
free_lusers(struct luser **first, struct luser **last)
{
	struct luser *loser, *old;

	loser = *first;
	while(loser)
	{
		old = loser;
		loser = loser->next;
		free(old->name);
		free(old);
	}
	*first = *last = NULL;
}

char *
find_partial_luser(struct luser *first, const char *key)
{
	struct luser *loser;

	loser = first;
	while(loser)
	{
		if(!strncasecmp(key, loser->name, strlen(key)))
		{
			if(strlen(loser->name) == strlen(key))
			{
				struct luser *nextluser = loser->next;
				if(nextluser)
					return nextluser->name;
				else
					return first->name;
			}
			return loser->name;
		}
		loser = loser->next;  /* get next luser */
	}
	return NULL;	
}
#endif
