/* 
 * $Header: /cvsroot/overdose/overdose/ycht.c,v 1.8 2006/09/22 20:08:34 segin Exp $
 */

#include "main.h"
#include "http.h"
#include "strutil.h"
#include <stdarg.h>
#include <stdlib.h>

void yrecvd(int service, char *content, int len);

int yauth(char *username, char *password, char **auth)
{
  char *request;
  oasprintf(&request, "/config/login?.src=&login=%s&passwd=%s&n=1", username, password);
  char *header, *body;
  int error;
#ifdef DEBUG  
  debug_message("http_get(\"login.yahoo.com\", 80, request, &header, &body)");
#endif    
  if((error = http_get("login.yahoo.com", 80, request, &header, &body)) < 0)
    return error;
#ifdef DEBUG
   debug_message("http_get() complete");
#endif
  free(request);
  free(body);
  char **lines;
  int linecount = split("\n", header, &lines);
  free(header);
  char *part1 = 0, *part2 = 0;
  int i;
  for(i = 0; i < linecount; i++)
    if(strncmp(lines[i], "Set-Cookie: ", 12) == 0)
      {
        char *cookiedata = substr(lines[i], 12, strlen(lines[i]) - 13);
        char **cookie;
        split("; ", cookiedata, &cookie);
        free(cookiedata);
        if(strncmp(cookie[0], "Y=", 2) == 0)
          part1 = cookie[0];
        if(strncmp(cookie[0], "T=", 2) == 0)
          part2 = cookie[0];
        free(cookie);
      }
  free(lines);
  if(part1 == 0 || part2 == 0 || strcmp(part2, "T=z=0") == 0)
    return -4;
  oasprintf(&*auth, "%s\001%s; %s", username, part1, part2);
  free(part1);
  free(part2);
  return 0;
}

void yrecv(int socket)
{
	int c;
	for(;;)
	{
		char *header = (char *) malloc(16 * sizeof(char));
#ifdef __WIN32__
		if(recv(socket, header, 16, 0) == 0)
#else
		if(read(socket, header, 16) == 0)
#endif	      
			break;
		int len = strint(substr(header, 14, 2), 2);
		char *content = (char *) malloc((len + 1) * sizeof(char));
		bzero(content, len + 1);
		char *part =  (char *) malloc((len + 1) * sizeof(char));
#ifdef __WIN32__
	c = recv(socket, content, len, 0);
#else
	c = read(socket, content, len);
#endif	
      while(c < len)
        {
          bzero(part, len + 1);
#ifdef __WIN32__
	  c = c + recv(socket, part, len - c, 0);
#else	  
	  c = c + read(socket, part, len - c);
#endif          
	  strncat(content, part, strlen(part));
        }
      free(part);
      yrecvd(strint(substr(header, 10, 2), 2), content, len);
      free(header);
      free(content);
    }
}

void ycmd(int socket, int service, char *text, int len)
{
  char header[] = {'Y', 'C', 'H', 'T', 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, digit(service, 1, 256), digit(service, 0, 256), 0x00, 0x00, digit(len, 1, 256), digit(len, 0, 256)};
  char *msg = (char *) malloc((16 + len) * sizeof(char));
  strput(msg, 0, header, 16);
  strput(msg, 16, text, len);
#ifdef __WIN32__
  send(socket, msg, 16 + len, 0);
#else
  write(socket, msg, 16 + len);
#endif
  free(msg);
}

void ycmd_emote(int socket, int service, char *text, int len)
{
	char header[] = {'Y', 'C', 'H', 'T', 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, digit(len, 1, 256), digit(len, 0, 256)};
 	char *msg = (char *) malloc((16 + len) * sizeof(char));
	strput(msg, 0, header, 16);
	strput(msg, 16, text, len);
#ifdef __WIN32__
	send(socket, msg, 16 + len, 0);
#else
	write(socket, msg, 16 + len);
#endif
	free(msg);
}


	
/*
void ypm(int socket, char *msg)
{
  char prefix[] = {0x43, 0x01, 0x00};
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, msg);
  ycmd(socket, 0x41, msg2, strlen(msg2));
  free(msg2);
}
*/

void ysay(int socket, char *msg)
{
  char prefix[] = {0x43, 0x01, 0x00};
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, msg);
  ycmd(socket, 0x41, msg2, strlen(msg2));
  free(msg2);
}

void yemote(int socket, char *msg)
{
  char prefix[] = {' ', 0x01, 0x00};
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, msg);
  ycmd(socket, 0x43, msg2, strlen(msg2));
  free(msg2);
}

void yfollow(int socket, char *user)
{
  char prefix[] = "goto ";
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, user);
  ycmd(socket, 0x71, msg2, strlen(msg2));
  free(msg2);
}

/* Ping command. Sorry, The "ping" packet must be built in a manner 
 * that ycmd can't handle, so i duplicated ycmd and edited it.
 */

void yping(int socket)
{
  char msg[] = {'Y', 'C', 'H', 'T', 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x62, 0x00, 0x00, 0x00, 0x00};
#ifdef __WIN32__
  send(socket, msg, 32, 0);
#else
  write(socket, msg, 32);
#endif
  /* free(msg); */
}
