/* 
 * $Header: /cvsroot/overdose/overdose/ymsg.c,v 1.15 2006/09/29 10:25:29 segin Exp $
 */

#define __USE_YMSG__
#ifdef __USE_YMSG__

#include "main.h"
#include "http.h"
#include "strutil.h"
#include "ymsg.h"
#include <stdarg.h>
#include <stdlib.h>

void ymsg_recvd(int service, char *content, int len);

int yauth(char *username, char *password, char **auth)
{
  char *request;
  oasprintf(&request, "/config/login?.src=&login=%s&passwd=%s&n=1", username, password);
  char *header, *body;
  int error;
#ifdef DEBUG  
  debug_message("http_get(\"login.yahoo.com\", 80, request, &header, &body)");
#endif    
  if((error = http_get("login.yahoo.com", 80, request, &header, &body)) < 0)
    return error;
#ifdef DEBUG
   debug_message("http_get() complete");
#endif
  free(request);
  free(body);
  char **lines;
  int linecount = split("\n", header, &lines);
  free(header);
  char *part1 = 0, *part2 = 0;
  int i;
  for(i = 0; i < linecount; i++)
    if(strncmp(lines[i], "Set-Cookie: ", 12) == 0)
      {
        char *cookiedata = substr(lines[i], 12, strlen(lines[i]) - 13);
        char **cookie;
        split("; ", cookiedata, &cookie);
        free(cookiedata);
        if(strncmp(cookie[0], "Y=", 2) == 0)
          part1 = cookie[0];
        if(strncmp(cookie[0], "T=", 2) == 0)
          part2 = cookie[0];
        free(cookie);
      }
  free(lines);
  if(part1 == 0 || part2 == 0 || strcmp(part2, "T=z=0") == 0)
    return -4;
  oasprintf(&*auth, "%s; %s;", part1, part2);
  free(part1);
  free(part2);
  return 0;
}

void yrecv(int socket)
{
	int c;
	char *tmp;
	YMSGHeader *hdr;
	for(;;)
	{
		char *header = (char *) malloc(20 * sizeof(char));
#ifdef __WIN32__
		if(recv(socket, header, 20, 0) == 0)
#else
		if(read(socket, header, 20) == 0)
#endif	      
			break;
		/* Fixes memory leak */
		tmp = substr(header, 8, 2);
		int len = strint(tmp, 2);
		free(tmp);
		char *content = (char *) malloc((len + 1) * sizeof(char));
		bzero(content, len + 1);
		char *part =  (char *) malloc((len + 1) * sizeof(char));
#ifdef __WIN32__
	c = recv(socket, content, len, 0);
#else
	c = read(socket, content, len);
#endif	
      while(c < len)
        {
          bzero(part, len + 1);
#ifdef __WIN32__
	  c = c + recv(socket, part, len - c, 0);
#else	  
	  c = c + read(socket, part, len - c);
#endif          
	  strncat(content, part, strlen(part));
        }
      free(part);
      /* segin: Fixes another memory leak */
      tmp = substr(header, 10, 2);
      if((strint(tmp,2)) == 30) {
            tmp = substr(header, 16, 4);
      	    session = strint(tmp, 4);
            free(tmp);
      }
      yrecvd(strint(tmp, 2), content, len);
      free(tmp);
      free(header);
      free(content);
    }
}

void ycmd(int socket, int service, char *text, int len)
{
  char header[] = {'Y', 'M', 'S', 'G', 0x0a, 0x00, 0x00, 0x00, digit(len, 1, 256), digit(len, 0, 256), digit(service, 1, 256), digit(service, 0, 256),digit(status, 3, 256), digit(status, 2, 256), digit(status, 1, 256), digit(status, 0, 256), 0x00,/*key*/ 0x00, 0x00, 0x00, 0x00};
  YMSGHeader *msg;
  short int serv = service;
  char *msg2 = (char *) malloc((20 + len) * sizeof(char));
  strput(msg2, 0, header, 20);
  msg = msg2;
  strput(msg2, 12, &session, 4);

 // if (strlen(key) == 4) 
 //	strput(msg, 16, key, 0);
  strput(msg2, 20, text, len);
#ifdef __WIN32__
  send(socket, msg2, 20 + len, 0);
#else
  write(socket, msg2, 20 + len);
#endif
  free(msg2);
}

/*
void ycmd_emote(int socket, int service, char *text, int len)
{
	char header[] = {'Y', 'C', 'H', 'T', 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x43, 0x00, 0x00, digit(len, 1, 256), digit(len, 0, 256)};
 	char *msg = (char *) malloc((16 + len) * sizeof(char));
	strput(msg, 0, header, 16);
	strput(msg, 16, text, len);
#ifdef __WIN32__
	send(socket, msg, 16 + len, 0);
#else
	write(socket, msg, 16 + len);
#endif
	free(msg);
}
*/

	
/*
void ypm(int socket, char *msg)
{
  char prefix[] = {0x43, 0x01, 0x00};
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, msg);
  ycmd(socket, 0x41, msg2, strlen(msg2));
  free(msg2);
}
*/

void ysay(int socket, char *msg)
{
  char prefix[] = {'1', 0xc0, 0x80, 0};
  char *msg2;
  oasprintf(&msg2, "%s%s%s%s%s%s%s%s%s",prefix, username,
 	"\xc0\x80""104\xc0\x80", groom, "\xc0\x80""117\xc0\x80", msg, "\xc0\x80"
	"124\xc0\x80""1\xc0\x80");
  ycmd(socket, 0xA8, msg2, strlen(msg2));
  free(msg2);
}

void yemote(int socket, char *msg)
{
  char prefix[] = {' ', 0x01, 0x00};
  char *msg2;
  oasprintf(&msg2, "%s%s", prefix, msg);
  ycmd(socket, 0x43, msg2, strlen(msg2));
  free(msg2);
}

void yfollow(int socket, char *user)
{
  char prefix[] = "goto ";
  char *msg2;
  return;
  oasprintf(&msg2, "%s%s", prefix, user);
  ycmd(socket, 0x71, msg2, strlen(msg2));
  free(msg2);
}

void yping(char *s)
{
#ifdef DEBUG
	debug_message("/ping is null command");
#endif /* DEBUG */
}
#endif /* __USE_YMSG__ */
