/*
 $Header: /cvsroot/overdose/overdose/ymskdef.h,v 1.2 2006/03/24 16:54:28 segin Exp $
   
ymskdef.h
Copyright (c) 2006, Alex Mercader
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

  * Redistributions of source code must retain the above copyright notice,this
    list of conditions and the following disclaimer.

  * Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/

#define YMSKVER "YMSK v0.2"
#define HDRLEN 16
#define OBUF 512
#define MYBUF OBUF-HDRLEN
#define CMDLEN MYBUF+1
#define PROMPT1  "/> "
#define PROMPT2  "%> "
#define NAMELEN 64
#define PASSWDLEN 64
#define ROOMLEN 64
#define LINELEN 128
#define RCFILE ".ymskrc"
#define CHATSERVER "jcs.chat.dcn.yahoo.com"
#define CHATPORT 8001
#define LOGINPKT 0x01
#define COMMENTPKT 0x41
#define EMOTEPKT 0x43
#define ENTERPKT 0x11
#define EXITPKT 0x12

typedef struct {
	char *name;
	char *password;
	char *cookie;
	char command[CMDLEN];
}yuser_t;

struct luser {
	char *name;
	struct luser *next;  /* pointer to next entry */
	struct luser *prev;  /* pointer to previous record */
};

typedef struct chat {
	struct luser *firstuser;
	struct luser *lastuser;
	struct luser *firstignore;
	struct luser *lastignore;
	yuser_t *user;
	char *room;
	int sckt;
	int quit;
	char bufout[OBUF+sizeof(short)+1];
}chat_t;

typedef struct {
	int pcktid;
	int errflag;
	int ignore;
	char *data;
	char *val[4];
}msg_t;

















