/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;


   /* ... Class ......................................................... */


      public class cStreamCharSet
      {

          // inside data
          BufferedInputStream bis ;
          String blanks ;


          // methods
          public cStreamCharSet ( BufferedInputStream bis )
          {
            this.bis    = bis ;
            this.blanks = " \t\r\n" ;
          }

          public cStreamCharSet ( BufferedInputStream bis,
                                  String              blanks )
          {
            this.bis    = bis ;
            this.blanks = blanks ;
          }


          public boolean isBlank ( char ch )
          {
            int i ;

            for (i=0; i<blanks.length(); i++)
                {
                  if (blanks.charAt(i) == ch)
                      return true ;
                }
            return false ;
          }

          public int skipBlanks ( )
          {
            int b ;

            try
            {
              do
              {
                b = bis.read() ;
              } while (
                        (b != -1)
                           &&
                        ( isBlank((char)b) )
                      ) ;
            }
            catch ( Exception e )
            {
              b = -1 ;
            }
            return b ;
          }

          public int skipTillBlanks ( )
          {
            int b ;

            try
            {
              do
              {
                b = bis.read() ;
              } while (
                        (b != -1)
                           &&
                        (! isBlank((char)b) )
                      ) ;
            }
            catch ( Exception e )
            {
              b = -1 ;
            }
            return b ;
          }

          public int skipTillChar ( char ch )
          {
            int b ;

            try
            {
              do
              {
                b = bis.read() ;
              } while (
                              (b != -1)
                                 &&
                        ((char)b != ch)
                      ) ;
            }
            catch ( Exception e )
            {
              b = -1 ;
            }
            return b ;
          }

          public boolean strcmp ( String str )
          {
            int i, b ;

            try
            {
              bis.mark(str.length()+1) ;
                    // ^ (str.length()+1) => when mark will be invalid
              for (i=0; i<str.length(); i++)
              {
                b = bis.read() ;
                if (b == -1)
                   {
                     bis.reset() ;       
                     return false ;
                   }
                if ((char)b != str.charAt(i))
                   {
                     bis.reset() ;
                     return false ;
                   }
              }
            }
            catch ( Exception e )
            {
              try
              {
                bis.reset() ;
              }
              catch ( Exception e1 )
              {
              }
              return false ;
            }
            return true ;
          }

          public String readStrTillBlanks ( )
          {
            StringBuffer str ;
            int b ;

            str = new StringBuffer() ;
            try
            {
              b = bis.read() ;
              while (
                      (b != -1)
                         &&
                      (! isBlank((char)b) )
                    )
              {
                str.append((char)b) ;
                b = bis.read() ;
              }
            }
            catch ( Exception e )
            {
            }
            return new String(str) ;
          }

          public String readStrBetween ( char beginChar,
                                         char endChar )
          {
            StringBuffer str ;
            int b ;

            str = new StringBuffer() ;
            try
            {
              b = skipTillChar(beginChar) ;
              if (b == -1)
                  return null ;
              b = bis.read() ;
              while (
                      (b != -1)
                         &&
                      ((char)b != endChar)
                    )
              {
                str.append((char)b) ;
                b = bis.read() ;
              }
            }
            catch ( Exception e )
            {
            }
            return new String(str) ;
          }

          public  int skipTillToken  ( String  tarray[] )
          {
            int     b, j, ltoken ;
            String  rtoken ;

            try
            {
              b = skipBlanks() ;
              while (b != -1)
              {
                for (j=0; j<tarray.length; j++)
                {
                  if ((char)b == tarray[j].charAt(0))
                     {
                       ltoken = tarray[j].length() ;
                       rtoken = tarray[j].substring(1,ltoken) ;
                       if (strcmp(rtoken) == true)
                          {
                            return j ;
                          }
                     }
                }
                b = skipTillBlanks() ;
                if (b != -1)
                    b = skipBlanks() ;
              }
            }
            catch ( Exception e )
            {
              return -1 ;
            }
            return -1 ;
          }

      }  // cStreamCharSet


  /* ................................................................... */
