/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.app.* ;
      import wtool.vp.* ;


   /* ... Class ......................................................... */


      public class cUrlShadow
      {
         cUrl           url ;


         // constructor
         public cUrlShadow ( )
         {
           this.url = null ;
         }

         public cUrlShadow ( cUrl url )
         {
           this.url = url ;
         }


         // accesors
         public cUrl getCURL ( )
         {
           return url ;
         }


         // operations
         public File getFile ( boolean useFullPath )
         {
           File   fileShadow ;
           String fileName, filePath ;

           fileName   = url.getURL().getFile() ;
           fileName   = fileName.replace('/',java.io.File.separatorChar) ;
           fileShadow = new File(fileName) ;
           fileName   = fileShadow.getName() ;
           filePath   = fileShadow.getParent() ;
           if (filePath == null)
               filePath = "" ;
           if (fileName.equals("") == true)
               fileName = "index.html" ;

           if (useFullPath == true)
              {
                fileName   = url.getURL().getHost() + filePath + "/" + fileName ;
                fileName   = fileName.replace('/',java.io.File.separatorChar) ;
              }

           fileShadow = new File (fileName) ;
           return fileShadow ;
         }

         public boolean shadowToLFS ( File fo )
         {
           boolean        ok ;
           cIdent         identification ;
           OutputStream   os ;
           PrintStream    fpage ;
           cVpUrl         dagent ;

           try
           {
             // init values ...
             ok      = false ;
             os      = new FileOutputStream(fo) ;
             fpage   = new PrintStream(os) ;
             identification = url.getIdentification() ;

             // download ...
             dagent  = new cVpUrl() ;
             ok      = dagent.DownLoadUrl(fpage,url,identification) ;

             // end ...
             dagent = null ;
             fpage  = null ;
             os     = null ;
             return ok ;
           }
           catch ( Exception e )
           {
             return false ;
           }
         }

      }  // cUrlShadow


   /* ................................................................... */

