/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.util.* ;

      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cWorkSpace
      {

         Properties currentWS ;


         public cWorkSpace ( )
         {
           currentWS = new Properties() ;
         }

         public cWorkSpace ( String defaultPropertiesFileName )
         {
           try
           {
             Properties defaultWS ;

             // load default values
             defaultWS = new Properties() ;
       	     FileInputStream in = new FileInputStream(defaultPropertiesFileName) ;
             defaultWS.load(in) ;
	           in.close() ;

             // copy into 'currentWS'
             currentWS = new Properties(defaultWS) ;
           }
           catch ( Exception e )
	         {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
	         }
         }

         public cWorkSpace ( String defaultPropertiesFileName,
		             String resumePropertiesFileName )
         {
           try
           {
             Properties defaultWS ;

             // load default values
             defaultWS = new Properties() ;
       	     FileInputStream in = new FileInputStream(defaultPropertiesFileName) ;
             defaultWS.load(in) ;
	           in.close() ;

             // copy into 'currentWS'
             currentWS = new Properties(defaultWS) ;

             // overwrite with resume properties
      	     in = new FileInputStream(resumePropertiesFileName);
	           currentWS.load(in);
       	     in.close();
           }
           catch ( Exception e )
      	   {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
      	   }
         }


         public void resume ( String resumePropertiesFileName )
         {
           try
           {
             FileOutputStream out ;
             String msg ;

             // save 'currentWS'
             msg = new String("") ;
      	     out = new FileOutputStream(resumePropertiesFileName) ;
             currentWS.save(out,msg) ;
             out.close() ;
           }
           catch ( Exception e )
      	   {
             appLog.system.print( "(" + this + ")" + e ) ;
             e.printStackTrace() ;
      	   }
         }

         public void putProperty ( String key, 
                                   Object value )
         {
           currentWS.put(key,value) ;
         }

         public String getProperty ( String key )
         {
           return currentWS.getProperty(key).toString() ;
         }

      }


   /* ................................................................... */

