/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.base ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.util.zip.* ;

      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cZipStore
      {

          // const
          final int BUFF_SIZE = 4 * 1024 ;


          // inside data
          byte[]    iobuffer ;
          File              fo ;
          FileOutputStream  os ;
          ZipOutputStream   zos ;


          // methods
          public cZipStore ( String zipFName )
          {
            try
            {
              iobuffer = new byte[BUFF_SIZE] ;
              fo  = new File(zipFName) ;
              os  = new FileOutputStream(fo) ;
              zos = new ZipOutputStream(os) ;
              zos.setComment("by WebCopy -") ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

          public void addFile ( String fname,
                                String lname )
          {
            FileInputStream     is ;
            BufferedInputStream bis ;
            ZipEntry  ze ;
            int       ret ;

            try
            {
              // per zip entry ...
              is  = new FileInputStream(lname) ;
              bis = new BufferedInputStream(is) ;
              ze  = new ZipEntry(fname) ;

              // insert entry in zip file ...
              zos.putNextEntry(ze) ;
              ret = bis.read(iobuffer,0,iobuffer.length) ;
              while (ret != -1)
              {
                zos.write(iobuffer,0,ret) ;
                ret = bis.read(iobuffer,0,iobuffer.length) ;
              }
              zos.closeEntry() ;

              // end zip entry ...
              is.close() ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

          public void finish ( )
          {
            try
            {
              zos.close() ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      } // cZipStore


  /* ................................................................... */
