/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.bin ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;
      import java.awt.*;
      import java.awt.*;
      import java.awt.event.*;
      import java.awt.datatransfer.*;

      import wtool.base.* ;
      import wtool.app.* ;
      import wtool.spider.* ;


   /* ... Class ......................................................... */


      public
      class cSpiderBotLauncher
            extends    Frame
            implements ActionListener
      {
         /**
          *
          *   Atributos
          *
          */
        TextField    urlTextField ;
        Label        urlLabel ;
        Checkbox     recursiveCheck, overwriteCheck ;
        Button       okButton, cancelButton, exitButton ;
        Panel        panel1, panel2, panel3 ;


        // constructors
        public cSpiderBotLauncher ( )
        {
          super("Spider Options...");
          try
          {
            sblInit() ;
          }
          catch (Exception e)
          {
            e.printStackTrace() ;
          }
        }

        private void sblInit( )
                throws Exception
        {
            // pannel layout ...
            this.setTitle("Spider Options") ;
            GridBagLayout gridbag = new GridBagLayout() ;
            GridBagConstraints c  = new GridBagConstraints() ;
            this.setLayout(gridbag) ;
            this.setSize(new Dimension(400,300)) ;


            // Flags ...
            panel1 = new Panel() ;
            panel1.setLayout(new GridBagLayout()) ;
            panel1.setBackground(Color.gray) ;
            c.gridx = 0 ;
            c.gridy = 1 ;
            c.gridwidth = 2 ;
            gridbag.setConstraints(panel1, c) ;
            this.add(panel1) ;

               // Checkboxes
               recursiveCheck = new Checkbox("",true) ;
               recursiveCheck.setLabel("recursive");
               c.gridx = 0 ;
               c.gridy = 1 ;
               c.gridwidth = 1 ;
               gridbag.setConstraints(recursiveCheck, c) ;
               panel1.add(recursiveCheck) ;

               overwriteCheck = new Checkbox("",true) ;
               overwriteCheck.setLabel("overwrite");
               c.gridx = 0 ;
               c.gridy = 2 ;
               c.gridwidth = 1 ;
               gridbag.setConstraints(overwriteCheck, c) ;
               panel1.add(overwriteCheck);


            // Host ...
            panel2 = new Panel() ;
            panel2.setLayout(new GridBagLayout()) ;
            c.gridx = 0 ;
            c.gridy = 2 ;
            c.gridwidth = 2 ;
            gridbag.setConstraints(panel2, c) ;
            this.add(panel2) ;

               // url
               urlLabel     = new Label() ;
               urlLabel.setText("Enter url");
               c.gridx = 0 ;
               c.gridy = 2 ;
               c.gridwidth = 1 ;
               c.anchor = GridBagConstraints.CENTER ;
               gridbag.setConstraints(urlLabel, c) ;
               panel2.add(urlLabel) ;

               urlTextField = new TextField() ;
               urlTextField.setColumns(64);
               c.gridx = 1 ;
               c.gridy = 2 ;
               c.gridwidth = 2 ;
               c.anchor = GridBagConstraints.CENTER ;
               gridbag.setConstraints(urlTextField, c) ;
               panel2.add(urlTextField) ;


            // Ok/Cancel ...
            panel3 = new Panel() ;
            panel1.setBackground(Color.gray) ;
            panel3.setLayout(new GridBagLayout()) ;
            c.gridx = 0 ;
            c.gridy = 3 ;
            c.gridwidth = 2 ;
            gridbag.setConstraints(panel3, c) ;
            this.add(panel3) ;

               // ok
               okButton = new Button("Ok");
               okButton.setLabel("ok");
               okButton.setActionCommand("ok");
               okButton.addActionListener(this);
               c.gridx = 1 ;
               c.gridy = 3 ;
               c.gridwidth = 1 ;
               gridbag.setConstraints(okButton, c);
               panel3.add(okButton);

               // cancel
               cancelButton = new Button("Cancel");
               cancelButton.setLabel("cancel");
               cancelButton.setActionCommand("cancel");
               cancelButton.addActionListener(this);
               c.gridx = 2 ;
               c.gridy = 3 ;
               c.gridwidth = 1 ;
               gridbag.setConstraints(cancelButton, c);
               panel3.add(cancelButton);

               // exit
               exitButton = new Button("Exit");
               exitButton.setLabel("exit");
               exitButton.setActionCommand("exit");
               exitButton.addActionListener(this);
               c.gridx = 3 ;
               c.gridy = 3 ;
               c.gridwidth = 1 ;
               gridbag.setConstraints(exitButton, c);
               panel3.add(exitButton);


            // pack componets ...
            this.pack();
        }
                            
        public void actionPerformed ( ActionEvent evt )
        {
            String cmd = evt.getActionCommand() ;

            if (cmd.equals("ok"))
            {
               String url ;
               cSpiderBotRocketControl sbc ;
               boolean  recursiveFlag, overwriteFlag ;


               url    = urlTextField.getText() ;
               recursiveFlag = recursiveCheck.getState() ;
               overwriteFlag = overwriteCheck.getState() ;

               if (url.length() == 0)
                   System.out.print("\t" + "unknow resource locator! " + "\n") ;

               if (url.length() != 0)
                  {
                    sbc = new cSpiderBotRocketControl(url,recursiveFlag,overwriteFlag) ;
                    sbc.show() ;
                  }
            }
            else if (cmd.equals("cancel"))
            {
               // cancel ...
               urlTextField.setText("") ;
               recursiveCheck.setState(false) ;
               overwriteCheck.setState(false) ;
               appLog.user.println("canceled ...") ;
            }
            else if (cmd.equals("exit"))
            {
               // exit ...
               appLog.user.println("exiting ...") ;
               System.exit(0) ;
            }
        }

      }


   /* ................................................................... */


