/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.bin ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;
      import java.awt.*;
      import java.awt.*;
      import java.awt.event.*;
      import java.awt.datatransfer.*;

      import wtool.base.* ;
      import wtool.app.* ;
      import wtool.spider.* ;


   /* ... Class ......................................................... */


      public
      class cSpiderBotRocketControl
	    extends    Frame
            implements ActionListener
      {
         /**
          *
          *   Atributos
          *
          */
        // ui
        Button               cancelButton, continueButton ;
        cSpiderBotRocketLog  sbLog ;
        // thread
        Thread  sbThread ;
        boolean isStopped ;


        // constructor ...
        public cSpiderBotRocketControl ( String  url,
                       		         boolean recursive,
                       		         boolean overwrite )
        {
            try
            {
              // show params ...
              System.out.print("\n") ;
              System.out.print("\toptions :" + "\n") ;
              System.out.print("\t\t-" + "from url " + url + "\n") ;
              if (recursive == true)
                  System.out.print("\t\t-" + "explore links " + "\n") ;
              if (overwrite == true)
                  System.out.print("\t\t-" + "overwrite old files" + "\n") ;

              // user interface
              setTitle(url) ;
              sbrInit() ;

              // thread
              sbThread = new cSpiderBotRocket(this,url,recursive,overwrite) ;
              sbThread.start() ;
              isStopped = false ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
        }

        // user interface ...
        private void sbrInit( )
                throws Exception
        {
            // pannel layout ...
            this.setLayout(new FlowLayout()) ;
            this.setSize(new Dimension(600,400)) ;


            // progress ...
            sbLog = new cSpiderBotRocketLog(this) ;
            appLog.user = sbLog ;
            appLog.system = sbLog ;
            appLog.program = sbLog ;


            // Cancel ...
            cancelButton = new Button("Cancel");
            cancelButton.setLabel("cancel");
            cancelButton.setActionCommand("cancel");
            cancelButton.addActionListener(this);
            this.add(cancelButton);


            // Continue ...
            continueButton = new Button("Continue");
            continueButton.setLabel("Continue");
            continueButton.setActionCommand("continue");
            continueButton.addActionListener(this);
            this.add(continueButton);


            // pack componets ...
            this.pack();
            continueButton.setVisible(false) ;
        }
                            
        public void actionPerformed ( ActionEvent evt )
        {
            String cmd = evt.getActionCommand() ;

            if (cmd.equals("cancel"))
            {
               if (isStopped == false)
                  {
                    this.cancelButton.setLabel("close");
                    this.continueButton.setVisible(true) ;
                    this.validate() ;
                    this.isStopped = true ;
                    this.sbThread.suspend() ;
                  }
               else 
                  {
                    this.sbThread.stop() ;
                    this.dispose() ;
                  }
            }
            if (cmd.equals("continue"))
            {
               this.isStopped = false ;
               this.continueButton.setVisible(false) ;
               this.cancelButton.setLabel("cancel");
               this.sbThread.resume() ;
            }
        }

      }  // cSpiderBotRocketControl


  /* ................................................................... */
