/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.bin ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;
      import wtool.spider.* ;


   /* ... Class ......................................................... */


      class wdir
      {
         /**
          *
          *   Atributos
          *
          */


         /**
          *
          *  Print a welcome intro
          *
          *     @params wVer version
          *     @return nothing
          *
          */
          public static void welcome ( cVersion wVer )
          {
            System.out.print( "\n" +
                              wVer +
                              "\n" ) ;
          }

         /**
          *
          *  Print goodbye ...
          *
          *     @params wName program name
          *     @return nothing
          *
          */
          public static void goodbye ( String wName )
          {
            System.out.print( "\n" +
                              "\n" +
                              "\t" + "thanks for use " + wName + "\n" +
                              "\n" ) ;
          }

          /**
           *
           *   wdir  <url>
           *         like ls (unix) or dir (dos), present information of
           *         <url> and links its point.
           *
           */
          public static void main ( String args [] )
          {
            // spider
            cSpider     sbot ;
            cWorkSpace  spiderWS ;
            // wdir
            cVersion    wdirVer ;
            cWlsParams  wdirPar ;


            try
            {
              // new Objects
              wdirVer    = new cVersion(0,11,3,
                                       "acaldero@laurel.datsi.fi.upm.es",
                                       "wdir") ;
              welcome(wdirVer) ;
              wdirPar   = new cWlsParams(args,1) ;
              spiderWS  = new cWorkSpace() ;

              // get params ...
              spiderWS.putProperty("fromUrl",args[0]) ;
              if ( wdirPar.getValue("-r") == null )
                        spiderWS.putProperty("recursive","false") ;
                   else spiderWS.putProperty("recursive","true") ;
              if ( wdirPar.getValue("-l") == null )
                        spiderWS.putProperty("shortInfo","true") ;
                   else spiderWS.putProperty("shortInfo","false") ;

              // wdir
              sbot = new cListSpider(spiderWS) ;
              sbot.walk() ;
              goodbye("wdir") ;
              System.exit(0) ;
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      }  // wdir


  /* ................................................................... */

