/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.spider ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cListSpider extends cSpider
      {

          cUrl     urlFrom ;
          String   resumeFile ;
          boolean  shortInfo, zeroLevel ;


          public cListSpider ( )
          {
            super() ;
            urlFrom    = null ;
            resumeFile = null ;
            shortInfo  = true ;
            zeroLevel  = false ;
          }

          public cListSpider ( cWorkSpace spiderWS )
          {
            super(spiderWS) ;

            try
            {
              String value ;
              String sUrlFrom ;

              // url
              value    = spiderWS.getProperty("fromUrl") ;
              sUrlFrom = new String(value   ) ;
              urlFrom  = new cUrl(sUrlFrom) ;

              // resumeFile
              value      = urlFrom.getURL().getHost() ;
              resumeFile = new String("resume." + value) ;

              // shortInfo
              value     = spiderWS.getProperty("shortInfo") ;
              shortInfo = (value.equalsIgnoreCase("TRUE")) ;

              // zeroLevel
              value     = spiderWS.getProperty("recursive") ;
              zeroLevel = (value.toString().equalsIgnoreCase("FALSE")) ;
            }
            catch ( Exception e )
            {
            }
          }


          public void walk ( )
          {
            boolean      ok ;
            File         f ;
            int          irI, lastI ;
            cUrl         rI ;
            cUrlList     rL ;
            cUrlShadow   rS ;


            try
            {
              rL = new cUrlList() ;
              rL.insert(urlFrom) ;

              // go download ...
              rI    = rL.getFirst() ;
              irI   = 0 ;
              lastI = 0 ;
              while (rI != null)
              {
                irI ++ ;
                if (shortInfo == false)
                   {
                     appLog.user.print
                     (
                       "\r" + "[" + irI + "/" + rL.length() + "]" + "\t"
                     ) ;
                     rS = new cUrlShadow(rI) ;
                     f  = rS.getFile(false) ;
                     ok = rS.shadowToLFS(f) ;
                     if (ok == true)
                        {
                          exploreURL(f,rL,rI.getURL()) ;
                          rI.info(System.out) ;
                          rL.info(System.out,false,lastI) ;
                          lastI = rL.length() ;
                        }
                     appLog.user.print("\n") ;
                   }
                else // (shortInfo == true)
                   {
                     rS = new cUrlShadow(rI) ;
                     f  = rS.getFile(false) ;
                     ok = rS.shadowToLFS(f) ;
                     if (ok == true)
                        {
                          exploreURL(f,rL,rI.getURL()) ;
                          lastI = rL.length() ;
                        }
                   }
                f.delete() ;
                if (zeroLevel == true)
                    break ; // no more

                rI = rL.getNext() ;
              }
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      }  // ListSpider


  /* ................................................................... */

