/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.spider ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;
      import java.util.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cMirrorSpider extends cSpider
      {

          cUrl     urlFrom ;
          String   mirrorDir, resumeFile ;
          boolean  overWrite, zeroLevel ;


          public cMirrorSpider ( )
          {
            super() ;
            urlFrom    = null ;
            mirrorDir  = null ;
            resumeFile = null ;
            overWrite  = false ;
            zeroLevel  = false ;
          }                            

          public cMirrorSpider ( cWorkSpace spiderWS )
          {
            super(spiderWS) ;

            try
            {
              String value ;
              String sUrlFrom ;

              // url
              value    = spiderWS.getProperty("fromUrl") ;
              sUrlFrom = new String(value) ;
              urlFrom  = new cUrl(sUrlFrom) ;

              // mirrorDir
              value      = urlFrom.getURL().getHost() ;
              mirrorDir = new String(value) ;

              // resumeFile
              value      = urlFrom.getURL().getHost() ;
              resumeFile = new String("resume." + value) ;

              // overwrite
              value     = spiderWS.getProperty("overwrite") ;
              overWrite = (value.equalsIgnoreCase("TRUE")) ;

              // zeroLevel
              value     = spiderWS.getProperty("recursive") ;
              zeroLevel = (value.equalsIgnoreCase("FALSE")) ;
            }
            catch ( Exception e )
            {
            }
          }


          public void walk ( )
          {
            boolean      ok ;
            File         f ;
            int          irI ;
            cUrl         rI ;
            cUrlList     rL ;
            cUrlShadow   rS ;

            try
            {
              rL = new cUrlList() ;
              rL.insert(urlFrom) ;

              // go download ...
              rI  = rL.getFirst() ;
              irI = 0 ;
              while (rI != null)
              {
                irI ++ ;
                appLog.user.print
                (
                  "\r" + "[" + irI + "/" + rL.length() + "]" + "\t"
                ) ;
		            rS = new cUrlShadow(rI) ;
                f  = rS.getFile(true) ;
                if (
                     (overWrite == true)
                              ||
                     (f.exists() == false)
                   )
                   {
                     String dirName ;

                     dirName = f.getParent() ;
                     dirName = dirName.replace('/',java.io.File.separatorChar) ;
                     File fdir = new File(dirName) ;
                     if (fdir.isFile() == true)
                         fdir.delete() ;
                     fdir.mkdirs() ;
                     ok = rS.shadowToLFS(f) ;
                     if (ok == true)
                        {
                          if (zeroLevel == false)
                              exploreURL(f,rL,rI.getURL()) ;
                        }
                   }
                   else // at local file system ...
                   {
                     appLog.user.print
                     (
                       "\t" + f
                     ) ;
                     if (zeroLevel == false)
                         exploreURL(f,rL,rI.getURL()) ;
                   }

                rI = rL.getNext() ;
              }
            }
            catch ( Exception e )
            {
              appLog.system.print( "(" + this + ")" + e ) ;
              e.printStackTrace() ;
            }
          }

      }  // cMirrorSpider


  /* ................................................................... */


