/* ........................................................................
 *
 * Copyright Alejandro Calderon (1997-1998)
 * <acaldero@laurel.datsi.fi.upm.es>
 *
 * permission is hereby granted to copy, modify and redistribute this code
 * in terms of the GNU Library General Public License, Version 2 or later,
 * at your option.
 *
 * ........................................................................ */



   /* ... Package ....................................................... */

      package wtool.vp ;


   /* ... Import ........................................................ */

      import java.lang.* ;
      import java.io.* ;
      import java.net.* ;

      import wtool.base.* ;
      import wtool.app.* ;


   /* ... Class ......................................................... */


      public class cVpUrl
      {

        public cVpUrl ( )
        {
        }

        public void copyToFile ( cSocket     inPage,
                                 PrintStream fpage )
        throws IOException 
        {
          byte[] buffer ;
          int    off, br ;

          off = 0 ;
          buffer = new byte[4 * 1024] ;
          br = inPage.read(buffer,0,buffer.length) ;
          while ( br != -1 )
          {
            fpage.write(buffer,0,br) ;
            off = off + br ;
            appLog.user.print( "\r" +
                               "[" + off + "]" ) ;
            br = inPage.read(buffer,0,buffer.length) ;
          }
          appLog.user.print( "\r" +
                             "                                 " +
                             "\r" ) ;
        }

        public int  copyToFile ( DataInputStream   dis,
                                 PrintStream       fpage,
                                 int               contentLength )
        throws IOException
        {
          byte[] buffer ;
          int    nread, nwrite ;

          nwrite = 0 ;
          buffer = new byte[4 * 1024] ;
          nread  = dis.read(buffer,0,buffer.length) ;
          while (nread != -1)
          {
            fpage.write(buffer,0,nread) ;
            nwrite = nwrite + nread ;
            if (contentLength == -1)
                     appLog.user.print( "\r" +
                                        "[" + nwrite + "/unknow]" ) ;
                else appLog.user.print( "\r" +
                                        "[" + nwrite + "/" + contentLength + "]" ) ;
            nread  = dis.read(buffer,0,buffer.length) ;
          }
          appLog.user.print( "\r" +
                             "                                 " + "\r" ) ;
          return nwrite ;
        }

        public void copyLinesToFile ( cSocket     inPage,
                                      PrintStream fpage )
        throws IOException 
        {
          String  line ;
          int     off ;

          off  = 0 ;
          line = inPage.readLine() ;
          while (
                  ( line != null )
                         &&
                  ( cLine.isEnter(line) == false )
                )
          {
            fpage.print(line) ;
            off = off + line.length() ;
            appLog.user.print( "\r" +
                               "[" + off + "]" ) ;
            line = inPage.readLine() ;
          }
          appLog.user.print( "\r" +
                             "                                 " +
                             "\r" ) ;
        }

        public boolean NativeDownLoadUrl  ( PrintStream  fpage,
                                            cUrl         url,
                                            cIdent       identification )
        {
          InputStream       is ;
          DataInputStream   dis ;
          int               contentLength ;
          URLConnection     urlc ;

          try
          {
            // input staff ...
            urlc = url.getURL().openConnection() ;
            is   = urlc.getInputStream() ;
            dis  = new DataInputStream(is) ;
            contentLength = urlc.getContentLength() ;

            // read/write ...
            appLog.user.print( contentLength + "\t" + url + "\n" ) ;
            contentLength = this.copyToFile(dis,fpage,contentLength) ;
            is.close() ;
            return true ;
          }
          catch ( Exception e )
          {
            appLog.system.println( "(" + this + ")" + e ) ;
            return false ;
          }
        }

        public boolean DownLoadUrl  ( PrintStream  fpage,
                                      cUrl         url,
                                      cIdent       identification )
        {
          if (url.getURL().getProtocol().equalsIgnoreCase("POP3") == true)
             {
               return new cPop3Url().DownLoadUrl(fpage,url,identification) ;
             }
          return this.NativeDownLoadUrl(fpage,url,identification) ;
        }

      }


   /* ................................................................... */



