/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Bind;
import Sav.Processor.Binder;
import Sav.Processor.Hub;
import Sav.Processor.IncompatibleDataException;
import Sav.Processor.Int1;
import Sav.Processor.NonReadableFileException;
import Sav.Processor.NonWritableFileException;
import Sav.Processor.OldVersionException;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class AssFile {
    static int spaceMax = 8181;
    int number;
    Hub hub;
    boolean isTemporary;
    boolean modify;
    File file;
    RandomAccessFile raf;
    Bind bind;
    int endAddress = 0;
    int spaceAddress = -1;
    Trace space;
    Trace spaceEnd;
    int spaceContinue;
    boolean changed;

    AssFile(Hub hub) {
        this.hub = hub;
        this.isTemporary = true;
        this.modify = true;
        this.bind = new Bind();
        this.bind.af = this;
        this.spaceEnd = this.space = new Trace();
    }

    AssFile(Hub hub, String string, boolean bl) throws IOException {
        this.hub = hub;
        this.file = new File(string);
        this.modify = bl;
        if (this.file.exists()) {
            if (bl && !this.file.canWrite()) {
                throw new NonWritableFileException(string);
            }
            if (!bl && !this.file.canRead()) {
                throw new NonReadableFileException(string);
            }
        }
        this.open();
    }

    void open() throws IOException {
        if (this.bind != null) {
            return;
        }
        Binder.open(this);
        this.spaceEnd = this.space = new Trace();
        if (this.file == null || !this.file.exists()) {
            return;
        }
        this.endAddress = (int)(this.file.length() - (long)32 >> 13);
        if (!this.modify) {
            this.raf = new RandomAccessFile(this.file, "r");
        } else {
            this.raf = new RandomAccessFile(this.file, "rw");
            if (this.endAddress <= 1) {
                this.spaceAddress = 0;
            }
        }
        byte[] byArray = new byte[32];
        this.raf.seek(0L);
        if (this.raf.read(byArray) < 32) {
            throw new EOFException("");
        }
        int n = 13;
        if (!new String(byArray, 0, n).equals("Sav Processor")) {
            this.raf.close();
            throw new IncompatibleDataException();
        }
        n = 14;
        String string = new String(byArray, n, 3);
        if (string.compareTo("4.2") < 0) {
            this.raf.close();
            throw new OldVersionException(new String(byArray, 0, n + 3));
        }
    }

    void open(boolean bl) throws IOException {
        if (this.modify != bl) {
            this.close();
            this.modify = bl;
            if (this.file != null && this.file.exists()) {
                if (bl && !this.file.canWrite()) {
                    throw new NonWritableFileException(this.file.getPath());
                }
                if (!bl && !this.file.canRead()) {
                    throw new NonReadableFileException(this.file.getPath());
                }
            }
        }
        this.open();
    }

    void close() throws IOException {
        if (this.bind == null) {
            return;
        }
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            this.spaceAddress = -1;
            this.endAddress = 0;
            this.spaceContinue = 0;
            this.spaceEnd = this.space = null;
        }
        Binder.close(this);
        this.changed = false;
    }

    boolean delete() throws IOException {
        this.close();
        if (this.file == null || !this.file.exists()) {
            return true;
        }
        if (!this.file.delete()) {
            return false;
        }
        if (this.isTemporary) {
            Trace trace = PN.tempAssHold;
            synchronized (trace) {
                if (this.number == PN.tempAssNum) {
                    --PN.tempAssNum;
                } else {
                    Trace trace2 = new Trace(this.number);
                    trace2.next = PN.tempAssHold.next;
                    PN.tempAssHold = trace2;
                }
                this.number = 0;
            }
        }
        return true;
    }

    byte[] read(int n) throws IOException {
        if (this.raf == null) {
            return null;
        }
        byte[] byArray = new byte[8192];
        if (n == 0) {
            byte[] byArray2 = new byte[3];
            this.raf.seek(0L);
            if (this.raf.read(byArray2) < 3) {
                throw new EOFException("address == ".concat(String.valueOf(String.valueOf(n))));
            }
            int n2 = 0;
            if (byArray2[n2++] != 83 || byArray2[n2++] != 97 || byArray2[n2] != 118) {
                throw new IOException();
            }
        }
        long l = ((long)n << 13) + (long)32;
        this.raf.seek(l);
        if (this.raf.read(byArray) < 8192) {
            throw new EOFException("address == ".concat(String.valueOf(String.valueOf(n))));
        }
        return byArray;
    }

    void free(int n) {
        Trace trace = null;
        Trace trace2 = this.space;
        while (trace2.next != null && trace2.next.mark <= n) {
            trace = trace2;
            trace2 = trace2.next;
        }
        Trace trace3 = new Trace();
        if (trace2 == this.space) {
            trace2.mark = n;
            trace3.next = trace2;
            this.space = trace3;
        } else if (trace2.next == null) {
            trace3.mark = n;
            trace2.next = trace3;
            this.spaceEnd = trace3;
        } else {
            trace3.mark = n;
            trace3.next = trace2.next;
            trace.next = trace3;
        }
        this.changed = true;
    }

    void startSaving() throws IOException {
        Object object;
        if (this.spaceAddress >= 0) {
            return;
        }
        if (this.file == null) {
            Trace trace = PN.tempAssHold;
            synchronized (trace) {
                do {
                    if (PN.tempAssHold.next != null) {
                        object = PN.tempAssHold.next;
                        PN.tempAssHold.next = ((Trace)object).next;
                        this.number = ((Trace)object).mark;
                    } else {
                        this.number = ++PN.tempAssNum;
                    }
                    object = System.getProperty("java.io.tmpdir");
                    if (object == null) {
                        object = "Temp";
                    }
                    File file = new File((String)object);
                    file.mkdirs();
                    this.file = new File(file, String.valueOf(String.valueOf(new StringBuffer("~").append(this.number).append(".ass"))));
                } while (this.file.exists() && !this.file.delete());
            }
        }
        if (this.raf == null) {
            if (!this.file.exists()) {
                String string;
                char c = File.separatorChar;
                object = null;
                object = this.file.getPath();
                int n = c == '/' ? ((String)object).lastIndexOf(92) : ((String)object).lastIndexOf(47);
                if (n >= 0) {
                    object = c == '/' ? ((String)object).replace('\\', c) : ((String)object).replace('/', c);
                    this.file = new File((String)object);
                }
                if ((string = this.file.getParent()) != null) {
                    File file = new File(string);
                    file.mkdirs();
                }
            }
            this.raf = new RandomAccessFile(this.file, "rw");
            if (this.file.length() == (long)0) {
                String string = "Sav Processor 4.2, ";
                this.raf.writeBytes(string);
                this.raf.seek(28L);
                this.raf.writeInt(282624);
            }
        }
        this.openSpace();
    }

    void openSpace() throws IOException {
        this.spaceAddress = 0;
        if (this.endAddress <= 1) {
            return;
        }
        this.openSpace(this.endAddress - 1);
    }

    void openSpace(int n) throws IOException {
        this.raf.seek(((long)n << 13) + (long)32);
        byte[] byArray = new byte[8192];
        if (this.raf.read(byArray) < 8192) {
            throw new EOFException("address == ".concat(String.valueOf(String.valueOf(n))));
        }
        Int1 int1 = new Int1(0);
        PN.readSize(byArray, 0, int1);
        int n2 = 2 + int1.value;
        if (n2 >= 8192 || byArray[n2] == 0) {
            return;
        }
        int n3 = 2;
        Int1 int12 = new Int1(0);
        while (n3 < n2) {
            n3 = PN.readAddress(byArray, n3, int12);
            this.spaceEnd = this.spaceEnd.next = new Trace(int12.value);
        }
        n3 = PN.readAddress(byArray, n3, int12);
        this.spaceContinue = int12.value;
        PN.readAddress(byArray, n3, int12);
    }

    void stopSaving() throws IOException {
        if (!this.changed) {
            return;
        }
        if (this.spaceAddress == 0) {
            this.spaceAddress = this.endAddress++;
        }
        this.closeSpace();
        this.changed = false;
    }

    void closeSpace() throws IOException {
        Trace trace = this.space;
        this.closeSpace(this.spaceAddress);
        if (this.space.next == null) {
            this.space = trace;
            return;
        }
        Trace trace2 = this.space;
        int n = this.space.next.mark;
        while (this.space.next != null) {
            this.space = this.space.next;
            this.closeSpace(this.space.mark);
        }
        this.spaceContinue = n;
        this.space = trace;
        trace2.next = null;
    }

    void closeSpace(int n) throws IOException {
        byte[] byArray = new byte[8192];
        int n2 = 2;
        while (n2 < spaceMax && this.space.next != null) {
            this.space = this.space.next;
            n2 = PN.writeAddress(this.space.mark, byArray, n2);
        }
        int n3 = n2 - 2;
        PN.writeSize(n3, byArray, 0);
        n2 = this.space.next != null ? PN.writeAddress(this.space.next.mark, byArray, n2) : PN.writeAddress(this.spaceContinue, byArray, n2);
        byArray[n2++] = -47;
        byArray[n2++] = -32;
        byArray[n2] = -30;
        this.raf.seek(((long)n << 13) + (long)32);
        this.raf.write(byArray);
    }

    int alloc() throws IOException {
        if (this.space.next != null) {
            int n = this.space.next.mark;
            this.space = this.space.next;
            this.changed = true;
            return n;
        }
        this.changed = false;
        if (this.spaceAddress == 0) {
            return this.endAddress++;
        }
        if (this.spaceContinue == 0) {
            int n = this.spaceAddress;
            this.spaceAddress = 0;
            return n;
        }
        int n = this.spaceContinue;
        this.openSpace(n);
        return n;
    }

    void write(byte[] byArray, int n) throws IOException {
        this.raf.seek(((long)n << 13) + (long)32);
        this.raf.write(byArray);
    }

    File getFile() {
        if (this.isTemporary) {
            return null;
        }
        return this.file;
    }

    String getPath() {
        if (this.isTemporary) {
            return "";
        }
        return this.file.getPath();
    }

    String getAbsolutePath() {
        if (this.isTemporary) {
            return "";
        }
        return this.file.getAbsolutePath();
    }
}

