/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.NameTokenizer;
import Sav.Processor.NonRecognizableConnectException;
import Sav.Processor.NonRecognizableNumberException;
import Sav.Processor.PN;
import Sav.Processor.Trace;

public class Concept
implements Cloneable {
    String string;
    int type;
    int number = -1;
    Trace identifier;
    Trace classDefn;
    Trace classMean;
    Trace className;
    Trace classValue;
    int classLevel;

    public Concept() {
        this.identifier = new Trace(0);
    }

    public Concept(Trace trace) {
        this.identifier = (Trace)trace.clone();
        this.classLevel = Concept.countClassLevel(this.identifier);
    }

    public Concept(int n) {
        if (n > Integer.MAX_VALUE || n < 0) {
            throw new NonRecognizableNumberException("Need: #0 <= number <= 2147483647");
        }
        this.number = n;
        this.identifier = new Trace(0);
        this.identifier.next = new Trace(n, 31, 5);
        this.identifier.next.mark = 36;
    }

    public Concept(String string) {
        if (string == null || string.equals("")) {
            this.identifier = new Trace(0);
            return;
        }
        this.string = string;
        char c = string.charAt(0);
        int n = string.length();
        if (c == '#') {
            this.number = Concept.stringToNumber(string);
            if (this.number >= 0) {
                this.type = 36;
            }
        } else if (c == '\"') {
            if (n > 1) {
                char c2 = string.charAt(n - 1);
                if (c2 != '\"') {
                    this.string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf('\"')));
                } else {
                    string = string.substring(0, n - 1);
                }
            }
            this.type = 35;
        } else if (c == '\'') {
            if (n > 1) {
                char c3 = string.charAt(n - 1);
                if (c3 != '\'') {
                    this.string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf('\'')));
                } else {
                    string = string.substring(0, n - 1);
                }
            }
        } else if (c == '$') {
            char c4;
            int n2;
            for (n2 = 1; n2 < n && (c4 = string.charAt(n2)) >= 'A' && (c4 <= 'Z' || c4 >= 'a') && c4 <= 'z'; ++n2) {
            }
            if (n2 == n) {
                this.type = 34;
            }
        }
        this.equip(string);
        this.classLevel = Concept.countClassLevel(this.identifier);
    }

    void equip(String string) {
        this.identifier = new Trace(0);
        if (this.number >= 0) {
            this.identifier.next = new Trace(this.number, 31, 5);
            this.identifier.next.mark = 36;
            return;
        }
        Trace trace = this.identifier;
        NameTokenizer nameTokenizer = new NameTokenizer(string, this.type);
        block13: while (nameTokenizer.hasMoreElements()) {
            int n = nameTokenizer.nextType();
            trace = trace.next = new Trace(n);
            int n2 = nameTokenizer.tokenBegin;
            switch (n) {
                case 34: {
                    continue block13;
                }
                case 35: {
                    continue block13;
                }
                case 37: 
                case 38: 
                case 39: {
                    int n3;
                    while (n2 < nameTokenizer.tokenEnd) {
                        n3 = string.charAt(n2++);
                        trace = trace.next = new Trace(n3 & 0x1F);
                    }
                    continue block13;
                }
                case 44: 
                case 45: {
                    int n3;
                    int n4 = n == 45 ? 224 : 192;
                    while (n2 < nameTokenizer.tokenEnd) {
                        n3 = string.charAt(n2++) - n4;
                        trace = trace.next = new Trace(n3);
                    }
                    continue block13;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    int n3;
                    while (n2 < nameTokenizer.tokenEnd) {
                        n3 = string.charAt(n2++);
                        switch (n) {
                            case 43: {
                                trace = trace.next = new Trace(n3 >> 15 & 0x1F);
                            }
                            case 42: {
                                trace = trace.next = new Trace(n3 >> 10 & 0x1F);
                            }
                            case 41: {
                                trace = trace.next = new Trace(n3 >> 5 & 0x1F);
                            }
                            case 40: {
                                trace = trace.next = new Trace(n3 & 0x1F);
                            }
                        }
                    }
                    continue block13;
                }
            }
        }
    }

    public String toString() {
        return this.toString(this.identifier);
    }

    String toString(Trace trace) {
        if (this.string != null) {
            return this.string;
        }
        if (trace.next == null) {
            this.string = "";
            return this.string;
        }
        int n = 0;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.mark == 36) {
                while (trace2.next != null && trace2.next.mark <= 31) {
                    trace2 = trace2.next;
                }
                n += PN.MAX_NUMBER_LENGTH + 1;
            } else {
                ++n;
                if (trace2.mark == 35 || trace2.mark == 37) {
                    ++n;
                }
            }
            trace2 = trace2.next;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 39;
        boolean bl = false;
        boolean bl2 = false;
        trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.mark > 31) {
                if (trace2.mark >= 56) {
                    if (bl) {
                        cArray[n2++] = 34;
                        bl = false;
                    } else if (bl2) {
                        cArray[n2++] = 39;
                        bl2 = false;
                    }
                    if (trace2.mark == 57) {
                        cArray[n2++] = 58;
                    } else if (trace2.mark == 56) {
                        cArray[n2++] = 32;
                    }
                    n3 = 39;
                } else {
                    if (trace2.mark == 35) {
                        cArray[n2++] = 34;
                        bl = true;
                    } else if (trace2.mark == 36) {
                        cArray[n2++] = 35;
                    } else if (trace2.mark == 34) {
                        cArray[n2++] = 36;
                    }
                    n3 = trace2.mark;
                }
            } else {
                switch (n3) {
                    case 36: {
                        int n4 = trace2.mark;
                        while (trace2.next != null && trace2.next.mark <= 31) {
                            trace2 = trace2.next;
                            n4 <<= 5;
                            n4 |= trace2.mark;
                        }
                        String string = Integer.toString(n4);
                        int n5 = string.length();
                        string.getChars(0, n5, cArray, n2);
                        n2 += n5;
                        break;
                    }
                    case 37: {
                        cArray[n2] = (char)(0x20 | trace2.mark);
                        if (cArray[n2++] != '\'' || bl) break;
                        bl2 = true;
                        break;
                    }
                    case 39: {
                        cArray[n2++] = (char)(0x60 | trace2.mark);
                        break;
                    }
                    case 38: {
                        cArray[n2++] = (char)(0x40 | trace2.mark);
                        break;
                    }
                    case 45: {
                        cArray[n2++] = (char)(trace2.mark + 224);
                        break;
                    }
                    case 44: {
                        cArray[n2++] = (char)(trace2.mark + 192);
                        break;
                    }
                    case 43: {
                        int n6 = n2;
                        cArray[n6] = (char)(cArray[n6] | (char)(trace2.mark << 15));
                        trace2 = trace2.next;
                    }
                    case 42: {
                        int n7 = n2;
                        cArray[n7] = (char)(cArray[n7] | (char)(trace2.mark << 10));
                        trace2 = trace2.next;
                    }
                    case 41: {
                        int n8 = n2;
                        cArray[n8] = (char)(cArray[n8] | (char)(trace2.mark << 5));
                        trace2 = trace2.next;
                    }
                    case 40: {
                        int n9 = n2++;
                        cArray[n9] = (char)(cArray[n9] | (char)trace2.mark);
                        break;
                    }
                }
            }
            trace2 = trace2.next;
        }
        if (bl) {
            cArray[n2++] = 34;
        } else if (bl2) {
            cArray[n2++] = 39;
        }
        this.string = String.valueOf(cArray, 0, n2);
        return this.string;
    }

    static int countClassLevel(Trace trace) {
        Concept.normal(trace);
        return trace.mark;
    }

    static void normal(Trace trace) {
        if (trace.mark >= 0) {
            return;
        }
        int n = 0;
        int n2 = -1;
        Trace trace2 = trace;
        Trace trace3 = trace2.next;
        while (trace3 != null) {
            if (trace3.mark == n2) {
                trace2.next = trace3.next;
            } else {
                trace2 = trace3;
                if (trace3.mark > 31) {
                    if (trace3.mark < 56) {
                        n2 = trace3.mark;
                    } else {
                        if (trace3.mark == 57) {
                            ++n;
                        }
                        if (trace3.next == null) break;
                        if (trace3.next.mark <= 31) {
                            n2 = 39;
                            trace3 = trace3.next;
                            trace2 = trace2.next = new Trace(n2);
                            trace2.next = trace3;
                        } else {
                            n2 = -1;
                        }
                    }
                }
            }
            trace3 = trace2.next;
        }
        trace.mark = n;
    }

    public boolean equals(Concept concept) {
        return this.identifier.equals(concept.identifier);
    }

    public int toNumber() {
        if (this.number >= 0) {
            return this.number;
        }
        Trace trace = this.identifier.next;
        if (trace == null || trace.mark != 36) {
            return -1;
        }
        return trace.toInteger(31, 5);
    }

    public boolean isNumber() {
        return this.identifier.next != null && this.identifier.next.mark == 36;
    }

    public boolean isString() {
        return this.identifier.next != null && this.identifier.next.mark == 35;
    }

    public boolean isQuote() {
        Trace trace = this.identifier.next;
        if (trace == null) {
            return false;
        }
        return trace.mark == 37 && (trace = trace.next) != null && trace.mark == 39;
    }

    public boolean isSpecific() {
        return this.identifier.next != null && this.identifier.next.mark == 34;
    }

    public boolean isNone() {
        return this.identifier.next == null;
    }

    public Concept getName() {
        if (this.classLevel == 0) {
            return this;
        }
        if (this.className == null) {
            this.analyse();
        }
        return new Concept(this.className);
    }

    public Concept getValue() {
        if (this.classLevel == 0) {
            return null;
        }
        if (this.classValue == null) {
            this.analyse();
        }
        return new Concept(this.classValue);
    }

    public Concept getMean() {
        if (this.classLevel == 0) {
            return this;
        }
        if (this.classMean == null) {
            this.analyse();
        }
        return new Concept(this.classMean);
    }

    public Concept getDefn() {
        if (this.classLevel == 0) {
            return null;
        }
        if (this.classDefn == null) {
            this.analyse();
        }
        return new Concept(this.classDefn);
    }

    void analyse() {
        Trace trace;
        if (this.classLevel == 0) {
            this.classMean = this.identifier;
            this.className = this.identifier;
            return;
        }
        int n = 0;
        Trace trace2 = this.identifier;
        while (trace2.next != null) {
            if (trace2.next.mark == 57) {
                if (++n == 1) {
                    trace = trace2.next;
                    trace2.next = null;
                    this.className = new Trace(0);
                    this.className.insert(this.identifier);
                    this.classValue = new Trace();
                    this.classValue.insert(trace);
                    trace2.next = trace;
                }
                if (n == this.classLevel) break;
            }
            trace2 = trace2.next;
        }
        trace = trace2.next;
        trace2.next = null;
        this.classDefn = new Trace(this.identifier.mark - 1);
        this.classDefn.insert(this.identifier);
        trace2 = trace2.next = trace;
        this.classMean = new Trace(0);
        this.classMean.next = trace2.next;
    }

    public Concept(Concept concept, int n, Concept concept2) {
        String string;
        if (n == 57) {
            string = ":";
        } else if (n == 56) {
            string = " ";
        } else {
            throw new NonRecognizableConnectException();
        }
        if (concept.string != null && concept2.string != null) {
            this.string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(concept.string))).append(string).append(concept2.string)));
        }
        this.identifier = new Trace(concept.identifier.mark + concept2.identifier.mark);
        this.classLevel = concept.classLevel + concept2.classLevel;
        Trace trace = this.identifier.insert(concept.identifier);
        trace = trace.next = new Trace(n);
        trace.insert(concept2.identifier);
        if (n != 57) {
            return;
        }
        ++this.identifier.mark;
        ++this.classLevel;
        if (this.identifier.mark == 0) {
            this.className = this.identifier;
            this.classValue = concept2.identifier;
        }
        if (concept2.identifier.mark == 0) {
            this.classMean = concept2.identifier;
            this.classDefn = this.identifier;
        }
    }

    public int getNotation() {
        return this.getNotation(0);
    }

    public int getNotation(int n) {
        int n2 = -1;
        int n3 = 0;
        Trace trace = this.identifier.next;
        while (trace != null) {
            if (trace.mark > 31) {
                n2 = trace.mark;
            }
            if (n3++ == n) {
                return n2;
            }
            trace = trace.next;
        }
        return -1;
    }

    public char getFirstChar() {
        Trace trace;
        Trace trace2 = this.identifier.next;
        if (trace2 == null) {
            return '\u0000';
        }
        int n = trace2.mark;
        if (n == 34) {
            return '$';
        }
        if (n == 35) {
            return '\"';
        }
        if (n == 36) {
            return '#';
        }
        if (n == 57) {
            return ':';
        }
        Trace trace3 = trace = new Trace(0);
        trace3 = trace3.next = new Trace(n);
        trace2 = trace2.next;
        trace3.next = new Trace(trace2.mark);
        switch (n) {
            case 43: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.mark);
            }
            case 42: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.mark);
            }
            case 41: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.mark);
            }
            case 40: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.mark);
            }
        }
        if (this.string == null) {
            this.string = this.toString(trace);
        }
        return this.string.charAt(0);
    }

    public static int stringToNumber(String string) {
        int n = string.length();
        if (n == 0) {
            return -1;
        }
        char c = string.charAt(0);
        if (c != '#' || n <= 1) {
            return -1;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return -1;
        }
        if (n > PN.MAX_NUMBER_LENGTH + 1) {
            return -1;
        }
        int n2 = Integer.parseInt(string.substring(1));
        if (n2 > Integer.MAX_VALUE) {
            return -1;
        }
        return n2;
    }

    public static boolean isNumber(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '#' || n <= 1) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        if (n > PN.MAX_NUMBER_LENGTH + 1) {
            return false;
        }
        int n2 = Integer.parseInt(string.substring(1));
        return n2 <= Integer.MAX_VALUE;
    }

    public static boolean isSpecific(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '$' || n == 1) {
            return false;
        }
        c = string.charAt(1);
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (c >= 'A' && (c <= 'Z' || c >= 'a') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public String toIdString() {
        StringBuffer stringBuffer = new StringBuffer();
        Trace trace = this.identifier.next;
        while (trace != null) {
            stringBuffer.append(trace.mark);
            if (trace.next != null) {
                stringBuffer.append(":");
            }
            trace = trace.next;
        }
        return stringBuffer.toString();
    }
}

