/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.AssFile;
import Sav.Processor.Int1;
import Sav.Processor.Node;
import Sav.Processor.PN;
import java.io.File;
import java.io.IOException;
import java.util.Observable;

public class Hub
extends Observable {
    Node node;
    AssFile af;
    long state = 0L;
    int observation = 0;

    Hub() {
        this.af = new AssFile(this);
        this.node = new Node(this);
    }

    Hub(String string, boolean bl) throws IOException {
        this.af = new AssFile(this, string, bl);
        this.node = new Node(this);
        if (this.af.raf == null) {
            return;
        }
        this.node.count = -1;
        this.node.block = this.af.read(0);
        Int1 int1 = new Int1(0);
        this.node.onset = PN.readSize(this.node.block, 0, int1);
        this.node.size = int1.value;
        this.node.address = 0;
    }

    void reset() {
        this.setChanged();
        this.notifyObservers();
        this.deleteObservers();
        this.state = 0L;
    }

    boolean setUp() {
        if (++this.state > (long)0) {
            return true;
        }
        this.reset();
        return false;
    }

    void open() throws IOException {
        this.af.open();
        this.node.deploy();
    }

    void open(boolean bl) throws IOException {
        this.af.open(bl);
        this.node.deploy();
    }

    void close() throws IOException {
        if (this.node.count == 0) {
            this.delete();
            return;
        }
        this.node.save();
        this.af.close();
        if (this.node.address < 0) {
            return;
        }
        this.node.ploy();
        this.node.block = new byte[4];
        this.node.onset = 0;
        this.node.size = PN.writeAddress(this.node.address, this.node.block, 0);
        this.node.address = -1;
        this.reset();
    }

    boolean delete() throws IOException {
        if (!this.af.delete()) {
            return false;
        }
        this.node.delete();
        this.reset();
        return true;
    }

    void save() throws IOException {
        this.node.save();
    }

    void store() throws IOException {
        if (this.node.store()) {
            this.reset();
        }
    }

    void restore() throws IOException {
        if (this.node.restore()) {
            this.reset();
        }
    }

    File getFile() {
        return this.af.getFile();
    }

    String getPath() {
        return this.af.getPath();
    }

    String getAbsolutePath() {
        return this.af.getAbsolutePath();
    }
}

